/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.Env;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.Utils;
import weblogic.utils.Executable;
import weblogic.utils.StringUtils;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.io.Chunk;
import weblogic.version;

public final class CGIServlet
extends HttpServlet {
    private String[] cgiDir = null;
    private String allCgiDir = null;
    private ArrayList stat_env = null;
    private Hashtable extensionMap = null;
    private boolean debug = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        super.init(servletConfig);
        String string = this.getInitParameter("debug");
        if (string != null) {
            this.debug = string.equals("true");
        }
        this.setCgiDir(((WebAppServletContext)this.getServletContext()).getDocroot(), this.getInitParameter("cgiDir"));
        if (this.debug) {
            this.log("CGI Initialized [root : " + this.allCgiDir + "] [" + "debug : " + this.debug + "]");
        }
        Enumeration enumeration = this.getInitParameterNames();
        this.extensionMap = new Hashtable();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string2 = this.getInitParameter((String)object);
            if (!((String)object).startsWith("*.")) continue;
            this.extensionMap.put(object, string2);
        }
        object = Env.getenv();
        this.stat_env = ((Env)object).getWholeEnv();
        this.stat_env.add("SERVER_SOFTWARE=WebLogic/" + version.getReleaseBuildVersion());
        this.stat_env.add("GATEWAY_INTERFACE=CGI/1.1");
    }

    private void setCgiDir(String object, String string) {
        Object object2;
        if (string == null) {
            string = File.separator + "cgi-bin";
        }
        string = File.separatorChar == '\\' ? string.replace('/', File.separatorChar) : string.replace('\\', File.separatorChar);
        File file = new File((String)object);
        if (!file.isDirectory() && ((String)object).toUpperCase().endsWith(".WAR")) {
            object2 = ((String)object).substring(0, ((String)object).lastIndexOf(File.separatorChar)) + File.separatorChar + ((WebAppServletContext)this.getServletContext()).getTempPath();
            object2 = File.separatorChar == '\\' ? ((String)object2).replace('/', File.separatorChar) : ((String)object2).replace('\\', File.separatorChar);
            if (!this.extractScripts((String)object, (String)object2, string)) {
                this.log("Could not extract scripts from '" + (String)object + "'");
            }
            object = object2;
        }
        object2 = StringUtils.splitCompletely((String)string, (String)";");
        int n = ((String[])object2).length;
        this.cgiDir = new String[n];
        this.allCgiDir = "";
        for (int i = 0; i < n; ++i) {
            File file2;
            if (object2[i].endsWith("/") || object2[i].endsWith("\\")) {
                object2[i] = object2[i].substring(0, ((String)object2[i]).length() - 1);
            }
            Object object3 = !(file2 = new File((String)object2[i])).isAbsolute() ? (((String)object2[i]).charAt(0) == File.separatorChar ? (String)object + (String)object2[i] : (String)object + File.separator + (String)object2[i]) : object2[i];
            file2 = new File((String)object3);
            if (!file2.exists()) {
                this.log("CGI directory: " + (String)object3 + " doesn't exist.");
                this.cgiDir[i] = null;
                continue;
            }
            if (!file2.isDirectory()) {
                this.log("CGI directory: " + (String)object3 + " isn't a directory.");
                this.cgiDir[i] = null;
                continue;
            }
            try {
                this.cgiDir[i] = file2.getCanonicalPath();
                this.allCgiDir = this.allCgiDir + this.cgiDir[i] + File.pathSeparator;
                continue;
            }
            catch (IOException iOException) {
                this.cgiDir[i] = null;
                this.log("CGI directory: " + (String)object3 + " doesn't resolve to a canonical name.");
            }
        }
    }

    public String getCgiDir() {
        return this.allCgiDir;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n;
        Object object;
        int n2;
        String string;
        int n3;
        int n4;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string3 = null;
        String string4 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        String string5 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string4 == null) {
            string4 = Utils.encodeXSS(httpServletRequest.getPathInfo());
        }
        if (string5 == null) {
            string5 = httpServletRequest.getServletPath();
        }
        if ((string2 = (string5.length() <= 1 ? "" : string5) + (string4 == null ? "" : string4)) == null || string2.length() == 0) {
            this.log("Cannot resolve cgi script. Cannot proceed further.");
            httpServletResponse.sendError(500);
            return;
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if ((n4 = string2.indexOf(46)) != -1) {
            int n5 = string2.lastIndexOf("/", n4);
            int n6 = string2.indexOf("/", n4);
            string3 = n6 != -1 ? string2.substring(n5 + 1, n6) : string2.substring(n5 + 1);
        } else if (string4 == null) {
            try {
                string3 = string2.substring(1, string2.indexOf(47, 1));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string3 = string2.substring(1, string2.length());
            }
        } else {
            try {
                string3 = string4.substring(1, string4.indexOf(47, 1));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                string3 = string4.substring(1, string4.length());
            }
        }
        String string6 = string2.substring(string2.indexOf(string3) + string3.length()).replace('/', File.separatorChar);
        String string7 = ((WebAppServletContext)this.getServletContext()).getDocroot();
        File file = new File(string7);
        if (!file.isDirectory() && string7.toUpperCase().endsWith(".WAR")) {
            string7 = string7.substring(0, string7.length() - 4);
        }
        String string8 = string7 + string6;
        String string9 = string3;
        if (string3.length() == 0) {
            httpServletResponse.sendError(404);
            return;
        }
        if (this.debug) {
            this.log("script name=" + string3);
        }
        CGIServletOutputStream cGIServletOutputStream = new CGIServletOutputStream(httpServletResponse);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        String string10 = Utils.encodeXSS(httpServletRequest.getQueryString());
        if (string10 == null) {
            string10 = "";
        }
        String string11 = httpServletRequest.getContentType();
        int n7 = httpServletRequest.getContentLength();
        arrayList2.add("DOCUMENT_ROOT=" + string7);
        arrayList2.add("SERVER_NAME=" + httpServletRequest.getServerName());
        arrayList2.add("SERVER_PROTOCOL=" + httpServletRequest.getProtocol());
        arrayList2.add("SERVER_PORT=" + httpServletRequest.getServerPort());
        arrayList2.add("REQUEST_METHOD=" + httpServletRequest.getMethod());
        arrayList2.add("SCRIPT_NAME=" + HttpParsing.unescape((String)(httpServletRequest.getServletPath() + "/" + string3)));
        arrayList2.add("QUERY_STRING=" + string10);
        arrayList2.add("REMOTE_HOST=" + Utils.encodeXSS(httpServletRequest.getRemoteHost()));
        arrayList2.add("REMOTE_ADDR=" + Utils.encodeXSS(httpServletRequest.getRemoteAddr()));
        arrayList2.add("REQUEST_URI=" + Utils.encodeXSS(httpServletRequest.getRequestURI()) + (httpServletRequest.getQueryString() == null ? "" : "?" + string10));
        if (string6.length() != 0) {
            arrayList2.add("PATH_INFO=" + HttpParsing.unescape((String)string6).replace(File.separatorChar, '/'));
            arrayList2.add("PATH_TRANSLATED=" + HttpParsing.unescape((String)string8));
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string12 = Utils.encodeXSS((String)enumeration.nextElement());
            if (string12.toUpperCase(Locale.ENGLISH).startsWith("AUTHORIZATION")) continue;
            arrayList2.add("HTTP_" + string12.toUpperCase().replace('-', '_') + "=" + Utils.encodeXSS(httpServletRequest.getHeader(string12)));
        }
        arrayList2.add("AUTH_TYPE=" + httpServletRequest.getAuthType());
        arrayList2.add("REMOTE_USER=" + Utils.encodeXSS(httpServletRequest.getRemoteUser()));
        arrayList2.add("REMOTE_IDENT=");
        arrayList2.add("HTTP_COOKIE=" + Utils.encodeXSS(httpServletRequest.getHeader("Cookie")));
        arrayList2.add("SERVER_URL=" + Utils.encodeXSS(httpServletRequest.getScheme()) + "://" + Utils.encodeXSS(httpServletRequest.getHeader("HOST")) + Utils.encodeXSS(httpServletRequest.getContextPath()));
        if (string11 != null) {
            arrayList2.add("CONTENT_TYPE=" + string11);
        }
        if (n7 > -1) {
            arrayList2.add("CONTENT_LENGTH=" + Integer.toString(n7));
        }
        if ((n3 = string9.lastIndexOf(46)) != -1) {
            string = string9.substring(n3, string9.length());
            String string13 = (String)this.extensionMap.get("*" + string);
            if (string13 != null) {
                arrayList.add(string13);
            }
        }
        string = null;
        File file2 = null;
        for (n2 = 0; n2 < this.cgiDir.length; ++n2) {
            string = this.cgiDir[n2] + File.separator + string9;
            object = new File(string);
            if (!((File)object).exists()) continue;
            file2 = new File(this.cgiDir[n2]);
            break;
        }
        if (n2 == this.cgiDir.length) {
            this.log("Could not find script '" + string9 + "' in '" + this.allCgiDir + "'");
            if (this.debug && string10.startsWith("__cgiinfo")) {
                this.cgiInfo(arrayList, arrayList2, httpServletResponse);
                return;
            }
            httpServletResponse.sendError(404);
            return;
        }
        arrayList2.add("SCRIPT_FILENAME=" + string);
        arrayList.add(string);
        if (this.debug) {
            this.log("Script found " + string);
        }
        if (string10.indexOf("=") < 0) {
            object = new StringTokenizer(string10, "+");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (string10.startsWith("__cgiinfo")) {
            this.cgiInfo(arrayList, arrayList2, httpServletResponse);
            return;
        }
        if (this.debug) {
            this.log("Exec script with args :" + arrayList);
        }
        object = new Executable();
        object.setStdout((OutputStream)cGIServletOutputStream);
        object.setErrwriter(charArrayWriter);
        object.setPath("");
        if ("POST".equals(httpServletRequest.getMethod()) || "PUT".equals(httpServletRequest.getMethod())) {
            object.setStdin((InputStream)httpServletRequest.getInputStream());
        }
        int n8 = this.stat_env.size();
        int n9 = arrayList2.size();
        int n10 = arrayList.size();
        String[] stringArray = new String[n8 + n9];
        n2 = 0;
        for (n = 0; n < n8; ++n) {
            stringArray[n2++] = (String)this.stat_env.get(n);
        }
        for (n = 0; n < n9; ++n) {
            stringArray[n2++] = (String)arrayList2.get(n);
        }
        String[] stringArray2 = new String[n10];
        for (int i = 0; i < n10; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        try {
            if (!object.exec(stringArray2, stringArray, file2)) {
                if (this.debug) {
                    try {
                        this.log("Failed to exec CGI script. Return value : " + object.getExitValue());
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to exec CGI script. Process ended abrubtly. No return value available.");
                    }
                } else {
                    this.log("Failed to exec CGI script:" + string9);
                }
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(500);
                }
            }
        }
        catch (Exception exception) {
            String string14 = charArrayWriter != null ? charArrayWriter.toString() : "";
            string14 = "CGI script failed: " + string14;
            this.getServletContext().log(string14, (Throwable)exception);
            throw new ServletException(string14);
        }
        finally {
            ((OutputStream)cGIServletOutputStream).close();
        }
    }

    private void cgiInfo(ArrayList arrayList, ArrayList arrayList2, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Pragma", "no-cache");
        String string = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Draft//EN\">\n<HTML>\n<HEAD>\n<META NAME=\"GENERATOR\" CONTENT=\"WebLogic Server\">\n</HEAD>\n<BODY>\n<TABLE><TR><TD>Command = ";
        try {
            int n;
            for (n = 0; n < arrayList.size(); ++n) {
                string = string + (String)arrayList.get(n) + " ";
            }
            string = string + "</TD></TR>\n";
            for (n = 0; n < arrayList2.size(); ++n) {
                string = string + "<TR><TD>" + (String)arrayList2.get(n) + "</TD></TR>\n";
            }
            for (n = 0; n < this.stat_env.size(); ++n) {
                string = string + "<TR><TD>" + (String)this.stat_env.get(n) + "</TD></TR>\n";
            }
        }
        catch (Exception exception) {
            string = string + "<TR><TD>" + "got exception " + exception + "</TD></TR>\n";
        }
        string = string + "</TABLE>\n\n</BODY>\n</HTML>\n";
        httpServletResponse.getOutputStream().write(string.getBytes());
    }

    private boolean extractScripts(String string, String string2, String string3) {
        byte[] byArray = new byte[4096];
        String[] stringArray = StringUtils.splitCompletely((String)string3, (String)";");
        try {
            File file;
            for (int i = 0; i < stringArray.length; ++i) {
                file = new File(stringArray[i]);
                stringArray[i] = file.isAbsolute() ? null : (stringArray[i].startsWith("/") || stringArray[i].startsWith("\\") ? stringArray[i].substring(1).replace('\\', '/') : stringArray[i].replace('\\', '/'));
            }
            ZipFile zipFile = new ZipFile(string);
            file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                this.log("Cannot make temp directory '" + string2 + "' to extract scripts");
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                string3 = string3.replace('\\', '/');
                if (string4.endsWith("/") || !this.dirExistsInPath(string4, stringArray)) continue;
                File file2 = new File(file, string4.replace('/', File.separatorChar));
                new File(file2.getParent()).mkdirs();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            this.log("Failure extracting CGI scripts from WAR file " + string2, exception);
            return false;
        }
        return true;
    }

    private boolean dirExistsInPath(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    class CGIServletOutputStream
    extends OutputStream {
        private ServletOutputStream sos = null;
        private HttpServletResponse res;
        private StringBuffer buf;
        private boolean isBody;
        private boolean nphScript = false;
        String locHeader = null;
        private Chunk chunk = Chunk.getChunk();
        private ByteBuffer byteBuffer;

        CGIServletOutputStream(HttpServletResponse httpServletResponse) {
            this.byteBuffer = ByteBuffer.wrap(this.chunk.buf);
            this.res = httpServletResponse;
            this.buf = new StringBuffer();
            this.isBody = false;
            this.nphScript = false;
            this.locHeader = null;
            this.byteBuffer.clear();
        }

        private OutputStream getOutputStream() throws IOException {
            if (this.sos == null) {
                this.sos = (ServletOutputStreamImpl)this.res.getOutputStream();
            }
            return this.sos;
        }

        public void close() throws IOException {
            Chunk.releaseChunk((Chunk)this.chunk);
        }

        public void flush() throws IOException {
            if (this.byteBuffer.position() > 0) {
                this.getOutputStream().write(this.byteBuffer.array(), 0, this.byteBuffer.position());
            }
            this.byteBuffer.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(int n) {
            if (this.isBody) {
                if (!this.byteBuffer.hasRemaining()) {
                    try {
                        this.flush();
                    }
                    catch (IOException iOException) {
                        CGIServlet.this.log("CGIServlet failed to write body for the response", iOException);
                        return;
                    }
                }
                this.byteBuffer.put((byte)n);
                return;
            }
            if (n == 13) {
                return;
            }
            if (n != 10) {
                this.buf.append((char)n);
                return;
            } else if (this.buf.length() == 0) {
                this.isBody = true;
                try {
                    if (this.locHeader == null || this.nphScript) return;
                    this.res.sendRedirect(this.locHeader);
                    return;
                }
                catch (IOException iOException) {
                    CGIServlet.this.log("CGIServlet failed to redirect the request. locHeader=" + this.locHeader, iOException);
                    return;
                }
            } else {
                this.processHeader();
            }
        }

        private void processHeader() {
            String string = this.buf.toString();
            this.buf.setLength(0);
            if (string.startsWith("HTTP/")) {
                this.res.reset();
                this.nphScript = true;
                String[] stringArray = StringUtils.splitCompletely((String)string, (String)" ");
                if (stringArray.length < 2 || stringArray[1] == null) {
                    return;
                }
                try {
                    this.res.setStatus(Integer.parseInt(stringArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    CGIServlet.this.log("CGIServlet failed to set StatusHeader", numberFormatException);
                    return;
                }
            } else {
                String[] stringArray = StringUtils.split((String)string, (char)':');
                if (stringArray.length >= 2) {
                    this.setHeaderElement(stringArray);
                }
            }
        }

        private void setHeaderElement(String[] stringArray) {
            stringArray[0] = stringArray[0].trim();
            stringArray[1] = stringArray[1].trim();
            if ("Content-type".equalsIgnoreCase(stringArray[0])) {
                this.res.setContentType(stringArray[1]);
            } else if ("Content-length".equalsIgnoreCase(stringArray[0])) {
                try {
                    this.res.setContentLength(Integer.parseInt(stringArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    CGIServlet.this.log("CGIServlet failed to set ContentLength", numberFormatException);
                }
            } else if ("Location".equalsIgnoreCase(stringArray[0])) {
                this.locHeader = new String(stringArray[1]);
                this.res.setHeader("Location", this.locHeader);
            } else if ("Status".equalsIgnoreCase(stringArray[0])) {
                String[] stringArray2 = StringUtils.splitCompletely((String)stringArray[1], (String)" ");
                try {
                    this.res.setStatus(Integer.parseInt(stringArray2[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    CGIServlet.this.log("CGIServlet failed to set StatusHeader", numberFormatException);
                }
            } else if ("Set-Cookie".equalsIgnoreCase(stringArray[0])) {
                this.res.addHeader(stringArray[0], stringArray[1]);
            } else {
                this.res.setHeader(stringArray[0], stringArray[1]);
            }
        }
    }
}

