/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.application.AppClassLoaderManager;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.corba.utils.RemoteInfo;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.iiop.Utils;
import weblogic.j2ee.ApplicationManager;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.kernel.AuditableThread;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.StubGenerator;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.application.WarDetector;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.ByteArraySource;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.io.FilenameEncoder;

public final class ClasspathServlet
extends HttpServlet {
    private static final String SERVE_MANIFEST = "weblogic.classpathservlet.servemanifest";
    public static final String URI = "/classes";
    private static final DebugCategory debugging;
    private static final GenericClassLoader AUG_GCL;
    private static final String WLS_STUB_VERSION;
    private static final AppClassLoaderManager appClassLoaderManager;
    private static final String SYSTEM_INFO_RESOURCE_NAME = "/weblogic/SystemInfo";
    private static final Source systemInfoSource;
    private static final boolean serveManifest;
    private final ClassFinder finder = new ClasspathClassFinder2();
    private ServletContext context;
    private String defaultFilename;
    private boolean inited = false;
    private final ArrayList restrictedFiles = new ArrayList();
    private boolean strictCheck;
    private String restrictedDirectory;
    static final long serialVersionUID = -5240636019486779403L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    private static final boolean initServeManifest() {
        return Boolean.getBoolean(SERVE_MANIFEST);
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        if (this.inited) {
            return;
        }
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        this.defaultFilename = servletConfig.getInitParameter("defaultFilename");
        this.fillRestrictedFileList();
        this.inited = true;
    }

    private void fillRestrictedFileList() {
        this.restrictedFiles.add(".bat");
        this.restrictedFiles.add(".cmd");
        this.restrictedFiles.add(".crt");
        this.restrictedFiles.add(".der");
        this.restrictedFiles.add(".ini");
        this.restrictedFiles.add(".jks");
        this.restrictedFiles.add(".log");
        this.restrictedFiles.add(".p12");
        this.restrictedFiles.add(".pem");
        this.restrictedFiles.add(".sh");
        this.restrictedFiles.add("boot.properties");
        this.restrictedFiles.add("cacerts");
        this.restrictedFiles.add("config.xml");
        this.restrictedFiles.add("filerealm.properties");
        this.restrictedFiles.add("license.bea");
        this.restrictedFiles.add("SerializedSystemIni.dat");
        this.restrictedFiles.add("weblogiclicense");
        this.restrictedFiles.add("weblogic.properties");
        try {
            this.strictCheck = !Boolean.getBoolean("weblogic.servlet.ClasspathServlet.disableStrictCheck");
        }
        catch (SecurityException securityException) {
            this.strictCheck = true;
        }
        this.restrictedDirectory = "config/mydomain";
    }

    private static String parseResourceString(String string) {
        String string2 = FilenameEncoder.resolveRelativeURIPath((String)HttpParsing.unescape((String)string).toLowerCase(Locale.ENGLISH).trim());
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private boolean isRestrictedResource(String string) {
        String string2 = ClasspathServlet.parseResourceString(string);
        if (string2.length() == 0) {
            return false;
        }
        if (string2.endsWith(".class") || WarDetector.instance.suffixed(string2) || string2.endsWith(".jar") || string2.endsWith(".ear") || string2.endsWith(".rar") || string2.endsWith(".dtd") || string2.endsWith("rtd.xml") || string2.endsWith(".mf")) {
            return false;
        }
        if (this.strictCheck) {
            return true;
        }
        for (String string3 : this.restrictedFiles) {
            if (!string2.endsWith(string3.toLowerCase(Locale.ENGLISH))) continue;
            if (debugging.isEnabled()) {
                ClasspathServlet.logDebug(string3 + " is restricted. It cannot be served by ClasspathServlet.");
            }
            return true;
        }
        if (string2.indexOf(this.restrictedDirectory) != -1) {
            if (debugging.isEnabled()) {
                ClasspathServlet.logDebug(this.restrictedDirectory + " is restricted. It cannot be served by ClasspathServlet.");
            }
            return true;
        }
        return false;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block12: {
            block11: {
                block10: {
                    block9: {
                        bl = _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium.isEnabledAndNotDyeFiltered();
                        diagnosticActionArray = null;
                        diagnosticActionStateArray = null;
                        Object var11_6 = null;
                        if (bl) {
                            Object[] objectArray = null;
                            if (_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium.isArgumentsCaptureNeeded()) {
                                objectArray = new Object[]{this, httpServletRequest, httpServletResponse};
                            }
                            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium;
                            diagnosticActionArray = delegatingMonitor.getActions();
                            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                        }
                        try {
                            Source source;
                            if (debugging.isEnabled()) {
                                ClasspathServlet.logDebug("incoming request: " + httpServletRequest);
                                ClasspathServlet.logDebug("path info:        " + httpServletRequest.getPathInfo());
                                ClasspathServlet.logDebug("path trans:       " + httpServletRequest.getPathTranslated());
                                ClasspathServlet.logDebug("parsed request:   " + ClasspathServlet.parseResourceString(httpServletRequest.getPathInfo()));
                                ClasspathServlet.logDebug("ctx path :        " + httpServletRequest.getContextPath());
                                ClasspathServlet.logDebug("req uri :         " + httpServletRequest.getRequestURI());
                                ClasspathServlet.logDebug("servlet path :    " + httpServletRequest.getServletPath());
                            }
                            if ((source = this.findResource(httpServletRequest)) == null) {
                                if (debugging.isEnabled()) {
                                    ClasspathServlet.logDebug("Couldn't find resource for URI: " + httpServletRequest.getRequestURI() + " sending 404");
                                }
                                httpServletResponse.sendError(404);
                                Object var9_11 = null;
                                if (!bl) return;
                                break block9;
                            }
                            long l = source.length();
                            if (l == 0L) {
                                httpServletResponse.setContentLength(0);
                                break block10;
                            }
                            if (!ClasspathServlet.isModified(httpServletRequest, httpServletResponse, source)) {
                                httpServletResponse.setStatus(304);
                                break block11;
                            }
                            httpServletResponse.setContentType(this.context.getMimeType(source.getURL().toString()));
                            httpServletResponse.setContentLength((int)l);
                            ClasspathServlet.sendResource(source, httpServletResponse);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            if (!bl) throw throwable;
                            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                            throw throwable;
                        }
                    }
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    return;
                }
                Object var9_12 = null;
                if (!bl) return;
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                return;
            }
            Object var9_13 = null;
            if (!bl) return;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return;
        }
        Object var9_14 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private static boolean isModified(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Source source) throws IOException {
        if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
            return true;
        }
        long l = source.lastModified();
        if ((l -= l % 1000L) == 0L) {
            if (debugging.isEnabled()) {
                ClasspathServlet.logDebug("Couldn't find resource for URI: " + httpServletRequest.getRequestURI() + " - sending 404");
            }
            httpServletResponse.sendError(404);
            return false;
        }
        long l2 = -1L;
        try {
            l2 = httpServletRequest.getDateHeader("If-Modified-Since");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (l2 >= l) {
            if (debugging.isEnabled()) {
                ClasspathServlet.logDebug("Resource: " + source.getURL() + " last modified: " + l + " cache last modified: " + l2 + " sending 302");
            }
            httpServletResponse.setStatus(304);
            return false;
        }
        httpServletResponse.setDateHeader("Last-Modified", l);
        return true;
    }

    private Source findResource(HttpServletRequest httpServletRequest) throws IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            return null;
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("weblogiclicense") != -1) {
            return null;
        }
        if (SYSTEM_INFO_RESOURCE_NAME.equals(string)) {
            return systemInfoSource;
        }
        if (this.isRestrictedResource(string)) {
            return null;
        }
        if (string.endsWith("MANIFEST.MF") && serveManifest) {
            ByteArraySource byteArraySource = new ByteArraySource(VersionInfo.theOne().getVersionInfoForNetworkClassLoader(), new URL(httpServletRequest.getRequestURL().toString()));
            return byteArraySource;
        }
        int n = 0;
        if (string.charAt(0) == '/') {
            n = 1;
        }
        int n2 = string.indexOf("/", n);
        int n3 = string.indexOf(64);
        if (n3 != -1 && n3 < n2) {
            String string2 = string.substring(n, n3);
            String string3 = string.substring(n3 + 1, n2);
            String string4 = string.substring(n2 + 1);
            if (debugging.isEnabled()) {
                ClasspathServlet.logDebug("appName: " + string2 + ", componentName: " + string3);
            }
            return this.findSourceFromApplicationContainer(string2, string3, string4);
        }
        String string5 = string.substring(n);
        Source source = AUG_GCL.getClassFinder().getSource(string5);
        if (source != null) {
            return source;
        }
        if (ClasspathServlet.isGeneratableClass(string5)) {
            if (JDBCWrapperFactory.isJDBCRMIWrapperClass((String)string5)) {
                Source source2 = ClasspathServlet.getJDBCRMIWrapperClassSource(string5);
                if (source2 != null) {
                    return source2;
                }
            } else {
                Source source3 = this.getGeneratedClassSource(string5, null);
                if (source3 != null) {
                    return source3;
                }
            }
        }
        return this.sourceOrDefault(this.finder.getSource(string5));
    }

    private static boolean isGeneratableClass(String string) {
        return string.endsWith("_WLStub.class") || string.endsWith("_WLSkel.class") || Utils.isStubName(string) || ClasspathServlet.isWrapperInterface(string);
    }

    private static boolean isWrapperInterface(String string) {
        return string.endsWith("_RemoteInterface.class");
    }

    private Source findSourceFromApplicationContainer(String string, String string2, String string3) throws IOException {
        Source source;
        GenericClassLoader genericClassLoader = appClassLoaderManager.findLoader(new Annotation(string));
        if (genericClassLoader != null && (source = genericClassLoader.getClassFinder().getSource(string3)) != null) {
            return source;
        }
        genericClassLoader = appClassLoaderManager.findLoader(new Annotation(string, string2));
        if (genericClassLoader != null && (source = genericClassLoader.getClassFinder().getSource(string3)) != null) {
            return source;
        }
        source = this.sourceOrDefault(this.finder.getSource(string3));
        if (source != null) {
            return source;
        }
        if (ClasspathServlet.isGeneratableClass(string3)) {
            if (debugging.isEnabled()) {
                ClasspathServlet.logDebug("\n \n This is a Generatable class. name :" + string3 + "\n \n");
            }
            if (ClasspathServlet.isWrapperInterface(string3)) {
                return AUG_GCL.getClassFinder().getSource(string3);
            }
            if (JDBCWrapperFactory.isJDBCRMIWrapperClass((String)string3)) {
                return ClasspathServlet.getJDBCRMIWrapperClassSource(string3);
            }
            return this.getGeneratedClassSource(string3, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source getGeneratedClassSource(String string, String string2) throws IOException {
        Source source = null;
        String string3 = string.replace('/', '.');
        int n = string3.indexOf("_WLSkel.class");
        if (n != -1) {
            Class clazz = ClasspathServlet.loadClass(string3 = string3.substring(0, n), string2);
            if (clazz == null || clazz.isInterface()) {
                return null;
            }
            source = ClasspathServlet.getSkelClassSource(clazz, string);
            return source;
        }
        int n2 = string3.indexOf(WLS_STUB_VERSION);
        if (n2 != -1) {
            Class clazz = ClasspathServlet.loadClass(string3 = string3.substring(0, n2), string2);
            if (clazz == null || clazz.isInterface()) {
                return null;
            }
            source = ClasspathServlet.getStubClassSource(clazz, string);
            return source;
        }
        if (Utils.isStubName(string)) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getDefaultContextClassLoader());
                    Class clazz = ApplicationManager.loadClass(Utils.getClassNameFromStubName(string3), string2);
                    source = ClasspathServlet.getIIOPStubClassSource(clazz, string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (debugging.isEnabled()) {
                        ClasspathServlet.logDebug("Unexpected error in ClasspathServlet: " + classNotFoundException);
                    }
                    Object var10_13 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                Object var10_12 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            return source;
        }
        return source;
    }

    private ClassLoader getDefaultContextClassLoader() {
        if (Thread.currentThread() instanceof AuditableThread) {
            return ((AuditableThread)Thread.currentThread()).getDefaultContextClassLoader();
        }
        return null;
    }

    private static Source getSkelClassSource(Class clazz, String string) throws IOException {
        ServerHelper.getRuntimeDescriptor((Class)clazz);
        return AUG_GCL.getClassFinder().getSource(string);
    }

    private static Source getJDBCRMIWrapperClassSource(String string) {
        if (debugging.isEnabled()) {
            ClasspathServlet.logDebug("wrapperName: " + string);
        }
        JDBCWrapperFactory.generateWrapperClass((String)string, (boolean)false);
        Source source = AUG_GCL.getClassFinder().getSource(string);
        if (debugging.isEnabled()) {
            ClasspathServlet.logDebug("src: " + source);
        }
        return source;
    }

    private static Source getStubClassSource(Class clazz, String string) throws IOException {
        RuntimeDescriptor runtimeDescriptor = DescriptorHelper.getDescriptor((Class)clazz);
        if (debugging.isEnabled()) {
            ClasspathServlet.logDebug("cls: " + clazz);
            ClasspathServlet.logDebug("stubName: " + string);
            ClasspathServlet.logDebug("rtd: " + runtimeDescriptor);
        }
        new StubGenerator(runtimeDescriptor, null).generateClass((ClassLoader)AUG_GCL);
        Source source = AUG_GCL.getClassFinder().getSource(string);
        if (debugging.isEnabled()) {
            ClasspathServlet.logDebug("src: " + source);
        }
        return source;
    }

    private static Source getIIOPStubClassSource(Class clazz, String string) {
        ClassLoader classLoader;
        if (debugging.isEnabled()) {
            ClasspathServlet.logDebug("cls :" + clazz);
            ClasspathServlet.logDebug("stubName :" + string);
        }
        if (!((classLoader = clazz.getClassLoader()) instanceof GenericClassLoader)) {
            classLoader = AUG_GCL;
        }
        RemoteInfo.createStubs(clazz, classLoader);
        Source source = ((GenericClassLoader)classLoader).getClassFinder().getSource(string);
        if (debugging.isEnabled()) {
            ClasspathServlet.logDebug("src: " + source);
        }
        return source;
    }

    private Source sourceOrDefault(Source source) {
        if (source == null && this.defaultFilename != null) {
            return this.finder.getSource(this.defaultFilename);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sendResource(Source source, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        InputStream inputStream = source.getInputStream();
        try {
            ((ServletOutputStreamImpl)servletOutputStream).writeStream(inputStream);
            Object var5_4 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private static Source createSystemInfoSource() {
        String string = "ssl_strength=domestic\n";
        try {
            URL uRL = new URL("file", "", ".txt");
            return new ByteArraySource(string.getBytes("ASCII"), uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Throwable)malformedURLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Throwable)unsupportedEncodingException);
        }
    }

    private static void logDebug(String string) {
        Debug.say((String)string);
    }

    private static Class loadClass(String string, String string2) {
        try {
            return ApplicationManager.loadClass(string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return AUG_GCL.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (debugging.isEnabled()) {
                    ClasspathServlet.logDebug("Unexpected error in ClasspathServlet: " + classNotFoundException2);
                }
                return null;
            }
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.servlet.ClasspathServlet");
        _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Request_Action_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ClasspathServlet.java", (String)"weblogic.servlet.ClasspathServlet", (String)"doGet", (String)"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V", (int)216, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Request_Action_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        debugging = Debug.getCategory((String)"weblogic.ClasspathServlet");
        AUG_GCL = AugmentableClassLoaderManager.getAugmentableSystemClassLoader();
        WLS_STUB_VERSION = "_" + PeerInfo.getPeerInfo().getMajor() + PeerInfo.getPeerInfo().getMinor() + PeerInfo.getPeerInfo().getServicePack() + "_WLStub";
        appClassLoaderManager = AppClassLoaderManager.getAppClassLoaderManager();
        systemInfoSource = ClasspathServlet.createSystemInfoSource();
        serveManifest = ClasspathServlet.initServeManifest();
    }
}

