/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import java.text.CollationKey;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.platform.VM;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ByteRangeHandler;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.socket.WeblogicSocket;
import weblogic.utils.CharsetMap;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.StreamUtils;

public class FileServlet
extends HttpServlet {
    private static final String REQUEST_URI_INCLUDE = "javax.servlet.include.request_uri";
    private static final String SERVLET_PATH_INCLUDE = "javax.servlet.include.servlet_path";
    private static final String PATH_INFO_INCLUDE = "javax.servlet.include.path_info";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final int FORMAT_SPACE = 5;
    public static final String SORTBY_NAME = "NAME";
    public static final String SORTBY_LAST_MODIFIED = "LAST_MODIFIED";
    public static final String SORTBY_SIZE = "SIZE";
    private static final SimpleDateFormat DIRECTORY_DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy kk:mm");
    public static final DebugLogger DEBUG_URL_RES = DebugLogger.getDebugLogger((String)"DebugURLResolution");
    public static final long DEFAULT_MIN_NATIVE = 4096L;
    private long minNative = 4096L;
    private boolean nativeOK = false;
    protected WebAppServletContext context;
    protected String defaultFilename;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = (WebAppServletContext)servletConfig.getServletContext();
        this.defaultFilename = this.context.getInitParameter("defaultFilename");
        if (this.defaultFilename == null) {
            this.defaultFilename = servletConfig.getInitParameter("defaultFilename");
        }
        if ("".equals(this.defaultFilename)) {
            this.defaultFilename = null;
        }
        this.nativeOK = this.initNative(servletConfig);
    }

    private synchronized boolean initNative(ServletConfig servletConfig) {
        String string;
        if (!this.context.getConfigManager().isNativeIOEnabled()) {
            string = this.context.getInitParameter("weblogic.http.nativeIOEnabled");
            if (string == null) {
                string = servletConfig.getInitParameter("nativeIOEnabled");
            }
            if (!"true".equalsIgnoreCase(string)) {
                if (DEBUG_URL_RES.isDebugEnabled()) {
                    DEBUG_URL_RES.debug(this.context.getLogContext() + ": using standard I/O");
                }
                return false;
            }
        }
        if ((string = this.context.getInitParameter("weblogic.http.minimumNativeFileSize")) == null) {
            string = servletConfig.getInitParameter("minimumNativeFileSize");
        }
        try {
            this.minNative = string != null && !"".equals(string) ? Long.parseLong(string) : this.context.getConfigManager().getMinimumNativeFileSize();
        }
        catch (NumberFormatException numberFormatException) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Invalid setting for minimumNativeFileSize: " + string);
            }
            this.minNative = this.context.getConfigManager().getMinimumNativeFileSize();
        }
        try {
            System.loadLibrary("fastfile");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Could not load library for native I/O", (Throwable)unsatisfiedLinkError);
            }
            HTTPLogger.logFailedToLoadNativeIOLibrary((String)this.context.getLogContext(), (Throwable)unsatisfiedLinkError);
            return false;
        }
        if (DEBUG_URL_RES.isDebugEnabled()) {
            DEBUG_URL_RES.debug(this.context.getLogContext() + ": Native I/O library loaded");
        }
        return true;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET) || string.equals(METHOD_HEAD) || string.equals(METHOD_POST)) {
            this.doGetHeadPost(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_OPTIONS)) {
            httpServletResponse.setHeader("Allow", "GET, HEAD, OPTIONS, POST");
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_TRACE)) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(501);
        }
    }

    private void doGetHeadPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        long l;
        WarSource warSource = this.findSource(httpServletRequest, httpServletResponse);
        if (warSource == null) {
            return;
        }
        if (warSource.length() == 0L) {
            httpServletResponse.setContentLength(0);
            return;
        }
        if (httpServletRequest.getAttribute("javax.servlet.error.request_uri") == null && !this.isModified(httpServletRequest, httpServletResponse, warSource)) {
            return;
        }
        if (FileServlet.isRangeRequest(httpServletRequest)) {
            this.sendRangeData(warSource, httpServletRequest, httpServletResponse);
            return;
        }
        String string = warSource.getContentType(this.context);
        if (string != null) {
            httpServletResponse.setContentType(string);
        }
        if ((l = warSource.length()) != -1L) {
            httpServletResponse.setContentLength((int)l);
        }
        if (httpServletRequest.getMethod().equals(METHOD_HEAD)) {
            return;
        }
        if (this.nativeOK && this.isNativeOK(warSource, httpServletRequest, httpServletResponse)) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Sending file using native I/O");
            }
            this.sendFileNative(warSource.getFileName(), ServletRequestImpl.getOriginalRequest((ServletRequest)httpServletRequest), l);
        } else {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Sending file using standard I/O");
            }
            boolean bl = httpServletRequest.getAttribute(REQUEST_URI_INCLUDE) != null;
            this.sendFile(warSource, httpServletResponse, "HTTP/1.1".equals(httpServletRequest.getProtocol()), bl);
        }
    }

    private static boolean isRangeRequest(HttpServletRequest httpServletRequest) {
        if (!"HTTP/1.1".equals(httpServletRequest.getProtocol())) {
            return false;
        }
        if (!httpServletRequest.getMethod().equals(METHOD_GET)) {
            return false;
        }
        return httpServletRequest.getHeader("Range") != null;
    }

    private boolean isNativeOK(WarSource warSource, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return !httpServletRequest.isSecure() && warSource.length() > this.minNative && warSource.isFile() && httpServletRequest.getAttribute(REQUEST_URI_INCLUDE) == null && httpServletResponse instanceof ServletResponseImpl && !((ServletResponseImpl)httpServletResponse).isInternalDispatch();
    }

    protected WarSource findSource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        char c;
        WarSource warSource;
        String string = FileServlet.getURI(httpServletRequest);
        if (DEBUG_URL_RES.isDebugEnabled()) {
            DEBUG_URL_RES.debug(this.context.getLogContext() + ": looking for file: '" + string + "'");
        }
        if ((warSource = this.getSource(string)) == null) {
            httpServletResponse.sendError(404);
            return null;
        }
        char c2 = c = string.length() == 0 ? (char)'\u0000' : string.charAt(string.length() - 1);
        if (warSource.isDirectory()) {
            if (c != '/') {
                httpServletResponse.sendRedirect(httpServletRequest.getRequestURL().append('/').toString());
            } else {
                Object object;
                if (this.defaultFilename != null && (object = this.getSource(string + this.defaultFilename)) != null) {
                    return object;
                }
                if (this.context.getConfigManager().isIndexDirectoryEnabled()) {
                    object = this.context.getResourceFinder(string).getSources(string);
                    this.produceDirectoryListing((Enumeration)object, httpServletRequest, httpServletResponse);
                } else {
                    httpServletResponse.sendError(403);
                }
            }
            return null;
        }
        if (c == '\\' || c == '/') {
            httpServletResponse.sendError(404);
            return null;
        }
        return warSource;
    }

    private static String getURI(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(SERVLET_PATH_INCLUDE);
        String string2 = (String)httpServletRequest.getAttribute(PATH_INFO_INCLUDE);
        if (string == null && string2 == null) {
            string = httpServletRequest.getServletPath();
            string2 = httpServletRequest.getPathInfo();
        }
        String string3 = null;
        if (string != null) {
            string3 = string;
            if (string2 != null) {
                string3 = string3 + string2;
            }
        } else if (string2 != null) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    private WarSource getSource(String string) {
        return this.context.getResourceAsSourceWithMDS(string);
    }

    private boolean isModified(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WarSource warSource) throws IOException {
        if (httpServletRequest.getAttribute(REQUEST_URI_INCLUDE) != null) {
            return true;
        }
        long l = warSource.lastModified();
        if ((l -= l % 1000L) == 0L) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Couldn't find resource for URI: " + httpServletRequest.getRequestURI() + " - sending 404");
            }
            httpServletResponse.sendError(404);
            return false;
        }
        long l2 = -1L;
        try {
            l2 = httpServletRequest.getDateHeader("If-Modified-Since");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (l2 >= l) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Source: " + warSource + " Last-Modified: " + l + " If-Modified-Since : " + l2 + " - sending 302");
            }
            httpServletResponse.setStatus(304);
            return false;
        }
        httpServletResponse.setHeader("Last-Modified", warSource.getLastModifiedAsString());
        return true;
    }

    private void sendRangeData(WarSource warSource, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = warSource.getContentType(this.context);
        httpServletResponse.addHeader("Accept-Ranges", "bytes");
        ByteRangeHandler byteRangeHandler = ByteRangeHandler.makeInstance(warSource, httpServletRequest, string);
        if (byteRangeHandler != null) {
            byteRangeHandler.sendRangeData(httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendFile(Source source, HttpServletResponse httpServletResponse, boolean bl, boolean bl2) throws IOException {
        InputStream inputStream;
        block11: {
            block10: {
                inputStream = source.getInputStream();
                try {
                    try {
                        if (inputStream == null) {
                            httpServletResponse.sendError(404);
                            Object var9_6 = null;
                            if (inputStream == null) return;
                            break block10;
                        }
                        if (bl) {
                            httpServletResponse.addHeader("Accept-Ranges", "bytes");
                        }
                        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                        try {
                            ((ServletOutputStreamImpl)servletOutputStream).writeStream(inputStream);
                        }
                        catch (ClassCastException classCastException) {
                            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)servletOutputStream);
                        }
                        break block11;
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!(httpServletResponse instanceof ServletResponseWrapper) && !bl2) {
                            throw illegalStateException;
                        }
                        this.sendFileUsingWriter(source, httpServletResponse);
                        Object var9_8 = null;
                        if (inputStream == null) return;
                        inputStream.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
            }
            inputStream.close();
            return;
        }
        Object var9_7 = null;
        if (inputStream == null) return;
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendFileUsingWriter(Source source, HttpServletResponse httpServletResponse) throws IOException {
        Reader reader;
        InputStream inputStream;
        block10: {
            block8: {
                block9: {
                    inputStream = null;
                    reader = null;
                    int n = httpServletResponse.getBufferSize();
                    try {
                        PrintWriter printWriter = httpServletResponse.getWriter();
                        inputStream = source.getInputStream();
                        if (inputStream == null) {
                            httpServletResponse.sendError(404);
                            Object var11_7 = null;
                            if (reader == null) break block8;
                            break block9;
                        }
                        String string = httpServletResponse.getCharacterEncoding();
                        if (string == null) {
                            string = ((WebAppServletContext)this.getServletContext()).getConfigManager().getDefaultEncoding();
                        }
                        reader = new InputStreamReader(inputStream, string);
                        if (n == -1) {
                            n = 4096;
                        }
                        char[] cArray = new char[n];
                        int n2 = 0;
                        while ((n2 = reader.read(cArray)) > 0) {
                            printWriter.write(cArray, 0, n2);
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var11_9 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                reader.close();
            }
            if (inputStream == null) return;
            inputStream.close();
            return;
        }
        Object var11_8 = null;
        if (reader != null) {
            reader.close();
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    private void sendFileNative(String string, ServletRequestImpl servletRequestImpl, long l) throws IOException {
        int n;
        ServletResponseImpl servletResponseImpl = servletRequestImpl.getResponse();
        ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStream();
        servletOutputStreamImpl.setNativeControlsPipe(true);
        Socket socket = servletRequestImpl.getConnection().getSocket();
        if (socket instanceof WeblogicSocket) {
            socket = ((WeblogicSocket)socket).getSocket();
        }
        if ((n = servletRequestImpl.getConnection().getSocketFD()) == -1) {
            n = VM.getVM().getFD(socket);
            servletRequestImpl.getConnection().setSocketFD(n);
        }
        FileServlet.transmitFile(string, l, n);
        servletOutputStreamImpl.setNativeControlsPipe(false);
    }

    private void produceDirectoryListing(Enumeration enumeration, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        int n;
        String string = CharsetMap.getIANAFromJava((String)System.getProperty("file.encoding"));
        String string2 = "text/html";
        if (string != null) {
            string2 = string2 + "; charset=" + string;
        }
        httpServletResponse.setContentType(string2);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String string3 = ServletRequestImpl.getResolvedURI(httpServletRequest);
        servletOutputStream.println("<HTML>\n<HEAD>\n<TITLE>Index of ");
        servletOutputStream.println(string3);
        servletOutputStream.println("</TITLE>\n</HEAD>\n<BODY>");
        servletOutputStream.println("<H1>Index of ");
        servletOutputStream.println(string3);
        servletOutputStream.println("</H1><BR>");
        servletOutputStream.println("<PRE>");
        servletOutputStream.print("<A HREF=\"?sortby=NAME\">");
        FileServlet.outStr("Name", servletOutputStream, 29, true);
        servletOutputStream.print("<A HREF=\"?sortby=LAST_MODIFIED\">");
        FileServlet.outStr("Last Modified", servletOutputStream, 24, true);
        servletOutputStream.print("<A HREF=\"?sortby=SIZE\">");
        FileServlet.outStr("Size", servletOutputStream, 10, true);
        servletOutputStream.println("<HR>");
        if (!"/".equals(string3) && string3.length() > 2 && (n = string3.lastIndexOf(47, string3.length() - 2)) >= 0) {
            object = string3.substring(0, n + 1);
            servletOutputStream.println("<A HREF=\"" + (String)object + "\">Parent Directory</A>");
        }
        List<WarSource> list = null;
        while (enumeration.hasMoreElements()) {
            object = (WarSource)enumeration.nextElement();
            List<WarSource> list2 = Arrays.asList(((WarSource)object).listSources());
            if (enumeration.hasMoreElements() || list != null) {
                if (list == null) {
                    list = new ArrayList<WarSource>();
                }
                list.addAll(list2);
                continue;
            }
            list = list2;
        }
        if (list.size() == 0) {
            servletOutputStream.println("</PRE></BODY></HTML>");
            return;
        }
        object = new TypeComparator(this.getComparator(httpServletRequest));
        Collections.sort(list, object);
        for (WarSource warSource : list) {
            String string4 = warSource.getName();
            Date date = new Date(warSource.lastModified());
            if (warSource.isDirectory()) {
                if ("WEB-INF".equals(string4) || "META-INF".equals(string4)) continue;
                servletOutputStream.print("<A HREF=\"" + string4 + "/\">");
                FileServlet.outStr(string4, servletOutputStream, 29, true);
                FileServlet.outStr(DIRECTORY_DATE_FORMAT.format(date), servletOutputStream, 24, false);
                FileServlet.outStr("&lt;DIR&gt;", servletOutputStream, 10, false);
            } else {
                servletOutputStream.print("<A HREF=\"" + string4 + "\">");
                FileServlet.outStr(string4, servletOutputStream, 29, true);
                FileServlet.outStr(DIRECTORY_DATE_FORMAT.format(date), servletOutputStream, 24, false);
                long l = warSource.length();
                String string5 = l >= 1024L ? String.valueOf(l / 1024L) + 'k' : String.valueOf(l);
                FileServlet.outStr(string5, servletOutputStream, 10, false);
            }
            servletOutputStream.println();
        }
        servletOutputStream.println("</PRE></BODY></HTML>");
    }

    private Comparator getComparator(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("sortby");
        if (SORTBY_LAST_MODIFIED.equals(string)) {
            return new LastModifiedComparator();
        }
        if (SORTBY_SIZE.equals(string)) {
            return new SizeComparator();
        }
        if (SORTBY_NAME.equals(string)) {
            return new NameComparator();
        }
        string = this.context.getConfigManager().getIndexDirectorySortBy();
        if (SORTBY_LAST_MODIFIED.equals(string)) {
            return new LastModifiedComparator();
        }
        if (SORTBY_SIZE.equals(string)) {
            return new SizeComparator();
        }
        return new NameComparator();
    }

    private static void outStr(String string, ServletOutputStream servletOutputStream, int n, boolean bl) throws IOException {
        int n2;
        for (n2 = 0; n2 < string.length() && n2 < n; ++n2) {
            servletOutputStream.print(string.charAt(n2));
        }
        if (bl) {
            servletOutputStream.print("</A>");
        }
        while (n2 < n) {
            servletOutputStream.write(32);
            ++n2;
        }
    }

    private static native void transmitFile(String var0, long var1, int var3) throws IOException;

    private static final class TypeComparator
    implements Comparator {
        private final Comparator tieBreaker;

        TypeComparator(Comparator comparator) {
            this.tieBreaker = comparator;
        }

        public int compare(Object object, Object object2) {
            boolean bl;
            WarSource warSource = (WarSource)object;
            WarSource warSource2 = (WarSource)object2;
            boolean bl2 = warSource.isDirectory();
            if (bl2 == (bl = warSource2.isDirectory())) {
                return this.tieBreaker.compare(warSource, warSource2);
            }
            if (bl2) {
                return -1;
            }
            return 1;
        }
    }

    private static final class SizeComparator
    extends NameComparator {
        private SizeComparator() {
        }

        public int compare(Object object, Object object2) {
            WarSource warSource = (WarSource)object;
            WarSource warSource2 = (WarSource)object2;
            if (warSource.isDirectory()) {
                return super.compare(warSource, warSource2);
            }
            long l = warSource.length() - warSource2.length();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return super.compare(warSource, warSource2);
        }
    }

    private static final class LastModifiedComparator
    extends NameComparator {
        private LastModifiedComparator() {
        }

        public int compare(Object object, Object object2) {
            Source source = (Source)object;
            Source source2 = (Source)object2;
            long l = source.lastModified() - source2.lastModified();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return super.compare(source, source2);
        }
    }

    private static class NameComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((WarSource)object).getName();
            String string2 = ((WarSource)object2).getName();
            CollationKey collationKey = this.collator.getCollationKey(string);
            CollationKey collationKey2 = this.collator.getCollationKey(string2);
            return collationKey.compareTo(collationKey2);
        }
    }
}

