/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.AddToMapException;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspFactoryImpl;
import weblogic.servlet.jsp.JspStub;
import weblogic.servlet.jsp.ResourceProviderJspStub;
import weblogic.utils.io.FilenameEncoder;

public class JSPServlet
extends HttpServlet {
    public static final String DEFAULT_PACKAGE_PREFIX = "jsp_servlet";
    public static final String DEFAULT_PAGE_NAME = "index.jsp";
    public static final Constructor JSP_STUB = JSPServlet.getJSPStubConstructor();
    protected JspConfig jspConfig;
    protected WebAppServletContext ourContext;
    private static boolean isCaseSensitive;

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.ourContext = (WebAppServletContext)this.getServletContext();
        this.jspConfig = this.ourContext.getJSPManager().createJspConfig();
        this.jspConfig.setValuesFromInitArgs(servletConfig);
        boolean bl = this.jspConfig.isVerbose();
        if (bl) {
            this.log("param verbose initialized to: " + bl);
            this.log("param packagePrefix initialized to: " + this.jspConfig.getPackagePrefix());
            this.log("param compilerclass initialized to: " + this.jspConfig.getCompilerClass());
            this.log("param compileCommand initialized to: " + this.jspConfig.getCompileCommand());
            this.log("param compilerval initialized to: " + this.jspConfig.getCompilerval());
            this.log("param pageCheckSeconds initialized to: " + this.jspConfig.getPageCheckSecs());
            this.log("param encoding initialized to: " + this.jspConfig.getEncoding());
            this.log("param superclass initialized to " + this.jspConfig.getSuperClassName());
        }
        if (this.jspConfig.getCompilerval() == null) {
            throw new UnavailableException("Couldn't find init param: compileCommand");
        }
        String string = this.jspConfig.getWorkingDir();
        if (string == null) {
            throw new UnavailableException("Couldn't find init param: workingDir");
        }
        File file = new File(string.replace('/', File.separatorChar));
        if (!file.exists()) {
            if (file.mkdirs()) {
                this.log("Making new working directory: " + string);
            } else {
                throw new UnavailableException("Working directory: " + string + " was not found and " + "could not be created.");
            }
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new UnavailableException("Couldn't resolve canonical path for: " + string);
        }
        if (bl) {
            this.log("param workingDir initialized to: " + string);
        }
        this.ourContext.addClassPath(string);
        if (bl) {
            this.log("initialization complete");
        }
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        int n;
        ServletStubImpl servletStubImpl = null;
        StringBuilder stringBuilder = new StringBuilder(30);
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
        if (string == null && string2 == null) {
            string = httpServletRequest.getServletPath();
            string2 = httpServletRequest.getPathInfo();
        }
        if (string != null) {
            stringBuilder.append(string);
        }
        if (string2 != null) {
            if (this.jspConfig.isExactMapping() || string == null) {
                stringBuilder.append(string2);
            } else {
                String string3 = string2.toLowerCase();
                int n2 = 0;
                n2 = string3.indexOf(".jsp/");
                if (n2 != -1) {
                    string2 = string2.substring(0, n2 + 4);
                    stringBuilder.append(string2);
                } else {
                    n2 = string3.indexOf(".jspx/");
                    if (n2 != -1) {
                        string2 = string2.substring(0, n2 + 5);
                        stringBuilder.append(string2);
                    } else {
                        stringBuilder.append(string2);
                    }
                }
            }
        }
        if ((n = stringBuilder.length()) == 0) {
            stringBuilder.append('/');
            stringBuilder.append(this.jspConfig.getDefaultFilename());
        } else if (stringBuilder.charAt(n - 1) == '/') {
            stringBuilder.append(this.jspConfig.getDefaultFilename());
        }
        String string4 = FilenameEncoder.resolveRelativeURIPath((String)stringBuilder.toString());
        if (this.ourContext.getJSPManager().getResourceProviderClass() == null) {
            object = this.ourContext.getResourceAsSource(string4);
            if (object == null) {
                httpServletResponse.sendError(404);
                return;
            }
            if (object.length() == 0L) {
                httpServletResponse.setContentLength(0);
                return;
            }
        }
        if ((servletStubImpl = ((WebAppServletContext)(object = (WebAppServletContext)this.getServletContext())).getServletStub(string4)) != null && servletStubImpl instanceof JspStub && !servletStubImpl.getClassName().equals(((Object)((Object)this)).getClass().getName())) {
            throw new AddToMapException(string4, servletStubImpl);
        }
        if (this.ourContext.getJspResourceProvider() != null) {
            servletStubImpl = new ResourceProviderJspStub(string4, this.ourContext, this.jspConfig);
            throw new AddToMapException(string4, servletStubImpl);
        }
        servletStubImpl = JSPServlet.getNewJspStub(string4, JSPServlet.uri2classname(this.jspConfig.getPackagePrefix(), string4), null, this.ourContext, this.jspConfig);
        throw new AddToMapException(string4, servletStubImpl);
    }

    public static JspStub getNewJspStub(String string, String string2, Map map, WebAppServletContext webAppServletContext, JspConfig jspConfig) throws ServletException {
        try {
            return (JspStub)JSP_STUB.newInstance(string, string2, map, webAppServletContext, jspConfig);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    private static Constructor getJSPStubConstructor() {
        try {
            Class<?> clazz = Class.forName("weblogic.servlet.jsp.JavelinxJSPStub");
            return clazz.getConstructor(String.class, String.class, Map.class, WebAppServletContext.class, JspConfig.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)"Unable to find class weblogic.servlet.jsp.JavelinxJSPStub");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)"Unable to find constructor weblogic.servlet.jsp.JavelinxJSPStub(String, String, Map, WebAppServletContext, JspConfig)");
        }
    }

    public static String uri2classname(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("weblogic.jsp.internal.jsp.utils.JavaTransformUtils");
            if (string2.endsWith(".tag") || string2.endsWith(".tagx")) {
                Method method = clazz.getMethod("computeTagClassName", String.class, String.class);
                String string3 = (String)method.invoke(null, string2, string);
                return string3;
            }
            Method method = clazz.getMethod("getFullClassName", String.class, Boolean.TYPE, String.class);
            String string4 = (String)method.invoke(null, string2, Boolean.FALSE, string);
            return string4;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    static {
        JspFactoryImpl.init();
        isCaseSensitive = false;
        try {
            String string = System.getProperty("weblogic.jsp.windows.caseSensitive");
            String string2 = System.getProperty("weblogic.jsp.caseSensitive");
            if ("true".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string2)) {
                isCaseSensitive = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

