/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.FileServlet;
import weblogic.servlet.internal.WarSource;
import weblogic.utils.http.QueryParams;

public final class ServerSideIncludeServlet
extends FileServlet {
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            WarSource warSource = this.findSource(httpServletRequest, httpServletResponse);
            if (warSource == null) {
                return;
            }
            if (warSource.length() == 0L) {
                httpServletResponse.setContentLength(0);
                return;
            }
            InputStream inputStream = warSource.getInputStream();
            try {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
                while (true) {
                    int n;
                    if ((n = pushbackInputStream.read()) == 60) {
                        String string;
                        n = pushbackInputStream.read();
                        if (n == 115 || n == 83) {
                            pushbackInputStream.unread(n);
                            string = this.parseTagName(pushbackInputStream);
                            if (string.equalsIgnoreCase("servlet")) {
                                this.handleServletTag(httpServletRequest, httpServletResponse, pushbackInputStream, servletOutputStream);
                                continue;
                            }
                            servletOutputStream.print("<");
                            servletOutputStream.print(string);
                            continue;
                        }
                        if (n == 33) {
                            n = pushbackInputStream.read();
                            if (n == 45) {
                                n = pushbackInputStream.read();
                                if (n == 45) {
                                    n = pushbackInputStream.read();
                                    if (n == 35) {
                                        string = this.parseTagName(pushbackInputStream);
                                        if (string.equalsIgnoreCase("include")) {
                                            try {
                                                this.handleIncludeTag(pushbackInputStream, httpServletRequest, httpServletResponse);
                                            }
                                            catch (Exception exception) {
                                                this.log("ServerSideIncludeServlet failed to handle include tag", exception);
                                                httpServletResponse.sendError(404);
                                            }
                                            continue;
                                        }
                                        servletOutputStream.print("<!--#");
                                        servletOutputStream.print(string);
                                        continue;
                                    }
                                    servletOutputStream.print("<!--");
                                } else {
                                    servletOutputStream.print("<!-");
                                }
                            } else {
                                servletOutputStream.print("<!");
                            }
                        } else {
                            if (n != -1) {
                                pushbackInputStream.unread(n);
                            }
                            n = 60;
                        }
                    }
                    if (n != -1) {
                        servletOutputStream.write(n);
                        continue;
                    }
                    break;
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            httpServletResponse.sendError(404);
        }
    }

    protected void handleServletTag(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PushbackInputStream pushbackInputStream, ServletOutputStream servletOutputStream) throws IOException {
        String string;
        Map map = this.parseTagParameters(pushbackInputStream);
        QueryParams queryParams = new QueryParams();
        pushbackInputStream.read();
        while (true) {
            int n;
            if ((n = pushbackInputStream.read()) == 60) {
                n = pushbackInputStream.read();
                if (n == 47) {
                    string = this.parseTagName(pushbackInputStream);
                    if ("servlet".equalsIgnoreCase(string)) {
                        pushbackInputStream.read();
                        break;
                    }
                    servletOutputStream.print("</");
                    servletOutputStream.print(string);
                    continue;
                }
                if (n != -1) {
                    pushbackInputStream.unread(n);
                }
                if ((string = this.parseTagName(pushbackInputStream)).equalsIgnoreCase("param")) {
                    this.parseParamTag(pushbackInputStream, (Map)queryParams);
                    continue;
                }
                servletOutputStream.print("<");
                servletOutputStream.print(string);
                continue;
            }
            if (n == -1) break;
            servletOutputStream.write(n);
        }
        String string2 = (String)map.get("name");
        if (string2 == null || string2.equals("")) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Couldn't find servlet parameter: name");
            }
            return;
        }
        try {
            string = this.getRD(string2, httpServletRequest);
            if (string == null) {
                if (DEBUG_URL_RES.isDebugEnabled()) {
                    DEBUG_URL_RES.debug(this.context.getLogContext() + ": Couldn't find servlet for name: " + string2);
                }
                return;
            }
            string.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            if (DEBUG_URL_RES.isDebugEnabled()) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Error initializing servlet", (Throwable)exception);
            }
            return;
        }
    }

    private void consumeToTagEnd(InputStream inputStream) throws IOException {
        int n;
        while ((n = inputStream.read()) != 62 && n != -1) {
        }
    }

    private String readRValue(PushbackInputStream pushbackInputStream) throws IOException {
        char c = '\u0000';
        StringBuilder stringBuilder = new StringBuilder();
        this.skipWhiteSpace(pushbackInputStream);
        int n = pushbackInputStream.read();
        if (n == 39 || n == 34) {
            c = (char)n;
        } else {
            if (n == -1) {
                return "";
            }
            stringBuilder.append((char)n);
        }
        while ((n = pushbackInputStream.read()) != -1 && (n != c || n == 0)) {
            if (n == 32) {
                if (c == '\u0000') {
                    pushbackInputStream.unread(n);
                    break;
                }
                stringBuilder.append((char)n);
                continue;
            }
            if (n == 62) {
                pushbackInputStream.unread(n);
                break;
            }
            if (n <= 32 || n >= 127) break;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private boolean parseParamTag(PushbackInputStream pushbackInputStream, Map map) throws IOException {
        boolean bl = false;
        while (true) {
            int n;
            this.skipWhiteSpace(pushbackInputStream);
            boolean bl2 = false;
            String string = this.parseTagName(pushbackInputStream);
            if ("".equals(string)) break;
            if ("name".equalsIgnoreCase(string)) {
                bl2 = true;
                bl = true;
                this.skipWhiteSpace(pushbackInputStream);
                n = pushbackInputStream.read();
                if (n == -1 || n == 62) break;
                if (n != 61) {
                    this.consumeToTagEnd(pushbackInputStream);
                    break;
                }
                string = this.readRValue(pushbackInputStream);
                if ("".equalsIgnoreCase(string)) {
                    break;
                }
            } else {
                this.skipWhiteSpace(pushbackInputStream);
                n = pushbackInputStream.read();
                if (n != 61) {
                    this.consumeToTagEnd(pushbackInputStream);
                    break;
                }
            }
            this.skipWhiteSpace(pushbackInputStream);
            String string2 = this.parseTagName(pushbackInputStream);
            if (bl2) {
                this.skipWhiteSpace(pushbackInputStream);
                int n2 = pushbackInputStream.read();
                if (n2 == -1 || n2 == 62) break;
                if (n2 != 61) {
                    this.consumeToTagEnd(pushbackInputStream);
                    break;
                }
                string2 = this.readRValue(pushbackInputStream);
            }
            this.consumeToTagEnd(pushbackInputStream);
            map.put(string, string2);
        }
        return bl;
    }

    protected void handleIncludeTag(PushbackInputStream pushbackInputStream, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RequestDispatcher requestDispatcher = null;
        Map map = this.parseTagParameters(pushbackInputStream);
        String string = (String)map.get("virtual");
        if (string != null) {
            if (string.charAt(0) != '/') {
                string = "/" + string;
            }
            if ((requestDispatcher = this.getRD(string, httpServletRequest)) == null) {
                throw new FileNotFoundException("Failed find SSI included file: " + string);
            }
            try {
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        string = (String)map.get("file");
        if (string != null) {
            requestDispatcher = this.getRD(string, httpServletRequest);
            try {
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Iterator iterator = map.keySet().iterator();
        String string2 = (String)map.get(iterator.next());
        if (DEBUG_URL_RES.isDebugEnabled()) {
            if (string2 != null) {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Syntax of include tag containing " + string2 + " is incorrect.  Tag format is: <!--#include virtual=\"somefile.txt\">");
            } else {
                DEBUG_URL_RES.debug(this.context.getLogContext() + ": Syntax of include tag incorrect.  Tag format is: <!--#include virtual=\"somefile.txt\">");
            }
        }
    }

    private String parseTagName(PushbackInputStream pushbackInputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = pushbackInputStream.read();
        while (n != -1 && (Character.isLetterOrDigit((char)n) || (char)n == '_')) {
            stringBuilder.append((char)n);
            n = pushbackInputStream.read();
        }
        if (n != -1) {
            pushbackInputStream.unread(n);
        }
        return stringBuilder.toString();
    }

    private Map parseTagParameters(PushbackInputStream pushbackInputStream) throws IOException {
        String string;
        QueryParams queryParams = new QueryParams();
        this.skipWhiteSpace(pushbackInputStream);
        while ((string = this.parseTagName(pushbackInputStream)) != null && !"".equals(string)) {
            this.skipWhiteSpace(pushbackInputStream);
            String string2 = "";
            int n = pushbackInputStream.read();
            if (n == 61) {
                int n2;
                boolean bl;
                this.skipWhiteSpace(pushbackInputStream);
                n = pushbackInputStream.read();
                if (n == 34 || n == 39) {
                    bl = true;
                    n2 = n;
                    n = pushbackInputStream.read();
                } else {
                    bl = false;
                    n2 = -1;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (n > 0) {
                    if (bl) {
                        if (n == 10 || n == 13) {
                            throw new IOException("End of line reached within quoted value");
                        }
                        if (n == n2) {
                            break;
                        }
                    } else if (n == 32 || n == 9 || n == 10 || n == 13 || n == 62) {
                        pushbackInputStream.unread(n);
                        break;
                    }
                    stringBuilder.append((char)n);
                    n = pushbackInputStream.read();
                }
                if (n == 0) {
                    throw new IOException("End of file reached within SSI tag");
                }
                this.skipWhiteSpace(pushbackInputStream);
                string2 = stringBuilder.toString();
            }
            string = string.toLowerCase(Locale.ENGLISH);
            queryParams.put(string, string2);
            this.skipWhiteSpace(pushbackInputStream);
        }
        this.consumeToTagEnd(pushbackInputStream);
        return queryParams;
    }

    private void skipWhiteSpace(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        while ((n = pushbackInputStream.read()) != -1 && Character.isWhitespace((char)n)) {
        }
        if (n != -1) {
            pushbackInputStream.unread(n);
        }
    }

    private RequestDispatcher getRD(String string, HttpServletRequest httpServletRequest) {
        String string2;
        if (string.charAt(0) != '/') {
            String string3;
            string2 = httpServletRequest.getRequestURI();
            int n = string2.lastIndexOf(47);
            string = n == -1 ? '/' + string : (n == string2.length() - 1 ? string2 + string : (string2.startsWith(string3 = httpServletRequest.getContextPath()) ? string2.substring(string3.length(), n + 1) + string : string2.substring(0, n + 1) + string));
        }
        string2 = this.context.getRequestDispatcher(string);
        return string2;
    }
}

