/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import weblogic.servlet.XMLProcessingException;

public class XMLParsingHelper
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        XMLParsingRequestWrapper xMLParsingRequestWrapper = new XMLParsingRequestWrapper(servletRequest);
        filterChain.doFilter((ServletRequest)xMLParsingRequestWrapper, servletResponse);
    }

    public void destroy() {
    }

    private class XMLParsingRequestWrapper
    extends HttpServletRequestWrapper {
        public XMLParsingRequestWrapper(ServletRequest servletRequest) {
            super((HttpServletRequest)servletRequest);
        }

        public Object getAttribute(String string) {
            Object object = super.getAttribute(string);
            if (object != null) {
                return object;
            }
            String string2 = this.getContentType();
            if (string != null && string2 != null && "POST".equals(this.getMethod()) && string.equals("org.w3c.dom.Document") && (string2.startsWith("text/xml") || string2.startsWith("application/xml"))) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    EntityResolver entityResolver = (EntityResolver)this.getAttribute("org.xml.sax.EntityResolver");
                    if (entityResolver != null) {
                        documentBuilder.setEntityResolver(entityResolver);
                    }
                    return documentBuilder.parse((InputStream)this.getInputStream());
                }
                catch (Exception exception) {
                    throw new XMLProcessingException("Could not parse XML into a document", exception);
                }
            }
            return null;
        }

        public void setAttribute(String string, Object object) {
            if (string == null) {
                return;
            }
            String string2 = this.getContentType();
            if (object != null && string2 != null && "POST".equals(this.getMethod()) && (string2.startsWith("text/xml") || string2.startsWith("application/xml"))) {
                boolean bl = false;
                boolean bl2 = false;
                if (string.equals("org.xml.sax.HandlerBase") && object instanceof HandlerBase) {
                    bl = true;
                } else if (string.equals("org.xml.sax.helpers.DefaultHandler") && object instanceof DefaultHandler) {
                    bl2 = true;
                }
                if (bl || bl2) {
                    this.removeAttribute(string);
                    try {
                        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                        sAXParserFactory.setNamespaceAware(true);
                        SAXParser sAXParser = sAXParserFactory.newSAXParser();
                        if (bl) {
                            sAXParser.parse((InputStream)this.getInputStream(), (HandlerBase)object);
                        } else {
                            sAXParser.parse((InputStream)this.getInputStream(), (DefaultHandler)object);
                        }
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new XMLProcessingException("Could not parse posted XML into SAX events. " + parserConfigurationException.getMessage(), parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        throw new XMLProcessingException("Could not parse posted XML into SAX events." + sAXException.getMessage(), sAXException);
                    }
                    catch (IOException iOException) {
                        throw new XMLProcessingException("Could not parse posted XML into SAX events." + iOException.getMessage(), iOException);
                    }
                    return;
                }
            }
            super.setAttribute(string, object);
        }
    }
}

