/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.cluster;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.servlet.cluster.WANReplicationDetailsDebugLogger;
import weblogic.servlet.cluster.wan.BatchedSessionState;
import weblogic.servlet.cluster.wan.PersistenceServiceInternal;
import weblogic.servlet.cluster.wan.ServiceUnavailableException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public class LinkLivenessChecker
implements TimerListener {
    private static final long SUSPEND_TIMEOUT = 5000L;
    private final String remoteClusterURL;
    private PersistenceServiceInternal service;
    private boolean timerStopped = true;
    private final TimerManager timerManager;
    private final ClusterMBean clusterMBean;
    private boolean requiresValidSubject;

    LinkLivenessChecker(String string, ClusterMBean clusterMBean) {
        this(string, clusterMBean, false);
    }

    LinkLivenessChecker(String string, ClusterMBean clusterMBean, boolean bl) {
        this.remoteClusterURL = string;
        this.clusterMBean = clusterMBean;
        this.requiresValidSubject = bl;
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("commLinkManager");
    }

    PersistenceServiceInternal getRemotePersistenceService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        TimerManager timerManager = this.timerManager;
        synchronized (timerManager) {
            if (this.timerStopped) {
                return;
            }
            try {
                this.timerManager.waitForSuspend(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.timerStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        TimerManager timerManager = this.timerManager;
        synchronized (timerManager) {
            if (this.timerStopped) {
                this.timerManager.resume();
                this.timerManager.schedule((TimerListener)this, (long)this.clusterMBean.getInterClusterCommLinkHealthCheckInterval());
                this.timerStopped = false;
            }
        }
    }

    private void lookupRemotePersistenceService() {
        try {
            this.service = SecurePersistenceServiceImpl.getInstance(this.remoteClusterURL, this.requiresValidSubject);
            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                String string = this.service != null ? "Successfully looked up" : "Failed to look up";
                WANReplicationDetailsDebugLogger.debug(string + " Persistence Service from the remote cluster " + this.service);
            }
            if (this.service == null) {
                int n = this.clusterMBean.getInterClusterCommLinkHealthCheckInterval();
                this.timerManager.schedule((TimerListener)this, (long)n);
            }
        }
        catch (NamingException namingException) {
            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                WANReplicationDetailsDebugLogger.debug("Failed to get initial context " + this.remoteClusterURL);
            }
            int n = this.clusterMBean.getInterClusterCommLinkHealthCheckInterval();
            this.timerManager.schedule((TimerListener)this, (long)n);
        }
        catch (IOException iOException) {
            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                WANReplicationDetailsDebugLogger.debug("Failed to get initial context " + this.remoteClusterURL);
            }
            int n = this.clusterMBean.getInterClusterCommLinkHealthCheckInterval();
            this.timerManager.schedule((TimerListener)this, (long)n);
        }
    }

    public void timerExpired(Timer timer) {
        this.lookupRemotePersistenceService();
    }

    private static class SecurePersistenceServiceImpl
    implements PersistenceServiceInternal {
        static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        private final PersistenceServiceInternal delegate;
        private final String remoteURL;
        private final AuthenticatedSubject subject;

        static PersistenceServiceInternal getInstance(final String string, boolean bl) throws NamingException, IOException {
            AuthenticatedSubject authenticatedSubject = RemoteDomainSecurityHelper.getSubject(string);
            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                WANReplicationDetailsDebugLogger.debug("SecurePersistenceServiceImpl.getInstance  subject for " + string + " is " + authenticatedSubject);
            }
            if (authenticatedSubject == null) {
                return bl ? null : SecurePersistenceServiceImpl.lookup(string);
            }
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        return SecurePersistenceServiceImpl.lookup(string);
                    }
                    catch (NamingException namingException) {
                        return namingException;
                    }
                }
            };
            try {
                Object object = SecurityManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)privilegedExceptionAction);
                if (object instanceof NamingException) {
                    throw (NamingException)object;
                }
                return new SecurePersistenceServiceImpl((PersistenceServiceInternal)object, string, authenticatedSubject);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new AssertionError((Object)privilegedActionException);
            }
        }

        private static PersistenceServiceInternal lookup(String string) throws NamingException {
            Environment environment = new Environment();
            environment.setProviderUrl(string);
            Context context = environment.getInitialContext();
            return (PersistenceServiceInternal)context.lookup("weblogic/servlet/wan/persistenceservice");
        }

        private SecurePersistenceServiceImpl(PersistenceServiceInternal persistenceServiceInternal, String string, AuthenticatedSubject authenticatedSubject) {
            this.delegate = persistenceServiceInternal;
            this.remoteURL = string;
            this.subject = authenticatedSubject;
        }

        public void persistState(final BatchedSessionState batchedSessionState) throws ServiceUnavailableException, RemoteException {
            if (this.subject == null) {
                this.delegate.persistState(batchedSessionState);
            } else {
                SecurePersistenceServiceImpl.execute(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            SecurePersistenceServiceImpl.this.delegate.persistState(batchedSessionState);
                            return null;
                        }
                        catch (RemoteException remoteException) {
                            return remoteException;
                        }
                    }
                }, this.subject);
            }
        }

        public void invalidateSessions(final Set set) throws RemoteException {
            if (this.subject == null) {
                this.delegate.invalidateSessions(set);
            } else {
                SecurePersistenceServiceImpl.execute(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            SecurePersistenceServiceImpl.this.delegate.invalidateSessions(set);
                            return null;
                        }
                        catch (RemoteException remoteException) {
                            return remoteException;
                        }
                    }
                }, this.subject);
            }
        }

        private static void execute(PrivilegedExceptionAction privilegedExceptionAction, AuthenticatedSubject authenticatedSubject) throws RemoteException {
            try {
                RemoteException remoteException = (RemoteException)SecurityManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)privilegedExceptionAction);
                if (remoteException != null) {
                    throw remoteException;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new AssertionError((Object)privilegedActionException);
            }
        }

        private static AuthenticatedSubject getSubject(String string) {
            try {
                return RemoteDomainSecurityHelper.getSubject(string);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

