/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.cluster;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.cluster.LinkLivenessChecker;
import weblogic.servlet.cluster.WANReplicationDetailsDebugLogger;
import weblogic.servlet.cluster.WANReplicationRuntime;
import weblogic.servlet.cluster.wan.BatchedSessionState;
import weblogic.servlet.cluster.wan.Invalidate;
import weblogic.servlet.cluster.wan.PersistenceService;
import weblogic.servlet.cluster.wan.PersistenceServiceControl;
import weblogic.servlet.cluster.wan.PersistenceServiceImpl;
import weblogic.servlet.cluster.wan.PersistenceServiceInternal;
import weblogic.servlet.cluster.wan.ServiceUnavailableException;
import weblogic.servlet.cluster.wan.SessionDiff;
import weblogic.servlet.cluster.wan.Update;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.WANSessionData;
import weblogic.servlet.utils.ServletObjectInputStream;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.StopTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.AssertionError;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class WANPersistenceManager
implements PersistenceService,
PersistenceServiceControl {
    private static final int DEFAULT_MAX_CONCURRENCY = 5;
    private String selectQuery;
    private static String isSessionValidQuery;
    private long timeAtLastInvalidateFlush;
    private final int UPDATE_SIZE;
    private final int INVALIDATE_SIZE;
    private final String backupClusterAddress;
    private final String dataSourceName;
    private final DataSource dataSource;
    private final int sessionFlushInterval;
    private final ArrayList pendingUpdates = new ArrayList();
    private final ArrayList pendingInvalidates = new ArrayList();
    private final HashSet updateSet;
    private final HashSet invalidateSet;
    private final WorkManager workManager;
    private final PersistenceServiceInternal localService;
    private final Timer updateTimer;
    private final Timer invalidateTimer;
    private long timeAtLastUpdateFlush = 0L;
    private int updateIndex = 0;
    private int invalidateIndex = 0;
    private LinkLivenessChecker linkChecker;
    private final TimerManager sessionUpdateFlushTimerManager;
    private final TimerManager sessionInvalidateFlushTimerManager;
    private final boolean isServiceAvailable;
    private final WANReplicationRuntime runtime;
    private final boolean updateOnlyOnShutdown;
    private String srvrState;

    public static final PersistenceService getInstance() {
        return SingletonMaker.singleton;
    }

    public static final PersistenceServiceControl getControlInstance() {
        return SingletonMaker.singleton;
    }

    private void initQueryStrings(String string) {
        this.selectQuery = " SELECT WL_SESSION_ATTRIBUTE_KEY, WL_SESSION_ATTRIBUTE_VALUE FROM " + string + " WHERE WL_ID = ? AND WL_CONTEXT_PATH = ? AND WL_INTERNAL_ATTRIBUTE = ?";
        isSessionValidQuery = "SELECT WL_CREATE_TIME, WL_ACCESS_TIME, WL_MAX_INACTIVE_INTERVAL, WL_VERSION FROM " + string + " WHERE WL_ID = ? AND WL_CONTEXT_PATH = ? AND" + " WL_VERSION = (SELECT MAX(WL_VERSION) from " + string + " WHERE WL_ID = ? AND" + " WL_CONTEXT_PATH = ?)";
    }

    private WANPersistenceManager() {
        String[] stringArray;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getCluster();
        this.initQueryStrings(clusterMBean.getWANSessionPersistenceTableName());
        this.UPDATE_SIZE = clusterMBean.getSessionFlushThreshold() == -1 ? 0 : clusterMBean.getSessionFlushThreshold();
        this.INVALIDATE_SIZE = this.UPDATE_SIZE / 10 == 0 ? 1 : this.UPDATE_SIZE / 10;
        this.sessionFlushInterval = clusterMBean.getSessionFlushInterval() == -1 ? 0 : clusterMBean.getSessionFlushInterval() * 1000;
        this.updateOnlyOnShutdown = this.UPDATE_SIZE + this.sessionFlushInterval == 0 || clusterMBean.getPersistSessionsOnShutdown() && clusterMBean.getClusterType() != "wan";
        JDBCSystemResourceMBean jDBCSystemResourceMBean = clusterMBean.getDataSourceForSessionPersistence();
        this.dataSourceName = jDBCSystemResourceMBean != null ? ((stringArray = jDBCSystemResourceMBean.getJDBCResource().getJDBCDataSourceParams().getJNDINames()) != null && stringArray.length > 0 ? stringArray[0] : null) : null;
        this.backupClusterAddress = clusterMBean.getRemoteClusterAddress();
        this.dataSource = this.lookupDataSource();
        this.workManager = WorkManagerFactory.getInstance().findOrCreate("WAN_ASYNC_SESSION_FLUSH_WM", -1, WANPersistenceManager.getMaxThreadsConstraint(jDBCSystemResourceMBean));
        this.localService = this.dataSource != null ? new PersistenceServiceImpl(this.dataSource) : null;
        this.sessionUpdateFlushTimerManager = this.dataSource != null ? TimerManagerFactory.getTimerManagerFactory().getTimerManager("sessionUpdateFlushTimerManager") : null;
        this.sessionInvalidateFlushTimerManager = this.dataSource != null ? TimerManagerFactory.getTimerManagerFactory().getTimerManager("sessionInvalidateFlushTimerManager") : null;
        this.isServiceAvailable = this.dataSource != null;
        this.startLivenessLinkChecker(clusterMBean);
        this.runtime = this.getWANReplicationRuntime(ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getName());
        this.updateSet = WANPersistenceManager.createUpdateSet(this.UPDATE_SIZE);
        this.invalidateSet = WANPersistenceManager.createInvalidationSet(this.INVALIDATE_SIZE);
        this.updateTimer = this.scheduleSessionUpdateTimer();
        this.invalidateTimer = this.scheduleInvalidationTimer();
        this.srvrState = this.isServiceAvailable ? "RUNNING" : "";
    }

    private static int getMaxThreadsConstraint(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        if (jDBCSystemResourceMBean == null) {
            return 5;
        }
        return jDBCSystemResourceMBean.getJDBCResource().getJDBCConnectionPoolParams().getMaxCapacity();
    }

    private Timer scheduleSessionUpdateTimer() {
        if (!this.isServiceAvailable) {
            return null;
        }
        if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
            WANReplicationDetailsDebugLogger.debug("Session Flush Interval " + this.sessionFlushInterval + "ms" + " and threshold is " + this.UPDATE_SIZE);
        }
        return this.sessionUpdateFlushTimerManager.schedule((TimerListener)new SessionUpdateFlushTrigger(this, this.sessionFlushInterval), (long)this.sessionFlushInterval, (long)this.sessionFlushInterval);
    }

    private Timer scheduleInvalidationTimer() {
        if (!this.isServiceAvailable) {
            return null;
        }
        int n = this.sessionFlushInterval / 2;
        if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
            WANReplicationDetailsDebugLogger.debug("Session Invalidation Interval " + n + "ms " + " and threshold is " + this.INVALIDATE_SIZE);
        }
        return this.sessionInvalidateFlushTimerManager.schedule((TimerListener)new SessionInvalidateFlushTrigger(this), (long)n, (long)n);
    }

    private static HashSet createUpdateSet(int n) {
        if (n == 0) {
            return new HashSet(5);
        }
        return new HashSet(n);
    }

    private static HashSet createInvalidationSet(int n) {
        if (n == 0) {
            return new HashSet(5);
        }
        return new HashSet(n);
    }

    private void startLivenessLinkChecker(ClusterMBean clusterMBean) {
        if (this.backupClusterAddress == null) {
            return;
        }
        boolean bl = false;
        if (clusterMBean != null) {
            bl = ((DomainMBean)clusterMBean.getParent()).getSecurityConfiguration().isCrossDomainSecurityEnabled();
        }
        this.linkChecker = new LinkLivenessChecker(this.backupClusterAddress, clusterMBean, bl);
        this.linkChecker.resume();
    }

    private WANReplicationRuntime getWANReplicationRuntime(String string) {
        if (this.dataSource == null) {
            return null;
        }
        try {
            return new WANReplicationRuntime(string);
        }
        catch (ManagementException managementException) {
            throw new AssertionError("Unexpected exception", (Throwable)managementException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSource lookupDataSource() {
        DataSource dataSource;
        if (this.dataSourceName == null) {
            return null;
        }
        InitialContext initialContext = null;
        try {
            try {
                initialContext = new InitialContext();
                dataSource = (DataSource)initialContext.lookup(this.dataSourceName);
                Object var5_4 = null;
                if (initialContext == null) return dataSource;
            }
            catch (NamingException namingException) {
                HTTPSessionLogger.logWANSessionConfigurationError();
                DataSource dataSource2 = null;
                Object var5_5 = null;
                if (initialContext == null) return dataSource2;
                try {
                    initialContext.close();
                    return dataSource2;
                }
                catch (NamingException namingException3) {
                    // empty catch block
                }
                return dataSource2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (initialContext == null) throw throwable;
            try {}
            catch (NamingException namingException2) {
                throw throwable;
            }
            initialContext.close();
            throw throwable;
        }
        try {}
        catch (NamingException namingException) {
            // empty catch block
            return dataSource;
        }
        initialContext.close();
        return dataSource;
    }

    private PersistenceServiceInternal getPersistenceServiceInternal() {
        if (this.backupClusterAddress == null) {
            return ((PersistenceServiceImpl)this.localService).getLocalService();
        }
        return this.linkChecker.getRemotePersistenceService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String string, long l, String string2, int n, long l2, SessionDiff sessionDiff) {
        if (this.updateOnlyOnShutdown) {
            return;
        }
        boolean bl = false;
        HashSet hashSet = null;
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            this.updateSet.add(new Update(string, string2, l, n, l2, sessionDiff));
            ++this.updateIndex;
            boolean bl2 = bl = this.updateIndex == this.UPDATE_SIZE;
            if (bl) {
                hashSet = (HashSet)this.updateSet.clone();
                this.updateSet.clear();
                this.updateIndex = 0;
                this.timeAtLastUpdateFlush = System.currentTimeMillis();
            }
        }
        if (bl) {
            this.workManager.schedule((Runnable)new FlushWork(hashSet, this));
        }
    }

    public void flushUponShutdown(String string, long l, String string2, int n, long l2, SessionDiff sessionDiff) {
        this.updateSet.add(new Update(string, string2, l, n, l2, sessionDiff));
        PersistenceServiceInternal persistenceServiceInternal = this.getPersistenceServiceInternal();
        if (persistenceServiceInternal == null) {
            return;
        }
        this.flush(persistenceServiceInternal, this.updateSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fetchState(String string, String string2, WANSessionData wANSessionData) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block19: {
            boolean bl;
            block18: {
                boolean bl2;
                block17: {
                    connection = null;
                    try {
                        connection = this.dataSource.getConnection();
                    }
                    catch (SQLException sQLException) {
                        if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                            WANReplicationDetailsDebugLogger.debug("Failed to obtain database connection", sQLException);
                        }
                        return false;
                    }
                    preparedStatement = null;
                    resultSet = null;
                    try {
                        try {
                            resultSet = WANPersistenceManager.isSessionValid(connection, string, string2);
                            if (!resultSet.next()) {
                                if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                                    WANReplicationDetailsDebugLogger.debug("Session is invalid");
                                }
                                bl2 = false;
                                Object var17_13 = null;
                                break block17;
                            }
                            long l2 = resultSet.getLong(1);
                            long l = resultSet.getLong(2);
                            int n = resultSet.getInt(3);
                            long l3 = System.currentTimeMillis();
                            if (l3 - l > (long)(n * 1000)) {
                                if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                                    WANReplicationDetailsDebugLogger.debug("Session expired");
                                    WANReplicationDetailsDebugLogger.debug("CURRENT TIME " + l3);
                                    WANReplicationDetailsDebugLogger.debug("Last Access " + l);
                                    WANReplicationDetailsDebugLogger.debug("MAX INACTIVE " + n);
                                    WANReplicationDetailsDebugLogger.debug("RESULT " + (l3 - l > (long)(n * 1000)));
                                }
                                bl = false;
                                break block18;
                            }
                            wANSessionData.setLastAccessedTime(l);
                            wANSessionData.setMaxInactiveInterval(n);
                            wANSessionData.setCreationTime(l2);
                            SessionDiff sessionDiff = new SessionDiff();
                            int n2 = resultSet.getInt(4);
                            if (n2 > sessionDiff.getVersionCount()) {
                                sessionDiff.setVersionCounter(n2);
                            }
                            preparedStatement = connection.prepareStatement(this.selectQuery);
                            resultSet = WANPersistenceManager.populateInternalAttributes(preparedStatement, string, string2, resultSet, sessionDiff);
                            preparedStatement = connection.prepareStatement(this.selectQuery);
                            resultSet = WANPersistenceManager.populateAttributes(preparedStatement, string, string2, resultSet, sessionDiff);
                            wANSessionData.applySessionDiff(sessionDiff);
                            break block19;
                        }
                        catch (SQLException sQLException) {
                            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                                WANReplicationDetailsDebugLogger.debug("Failed to updateIndex the database", sQLException);
                            }
                            boolean bl3 = false;
                            Object var17_16 = null;
                            WANPersistenceManager.close(preparedStatement, resultSet, connection);
                            return bl3;
                        }
                        catch (IOException iOException) {
                            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                                WANReplicationDetailsDebugLogger.debug("Failed while deserializing the attribute for user session with id: " + string, iOException);
                            }
                            boolean bl4 = false;
                            Object var17_17 = null;
                            WANPersistenceManager.close(preparedStatement, resultSet, connection);
                            return bl4;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                                WANReplicationDetailsDebugLogger.debug("Failed while deserializing the session attributes for user session  with id: " + string, classNotFoundException);
                            }
                            boolean bl5 = false;
                            Object var17_18 = null;
                            WANPersistenceManager.close(preparedStatement, resultSet, connection);
                            return bl5;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        WANPersistenceManager.close(preparedStatement, resultSet, connection);
                        throw throwable;
                    }
                }
                WANPersistenceManager.close(preparedStatement, resultSet, connection);
                return bl2;
            }
            Object var17_14 = null;
            WANPersistenceManager.close(preparedStatement, resultSet, connection);
            return bl;
        }
        Object var17_15 = null;
        WANPersistenceManager.close(preparedStatement, resultSet, connection);
        this.runtime.incrementNumberOfSessionsRetrievedFromTheDatabase();
        return true;
    }

    private static ResultSet populateAttributes(PreparedStatement preparedStatement, String string, String string2, ResultSet resultSet, SessionDiff sessionDiff) throws SQLException, IOException, ClassNotFoundException {
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setInt(3, 0);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            WANPersistenceManager.populateAttributes(resultSet, sessionDiff);
        }
        return resultSet;
    }

    private static ResultSet populateInternalAttributes(PreparedStatement preparedStatement, String string, String string2, ResultSet resultSet, SessionDiff sessionDiff) throws SQLException, IOException, ClassNotFoundException {
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setInt(3, 1);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            WANPersistenceManager.populateInternalAttributes(resultSet, sessionDiff);
        }
        return resultSet;
    }

    private static ResultSet isSessionValid(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(isSessionValidQuery);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string);
        preparedStatement.setString(4, string2);
        return preparedStatement.executeQuery();
    }

    private static void close(PreparedStatement preparedStatement, ResultSet resultSet, Connection connection) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void populateAttributes(ResultSet resultSet, SessionDiff sessionDiff) throws SQLException, IOException, ClassNotFoundException {
        do {
            String string = resultSet.getString(1);
            byte[] byArray = resultSet.getBytes(2);
            ServletObjectInputStream servletObjectInputStream = ServletObjectInputStream.getInputStream(byArray);
            Object object = servletObjectInputStream.readObject();
            sessionDiff.setAttribute(string, object, false, false);
            ServletObjectInputStream.releaseInputStream(servletObjectInputStream);
        } while (resultSet.next());
    }

    private static void populateInternalAttributes(ResultSet resultSet, SessionDiff sessionDiff) throws SQLException, IOException, ClassNotFoundException {
        do {
            String string = resultSet.getString(1);
            byte[] byArray = resultSet.getBytes(2);
            ServletObjectInputStream servletObjectInputStream = ServletObjectInputStream.getInputStream(byArray);
            Object object = servletObjectInputStream.readObject();
            sessionDiff.setAttribute(string, object, false, true);
            ServletObjectInputStream.releaseInputStream(servletObjectInputStream);
        } while (resultSet.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String string, String string2) {
        boolean bl = false;
        HashSet hashSet = null;
        Object object = this;
        synchronized (object) {
            this.invalidateSet.add(new Invalidate(string, string2));
            ++this.invalidateIndex;
            boolean bl2 = bl = this.invalidateIndex == this.INVALIDATE_SIZE;
            if (bl) {
                hashSet = (HashSet)this.invalidateSet.clone();
                this.timeAtLastInvalidateFlush = System.currentTimeMillis();
                this.invalidateIndex = 0;
                this.invalidateSet.clear();
            }
        }
        object = this.getPersistenceServiceInternal();
        if (bl && object != null) {
            this.flushInvalidateRequests((PersistenceServiceInternal)object, hashSet);
        }
    }

    public final boolean isServiceAvailable() {
        return this.isServiceAvailable;
    }

    public void start() {
        if (this.localService == null) {
            return;
        }
        try {
            Environment environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            Context context = environment.getInitialContext();
            context.rebind("weblogic/servlet/wan/persistenceservice", (Object)this.localService);
        }
        catch (NamingException namingException) {
            throw new AssertionError("Unexpected exception" + namingException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PersistenceServiceInternal persistenceServiceInternal = this.getPersistenceServiceInternal();
        if (persistenceServiceInternal == null) {
            return;
        }
        HashSet hashSet = null;
        Object object = this;
        synchronized (object) {
            hashSet = (HashSet)this.updateSet.clone();
        }
        this.flush(persistenceServiceInternal, hashSet);
        try {
            object = new Environment();
            Context context = ((Environment)object).getInitialContext();
            context.unbind("weblogic/servlet/wan/persistenceservice");
        }
        catch (NamingException namingException) {
            throw new AssertionError("Unexpected exception" + namingException.toString());
        }
        this.invalidateTimer.cancel();
        this.updateTimer.cancel();
        this.srvrState = "SHUTDOWN";
    }

    public void halt() {
        this.stop();
    }

    private void flushInvalidateRequests(PersistenceServiceInternal persistenceServiceInternal, Set set) {
        if (set.size() == 0) {
            return;
        }
        try {
            persistenceServiceInternal.invalidateSessions(set);
            if (this.getPendingInvalidatesSize() > 0) {
                this.firePendingInvalidates();
            }
            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                WANReplicationDetailsDebugLogger.debug("Invalidating " + this.invalidateSet.size() + " sessions in the database");
            }
        }
        catch (RemoteException remoteException) {
            this.addPendingInvalidates(new PendingInvalidateRequest(set, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        PersistenceServiceInternal persistenceServiceInternal = this.getPersistenceServiceInternal();
        if (persistenceServiceInternal == null) {
            return;
        }
        HashSet hashSet = null;
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            hashSet = (HashSet)this.updateSet.clone();
        }
        this.flush(persistenceServiceInternal, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInvalidation() {
        PersistenceServiceInternal persistenceServiceInternal = this.getPersistenceServiceInternal();
        if (persistenceServiceInternal == null) {
            return;
        }
        HashSet hashSet = null;
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            hashSet = (HashSet)this.invalidateSet.clone();
        }
        this.flushInvalidateRequests(persistenceServiceInternal, hashSet);
    }

    private void flush(PersistenceServiceInternal persistenceServiceInternal, Set set) {
        int n = set.size();
        Update[] updateArray = new Update[n];
        set.toArray(updateArray);
        BatchedSessionState batchedSessionState = new BatchedSessionState(updateArray);
        try {
            if (persistenceServiceInternal != null) {
                persistenceServiceInternal.persistState(batchedSessionState);
                if (this.getPendingUpdatesSize() > 0) {
                    this.firePendingUpdates();
                    this.runtime.setRemoteClusterReachable(true);
                }
                this.incrementUpdateCount();
            } else {
                this.addPendingUpdates(new PendingUpdateRequest(batchedSessionState, this));
            }
            if (WANReplicationDetailsDebugLogger.isDebugEnabled() && this.backupClusterAddress != null) {
                WANReplicationDetailsDebugLogger.debug("Flushed " + n + " sessions to the remote cluster");
            }
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            this.runtime.setRemoteClusterReachable(false);
            this.addPendingUpdates(new PendingUpdateRequest(batchedSessionState, this));
        }
        catch (RemoteException remoteException) {
            this.runtime.setRemoteClusterReachable(false);
            this.addPendingUpdates(new PendingUpdateRequest(batchedSessionState, this));
        }
    }

    private long getTimeAtLastUpdateFlush() {
        return this.timeAtLastUpdateFlush;
    }

    private long getTimeAtLastInvalidateFlush() {
        return this.timeAtLastInvalidateFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingUpdates(PendingUpdateRequest pendingUpdateRequest) {
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            this.pendingUpdates.add(pendingUpdateRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPendingUpdatesSize() {
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            return this.pendingUpdates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePendingUpdates() {
        ArrayList arrayList = null;
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            arrayList = (ArrayList)this.pendingUpdates.clone();
            this.pendingUpdates.clear();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PendingUpdateRequest pendingUpdateRequest = (PendingUpdateRequest)arrayList.get(i);
            this.workManager.schedule((Runnable)pendingUpdateRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPendingInvalidatesSize() {
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            return this.pendingInvalidates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePendingInvalidates() {
        ArrayList arrayList = null;
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            arrayList = (ArrayList)this.pendingInvalidates.clone();
            this.pendingInvalidates.clear();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PendingInvalidateRequest pendingInvalidateRequest = (PendingInvalidateRequest)arrayList.get(i);
            this.workManager.schedule((Runnable)pendingInvalidateRequest);
        }
    }

    private void incrementUpdateCount() {
        this.runtime.incrementNumberOfSessionsFlushedToTheDatabase();
    }

    private LinkLivenessChecker getLinkChecker() {
        return this.linkChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingInvalidates(PendingInvalidateRequest pendingInvalidateRequest) {
        WANPersistenceManager wANPersistenceManager = this;
        synchronized (wANPersistenceManager) {
            this.pendingInvalidates.add(pendingInvalidateRequest);
        }
    }

    private static final class SessionInvalidateFlushTrigger
    implements NakedTimerListener,
    StopTimerListener {
        private final WANPersistenceManager manager;

        private SessionInvalidateFlushTrigger(WANPersistenceManager wANPersistenceManager) {
            this.manager = wANPersistenceManager;
        }

        public void timerExpired(Timer timer) {
            this.manager.flushInvalidation();
        }

        public void timerStopped(Timer timer) {
            this.manager.flushInvalidation();
        }
    }

    private static final class FlushWork
    implements Runnable {
        private final WANPersistenceManager manager;
        private final Set set;

        private FlushWork(Set set, WANPersistenceManager wANPersistenceManager) {
            this.set = set;
            this.manager = wANPersistenceManager;
        }

        public void run() {
            PersistenceServiceInternal persistenceServiceInternal = this.manager.getPersistenceServiceInternal();
            if (persistenceServiceInternal == null && WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                WANReplicationDetailsDebugLogger.debug("Couldn't reach remote cluster  persistence service");
            }
            this.manager.flush(persistenceServiceInternal, this.set);
        }
    }

    private static final class SessionUpdateFlushTrigger
    implements NakedTimerListener {
        private final WANPersistenceManager manager;
        private final int flushPeriod;

        private SessionUpdateFlushTrigger(WANPersistenceManager wANPersistenceManager, int n) {
            this.manager = wANPersistenceManager;
            this.flushPeriod = n;
        }

        public void timerExpired(Timer timer) {
            if (System.currentTimeMillis() - this.manager.getTimeAtLastUpdateFlush() > (long)this.flushPeriod) {
                this.manager.flush();
            }
        }
    }

    private static final class PendingInvalidateRequest
    implements Runnable {
        private final WANPersistenceManager manager;
        private final Set set;

        private PendingInvalidateRequest(Set set, WANPersistenceManager wANPersistenceManager) {
            this.set = set;
            this.manager = wANPersistenceManager;
        }

        public void run() {
            block5: {
                try {
                    PersistenceServiceInternal persistenceServiceInternal = this.manager.getPersistenceServiceInternal();
                    if (persistenceServiceInternal != null) {
                        persistenceServiceInternal.invalidateSessions(this.set);
                        if (this.manager.getLinkChecker() != null) {
                            this.manager.getLinkChecker().stop();
                        }
                    } else {
                        this.manager.addPendingInvalidates(this);
                    }
                }
                catch (RemoteException remoteException) {
                    this.manager.addPendingInvalidates(this);
                    if (this.manager.getLinkChecker() == null) break block5;
                    this.manager.getLinkChecker().resume();
                }
            }
        }
    }

    private static final class PendingUpdateRequest
    implements Runnable {
        private final WANPersistenceManager manager;
        private final BatchedSessionState state;

        private PendingUpdateRequest(BatchedSessionState batchedSessionState, WANPersistenceManager wANPersistenceManager) {
            this.state = batchedSessionState;
            this.manager = wANPersistenceManager;
        }

        public void run() {
            block7: {
                try {
                    PersistenceServiceInternal persistenceServiceInternal = this.manager.getPersistenceServiceInternal();
                    if (persistenceServiceInternal != null) {
                        persistenceServiceInternal.persistState(this.state);
                        this.manager.incrementUpdateCount();
                        if (this.manager.getLinkChecker() != null) {
                            this.manager.getLinkChecker().stop();
                        }
                    } else {
                        this.manager.addPendingUpdates(this);
                    }
                }
                catch (ServiceUnavailableException serviceUnavailableException) {
                    this.manager.addPendingUpdates(this);
                    if (this.manager.getLinkChecker() != null) {
                        this.manager.getLinkChecker().resume();
                    }
                }
                catch (RemoteException remoteException) {
                    this.manager.addPendingUpdates(this);
                    if (this.manager.getLinkChecker() == null) break block7;
                    this.manager.getLinkChecker().resume();
                }
            }
        }
    }

    private static final class SingletonMaker {
        static final WANPersistenceManager singleton = new WANPersistenceManager();

        private SingletonMaker() {
        }
    }
}

