/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.cluster.wan;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import javax.sql.DataSource;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.servlet.cluster.WANReplicationDetailsDebugLogger;
import weblogic.servlet.cluster.wan.BatchedSessionState;
import weblogic.servlet.cluster.wan.Invalidate;
import weblogic.servlet.cluster.wan.PersistenceServiceInternal;
import weblogic.servlet.cluster.wan.ServiceUnavailableException;
import weblogic.servlet.cluster.wan.SessionDiff;
import weblogic.servlet.cluster.wan.Update;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public class PersistenceServiceImpl
implements PersistenceServiceInternal {
    private final String insertQuery;
    private final String updateQuery;
    private final String deleteQuery;
    private final PersistenceServiceInternal localService;
    static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int QUERY_TIMEOUT = 30;
    private final DataSource dataSource;

    public PersistenceServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
        String string = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getCluster().getWANSessionPersistenceTableName();
        this.insertQuery = " INSERT INTO " + string + " (wl_id, wl_create_time, wl_context_path, " + "wl_max_inactive_interval, wl_access_time, wl_version,  " + "wl_session_attribute_key, wl_session_attribute_value, wl_internal_attribute) " + " values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.updateQuery = " UPDATE " + string + " set wl_access_time " + " = ?, wl_session_attribute_value = ?, wl_version = ? where wl_id = ? " + "AND wl_context_path = ? AND wl_session_attribute_key = ? AND " + "wl_internal_attribute = ? AND (? > (select max(wl_version) from " + string + " where wl_id = ? AND wl_context_path = ? AND wl_session_attribute_key = ?))";
        this.deleteQuery = "DELETE FROM " + string + " WHERE WL_ID = ? AND WL_CONTEXT_PATH = ? ";
        this.localService = new LocalPersistenceServiceInternal(this);
    }

    public PersistenceServiceInternal getLocalService() {
        return this.localService;
    }

    public void localPersistState(BatchedSessionState batchedSessionState) throws ServiceUnavailableException {
        this.persistState(batchedSessionState, false);
    }

    public void persistState(BatchedSessionState batchedSessionState) throws ServiceUnavailableException {
        this.persistState(batchedSessionState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void persistState(BatchedSessionState batchedSessionState, boolean bl) throws ServiceUnavailableException {
        Update[] updateArray;
        int n;
        if (bl) {
            this.verifyCaller();
        }
        if ((n = (updateArray = batchedSessionState.getUpdates()).length) == 0) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) throw new ServiceUnavailableException("Database unavailabe");
            WANReplicationDetailsDebugLogger.debug("Database unavailable", sQLException);
            throw new ServiceUnavailableException("Database unavailabe");
        }
        try {
            SessionDiff[] sessionDiffArray = new SessionDiff[n];
            PreparedStatement preparedStatement = null;
            preparedStatement = this.createSessionsInDB(connection, preparedStatement, n, updateArray, sessionDiffArray, batchedSessionState);
            this.updateSession(connection, preparedStatement, n, sessionDiffArray, updateArray, batchedSessionState);
            if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                WANReplicationDetailsDebugLogger.debug("Persisted " + updateArray.length + " sessions to the database");
            }
            Object var9_9 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return;
        }
        catch (SQLException sQLException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement createSessionsInDB(Connection connection, PreparedStatement preparedStatement, int n, Update[] updateArray, SessionDiff[] sessionDiffArray, BatchedSessionState batchedSessionState) {
        try {
            try {
                preparedStatement = connection.prepareStatement(this.insertQuery);
                for (int i = 0; i < n; ++i) {
                    try {
                        sessionDiffArray[i] = updateArray[i].getChange();
                        HashMap hashMap = sessionDiffArray[i].getNewAttributes();
                        this.insertAttributes(hashMap, preparedStatement, updateArray[i], false, sessionDiffArray[i]);
                        hashMap = sessionDiffArray[i].getNewInternalAttributes();
                        this.insertAttributes(hashMap, preparedStatement, updateArray[i], true, sessionDiffArray[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                        WANReplicationDetailsDebugLogger.debug("Failed to serialize new attributes for user session identified by " + updateArray[i].getSessionID(), iOException);
                    }
                }
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {
                if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                    WANReplicationDetailsDebugLogger.debug("Failed while making bulk  insert. We will automatically attempt to fix this ", sQLException);
                }
                this.makeIndividualInsertCalls(connection, batchedSessionState, sessionDiffArray);
                Object var10_12 = null;
                this.closeStatement(preparedStatement);
            }
            Object var10_11 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSession(Connection connection, PreparedStatement preparedStatement, int n, SessionDiff[] sessionDiffArray, Update[] updateArray, BatchedSessionState batchedSessionState) {
        try {
            try {
                preparedStatement = connection.prepareStatement(this.updateQuery);
                PersistenceServiceImpl.setQueryTimeout(preparedStatement, 30);
                for (int i = 0; i < n; ++i) {
                    try {
                        if (sessionDiffArray[i] == null) {
                            sessionDiffArray[i] = updateArray[i].getChange();
                        }
                        HashMap hashMap = sessionDiffArray[i].getUpdateAttributes();
                        this.updateAttributes(hashMap, preparedStatement, updateArray[i], false, sessionDiffArray[i]);
                        hashMap = sessionDiffArray[i].getUpdateInternalAttributes();
                        this.updateAttributes(hashMap, preparedStatement, updateArray[i], true, sessionDiffArray[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                        WANReplicationDetailsDebugLogger.debug("Failed to serialize updated attributes for user session identified by " + updateArray[i].getSessionID(), iOException);
                    }
                }
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {
                if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                    WANReplicationDetailsDebugLogger.debug("Failed while making bulk  update. We will automatically attempt to fix this ", sQLException);
                }
                this.makeIndividualUpdateCalls(connection, batchedSessionState, sessionDiffArray);
                Object var10_12 = null;
                this.closeStatement(preparedStatement);
            }
            Object var10_11 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeIndividualUpdateCalls(Connection connection, BatchedSessionState batchedSessionState, SessionDiff[] sessionDiffArray) {
        PreparedStatement preparedStatement;
        Update[] updateArray = batchedSessionState.getUpdates();
        int n = updateArray.length;
        try {
            preparedStatement = connection.prepareStatement(this.updateQuery);
        }
        catch (SQLException sQLException) {
            throw new AssertionError((Object)("Unexpected exception" + sQLException.toString()));
        }
        try {
            for (int i = 0; i < n; ++i) {
                if (sessionDiffArray[i] == null) {
                    sessionDiffArray[i] = updateArray[i].getChange();
                }
                this.makeIndividualUpdateCall(sessionDiffArray[i].getUpdateAttributes(), updateArray[i], sessionDiffArray[i], preparedStatement, false);
                this.makeIndividualUpdateCall(sessionDiffArray[i].getUpdateInternalAttributes(), updateArray[i], sessionDiffArray[i], preparedStatement, true);
            }
            Object var9_9 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private void makeIndividualUpdateCall(HashMap hashMap, Update update, SessionDiff sessionDiff, PreparedStatement preparedStatement, boolean bl) {
        for (String string : hashMap.keySet()) {
            try {
                preparedStatement.setLong(1, update.getLastAccessTime());
                byte[] byArray = sessionDiff.getBytesForDB(hashMap.get(string));
                preparedStatement.setBytes(2, byArray);
                preparedStatement.setInt(3, sessionDiff.getVersionCount());
                preparedStatement.setString(4, update.getSessionID());
                preparedStatement.setString(5, update.getContextPath());
                preparedStatement.setString(6, string);
                preparedStatement.setInt(7, bl ? 1 : 0);
                preparedStatement.setInt(8, sessionDiff.getVersionCount());
                preparedStatement.setString(9, update.getSessionID());
                preparedStatement.setString(10, update.getContextPath());
                preparedStatement.setString(11, string);
                PersistenceServiceImpl.setQueryTimeout(preparedStatement, 30);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                WANReplicationDetailsDebugLogger.debug("Failed while making individual update call for user with session id " + update.getSessionID(), sQLException);
            }
            catch (IOException iOException) {
                if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                WANReplicationDetailsDebugLogger.debug("Failed while making individual update call for user with session id " + update.getSessionID(), iOException);
            }
        }
    }

    private void updateAttributes(HashMap hashMap, PreparedStatement preparedStatement, Update update, boolean bl, SessionDiff sessionDiff) throws SQLException, IOException {
        for (String string : hashMap.keySet()) {
            preparedStatement.setLong(1, update.getLastAccessTime());
            byte[] byArray = sessionDiff.getBytesForDB(hashMap.get(string));
            preparedStatement.setBytes(2, byArray);
            preparedStatement.setInt(3, sessionDiff.getVersionCount());
            preparedStatement.setString(4, update.getSessionID());
            preparedStatement.setString(5, update.getContextPath());
            preparedStatement.setString(6, string);
            preparedStatement.setInt(7, bl ? 1 : 0);
            preparedStatement.setInt(8, sessionDiff.getVersionCount());
            preparedStatement.setString(9, update.getSessionID());
            preparedStatement.setString(10, update.getContextPath());
            preparedStatement.setString(11, string);
            preparedStatement.addBatch();
        }
    }

    public void localInvalidateSessions(Set set) throws RemoteException {
        this.invalidateSessions(set, false);
    }

    public void invalidateSessions(Set set) throws RemoteException {
        this.invalidateSessions(set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void invalidateSessions(Set set, boolean bl) throws RemoteException {
        block16: {
            PreparedStatement preparedStatement;
            Connection connection;
            block15: {
                if (bl) {
                    this.verifyCaller();
                }
                connection = null;
                try {
                    connection = this.dataSource.getConnection();
                }
                catch (SQLException sQLException) {
                    throw new ServiceUnavailableException("Database unavailabe");
                }
                preparedStatement = null;
                preparedStatement = connection.prepareStatement(this.deleteQuery);
                for (Invalidate invalidate : set) {
                    preparedStatement.setString(1, invalidate.getSessionID());
                    preparedStatement.setString(2, invalidate.getContextPath());
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
                Object var8_9 = null;
                if (connection == null) break block15;
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.closeStatement(preparedStatement);
            {
                break block16;
                catch (SQLException sQLException) {
                    if (WANReplicationDetailsDebugLogger.isDebugEnabled()) {
                        WANReplicationDetailsDebugLogger.debug("Failed to invalidate some  sessions. The server will perform auto recovery", sQLException);
                    }
                    this.makeIndividualDeleteCalls(connection, set);
                    Object var8_10 = null;
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                    this.closeStatement(preparedStatement);
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.closeStatement(preparedStatement);
                throw throwable;
            }
        }
    }

    private void insertAttributes(HashMap hashMap, PreparedStatement preparedStatement, Update update, boolean bl, SessionDiff sessionDiff) throws SQLException, IOException {
        for (String string : hashMap.keySet()) {
            preparedStatement.setString(1, update.getSessionID());
            preparedStatement.setLong(2, update.getCreationTime());
            preparedStatement.setString(3, update.getContextPath());
            preparedStatement.setInt(4, update.getMaxInactiveTime());
            preparedStatement.setLong(5, update.getLastAccessTime());
            preparedStatement.setInt(6, sessionDiff.getVersionCount());
            preparedStatement.setString(7, string);
            byte[] byArray = sessionDiff.getBytesForDB(hashMap.get(string));
            preparedStatement.setBinaryStream(8, (InputStream)new UnsyncByteArrayInputStream(byArray), byArray.length);
            preparedStatement.setInt(9, bl ? 1 : 0);
            preparedStatement.addBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeIndividualDeleteCalls(Connection connection, Set set) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.deleteQuery);
        }
        catch (SQLException sQLException) {
            throw new AssertionError((Object)("Unexpected exception" + sQLException.toString()));
        }
        try {
            for (Invalidate invalidate : set) {
                try {
                    preparedStatement.setString(0, invalidate.getSessionID());
                    preparedStatement.setString(1, invalidate.getContextPath());
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                    WANReplicationDetailsDebugLogger.debug("Failed to invalidate  session " + invalidate.getSessionID(), sQLException);
                }
            }
            Object var8_8 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private void makeIndividualInsertCall(HashMap hashMap, Update update, SessionDiff sessionDiff, PreparedStatement preparedStatement, boolean bl) {
        for (String string : hashMap.keySet()) {
            try {
                preparedStatement.setString(1, update.getSessionID());
                preparedStatement.setLong(2, update.getCreationTime());
                preparedStatement.setString(3, update.getContextPath());
                preparedStatement.setInt(4, update.getMaxInactiveTime());
                preparedStatement.setLong(5, update.getLastAccessTime());
                preparedStatement.setInt(6, sessionDiff.getVersionCount());
                preparedStatement.setString(7, string);
                byte[] byArray = sessionDiff.getBytesForDB(hashMap.get(string));
                preparedStatement.setBinaryStream(8, (InputStream)new UnsyncByteArrayInputStream(byArray), byArray.length);
                preparedStatement.setInt(9, bl ? 1 : 0);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                WANReplicationDetailsDebugLogger.debug("Failed during an individual insert calls to the database. This is normal as the remote  call is idempotent", sQLException);
            }
            catch (IOException iOException) {
                if (!WANReplicationDetailsDebugLogger.isDebugEnabled()) continue;
                WANReplicationDetailsDebugLogger.debug("Failed during an individual insert calls to the database. This is normal as the remote  call is idempotent", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeIndividualInsertCalls(Connection connection, BatchedSessionState batchedSessionState, SessionDiff[] sessionDiffArray) {
        PreparedStatement preparedStatement;
        Update[] updateArray = batchedSessionState.getUpdates();
        int n = updateArray.length;
        try {
            preparedStatement = connection.prepareStatement(this.insertQuery);
        }
        catch (SQLException sQLException) {
            throw new AssertionError((Object)("Unexpected exception" + sQLException.toString()));
        }
        try {
            for (int i = 0; i < n; ++i) {
                if (sessionDiffArray[i] == null) {
                    sessionDiffArray[i] = updateArray[i].getChange();
                }
                this.makeIndividualInsertCall(sessionDiffArray[i].getNewAttributes(), updateArray[i], sessionDiffArray[i], preparedStatement, false);
                this.makeIndividualInsertCall(sessionDiffArray[i].getNewInternalAttributes(), updateArray[i], sessionDiffArray[i], preparedStatement, true);
            }
            Object var9_9 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private static void setQueryTimeout(PreparedStatement preparedStatement, int n) {
        try {
            preparedStatement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void verifyCaller() {
        try {
            HostID hostID = ServerHelper.getClientEndPoint().getHostID();
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)SubjectManager.getSubjectManager().getCurrentSubject((AbstractSubject)KERNEL_ID);
            if (authenticatedSubject == null) {
                throw new SecurityException("Null user is not permitted to perform WAN session replication operations");
            }
            int n = RemoteDomainSecurityHelper.acceptRemoteDomainCall(hostID, authenticatedSubject);
            if (n == 1) {
                throw new SecurityException("user " + authenticatedSubject.getName() + " is not " + "permitted to perform WAN session replication operations");
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            throw new SecurityException("operation not permitted");
        }
    }

    private final class LocalPersistenceServiceInternal
    implements PersistenceServiceInternal {
        PersistenceServiceImpl persistenceService;

        private LocalPersistenceServiceInternal(PersistenceServiceImpl persistenceServiceImpl2) {
            this.persistenceService = persistenceServiceImpl2;
        }

        public void invalidateSessions(Set set) throws RemoteException {
            this.persistenceService.localInvalidateSessions(set);
        }

        public void persistState(BatchedSessionState batchedSessionState) throws ServiceUnavailableException, RemoteException {
            this.persistenceService.localPersistState(batchedSessionState);
        }
    }
}

