/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.cluster.wan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.servlet.utils.ServletObjectOutputStream;

public final class SessionDiff
implements Externalizable {
    static final long serialVersionUID = 8310551219025541051L;
    private HashMap newAttributes;
    private HashMap updateAttributes = new HashMap(11);
    private HashMap newInternalAttributes;
    private HashMap updateInternalAttributes;
    private int versionCounter;
    private boolean serialized;

    public SessionDiff() {
        this.newAttributes = new HashMap(11);
        this.updateInternalAttributes = new HashMap(3);
        this.newInternalAttributes = new HashMap(3);
    }

    public final synchronized SessionDiff cloneAndClear() {
        SessionDiff sessionDiff = new SessionDiff();
        sessionDiff.updateAttributes = (HashMap)this.updateAttributes.clone();
        sessionDiff.updateInternalAttributes = (HashMap)this.updateInternalAttributes.clone();
        sessionDiff.newAttributes = (HashMap)this.newAttributes.clone();
        sessionDiff.newInternalAttributes = (HashMap)this.newInternalAttributes.clone();
        ++this.versionCounter;
        sessionDiff.versionCounter = this.versionCounter;
        this.updateAttributes.clear();
        this.updateInternalAttributes.clear();
        this.newAttributes.clear();
        this.newInternalAttributes.clear();
        return sessionDiff;
    }

    public final int getVersionCount() {
        return this.versionCounter;
    }

    public final synchronized void setAttribute(String string, Object object, boolean bl, boolean bl2) {
        if (!bl && !this.newAttributes.containsKey(string)) {
            HashMap hashMap = bl2 ? this.updateInternalAttributes : this.updateAttributes;
            hashMap.put(string, object);
            return;
        }
        HashMap hashMap = bl2 ? this.newInternalAttributes : this.newAttributes;
        hashMap.put(string, object);
    }

    HashMap getNewAttributes() {
        return this.newAttributes;
    }

    HashMap getUpdateAttributes() {
        return this.updateAttributes;
    }

    HashMap getNewInternalAttributes() {
        return this.newInternalAttributes;
    }

    HashMap getUpdateInternalAttributes() {
        return this.updateInternalAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAttributes() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = null;
        HashMap hashMap3 = null;
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.newAttributes.size() > 0) {
                hashMap2 = (HashMap)this.newAttributes.clone();
            }
            if (this.updateAttributes.size() > 0) {
                hashMap3 = (HashMap)this.updateAttributes.clone();
            }
        }
        if (hashMap2 != null) {
            for (Object k : hashMap2.keySet()) {
                hashMap.put(k, hashMap2.get(k));
            }
        }
        if (hashMap3 != null) {
            for (Object k : hashMap3.keySet()) {
                hashMap.put(k, hashMap3.get(k));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getInternalAttributes() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = null;
        HashMap hashMap3 = null;
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.newInternalAttributes.size() > 0) {
                hashMap2 = (HashMap)hashMap.clone();
            }
            if (this.updateInternalAttributes.size() > 0) {
                hashMap3 = (HashMap)this.updateInternalAttributes.clone();
            }
        }
        if (hashMap2 != null) {
            for (Object k : hashMap2.keySet()) {
                hashMap.put(k, hashMap2.get(k));
            }
        }
        if (hashMap3 != null) {
            for (Object k : hashMap3.keySet()) {
                hashMap.put(k, hashMap3.get(k));
            }
        }
        return hashMap;
    }

    public void setVersionCounter(int n) {
        this.versionCounter = n;
    }

    byte[] getBytesForDB(Object object) throws IOException {
        byte[] byArray;
        if (this.serialized) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byteBuffer.rewind();
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        } else {
            byArray = SessionDiff.passivateObject(object);
        }
        return byArray;
    }

    static byte[] passivateObject(Object object) throws IOException {
        ServletObjectOutputStream servletObjectOutputStream = null;
        servletObjectOutputStream = ServletObjectOutputStream.getOutputStream();
        servletObjectOutputStream.writeObject(object);
        servletObjectOutputStream.flush();
        return servletObjectOutputStream.toByteArray();
    }

    private synchronized void passivateMap(ObjectOutput objectOutput, HashMap hashMap) throws IOException {
        int n = hashMap.size();
        objectOutput.writeInt(n);
        if (n > 0) {
            for (String string : hashMap.keySet()) {
                byte[] byArray = SessionDiff.passivateObject(hashMap.get(string));
                objectOutput.writeUTF(string);
                objectOutput.writeInt(byArray.length);
                objectOutput.write(byArray);
            }
        }
    }

    private void readMap(ObjectInput objectInput, HashMap hashMap) throws IOException {
        int n = objectInput.readInt();
        if (n > 0) {
            int n2 = 0;
            while (n2++ < n) {
                int n3;
                String string = objectInput.readUTF();
                int n4 = objectInput.readInt();
                byte[] byArray = new byte[n4];
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4);
                for (int i = 0; i < n4; i += n3) {
                    n3 = objectInput.read(byArray, i, n4 - i);
                    if (n3 != -1) continue;
                    throw new IOException("Encountered EOF during deserialization");
                }
                byteBuffer.put(byArray, 0, n4);
                hashMap.put(string, byteBuffer);
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.versionCounter);
        this.passivateMap(objectOutput, this.newAttributes);
        this.passivateMap(objectOutput, this.updateAttributes);
        this.passivateMap(objectOutput, this.newInternalAttributes);
        this.passivateMap(objectOutput, this.updateInternalAttributes);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.versionCounter = objectInput.readInt();
        this.readMap(objectInput, this.newAttributes);
        this.readMap(objectInput, this.updateAttributes);
        this.readMap(objectInput, this.newInternalAttributes);
        this.readMap(objectInput, this.updateInternalAttributes);
        this.serialized = true;
    }
}

