/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.cluster.wan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.servlet.cluster.wan.SessionDiff;

public class Update
implements Externalizable {
    static final long serialVersionUID = 6694065036191470528L;
    private String sessionID;
    private String contextPath;
    private long creationTime;
    private int maxInactiveTime;
    private long lastAccessTime;
    private SessionDiff change;
    private boolean serialized = false;
    private int hashCode;

    public Update(String string, String string2, long l, int n, long l2, SessionDiff sessionDiff) {
        this.sessionID = string;
        this.contextPath = string2;
        this.hashCode = string.hashCode() ^ string2.hashCode();
        this.creationTime = l;
        this.maxInactiveTime = n;
        this.lastAccessTime = l2;
        this.change = sessionDiff;
    }

    public Update() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof WLObjectOutput) {
            WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
            wLObjectOutput.writeImmutable((Object)this.sessionID);
            wLObjectOutput.writeImmutable((Object)this.contextPath);
        } else {
            objectOutput.writeUTF(this.sessionID);
            objectOutput.writeUTF(this.contextPath);
        }
        objectOutput.writeLong(this.creationTime);
        objectOutput.writeInt(this.maxInactiveTime);
        objectOutput.writeLong(this.lastAccessTime);
        objectOutput.writeObject(this.change.cloneAndClear());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput instanceof WLObjectInput) {
            WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
            this.sessionID = (String)wLObjectInput.readImmutable();
            this.contextPath = (String)wLObjectInput.readImmutable();
        } else {
            this.sessionID = objectInput.readUTF();
            this.contextPath = objectInput.readUTF();
        }
        this.creationTime = objectInput.readLong();
        this.maxInactiveTime = objectInput.readInt();
        this.lastAccessTime = objectInput.readLong();
        this.change = (SessionDiff)objectInput.readObject();
        this.hashCode = this.sessionID.hashCode() ^ this.contextPath.hashCode();
        this.serialized = true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            Update update = (Update)object;
            return this.hashCode == update.hashCode && this.contextPath.equals(update.contextPath) && this.sessionID.equals(update.sessionID);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public SessionDiff getChange() {
        if (!this.serialized) {
            return this.change.cloneAndClear();
        }
        return this.change;
    }
}

