/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.servlet.ejb2jsp.EJBMethodGenerator;
import weblogic.servlet.ejb2jsp.HomeInterfaceGenerator;
import weblogic.servlet.ejb2jsp.Utils;
import weblogic.servlet.ejb2jsp.dd.BeanDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBTaglibDescriptor;

public class BeanGenerator {
    private String homeTagInterfaceName;
    private List imports = new ArrayList();
    private List methods = new ArrayList();
    private BeanDescriptor dd;
    private EJBTaglibDescriptor parentDD;

    public BeanGenerator(EJBTaglibDescriptor eJBTaglibDescriptor, BeanDescriptor beanDescriptor) {
        this.parentDD = eJBTaglibDescriptor;
        this.dd = beanDescriptor;
        this.addImport(beanDescriptor.getRemoteType());
        this.addImport(beanDescriptor.getHomeType());
        if (beanDescriptor.isStatefulBean()) {
            this.calculateHomeTagInterfaceName();
        }
    }

    public BeanDescriptor getDD() {
        return this.dd;
    }

    public EJBTaglibDescriptor getParentDD() {
        return this.parentDD;
    }

    public String getHomeTagInterfaceName() {
        return this.homeTagInterfaceName;
    }

    private void calculateHomeTagInterfaceName() {
        String string = this.dd.getHomeType();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        this.homeTagInterfaceName = this.parentDD.getFileInfo().getPackage() + ".__Base_" + string + "_homeTag";
    }

    public void addMethodImports(Method method) {
        this.addImport(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; classArray != null && i < classArray.length; ++i) {
            this.addImport(classArray[i]);
        }
    }

    public String getImportString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getImports().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("import " + iterator.next() + ";\n");
        }
        return stringBuffer.toString();
    }

    public String[] generateSources() throws Exception {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.dd.isStatefulBean()) {
            Object object = new HomeInterfaceGenerator(this.parentDD.getOpts(), this.getImportString(), this.getHomeTagInterfaceName(), this.dd.getRemoteType());
            arrayList.add(object.generate()[0]);
        }
        for (String[] stringArray2 : this.methods) {
            String[] stringArray3 = stringArray2.generate();
            int n = stringArray3.length;
            arrayList.add(stringArray3[0]);
            if (n <= 1) continue;
            arrayList.add(stringArray3[1]);
        }
        stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    static void p(String string) {
        System.err.println("[beangen]: " + string);
    }

    public void addImport(Class clazz) {
        if (clazz != Void.class && clazz != Void.TYPE) {
            this.addImport(clazz.getName());
        }
    }

    private void addImport(String string) {
        if (!Utils.isPrimitive(string) && !this.imports.contains(string)) {
            this.imports.add(string);
        }
    }

    public String getPackage() {
        return this.parentDD.getFileInfo().getPackage();
    }

    public List getImports() {
        return this.imports;
    }

    public void addMethod(EJBMethodGenerator eJBMethodGenerator) {
        if (!this.methods.contains((Object)eJBMethodGenerator)) {
            this.methods.add(eJBMethodGenerator);
        }
    }

    public List getMethods() {
        return this.methods;
    }
}

