/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarFile;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.servlet.ejb2jsp.EJB2JSPLexer;
import weblogic.servlet.ejb2jsp.EJBTaglibGenerator;
import weblogic.servlet.ejb2jsp.EJBean;
import weblogic.servlet.ejb2jsp.dd.BeanDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBMethodDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBTaglibDescriptor;
import weblogic.servlet.ejb2jsp.dd.FilesystemInfoDescriptor;
import weblogic.servlet.ejb2jsp.dd.MethodParamDescriptor;
import weblogic.servlet.jsp.JspConfig;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.io.XMLWriter;
import weblogic.utils.jars.JarFileObject;
import weblogic.utils.reflect.ReflectUtils;

public class Utils {
    public static final String RESOLVE_ERRORS_MESSAGE = "You may resolve errors in the following ways using the GUI ejb2jsp tool:\n - for duplicate tag names, you can rename tag(s) so that all tag\n   names are unique.\n - for duplicate tag names, individual tag(s) can be disabled, so\n   that their name does not cause a conflict.  The JSP tag for that\n   EJB method will not be generated.\n - for duplicate tag names in projects containing more than one EJB,\n   entire beans may be disabled.  JSP tags are not generated for\n   disabled beans, and their tag names will not cause conflicts.\n - for \"meaningless\" parameter names (arg0,arg1,...) each parameter\n   should be given a usable name.  This is done in the GUI tool by\n   editing the tag's attributes.  Reasonable parameters can also be\n   inferred by the tool in most cases, if the \"Source Path\" of the\n   project is set correctly, so that the tool can parse the parameter\n   names out of the .java source files for the EJB interface(s).\n";

    static void p(String string) {
        System.err.println("[Utils]: " + string);
    }

    public static String[] union(String[] stringArray, String[] stringArray2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (arrayList.contains(stringArray2[n])) continue;
            arrayList.add(stringArray2[n]);
        }
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        return stringArray3;
    }

    public static String[] delta(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (arrayList.contains(stringArray2[i])) continue;
            arrayList2.add(stringArray2[i]);
        }
        String[] stringArray3 = new String[arrayList2.size()];
        arrayList2.toArray(stringArray3);
        return stringArray3;
    }

    public static String[] splitPath(String string) {
        string = string.replace('/', File.separatorChar);
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Utils.abs(stringArray[i]);
        }
        return stringArray;
    }

    public static String flattenPath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i].replace('/', File.separatorChar));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    public static void compile(EJBTaglibDescriptor eJBTaglibDescriptor, PrintStream printStream) throws Exception {
        String[] stringArray = eJBTaglibDescriptor.getErrors();
        if (stringArray != null && stringArray.length > 0) {
            printStream.println("[ejb2jsp] cannot compile taglib, it has " + stringArray.length + " error(s):");
            for (int i = 0; i < stringArray.length; ++i) {
                printStream.println(' ' + stringArray[i]);
            }
            throw new RuntimeException("taglib descriptor had errors");
        }
        EJBTaglibGenerator eJBTaglibGenerator = eJBTaglibDescriptor.createGenerator();
        String[] stringArray2 = eJBTaglibGenerator.generateSources();
        printStream.println("[ejb2jsp]: generated the following sources: ");
        for (int i = 0; i < stringArray2.length; ++i) {
            printStream.println(" " + stringArray2[i]);
        }
        CompilerInvoker compilerInvoker = Utils.getCompiler(eJBTaglibDescriptor);
        compilerInvoker.setWantCompilerErrors(true);
        compilerInvoker.setNoExit(true);
        try {
            compilerInvoker.compile(stringArray2);
        }
        catch (Exception exception) {
            printStream.println("compilation failed:\n---");
            printStream.println("" + compilerInvoker.getCompilerErrors());
            printStream.println("---\n" + exception);
            throw new IOException("compilation failed: " + compilerInvoker.getCompilerErrors());
        }
        Utils.doPackaging(eJBTaglibDescriptor, eJBTaglibGenerator);
        FilesystemInfoDescriptor filesystemInfoDescriptor = eJBTaglibDescriptor.getFileInfo();
        if (filesystemInfoDescriptor.saveAsDirectory()) {
            printStream.println("TLD file written to " + filesystemInfoDescriptor.getSaveDirTldFile());
            printStream.println("classes compiled to directory " + filesystemInfoDescriptor.getSaveDirClassDir());
        } else {
            printStream.println("Taglib jar file written to " + filesystemInfoDescriptor.getSaveJarFile());
        }
        printStream.println("[ejb2jsp]: compile successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPackaging(EJBTaglibDescriptor eJBTaglibDescriptor, EJBTaglibGenerator eJBTaglibGenerator) throws Exception {
        if (eJBTaglibDescriptor.getFileInfo().saveAsDirectory()) {
            String string = eJBTaglibDescriptor.getFileInfo().getSaveDirTldFile();
            string = string.replace('/', File.separatorChar);
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            try {
                printStream.print(eJBTaglibGenerator.toXML());
                printStream.flush();
            }
            finally {
                printStream.close();
            }
        }
        File file = new File(eJBTaglibDescriptor.getFileInfo().getSaveJarTmpdir().replace('/', File.separatorChar));
        File file2 = new File(file, "META-INF");
        file2.mkdirs();
        if (!file2.isDirectory()) {
            throw new Exception("cannot make directory: " + file2.getAbsolutePath());
        }
        File file3 = new File(file2, "taglib.tld");
        PrintStream printStream = new PrintStream(new FileOutputStream(file3));
        try {
            printStream.print(eJBTaglibGenerator.toXML());
            printStream.flush();
        }
        finally {
            printStream.close();
        }
        String string = eJBTaglibDescriptor.getFileInfo().getSaveJarFile();
        JarFileObject jarFileObject = JarFileObject.makeJar((String)string, (File)file);
        jarFileObject.save();
    }

    public static CompilerInvoker getCompiler(EJBTaglibDescriptor eJBTaglibDescriptor) throws Exception {
        FilesystemInfoDescriptor filesystemInfoDescriptor = eJBTaglibDescriptor.getFileInfo();
        String[] stringArray = filesystemInfoDescriptor.getBuiltinClasspath();
        String string = Utils.flattenPath(stringArray);
        stringArray = filesystemInfoDescriptor.getCompileClasspath();
        if (stringArray != null && stringArray.length > 0) {
            string = string + File.pathSeparator + Utils.flattenPath(stringArray);
        }
        String string2 = null;
        string2 = filesystemInfoDescriptor.saveAsDirectory() ? filesystemInfoDescriptor.getSaveDirClassDir() : filesystemInfoDescriptor.getSaveJarTmpdir();
        string = string + File.pathSeparator + string2;
        String[] stringArray2 = JspConfig.parseFlags(filesystemInfoDescriptor.getJavacFlags());
        Getopt2 getopt2 = new Getopt2();
        CompilerInvoker compilerInvoker = new CompilerInvoker(getopt2);
        getopt2.setOption("classpath", string);
        getopt2.setOption("compiler", filesystemInfoDescriptor.getJavacPath());
        getopt2.grok(eJBTaglibDescriptor.getFileInfo().getCompileCommand());
        compilerInvoker.setExtraCompileFlags(stringArray2);
        return compilerInvoker;
    }

    public static List getAllEJBeans(EjbDescriptorBean ejbDescriptorBean) {
        Object object;
        String string;
        String string2;
        String string3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        int n = 0;
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
        for (int i = 0; entityBeanBeanArray != null && i < entityBeanBeanArray.length; ++i) {
            String string4 = null;
            string3 = null;
            string2 = null;
            string = null;
            if (entityBeanBeanArray[i].getLocal() != null) {
                string4 = entityBeanBeanArray[i].getLocalHome();
                string3 = entityBeanBeanArray[i].getLocal();
                string2 = weblogicEnterpriseBeanBeanArray[n++].getLocalJNDIName();
            } else {
                string4 = entityBeanBeanArray[i].getHome();
                string3 = entityBeanBeanArray[i].getRemote();
                string2 = weblogicEnterpriseBeanBeanArray[n++].getJNDIName();
            }
            string = entityBeanBeanArray[i].getEjbName();
            object = new EJBean(string, string3, string4, string2, true, false, false);
            arrayList.add(object);
        }
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; sessionBeanBeanArray != null && i < sessionBeanBeanArray.length; ++i) {
            string3 = null;
            string2 = null;
            string = null;
            object = null;
            if (sessionBeanBeanArray[i].getLocal() != null) {
                string3 = sessionBeanBeanArray[i].getLocalHome();
                string2 = sessionBeanBeanArray[i].getLocal();
                string = weblogicEnterpriseBeanBeanArray[n++].getLocalJNDIName();
            } else {
                string3 = sessionBeanBeanArray[i].getHome();
                string2 = sessionBeanBeanArray[i].getRemote();
                string = weblogicEnterpriseBeanBeanArray[n++].getJNDIName();
            }
            object = sessionBeanBeanArray[i].getEjbName();
            boolean bl = "Stateful".equalsIgnoreCase(sessionBeanBeanArray[i].getSessionType());
            EJBean eJBean = new EJBean((String)object, string2, string3, string, false, true, bl);
            arrayList.add(eJBean);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "weblogic.apache.xerces.jaxp.SAXParserFactoryImpl");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "weblogic.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        JarFile jarFile = new JarFile(stringArray[0]);
        EjbDescriptorBean ejbDescriptorBean = EjbDescriptorFactory.createDescriptorFromJarFile(jarFile);
        jarFile.close();
        File file = new File(stringArray[0]);
        Getopt2 getopt2 = new Getopt2();
        EJBTaglibDescriptor eJBTaglibDescriptor = Utils.createDefaultDescriptor(file, Utils.getAllEJBeans(ejbDescriptorBean), "C:/tmp");
        XMLWriter xMLWriter = new XMLWriter((OutputStream)System.out);
        eJBTaglibDescriptor.toXML(xMLWriter);
        xMLWriter.flush();
    }

    public static String abs(String string) {
        File file = new File(string.replace('/', File.separatorChar));
        return file.getAbsolutePath();
    }

    public static EJBTaglibDescriptor createDefaultDescriptor(String string, String string2, String string3) throws Exception {
        JarFile jarFile = new JarFile(string);
        EjbDescriptorBean ejbDescriptorBean = EjbDescriptorFactory.createDescriptorFromJarFile(jarFile);
        List list = Utils.getAllEJBeans(ejbDescriptorBean);
        jarFile.close();
        EJBTaglibDescriptor eJBTaglibDescriptor = null;
        eJBTaglibDescriptor = Utils.createDefaultDescriptor(new File(string), list, string3);
        String[] stringArray = StringUtils.splitCompletely((String)string2, (String)File.pathSeparator);
        eJBTaglibDescriptor.getFileInfo().setSourcePath(stringArray);
        Utils.resolveSources(eJBTaglibDescriptor);
        return eJBTaglibDescriptor;
    }

    static boolean isWin32() {
        try {
            String string = System.getProperty("os.name");
            if (string == null) {
                return false;
            }
            return (string = string.toLowerCase(Locale.ENGLISH)).indexOf("windows") >= 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static EJBTaglibDescriptor createDefaultDescriptor(File file, List list, String string) throws Exception {
        EJBTaglibDescriptor eJBTaglibDescriptor = new EJBTaglibDescriptor();
        FilesystemInfoDescriptor filesystemInfoDescriptor = eJBTaglibDescriptor.getFileInfo();
        filesystemInfoDescriptor.setEJBJarFile(file.getAbsolutePath());
        filesystemInfoDescriptor.setJavacPath("javac");
        filesystemInfoDescriptor.setSourcePath(new String[0]);
        filesystemInfoDescriptor.setSaveAs("DIRECTORY");
        String string2 = eJBTaglibDescriptor.toString();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        String string3 = "/tmp/" + string2 + "_tags";
        if (Utils.isWin32()) {
            string3 = "C:\\TEMP\\" + string2 + "_tags";
        }
        filesystemInfoDescriptor.setSaveJarTmpdir(string3 + File.separatorChar + "jar_tmp");
        if (!string.toUpperCase(Locale.ENGLISH).endsWith("WEB-INF")) {
            string = string + File.separatorChar + "WEB-INF";
        }
        String string4 = string + File.separatorChar + "lib" + File.separatorChar + string2 + "-tags.jar";
        String string5 = string + File.separatorChar + "classes";
        String string6 = string + File.separatorChar + string2 + "-tags.tld";
        filesystemInfoDescriptor.setSaveJarFile(string4);
        filesystemInfoDescriptor.setSaveDirClassDir(string5);
        filesystemInfoDescriptor.setSaveDirTldFile(string6);
        BeanDescriptor[] beanDescriptorArray = new BeanDescriptor[list.size()];
        Iterator iterator = list.iterator();
        ClassLoader classLoader = eJBTaglibDescriptor.getClassLoader();
        for (int i = 0; i < beanDescriptorArray.length; ++i) {
            beanDescriptorArray[i] = Utils.createBeanDescriptor((EJBean)iterator.next(), classLoader);
        }
        eJBTaglibDescriptor.setBeans(beanDescriptorArray);
        if (beanDescriptorArray.length > 0) {
            String string7 = beanDescriptorArray[0].getRemoteType();
            n = string7.lastIndexOf(46);
            if (n > 0) {
                string7 = string7.substring(0, n);
            }
            string7 = string7 + ".jsp_tags";
            filesystemInfoDescriptor.setPackage(string7);
        }
        eJBTaglibDescriptor.setEnableBaseEJB(false);
        return eJBTaglibDescriptor;
    }

    private static BeanDescriptor createBeanDescriptor(EJBean eJBean, ClassLoader classLoader) throws Exception {
        Object object;
        EJBMethodDescriptor[] eJBMethodDescriptorArray;
        BeanDescriptor beanDescriptor = new BeanDescriptor();
        beanDescriptor.setRemoteType(eJBean.getRemoteInterfaceName());
        beanDescriptor.setHomeType(eJBean.getHomeInterfaceName());
        beanDescriptor.setJNDIName(eJBean.getJNDIName());
        beanDescriptor.setEJBName(eJBean.getEJBName());
        String string = null;
        string = eJBean.isEntityBean() ? "ENTITY" : (eJBean.isStatefulSessionBean() ? "STATEFUL" : "STATELESS");
        beanDescriptor.setEJBType(string);
        Class<?> clazz = classLoader.loadClass(eJBean.getRemoteInterfaceName());
        Class<?> clazz2 = classLoader.loadClass(eJBean.getHomeInterfaceName());
        Enumeration enumeration = ReflectUtils.distinctInterfaceMethods(clazz);
        ArrayList<EJBMethodDescriptor> arrayList = new ArrayList<EJBMethodDescriptor>();
        while (enumeration.hasMoreElements()) {
            eJBMethodDescriptorArray = (EJBMethodDescriptor[])enumeration.nextElement();
            object = Utils.method2descriptor((Method)eJBMethodDescriptorArray);
            ((EJBMethodDescriptor)object).setTargetType(eJBean.getRemoteInterfaceName());
            arrayList.add((EJBMethodDescriptor)object);
        }
        eJBMethodDescriptorArray = new EJBMethodDescriptor[arrayList.size()];
        arrayList.toArray(eJBMethodDescriptorArray);
        beanDescriptor.setEJBMethods(eJBMethodDescriptorArray);
        if (beanDescriptor.isStatefulBean()) {
            arrayList.clear();
            enumeration = ReflectUtils.distinctInterfaceMethods(clazz2);
            while (enumeration.hasMoreElements()) {
                object = (Method)enumeration.nextElement();
                EJBMethodDescriptor eJBMethodDescriptor = Utils.method2descriptor((Method)object);
                eJBMethodDescriptor.setTargetType(eJBean.getHomeInterfaceName());
                eJBMethodDescriptor.setTagName("home-" + eJBMethodDescriptor.getTagName());
                arrayList.add(eJBMethodDescriptor);
            }
            eJBMethodDescriptorArray = new EJBMethodDescriptor[arrayList.size()];
            arrayList.toArray(eJBMethodDescriptorArray);
            beanDescriptor.setHomeMethods(eJBMethodDescriptorArray);
        }
        beanDescriptor.resolveBaseMethods();
        return beanDescriptor;
    }

    public static String unArray(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        String string = clazz.getName();
        while (n > 0) {
            string = string + "[]";
            --n;
        }
        return string;
    }

    static EJBMethodDescriptor method2descriptor(Method method) {
        EJBMethodDescriptor eJBMethodDescriptor = new EJBMethodDescriptor();
        eJBMethodDescriptor.setName(method.getName());
        eJBMethodDescriptor.setTagName(method.getName());
        eJBMethodDescriptor.setInfo("");
        String string = Utils.unArray(method.getReturnType());
        eJBMethodDescriptor.setReturnType(string);
        eJBMethodDescriptor.setParams(Utils.method2params(method));
        return eJBMethodDescriptor;
    }

    static MethodParamDescriptor[] method2params(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray == null) {
            return new MethodParamDescriptor[0];
        }
        MethodParamDescriptor[] methodParamDescriptorArray = new MethodParamDescriptor[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            MethodParamDescriptor methodParamDescriptor = methodParamDescriptorArray[i] = new MethodParamDescriptor();
            methodParamDescriptor.setType(Utils.unArray(classArray[i]));
            methodParamDescriptor.setName("arg" + i);
            methodParamDescriptor.setDefault("NONE");
            methodParamDescriptor.setDefaultValue("");
            methodParamDescriptor.setDefaultMethod("");
        }
        return methodParamDescriptorArray;
    }

    public static void resolveSources(EJBTaglibDescriptor eJBTaglibDescriptor) throws Exception {
        ClassLoader classLoader = eJBTaglibDescriptor.getClassLoader();
        String[] stringArray = eJBTaglibDescriptor.getFileInfo().getSourcePath();
        BeanDescriptor[] beanDescriptorArray = eJBTaglibDescriptor.getBeans();
        for (int i = 0; beanDescriptorArray != null && i < beanDescriptorArray.length; ++i) {
            BeanDescriptor beanDescriptor = beanDescriptorArray[i];
            System.out.println("[ejb2jsp] resolving sources for bean " + beanDescriptor.getEJBName() + ":");
            Class<?> clazz = classLoader.loadClass(beanDescriptor.getRemoteType());
            Utils.resolveSources(beanDescriptor, clazz, stringArray);
            clazz = classLoader.loadClass(beanDescriptor.getHomeType());
            Utils.resolveSources(beanDescriptor, clazz, stringArray);
            EJBMethodDescriptor[] eJBMethodDescriptorArray = beanDescriptor.getUnresolvedMethods();
            if (eJBMethodDescriptorArray == null || eJBMethodDescriptorArray.length <= 0) continue;
            System.err.println("[ejb2jsp] WARNING: the following methods are unresolved: ");
            for (int j = 0; j < eJBMethodDescriptorArray.length; ++j) {
                System.err.println(" " + eJBMethodDescriptorArray[j].getSignature() + " on type " + eJBMethodDescriptorArray[j].getTargetType());
            }
        }
    }

    private static void resolveSources(BeanDescriptor beanDescriptor, Class clazz, String[] stringArray) throws Exception {
        Enumeration enumeration = ReflectUtils.allInterfaces((Class)clazz);
        do {
            if (Utils.isBaseEJBClass(clazz)) continue;
            try {
                Utils.resolveSingleSource(beanDescriptor, clazz, stringArray);
            }
            catch (Exception exception) {
                System.err.println("[ejb2jsp] WARNING: cannot resolve source file(s): " + exception);
            }
        } while (enumeration.hasMoreElements() && (clazz = (Class)enumeration.nextElement()) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveSingleSource(BeanDescriptor beanDescriptor, Class clazz, String[] stringArray) throws Exception {
        InputStream inputStream = Utils.findSource(clazz, stringArray);
        try {
            EJB2JSPLexer eJB2JSPLexer = new EJB2JSPLexer(inputStream);
            eJB2JSPLexer.setDescriptor(beanDescriptor);
            eJB2JSPLexer.parse();
        }
        finally {
            inputStream.close();
        }
    }

    private static InputStream findSource(Class clazz, String[] stringArray) throws FileNotFoundException {
        String string;
        String string2 = string = clazz.getName().replace('.', File.separatorChar) + ".java";
        int n = string.lastIndexOf(File.separatorChar);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace('/', File.separatorChar);
            File file = new File(stringArray[i], string);
            if (file.exists()) {
                return new FileInputStream(file);
            }
            file = new File(stringArray[i], string2);
            if (!file.exists()) continue;
            return new FileInputStream(file);
        }
        throw new FileNotFoundException("cannot resolve " + string + " or " + string2 + " in path " + ArrayUtils.toString((Object[])stringArray));
    }

    static boolean isBaseEJBClass(Class clazz) {
        return Utils.isBaseEJBClass(clazz.getName());
    }

    static boolean isBaseEJBClass(String string) {
        return "javax.ejb.EJBObject".equals(string) || "javax.ejb.EJBHome".equals(string) || "java.rmi.Remote".equals(string);
    }

    static boolean isBaseEJBMethod(Method method) {
        return Utils.isBaseEJBClass(method.getDeclaringClass());
    }

    public static boolean isPrimitive(String string) {
        return "boolean".equals(string) || "int".equals(string) || "short".equals(string) || "long".equals(string) || "byte".equals(string) || "char".equals(string) || "float".equals(string) || "double".equals(string);
    }

    public static boolean isPrimitive(Class clazz) {
        return Utils.isPrimitive(clazz.getName());
    }

    public static boolean isVoid(Class clazz) {
        return clazz == Void.class || clazz == Void.TYPE;
    }

    public static boolean isVoid(String string) {
        return string.equals("void") || string.equals("Void") || string.equals("java.lang.Void");
    }

    public static String primitive2Object(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        if (clazz == Integer.TYPE) {
            return "Integer";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Character.TYPE) {
            return "Character";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        throw new IllegalArgumentException("type " + clazz.getName() + " not primitive");
    }

    public static String primitive2Object(String string) {
        if (string.equals("boolean")) {
            return "Boolean";
        }
        if (string.equals("byte")) {
            return "Byte";
        }
        if (string.equals("double")) {
            return "Double";
        }
        if (string.equals("int")) {
            return "Integer";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("long")) {
            return "Long";
        }
        if (string.equals("char")) {
            return "Character";
        }
        if (string.equals("short")) {
            return "Short";
        }
        throw new IllegalArgumentException("type " + string + " not primitive");
    }

    public static String primitive2Object(String string, String string2) {
        return "new " + Utils.primitive2Object(string) + "(" + string2 + ")";
    }

    public static String primitive2Object(Class clazz, String string) {
        return "new " + Utils.primitive2Object(clazz) + "(" + string + ")";
    }
}

