/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.dd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.servlet.ejb2jsp.SourceMethodInfo;
import weblogic.servlet.ejb2jsp.dd.BaseEJB;
import weblogic.servlet.ejb2jsp.dd.EJBMethodDescriptor;
import weblogic.servlet.ejb2jsp.dd.MethodParamDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class BeanDescriptor
implements ToXML,
Serializable {
    private EJBMethodDescriptor[] ejbMethods;
    private EJBMethodDescriptor[] homeMethods;
    private String ejbName;
    private String remoteType;
    private String homeType;
    private String ejbType;
    private String jndiName;
    private boolean enabled;
    private static final BaseEJB[] baseEJBMethods = new BaseEJB[]{new BaseEJB("javax.ejb.EJBHome", "getEJBHome", null), new BaseEJB("javax.ejb.Handle", "getHandle", null), new BaseEJB("java.lang.Object", "getPrimaryKey", null), new BaseEJB("boolean", "isIdentical", "javax.ejb.EJBObject"), new BaseEJB("void", "remove", null)};
    private static final BaseEJB[] baseHomeMethods = new BaseEJB[]{new BaseEJB("javax.ejb.EJBMetaData", "getEJBMetaData", null), new BaseEJB("javax.ejb.HomeHandle", "getHomeHandle", null), new BaseEJB("void", "remove", "java.lang.Object"), new BaseEJB("void", "remove", "javax.ejb.Handle")};

    static void p(String string) {
        System.err.println("[EJBTagDesc]: " + string);
    }

    public BeanDescriptor() {
        this.homeMethods = new EJBMethodDescriptor[0];
        this.ejbMethods = this.homeMethods;
        this.jndiName = "";
        this.ejbName = "";
        this.ejbType = "";
        this.homeType = "";
        this.remoteType = "";
        this.enabled = true;
    }

    public BeanDescriptor(Element element) throws DOMProcessingException {
        this.initFromRoot(element);
    }

    private void initFromRoot(Element element) throws DOMProcessingException {
        Element element2 = null;
        String string = null;
        this.ejbName = DOMUtils.getValueByTagName(element, "ejb-name");
        this.remoteType = DOMUtils.getValueByTagName(element, "remote-type");
        this.homeType = DOMUtils.getValueByTagName(element, "home-type");
        this.jndiName = DOMUtils.getValueByTagName(element, "jndi-name");
        this.ejbType = DOMUtils.getValueByTagName(element, "ejb-type");
        string = DOMUtils.getValueByTagName(element, "enabled");
        this.enabled = !"false".equalsIgnoreCase(string) && !"no".equalsIgnoreCase(string);
        element2 = DOMUtils.getElementByTagName(element, "ejb-methods");
        List list = DOMUtils.getOptionalElementsByTagName(element2, "method");
        ArrayList<EJBMethodDescriptor> arrayList = new ArrayList<EJBMethodDescriptor>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new EJBMethodDescriptor((Element)iterator.next()));
        }
        this.ejbMethods = new EJBMethodDescriptor[arrayList.size()];
        arrayList.toArray(this.ejbMethods);
        arrayList.clear();
        element2 = DOMUtils.getElementByTagName(element, "home-methods");
        list = DOMUtils.getOptionalElementsByTagName(element2, "method");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new EJBMethodDescriptor((Element)iterator.next()));
        }
        this.homeMethods = new EJBMethodDescriptor[arrayList.size()];
        arrayList.toArray(this.homeMethods);
        this.resolveBaseMethods();
    }

    public String toString() {
        return "EJB: " + this.getEJBName();
    }

    public String getRemoteType() {
        return this.remoteType;
    }

    public void setRemoteType(String string) {
        this.remoteType = string;
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public void setEJBName(String string) {
        this.ejbName = string;
    }

    public String getHomeType() {
        return this.homeType;
    }

    public void setHomeType(String string) {
        this.homeType = string;
    }

    public String getEJBType() {
        return this.ejbType;
    }

    public void setEJBType(String string) {
        this.ejbType = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String string) {
        this.jndiName = string;
    }

    public EJBMethodDescriptor[] getEJBMethods() {
        return this.ejbMethods != null ? this.ejbMethods : new EJBMethodDescriptor[]{};
    }

    public void setEJBMethods(EJBMethodDescriptor[] eJBMethodDescriptorArray) {
        if (eJBMethodDescriptorArray == null) {
            this.ejbMethods = new EJBMethodDescriptor[0];
            return;
        }
        this.ejbMethods = (EJBMethodDescriptor[])eJBMethodDescriptorArray.clone();
    }

    public EJBMethodDescriptor[] getHomeMethods() {
        return this.homeMethods != null ? this.homeMethods : new EJBMethodDescriptor[]{};
    }

    public void setHomeMethods(EJBMethodDescriptor[] eJBMethodDescriptorArray) {
        if (eJBMethodDescriptorArray == null) {
            this.homeMethods = new EJBMethodDescriptor[0];
            return;
        }
        this.homeMethods = (EJBMethodDescriptor[])eJBMethodDescriptorArray.clone();
    }

    public EJBMethodDescriptor[] getUnresolvedMethods() {
        int n;
        ArrayList<EJBMethodDescriptor> arrayList = new ArrayList<EJBMethodDescriptor>();
        EJBMethodDescriptor[] eJBMethodDescriptorArray = this.getEJBMethods();
        for (n = 0; n < eJBMethodDescriptorArray.length; ++n) {
            if (!eJBMethodDescriptorArray[n].isEnabled() || eJBMethodDescriptorArray[n].isResolved()) continue;
            arrayList.add(eJBMethodDescriptorArray[n]);
        }
        eJBMethodDescriptorArray = this.getHomeMethods();
        for (n = 0; n < eJBMethodDescriptorArray.length; ++n) {
            if (!eJBMethodDescriptorArray[n].isEnabled() || eJBMethodDescriptorArray[n].isResolved()) continue;
            arrayList.add(eJBMethodDescriptorArray[n]);
        }
        EJBMethodDescriptor[] eJBMethodDescriptorArray2 = new EJBMethodDescriptor[arrayList.size()];
        arrayList.toArray(eJBMethodDescriptorArray2);
        return eJBMethodDescriptorArray2;
    }

    public void resolveSource(SourceMethodInfo sourceMethodInfo) {
        EJBMethodDescriptor[] eJBMethodDescriptorArray = this.getUnresolvedMethods();
        for (int i = 0; i < eJBMethodDescriptorArray.length; ++i) {
            if (!sourceMethodInfo.equalsMethod(eJBMethodDescriptorArray[i])) continue;
            eJBMethodDescriptorArray[i].resolveParamNames(sourceMethodInfo);
        }
    }

    public boolean isStatefulBean() {
        return "ENTITY".equalsIgnoreCase(this.getEJBType()) || "STATEFUL".equalsIgnoreCase(this.getEJBType());
    }

    public void setEnableBaseEJB(boolean bl) {
        int n;
        int n2;
        EJBMethodDescriptor[] eJBMethodDescriptorArray = this.getEJBMethods();
        for (n2 = 0; n2 < eJBMethodDescriptorArray.length; ++n2) {
            for (n = 0; n < baseEJBMethods.length; ++n) {
                if (!baseEJBMethods[n].matchesDescriptor(eJBMethodDescriptorArray[n2])) continue;
                eJBMethodDescriptorArray[n2].setEnabled(bl);
            }
        }
        eJBMethodDescriptorArray = this.getHomeMethods();
        for (n2 = 0; n2 < eJBMethodDescriptorArray.length; ++n2) {
            for (n = 0; n < baseHomeMethods.length; ++n) {
                if (!baseHomeMethods[n].matchesDescriptor(eJBMethodDescriptorArray[n2])) continue;
                eJBMethodDescriptorArray[n2].setEnabled(bl);
            }
        }
    }

    public void resolveBaseMethods() {
        SourceMethodInfo sourceMethodInfo = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        sourceMethodInfo = new SourceMethodInfo("getEJBHome", "javax.ejb.EJBHome", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        sourceMethodInfo = new SourceMethodInfo("getHandle", "javax.ejb.Handle", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        sourceMethodInfo = new SourceMethodInfo("getPrimaryKey", "java.lang.Object", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        sourceMethodInfo = new SourceMethodInfo("remove", "void", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        arrayList.add("javax.ejb.EJBObject");
        arrayList2.add("other");
        sourceMethodInfo = new SourceMethodInfo("isIdentical", "boolean", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        if (!this.isStatefulBean()) {
            return;
        }
        arrayList.clear();
        arrayList2.clear();
        sourceMethodInfo = new SourceMethodInfo("getEJBMetaData", "javax.ejb.EJBMetaData", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        sourceMethodInfo = new SourceMethodInfo("getHomeHandle", "javax.ejb.HomeHandle", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        arrayList.add("java.lang.Object");
        arrayList2.add("object");
        sourceMethodInfo = new SourceMethodInfo("remove", "void", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        arrayList.clear();
        arrayList2.clear();
        arrayList.add("javax.ejb.Handle");
        arrayList2.add("handle");
        sourceMethodInfo = new SourceMethodInfo("remove", "void", arrayList, arrayList2);
        this.resolveSource(sourceMethodInfo);
        EJBMethodDescriptor[] eJBMethodDescriptorArray = this.getHomeMethods();
        boolean bl = false;
        for (int i = 0; i < eJBMethodDescriptorArray.length; ++i) {
            MethodParamDescriptor[] methodParamDescriptorArray;
            EJBMethodDescriptor eJBMethodDescriptor = eJBMethodDescriptorArray[i];
            if (!"remove".equals(eJBMethodDescriptor.getName()) || !this.getHomeType().equals(eJBMethodDescriptor.getTargetType()) || !"home-remove".equals(eJBMethodDescriptor.getTagName()) || (methodParamDescriptorArray = eJBMethodDescriptor.getParams()).length != 1 || !methodParamDescriptorArray[0].getType().equals("javax.ejb.Handle")) continue;
            eJBMethodDescriptor.setTagName("home-remove-handle");
            bl = true;
        }
    }

    public String[] getErrors() {
        if (!this.isEnabled()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getDuplicateTagNames(arrayList);
        this.getDuplicateAttributeNames(arrayList);
        EJBMethodDescriptor[] eJBMethodDescriptorArray = this.getUnresolvedMethods();
        for (int i = 0; eJBMethodDescriptorArray != null && i < eJBMethodDescriptorArray.length; ++i) {
            String string = "tag " + eJBMethodDescriptorArray[i].getTagName() + " for method " + eJBMethodDescriptorArray[i].getName() + " on " + eJBMethodDescriptorArray[i].getTargetType() + " appears to " + "have meaningless parameter names (arg0,arg1,....)";
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    void getDuplicateAttributeNames(List list) {
        this.getDuplicateAttributeNames(list, this.getEJBMethods());
        this.getDuplicateAttributeNames(list, this.getHomeMethods());
    }

    private void getDuplicateAttributeNames(List list, EJBMethodDescriptor[] eJBMethodDescriptorArray) {
        for (int i = 0; i < eJBMethodDescriptorArray.length; ++i) {
            MethodParamDescriptor[] methodParamDescriptorArray;
            int n;
            EJBMethodDescriptor eJBMethodDescriptor = eJBMethodDescriptorArray[i];
            if (!eJBMethodDescriptor.isEnabled() || (n = (methodParamDescriptorArray = eJBMethodDescriptor.getParams()).length) < 2) continue;
            for (int j = 0; j < n - 1; ++j) {
                String string = methodParamDescriptorArray[j].getName();
                for (int k = j + 1; k < n; ++k) {
                    if (!string.equals(methodParamDescriptorArray[k].getName())) continue;
                    String string2 = "duplicate attribute name \"" + string + "\" for tag: " + eJBMethodDescriptor.getTagName() + " signature: " + eJBMethodDescriptor.getSignature();
                    list.add(string2);
                }
            }
        }
    }

    private void getDuplicateTagNames(List list) {
        this.getDuplicateTagNames(list, this.getEJBMethods());
        this.getDuplicateTagNames(list, this.getHomeMethods());
    }

    private void getDuplicateTagNames(List list, EJBMethodDescriptor[] eJBMethodDescriptorArray) {
        if (eJBMethodDescriptorArray == null) {
            return;
        }
        int n = eJBMethodDescriptorArray.length;
        for (int i = 0; i < n - 1; ++i) {
            if (!eJBMethodDescriptorArray[i].isEnabled()) continue;
            String string = eJBMethodDescriptorArray[i].getTagName();
            for (int j = i + 1; j < n; ++j) {
                if (!eJBMethodDescriptorArray[j].isEnabled() || string == null || !string.equals(eJBMethodDescriptorArray[j].getTagName())) continue;
                String string2 = "duplicate tag names \"" + string + "\" refer to methods \"" + eJBMethodDescriptorArray[i].getSignature() + "\" and \"" + eJBMethodDescriptorArray[j].getSignature() + "\"";
                list.add(string2);
            }
        }
    }

    public void toXML(XMLWriter xMLWriter) {
        int n;
        xMLWriter.println("<ejb>");
        xMLWriter.incrIndent();
        xMLWriter.println("<ejb-name>" + this.ejbName + "</ejb-name>");
        xMLWriter.println("<remote-type>" + this.remoteType + "</remote-type>");
        xMLWriter.println("<home-type>" + this.homeType + "</home-type>");
        xMLWriter.println("<jndi-name>" + this.jndiName + "</jndi-name>");
        xMLWriter.println("<ejb-type>" + this.ejbType + "</ejb-type>");
        xMLWriter.println("<enabled>" + this.isEnabled() + "</enabled>");
        xMLWriter.println("<ejb-methods>");
        xMLWriter.incrIndent();
        for (n = 0; this.ejbMethods != null && n < this.ejbMethods.length; ++n) {
            this.ejbMethods[n].toXML(xMLWriter);
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</ejb-methods>");
        xMLWriter.println("<home-methods>");
        xMLWriter.incrIndent();
        for (n = 0; this.homeMethods != null && n < this.homeMethods.length; ++n) {
            this.homeMethods[n].toXML(xMLWriter);
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</home-methods>");
        xMLWriter.decrIndent();
        xMLWriter.println("</ejb>");
    }
}

