/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.dd;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.servlet.ejb2jsp.SourceMethodInfo;
import weblogic.servlet.ejb2jsp.dd.MethodParamDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class EJBMethodDescriptor
implements ToXML {
    private String info;
    private String name;
    private String tagname;
    private String targetType;
    private String returnType;
    private String returnVarName;
    MethodParamDescriptor[] params;
    private boolean enabled;
    private boolean evalOut;

    public EJBMethodDescriptor() {
        this.returnType = "";
        this.targetType = "";
        this.tagname = "";
        this.name = "";
        this.info = "";
        this.enabled = true;
        this.params = new MethodParamDescriptor[0];
    }

    public EJBMethodDescriptor(Element element) throws DOMProcessingException {
        String string = null;
        this.info = DOMUtils.getValueByTagName(element, "info");
        this.name = DOMUtils.getValueByTagName(element, "name");
        string = DOMUtils.getValueByTagName(element, "enabled");
        this.enabled = !"false".equalsIgnoreCase(string) && !"no".equalsIgnoreCase(string);
        this.tagname = DOMUtils.getValueByTagName(element, "tagname");
        this.targetType = DOMUtils.getValueByTagName(element, "target-type");
        this.returnType = DOMUtils.getValueByTagName(element, "return-type");
        List list = DOMUtils.getOptionalElementsByTagName(element, "parameter");
        Iterator iterator = list.iterator();
        int n = DOMUtils.getElementCount(element, "parameter");
        this.params = new MethodParamDescriptor[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            this.params[n2++] = new MethodParamDescriptor((Element)iterator.next());
        }
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public String getSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getReturnType();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        String string2 = this.getTargetType();
        n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        stringBuffer.append(" " + string2 + ".");
        stringBuffer.append(this.getName() + "(");
        MethodParamDescriptor[] methodParamDescriptorArray = this.getParams();
        for (int i = 0; methodParamDescriptorArray != null && i < methodParamDescriptorArray.length; ++i) {
            String string3 = methodParamDescriptorArray[i].getType();
            n = string3.lastIndexOf(46);
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            stringBuffer.append(string3 + " " + methodParamDescriptorArray[i].getName());
            if (i == methodParamDescriptorArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.append(")").toString();
    }

    public void setSignature(String string) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getTagName() {
        return this.tagname;
    }

    public void setTagName(String string) {
        this.tagname = string;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String string) {
        this.targetType = string;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public String getReturnVarName() {
        return this.returnVarName;
    }

    public void setReturnVarName(String string) {
        this.returnVarName = string;
    }

    public MethodParamDescriptor[] getParams() {
        return this.params != null ? this.params : new MethodParamDescriptor[]{};
    }

    public void setParams(MethodParamDescriptor[] methodParamDescriptorArray) {
        if (methodParamDescriptorArray == null) {
            this.params = new MethodParamDescriptor[0];
            return;
        }
        this.params = (MethodParamDescriptor[])methodParamDescriptorArray.clone();
    }

    public boolean isEvalOut() {
        return this.evalOut;
    }

    public void setEvalOut(boolean bl) {
        this.evalOut = bl;
    }

    static void p(String string) {
        System.err.println("[EJBMethDesc]: " + string);
    }

    public boolean isResolved() {
        MethodParamDescriptor[] methodParamDescriptorArray = this.getParams();
        if (methodParamDescriptorArray == null || methodParamDescriptorArray.length == 0) {
            return true;
        }
        for (int i = 0; i < methodParamDescriptorArray.length; ++i) {
            if (!("arg" + i).equals(methodParamDescriptorArray[i].getName())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getSignature();
    }

    public void resolveParamNames(SourceMethodInfo sourceMethodInfo) {
        MethodParamDescriptor[] methodParamDescriptorArray = this.getParams();
        String[] stringArray = sourceMethodInfo.getParams()[1];
        for (int i = 0; i < methodParamDescriptorArray.length; ++i) {
            methodParamDescriptorArray[i].setName(stringArray[i]);
        }
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.println("<method>");
        xMLWriter.incrIndent();
        xMLWriter.println("<info>" + this.info + "</info>");
        xMLWriter.println("<name>" + this.name + "</name>");
        xMLWriter.println("<enabled>" + this.isEnabled() + "</enabled>");
        xMLWriter.println("<tagname>" + this.tagname + "</tagname>");
        xMLWriter.println("<target-type>" + this.targetType + "</target-type>");
        xMLWriter.println("<return-type>" + this.returnType + "</return-type>");
        xMLWriter.println("<return-variable-name>" + this.returnVarName + "</return-variable-name>");
        xMLWriter.println("<eval-out>" + this.isEvalOut() + "</eval-out>");
        for (int i = 0; this.params != null && i < this.params.length; ++i) {
            this.params[i].toXML(xMLWriter);
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</method>");
    }
}

