/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.dd;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import weblogic.servlet.ejb2jsp.BeanGenerator;
import weblogic.servlet.ejb2jsp.EJBMethodGenerator;
import weblogic.servlet.ejb2jsp.EJBTaglibGenerator;
import weblogic.servlet.ejb2jsp.HomeCollectionGenerator;
import weblogic.servlet.ejb2jsp.HomeFinderGenerator;
import weblogic.servlet.ejb2jsp.HomeMethodGenerator;
import weblogic.servlet.ejb2jsp.dd.BeanDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBMethodDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBTaglibEntityResolver;
import weblogic.servlet.ejb2jsp.dd.FilesystemInfoDescriptor;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.ClasspathClassLoader;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

public class EJBTaglibDescriptor
implements ToXML,
Externalizable {
    private static final long serialVersionUID = -9016538269900747655L;
    private FilesystemInfoDescriptor fileInfo;
    private BeanDescriptor[] beans;
    private transient ClassLoader jarLoader;
    private static final String PREAMBLE = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<!DOCTYPE ejb2jsp-taglib PUBLIC \"-//BEA Systems, Inc.//DTD EJB2JSP Taglib 1.0//EN\" \"http://www.bea.com/servers/wls600/dtd/weblogic-ejb2jsp.dtd\">";

    static void p(String string) {
        System.err.println("[EJBTagDesc]: " + string);
    }

    public EJBTaglibDescriptor() {
        this.fileInfo = new FilesystemInfoDescriptor();
        this.beans = new BeanDescriptor[0];
    }

    public EJBTaglibDescriptor(Element element) throws DOMProcessingException {
        this.initFromRoot(element);
    }

    private void initFromRoot(Element element) throws DOMProcessingException {
        Element element2 = null;
        element2 = DOMUtils.getElementByTagName(element, "filesystem-info");
        this.fileInfo = new FilesystemInfoDescriptor(element2);
        List list = DOMUtils.getElementsByTagName(element, "ejb");
        ArrayList<BeanDescriptor> arrayList = new ArrayList<BeanDescriptor>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new BeanDescriptor((Element)iterator.next()));
        }
        this.beans = new BeanDescriptor[arrayList.size()];
        arrayList.toArray(this.beans);
    }

    public String toString() {
        int n;
        String string = this.getFileInfo().getEJBJarFile();
        int n2 = string.lastIndexOf(47);
        int n3 = Math.max(n2, n = string.lastIndexOf(File.separatorChar));
        if (n3 < 0) {
            return string;
        }
        return string.substring(n3 + 1);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(EJBTaglibDescriptor.toString(this));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        StringReader stringReader = new StringReader(objectInput.readUTF());
        try {
            EJBTaglibDescriptor.load(stringReader, this);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("error reading XML: " + exception);
        }
    }

    public ClassLoader getClassLoader() {
        if (this.jarLoader == null) {
            this.jarLoader = new ClasspathClassLoader(this.getFileInfo().getEJBJarFile());
        }
        return this.jarLoader;
    }

    public FilesystemInfoDescriptor getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FilesystemInfoDescriptor filesystemInfoDescriptor) {
        this.fileInfo = filesystemInfoDescriptor;
    }

    public BeanDescriptor[] getBeans() {
        if (this.beans == null) {
            this.beans = new BeanDescriptor[0];
        }
        return (BeanDescriptor[])this.beans.clone();
    }

    public void setBeans(BeanDescriptor[] beanDescriptorArray) {
        this.beans = beanDescriptorArray == null ? new BeanDescriptor[0] : (BeanDescriptor[])beanDescriptorArray.clone();
    }

    public void setEnableBaseEJB(boolean bl) {
        BeanDescriptor[] beanDescriptorArray = this.getBeans();
        for (int i = 0; i < beanDescriptorArray.length; ++i) {
            beanDescriptorArray[i].setEnableBaseEJB(bl);
        }
    }

    public Getopt2 getOpts() throws Exception {
        Getopt2 getopt2 = new Getopt2();
        getopt2.addOption("d", "destination directory", "working dir of codegen");
        String string = null;
        string = this.getFileInfo().saveAsDirectory() ? this.getFileInfo().getSaveDirClassDir() : this.getFileInfo().getSaveJarTmpdir();
        getopt2.setOption("d", string);
        return getopt2;
    }

    public EJBTaglibGenerator createGenerator() throws Exception {
        Object object;
        File file;
        if (!(this.getFileInfo().saveAsDirectory() || (file = new File(((String)(object = this.getFileInfo().getSaveJarTmpdir())).replace('/', File.separatorChar))).mkdirs() || file.isDirectory())) {
            throw new Exception("cannot make tmp directory '" + file.getAbsolutePath() + "'");
        }
        object = new EJBTaglibGenerator(this);
        int n = 0;
        for (int i = 0; i < this.beans.length; ++i) {
            if (!this.beans[i].isEnabled()) continue;
            ++n;
        }
        BeanGenerator[] beanGeneratorArray = new BeanGenerator[n];
        int n2 = 0;
        for (int i = 0; i < this.beans.length; ++i) {
            if (!this.beans[i].isEnabled()) continue;
            beanGeneratorArray[n2++] = this.addMethodGenerators(this.beans[i], (EJBTaglibGenerator)object);
        }
        ((EJBTaglibGenerator)object).setGenerators(beanGeneratorArray);
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BeanGenerator addMethodGenerators(BeanDescriptor beanDescriptor, EJBTaglibGenerator eJBTaglibGenerator) throws Exception {
        void var6_7;
        EJBMethodDescriptor[] eJBMethodDescriptorArray = beanDescriptor.getEJBMethods();
        BeanGenerator beanGenerator = new BeanGenerator(this, beanDescriptor);
        Getopt2 getopt2 = this.getOpts();
        boolean bl = false;
        while (var6_7 < eJBMethodDescriptorArray.length) {
            if (eJBMethodDescriptorArray[var6_7].isEnabled()) {
                EJBMethodGenerator eJBMethodGenerator = new EJBMethodGenerator(getopt2, beanGenerator, eJBMethodDescriptorArray[var6_7]);
                beanGenerator.addMethod(eJBMethodGenerator);
            }
            ++var6_7;
        }
        if (!beanDescriptor.isStatefulBean()) return beanGenerator;
        eJBMethodDescriptorArray = beanDescriptor.getHomeMethods();
        Object var6_8 = null;
        for (int i = 0; i < eJBMethodDescriptorArray.length; ++i) {
            void var6_15;
            if (!eJBMethodDescriptorArray[i].isEnabled()) continue;
            String string = eJBMethodDescriptorArray[i].getName();
            if (string.startsWith("find") || string.startsWith("create")) {
                Class<?> clazz = this.getClassLoader().loadClass(eJBMethodDescriptorArray[i].getReturnType());
                if (clazz.getName().equals(beanDescriptor.getRemoteType())) {
                    HomeFinderGenerator homeFinderGenerator = new HomeFinderGenerator(getopt2, beanGenerator, eJBMethodDescriptorArray[i]);
                } else {
                    Class<Collection> clazz2 = Collection.class;
                    Class<Enumeration> clazz3 = Enumeration.class;
                    if (clazz2.isAssignableFrom(clazz)) {
                        HomeCollectionGenerator homeCollectionGenerator = new HomeCollectionGenerator(getopt2, beanGenerator, eJBMethodDescriptorArray[i]);
                    } else {
                        if (!clazz3.isAssignableFrom(clazz)) throw new IllegalArgumentException("illegal finder on home: " + eJBMethodDescriptorArray[i].getSignature());
                        HomeCollectionGenerator homeCollectionGenerator = new HomeCollectionGenerator(getopt2, beanGenerator, eJBMethodDescriptorArray[i]);
                        homeCollectionGenerator.setIsEnumeration(true);
                    }
                }
            } else {
                HomeMethodGenerator homeMethodGenerator = new HomeMethodGenerator(getopt2, beanGenerator, eJBMethodDescriptorArray[i]);
            }
            if (var6_15 == null) {
                throw new Error("no generator type for " + eJBMethodDescriptorArray[i].getSignature());
            }
            beanGenerator.addMethod((EJBMethodGenerator)var6_15);
        }
        return beanGenerator;
    }

    public String[] getErrors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getFileInfo().getErrors();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.getDuplicateTagNames(arrayList);
        this.getDuplicateAttributeNames(arrayList);
        this.getUnresolvedMethods(arrayList);
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private void getDuplicateAttributeNames(List list) {
        for (int i = 0; this.beans != null && i < this.beans.length; ++i) {
            this.beans[i].getDuplicateAttributeNames(list);
        }
    }

    private void getUnresolvedMethods(List list) {
        for (int i = 0; this.beans != null && i < this.beans.length; ++i) {
            if (!this.beans[i].isEnabled()) continue;
            EJBMethodDescriptor[] eJBMethodDescriptorArray = this.beans[i].getUnresolvedMethods();
            for (int j = 0; eJBMethodDescriptorArray != null && j < eJBMethodDescriptorArray.length; ++j) {
                String string = "tag " + eJBMethodDescriptorArray[j].getTagName() + " for method " + eJBMethodDescriptorArray[j].getName() + " on " + eJBMethodDescriptorArray[j].getTargetType() + " appears to " + "have meaningless parameter names (arg0,arg1,....)";
                list.add(string);
            }
        }
    }

    private void getDuplicateTagNames(List list) {
        ArrayList<EJBMethodDescriptor> arrayList = new ArrayList<EJBMethodDescriptor>();
        for (int i = 0; this.beans != null && i < this.beans.length; ++i) {
            int n;
            EJBMethodDescriptor[] eJBMethodDescriptorArray = this.beans[i].getEJBMethods();
            for (n = 0; eJBMethodDescriptorArray != null && n < eJBMethodDescriptorArray.length; ++n) {
                if (!eJBMethodDescriptorArray[n].isEnabled()) continue;
                arrayList.add(eJBMethodDescriptorArray[n]);
            }
            eJBMethodDescriptorArray = this.beans[i].getHomeMethods();
            for (n = 0; eJBMethodDescriptorArray != null && n < eJBMethodDescriptorArray.length; ++n) {
                if (!eJBMethodDescriptorArray[n].isEnabled()) continue;
                arrayList.add(eJBMethodDescriptorArray[n]);
            }
        }
        EJBMethodDescriptor[] eJBMethodDescriptorArray = new EJBMethodDescriptor[arrayList.size()];
        arrayList.toArray(eJBMethodDescriptorArray);
        this.getDuplicateTagNames(list, eJBMethodDescriptorArray);
    }

    private void getDuplicateTagNames(List list, EJBMethodDescriptor[] eJBMethodDescriptorArray) {
        if (eJBMethodDescriptorArray == null) {
            return;
        }
        int n = eJBMethodDescriptorArray.length;
        for (int i = 0; i < n - 1; ++i) {
            String string = eJBMethodDescriptorArray[i].getTagName();
            for (int j = i + 1; j < n; ++j) {
                if (string == null || !string.equals(eJBMethodDescriptorArray[j].getTagName())) continue;
                String string2 = "duplicate tag names \"" + string + "\" refer to methods \"" + eJBMethodDescriptorArray[i].getSignature() + "\" and \"" + eJBMethodDescriptorArray[j].getSignature() + "\"";
                list.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EJBTaglibDescriptor load(File file) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
        try {
            EJBTaglibDescriptor eJBTaglibDescriptor = EJBTaglibDescriptor.load(inputStreamReader);
            return eJBTaglibDescriptor;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    public static String toString(EJBTaglibDescriptor eJBTaglibDescriptor) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter);
        eJBTaglibDescriptor.toXML(xMLWriter);
        xMLWriter.flush();
        return stringWriter.toString();
    }

    public static EJBTaglibDescriptor load(String string) throws Exception {
        return EJBTaglibDescriptor.load(new StringReader(string));
    }

    public static EJBTaglibDescriptor load(Reader reader) throws Exception {
        return EJBTaglibDescriptor.load(reader, new EJBTaglibDescriptor());
    }

    private static EJBTaglibDescriptor load(Reader reader, EJBTaglibDescriptor eJBTaglibDescriptor) throws Exception {
        WebLogicDocumentBuilderFactory webLogicDocumentBuilderFactory = new WebLogicDocumentBuilderFactory();
        ((DocumentBuilderFactory)webLogicDocumentBuilderFactory).setValidating(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)webLogicDocumentBuilderFactory).newDocumentBuilder();
        documentBuilder.setEntityResolver(new EJBTaglibEntityResolver());
        InputSource inputSource = new InputSource(reader);
        Element element = null;
        element = documentBuilder.parse(inputSource).getDocumentElement();
        eJBTaglibDescriptor.initFromRoot(element);
        return eJBTaglibDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        EJBTaglibDescriptor eJBTaglibDescriptor = EJBTaglibDescriptor.load(file);
        XMLWriter xMLWriter = new XMLWriter((OutputStream)System.out);
        eJBTaglibDescriptor.toXML(xMLWriter);
        xMLWriter.flush();
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.println(PREAMBLE);
        xMLWriter.println("<ejb2jsp-taglib>");
        xMLWriter.incrIndent();
        this.fileInfo.toXML(xMLWriter);
        if (this.beans == null || this.beans.length == 0) {
            throw new IllegalStateException("cannot save xml descriptor file with no bean entries");
        }
        for (int i = 0; this.beans != null && i < this.beans.length; ++i) {
            this.beans[i].toXML(xMLWriter);
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</ejb2jsp-taglib>");
    }
}

