/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.dd;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import weblogic.servlet.ejb2jsp.Utils;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class FilesystemInfoDescriptor
implements ToXML {
    private String javacPath;
    private String javacFlags;
    private String pkgname;
    private String ejbJarFile;
    private String saveAs;
    private String saveJarTmpdir;
    private String saveJarFile;
    private String saveDirClassDir;
    private String saveDirTldFile;
    private String[] compileClasspath;
    private String[] sourcePath;
    private boolean keepgenerated;
    private boolean compile = true;

    public FilesystemInfoDescriptor() {
        this.saveDirTldFile = "";
        this.saveDirClassDir = "";
        this.saveJarFile = "";
        this.saveJarTmpdir = "";
        this.saveAs = "";
        this.ejbJarFile = "";
        this.pkgname = "";
        this.javacFlags = "";
        this.javacPath = "";
        this.sourcePath = new String[0];
        this.compileClasspath = new String[0];
    }

    public FilesystemInfoDescriptor(Element element) throws DOMProcessingException {
        Element element2 = null;
        this.javacPath = DOMUtils.getValueByTagName(element, "javac-path");
        this.javacFlags = DOMUtils.getValueByTagName(element, "javac-flags");
        this.compileClasspath = this.getPathElements(element, "compile-classpath");
        String string = DOMUtils.getValueByTagName(element, "keepgenerated");
        this.keepgenerated = "true".equalsIgnoreCase(string);
        this.sourcePath = this.getPathElements(element, "source-path");
        this.pkgname = DOMUtils.getValueByTagName(element, "package-name");
        this.ejbJarFile = DOMUtils.getValueByTagName(element, "ejb-jar-file");
        this.saveAs = DOMUtils.getValueByTagName(element, "save-as");
        element2 = DOMUtils.getElementByTagName(element, "save-taglib-jar");
        this.saveJarTmpdir = DOMUtils.getValueByTagName(element2, "tmpdir");
        this.saveJarFile = DOMUtils.getValueByTagName(element2, "taglib-jar-file");
        element2 = DOMUtils.getElementByTagName(element, "save-taglib-directory");
        this.saveDirClassDir = DOMUtils.getValueByTagName(element2, "classes-directory");
        this.saveDirTldFile = DOMUtils.getValueByTagName(element2, "tld-file");
    }

    private String[] getPathElements(Element element, String string) throws DOMProcessingException {
        Element element2 = DOMUtils.getElementByTagName(element, string);
        List list = DOMUtils.getOptionalElementsByTagName(element2, "path-element");
        list = DOMUtils.getTextDataValues(list);
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String toString() {
        return "Project Build Options";
    }

    private static String trim(String string) {
        return string == null ? "" : string.trim();
    }

    private static boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    public String[] getErrors() {
        this.javacPath = FilesystemInfoDescriptor.trim(this.javacPath);
        this.javacFlags = FilesystemInfoDescriptor.trim(this.javacFlags);
        this.pkgname = FilesystemInfoDescriptor.trim(this.pkgname);
        this.saveJarTmpdir = FilesystemInfoDescriptor.trim(this.saveJarTmpdir);
        this.saveJarFile = FilesystemInfoDescriptor.trim(this.saveJarFile);
        this.saveDirClassDir = FilesystemInfoDescriptor.trim(this.saveDirClassDir);
        this.saveDirTldFile = FilesystemInfoDescriptor.trim(this.saveDirTldFile);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (FilesystemInfoDescriptor.isNull(this.javacPath)) {
            arrayList.add("A java compiler (like \"javac\") must be specified, e.g., \"my.ejb.jsptags\"");
        }
        if (FilesystemInfoDescriptor.isNull(this.pkgname)) {
            arrayList.add("A java package for the generated code must be specified.");
        }
        if (this.saveAsDirectory()) {
            if (FilesystemInfoDescriptor.isNull(this.saveDirTldFile)) {
                arrayList.add("A file location for the TLD file must be specified, e.g., WEB-INF/myejb.tld");
            }
            if (FilesystemInfoDescriptor.isNull(this.saveDirClassDir)) {
                arrayList.add("A directory must be specified where the tag classes will be compiled, e.g., WEB-INF/classes");
            }
        } else {
            if (FilesystemInfoDescriptor.isNull(this.saveJarFile)) {
                arrayList.add("The target taglib jar file must be specified, e.g., WEB-INF/lib/myejb-tags.jar");
            }
            if (FilesystemInfoDescriptor.isNull(this.saveJarTmpdir)) {
                arrayList.add("A temporary compilation directory must be specified before packaging the jar file, e.g., C:\\TEMP or /tmp");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getCompileCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getKeepgenerated()) {
            arrayList.add("-keepgenerated");
        }
        arrayList.add("-d");
        if (this.saveAsDirectory()) {
            arrayList.add(this.getSaveDirClassDir());
        } else {
            arrayList.add(this.getSaveJarTmpdir());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getPackage() {
        return this.pkgname;
    }

    public void setPackage(String string) {
        this.pkgname = string;
        if (this.pkgname.endsWith(".")) {
            this.pkgname = this.pkgname.substring(0, this.pkgname.length() - 2);
        }
    }

    public String getJavacPath() {
        return this.javacPath;
    }

    public void setJavacPath(String string) {
        this.javacPath = string;
    }

    public String getJavacFlags() {
        return this.javacFlags;
    }

    public void setJavacFlags(String string) {
        this.javacFlags = string;
    }

    public String[] getCompileClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new String[0];
        }
        return (String[])this.compileClasspath.clone();
    }

    public String[] getBuiltinClasspath() {
        return Utils.splitPath(System.getProperty("java.class.path") + File.pathSeparator + this.getEJBJarFile());
    }

    public void setCompileClasspath(String[] stringArray) {
        this.compileClasspath = stringArray == null ? new String[0] : (String[])stringArray.clone();
    }

    public boolean getCompile() {
        return this.compile;
    }

    public void setCompile(boolean bl) {
        this.compile = bl;
    }

    public boolean getKeepgenerated() {
        return this.keepgenerated;
    }

    public void setKeepgenerated(boolean bl) {
        this.keepgenerated = bl;
    }

    public String[] getSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new String[0];
        }
        return (String[])this.sourcePath.clone();
    }

    public void setSourcePath(String[] stringArray) {
        this.sourcePath = (String[])stringArray.clone();
    }

    public String getEJBJarFile() {
        return this.ejbJarFile;
    }

    public void setEJBJarFile(String string) {
        this.ejbJarFile = string;
    }

    public String getSaveAs() {
        return this.saveAs;
    }

    public void setSaveAs(String string) {
        this.saveAs = string;
    }

    public boolean saveAsDirectory() {
        return !"JAR".equals(this.saveAs);
    }

    public String getSaveJarTmpdir() {
        return this.saveJarTmpdir;
    }

    public void setSaveJarTmpdir(String string) {
        this.saveJarTmpdir = string;
    }

    public String getSaveJarFile() {
        return this.saveJarFile;
    }

    public void setSaveJarFile(String string) {
        this.saveJarFile = string;
    }

    public String getSaveDirClassDir() {
        return this.saveDirClassDir;
    }

    public void setSaveDirClassDir(String string) {
        this.saveDirClassDir = string;
    }

    public String getSaveDirTldFile() {
        return this.saveDirTldFile;
    }

    public void setSaveDirTldFile(String string) {
        this.saveDirTldFile = string;
    }

    public void toXML(XMLWriter xMLWriter) {
        int n;
        xMLWriter.println("<filesystem-info>");
        xMLWriter.incrIndent();
        xMLWriter.println("<javac-path>" + this.javacPath + "</javac-path>");
        xMLWriter.println("<javac-flags>" + this.javacFlags + "</javac-flags>");
        xMLWriter.println("<compile-classpath>");
        String[] stringArray = this.getCompileClasspath();
        xMLWriter.incrIndent();
        for (n = 0; n < stringArray.length; ++n) {
            xMLWriter.println("<path-element>" + stringArray[n] + "</path-element>");
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</compile-classpath>");
        xMLWriter.println("<keepgenerated>" + this.keepgenerated + "</keepgenerated>");
        xMLWriter.println("<source-path>");
        stringArray = this.getSourcePath();
        xMLWriter.incrIndent();
        for (n = 0; n < stringArray.length; ++n) {
            xMLWriter.println("<path-element>" + stringArray[n] + "</path-element>");
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</source-path>");
        xMLWriter.println("<package-name>" + this.pkgname + "</package-name>");
        xMLWriter.println("<ejb-jar-file>" + this.ejbJarFile + "</ejb-jar-file>");
        xMLWriter.println("<save-as>" + this.saveAs + "</save-as>");
        xMLWriter.println("<save-taglib-jar>");
        xMLWriter.incrIndent();
        xMLWriter.println("<tmpdir>" + this.saveJarTmpdir + "</tmpdir>");
        xMLWriter.println("<taglib-jar-file>" + this.saveJarFile + "</taglib-jar-file>");
        xMLWriter.decrIndent();
        xMLWriter.println("</save-taglib-jar>");
        xMLWriter.println("<save-taglib-directory>");
        xMLWriter.incrIndent();
        xMLWriter.println("<classes-directory>" + this.saveDirClassDir + "</classes-directory>");
        xMLWriter.println("<tld-file>" + this.saveDirTldFile + "</tld-file>");
        xMLWriter.decrIndent();
        xMLWriter.println("</save-taglib-directory>");
        xMLWriter.decrIndent();
        xMLWriter.println("</filesystem-info>");
    }
}

