/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.dd;

import org.w3c.dom.Element;
import weblogic.servlet.internal.dd.ToXML;
import weblogic.utils.io.XMLWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class MethodParamDescriptor
implements ToXML {
    private String type;
    private String name;
    private String defalt;
    private String defaultValue;
    private String defaultMethod;

    static void p(String string) {
        System.err.println("[MethodParamDesc]: " + string);
    }

    public MethodParamDescriptor() {
        this.defalt = this.defaultValue = this.defaultMethod;
        this.name = this.defaultValue;
        this.type = this.defaultValue;
        this.setDefault("NONE");
    }

    public MethodParamDescriptor(Element element) throws DOMProcessingException {
        this.type = DOMUtils.getValueByTagName(element, "param-type");
        this.name = DOMUtils.getValueByTagName(element, "param-name");
        this.defalt = DOMUtils.getValueByTagName(element, "enable-default");
        this.defaultValue = DOMUtils.getValueByTagName(element, "default-value").trim();
        this.defaultMethod = DOMUtils.getValueByTagName(element, "default-method-body").trim();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDefault() {
        return this.defalt;
    }

    public void setDefault(String string) {
        this.defalt = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultMethod() {
        return this.defaultMethod;
    }

    public void setDefaultMethod(String string) {
        this.defaultMethod = string;
    }

    public String toString() {
        return "Attribute: " + this.name;
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.println("<parameter>");
        xMLWriter.incrIndent();
        xMLWriter.println("<param-type>" + this.type + "</param-type>");
        xMLWriter.println("<param-name>" + this.name + "</param-name>");
        xMLWriter.println("<enable-default>" + this.defalt + "</enable-default>");
        if (this.defaultValue != null) {
            xMLWriter.println("<default-value><![CDATA[" + this.defaultValue + "]]></default-value>");
        }
        if (this.defaultMethod != null) {
            xMLWriter.println("<default-method-body><![CDATA[");
            xMLWriter.printNoIndent(this.defaultMethod);
            xMLWriter.println("]]></default-method-body>");
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</parameter>");
    }
}

