/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import weblogic.tools.ui.AWTUtils;

public class ArrayEditorDialog
extends JDialog
implements ActionListener {
    private String[] elements;
    private JTextField[] fields;
    private JTextField newField;
    private JButton[] buttons;
    private JButton addButton;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel currentPanel;
    private JScrollPane scroll;
    private boolean trim;

    public ArrayEditorDialog(Frame frame, String string, boolean bl, String[] stringArray) {
        this(frame, string, bl, stringArray, true);
    }

    public ArrayEditorDialog(Frame frame, String string, boolean bl, String[] stringArray, boolean bl2) {
        super(frame, string, bl);
        this.elements = stringArray;
        if (this.elements == null) {
            this.elements = new String[0];
        }
        this.trim = bl2;
        this.scroll = new JScrollPane();
        this.getContentPane().add(this.scroll);
        this.makeComponents();
        this.myDoLayout();
    }

    private void makeComponents() {
        int n = this.elements.length;
        this.fields = new JTextField[n];
        this.buttons = new JButton[n];
        for (int i = 0; i < n; ++i) {
            this.fields[i] = new JTextField(this.elements[i]);
            this.buttons[i] = new JButton("Delete");
            this.buttons[i].addActionListener(this);
        }
        this.newField = new JTextField("");
        this.addButton = new JButton("Add New Element");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.addButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    static void p(String string) {
    }

    private void myDoLayout() {
        if (this.currentPanel != null) {
            this.currentPanel.removeAll();
        }
        this.currentPanel = new JPanel();
        this.currentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        for (int i = 0; i < this.fields.length; ++i) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            this.currentPanel.add((Component)this.fields[i], gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            this.currentPanel.add((Component)this.buttons[i], gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        this.currentPanel.add((Component)this.newField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.currentPanel.add((Component)this.addButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.currentPanel.add((Component)this.okButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.currentPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.scroll.setViewportView(this.currentPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        ArrayEditorDialog.p("actionPerformed");
        Object object = actionEvent.getSource();
        for (n = 0; n < this.buttons.length; ++n) {
            if (object != this.buttons[n]) continue;
            ArrayEditorDialog.p("button#" + n);
            JTextField[] jTextFieldArray = new JTextField[this.fields.length - 1];
            JButton[] jButtonArray = new JButton[this.fields.length - 1];
            System.arraycopy(this.fields, 0, jTextFieldArray, 0, n);
            System.arraycopy(this.fields, n + 1, jTextFieldArray, n, this.fields.length - n - 1);
            System.arraycopy(this.buttons, 0, jButtonArray, 0, n);
            System.arraycopy(this.buttons, n + 1, jButtonArray, n, this.buttons.length - n - 1);
            this.fields = jTextFieldArray;
            this.buttons = jButtonArray;
            this.myDoLayout();
            this.repaint();
            return;
        }
        if (object == this.addButton) {
            JTextField[] jTextFieldArray = new JTextField[this.fields.length + 1];
            JButton[] jButtonArray = new JButton[this.fields.length + 1];
            System.arraycopy(this.fields, 0, jTextFieldArray, 0, this.fields.length);
            jTextFieldArray[this.fields.length] = new JTextField(this.newField.getText());
            System.arraycopy(this.buttons, 0, jButtonArray, 0, this.buttons.length);
            jButtonArray[this.buttons.length] = new JButton("Delete");
            jButtonArray[this.buttons.length].addActionListener(this);
            this.fields = jTextFieldArray;
            this.buttons = jButtonArray;
            this.myDoLayout();
            this.repaint();
            this.newField.setText("");
            return;
        }
        if (object == this.okButton) {
            this.elements = new String[this.fields.length];
            for (n = 0; n < this.elements.length; ++n) {
                String string = this.fields[n].getText();
                if (this.trim) {
                    string = string.trim();
                }
                this.elements[n] = string;
            }
            this.setVisible(false);
            return;
        }
        if (object == this.cancelButton) {
            this.setVisible(false);
            return;
        }
    }

    public String[] getElements() {
        return this.elements;
    }

    public static void main(String[] stringArray) throws Exception {
        AWTUtils.initLookAndFeel();
        JFrame jFrame = new JFrame("array edit test");
        jFrame.getContentPane().add(new JLabel("blah"));
        jFrame.setSize(500, 500);
        jFrame.setLocation(800, 300);
        jFrame.setVisible(true);
        String[] stringArray2 = new String[7];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = "this is a field, #" + (i + 1);
        }
        ArrayEditorDialog arrayEditorDialog = new ArrayEditorDialog((Frame)jFrame, "edit values", true, stringArray2);
        arrayEditorDialog.pack();
        AWTUtils.centerOnWindow(arrayEditorDialog, jFrame);
        arrayEditorDialog.show();
        stringArray2 = arrayEditorDialog.getElements();
        System.err.println("updated elements are: ");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.err.println(" " + i + stringArray2[i]);
        }
    }
}

