/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.gui;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import weblogic.tools.ui.AWTUtils;

public class HelpFrame
extends JFrame
implements HyperlinkListener {
    private static final boolean debug = false;
    private boolean wasVisible;
    JFrame parent;
    JEditorPane html;
    JScrollPane scroll;
    HTMLDocument doc;
    private Map anchors = new HashMap();

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL uRL = hyperlinkEvent.getURL();
        String string = hyperlinkEvent.getDescription();
        Object object = hyperlinkEvent.getSource();
        HelpFrame.p("hyperlink event: u='" + uRL + "' desc='" + string + "' src type=" + object.getClass().getName());
        if (string == null) {
            return;
        }
        this.scroll2anchor(string);
    }

    public void scroll2anchor(String string) {
        Cloneable cloneable;
        Integer n = (Integer)this.anchors.get(string);
        if (n == null) {
            return;
        }
        int n2 = n;
        HelpFrame.p("scroll to " + n2);
        if (!this.isVisible() && !this.wasVisible) {
            this.wasVisible = true;
            cloneable = this.getPreferredSize();
            cloneable.width = Math.max(cloneable.width, 350);
            this.setSize(cloneable.width + 30, 400);
            AWTUtils.centerOnWindow(this, this.parent);
        }
        this.setVisible(true);
        cloneable = null;
        try {
            cloneable = this.html.modelToView(n2);
            HelpFrame.p("got rect=" + cloneable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        JViewport jViewport = this.scroll.getViewport();
        Point point = new Point();
        point.x = 0;
        point.y = ((Rectangle)cloneable).y;
        jViewport.setViewPosition(point);
    }

    static void p(String string) {
    }

    static String readHTML(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        String string2 = new String(byArray);
        return string2;
    }

    static String readHTML(URL uRL) throws Exception {
        InputStream inputStream = uRL.openStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        String string = new String(byArray);
        return string;
    }

    private Image getFrameIcon() {
        return AWTUtils.loadImage(this.getClass().getClassLoader(), "/weblogic/graphics/W.gif");
    }

    public HelpFrame(String string, JFrame jFrame, URL uRL) throws Exception {
        super(string);
        Image image = this.getFrameIcon();
        if (image != null) {
            this.setIconImage(image);
        }
        this.parent = jFrame;
        String string2 = HelpFrame.readHTML(uRL);
        this.html = new JEditorPane("text/html", string2);
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        this.scroll = new JScrollPane(this.html);
        this.getContentPane().add(this.scroll);
        this.doc = (HTMLDocument)this.html.getDocument();
        HTMLDocument.Iterator iterator = this.doc.getIterator(HTML.Tag.A);
        boolean bl = false;
        while (iterator.isValid()) {
            AttributeSet attributeSet = iterator.getAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                String string3 = obj.toString();
                String string4 = object.toString();
                if (!string3.equals("name") || string4.equals("a")) continue;
                int n = iterator.getStartOffset();
                HelpFrame.p("got anchor \"" + string4 + "\" at offset " + n);
                this.anchors.put(string4, new Integer(n));
                break;
            }
            iterator.next();
        }
        HelpFrame.p("CTOR done, anchors=" + this.anchors);
    }
}

