/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.ejb2jsp.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import weblogic.servlet.ejb2jsp.Utils;
import weblogic.servlet.ejb2jsp.dd.BeanDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBMethodDescriptor;
import weblogic.servlet.ejb2jsp.dd.EJBTaglibDescriptor;
import weblogic.servlet.ejb2jsp.dd.FilesystemInfoDescriptor;
import weblogic.servlet.ejb2jsp.dd.MethodParamDescriptor;
import weblogic.servlet.ejb2jsp.gui.BasePanel;
import weblogic.servlet.ejb2jsp.gui.BeanDescriptorPanel;
import weblogic.servlet.ejb2jsp.gui.EJB2JSPFileChooser;
import weblogic.servlet.ejb2jsp.gui.EJBMethodDescriptorPanel;
import weblogic.servlet.ejb2jsp.gui.EJBTaglibDescriptorPanel;
import weblogic.servlet.ejb2jsp.gui.EJBTaglibDescriptorTree;
import weblogic.servlet.ejb2jsp.gui.FilesystemInfoDescriptorPanel;
import weblogic.servlet.ejb2jsp.gui.HelpFrame;
import weblogic.servlet.ejb2jsp.gui.JarFileChooser;
import weblogic.servlet.ejb2jsp.gui.MainWorker;
import weblogic.servlet.ejb2jsp.gui.MethodParamDescriptorPanel;
import weblogic.servlet.ejb2jsp.gui.PreferencesDialog;
import weblogic.servlet.ejb2jsp.gui.Prefs;
import weblogic.tools.ui.AWTUtils;
import weblogic.tools.ui.GUIPrintStream;
import weblogic.utils.io.XMLWriter;

public class Main
implements TreeSelectionListener,
ActionListener,
WindowListener {
    public static final boolean debug = false;
    private Stack tasks = new Stack();
    EJBTaglibDescriptor currentBean;
    Hashtable panels = new Hashtable();
    String[] cmdLine;
    JScrollPane left;
    JScrollPane right;
    JFrame frame;
    JTree tree;
    JSplitPane split;
    JMenuBar mb;
    JMenu menu;
    JPanel splash;
    JTextArea compileTA;
    GUIPrintStream guiPS;
    Prefs prefs;
    JMenuItem saveMenu;
    JMenuItem saveAsMenu;
    JMenuItem quitMenu;
    JMenuItem openMenu;
    JMenuItem newMenu;
    JMenuItem compileMenu;
    JMenuItem resolveMenu;
    JMenuItem prefsMenu;
    JMenuItem helpMenu;
    JFrame docFrame;
    HelpFrame contextHelp;
    Image frameIcon = null;
    private static Main theMain;
    private boolean dirty = false;
    File currentDirectory = new File(".");
    File currentProject = null;

    static void p(String string) {
    }

    private BasePanel currentPanel() {
        JViewport jViewport = this.right.getViewport();
        Component component = jViewport.getView();
        if (component == null) {
            return null;
        }
        if (component instanceof BasePanel) {
            return (BasePanel)component;
        }
        return null;
    }

    private void setClean() {
        if (this.currentPanel() != null) {
            this.currentPanel().setDirty(false);
        }
    }

    private void fields2bean() {
        BasePanel basePanel = this.currentPanel();
        if (basePanel == null) {
            return;
        }
        try {
            basePanel.fields2bean();
            boolean bl = basePanel.isDirty();
            if (bl) {
                Main.p("panel " + basePanel.getClass().getName() + " says he's dirty");
            }
            this.dirty |= bl;
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    private void objectSelected(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return;
        }
        JViewport jViewport = this.right.getViewport();
        BasePanel basePanel = null;
        if (clazz == FilesystemInfoDescriptor.class) {
            FilesystemInfoDescriptor filesystemInfoDescriptor = (FilesystemInfoDescriptor)object;
            basePanel = new FilesystemInfoDescriptorPanel(filesystemInfoDescriptor);
            jViewport.setView(null);
            jViewport.setView(basePanel);
        } else if (clazz == BeanDescriptor.class) {
            BeanDescriptor beanDescriptor = (BeanDescriptor)object;
            basePanel = new BeanDescriptorPanel(beanDescriptor);
            jViewport.setView(null);
            jViewport.setView(basePanel);
        } else if (clazz == EJBTaglibDescriptor.class) {
            EJBTaglibDescriptor eJBTaglibDescriptor = (EJBTaglibDescriptor)object;
            basePanel = new EJBTaglibDescriptorPanel(eJBTaglibDescriptor);
            jViewport.setView(null);
            jViewport.setView(basePanel);
        } else if (clazz == MethodParamDescriptor.class) {
            MethodParamDescriptor methodParamDescriptor = (MethodParamDescriptor)object;
            basePanel = new MethodParamDescriptorPanel(methodParamDescriptor);
            jViewport.setView(null);
            jViewport.setView(basePanel);
        } else if (clazz == EJBMethodDescriptor.class) {
            EJBMethodDescriptor eJBMethodDescriptor = (EJBMethodDescriptor)object;
            basePanel = new EJBMethodDescriptorPanel(eJBMethodDescriptor);
            jViewport.setView(null);
            jViewport.setView(basePanel);
        } else {
            System.err.println("ERROR: I don't understand type " + clazz.getName());
        }
    }

    private void objectDeselected(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return;
        }
        JViewport jViewport = this.right.getViewport();
        Component component = jViewport.getView();
        if (component != null && component instanceof BasePanel) {
            BasePanel basePanel = null;
            basePanel = (BasePanel)component;
            basePanel.fields2bean();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
        TreePath treePath2 = treeSelectionEvent.getNewLeadSelectionPath();
        Object object = null;
        Object object2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
            object = defaultMutableTreeNode.getUserObject();
        }
        if (treePath2 != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent()) != null) {
            object2 = defaultMutableTreeNode.getUserObject();
        }
        if (object != null) {
            Main.p("deselected type: " + object.getClass().getName());
            try {
                this.objectDeselected(object);
            }
            catch (Exception exception) {
                this.displayException(exception);
            }
        }
        if (object2 != null) {
            Main.p("selected type: " + object2.getClass().getName());
            try {
                this.objectSelected(object2);
            }
            catch (Exception exception) {
                this.displayException(exception);
            }
        }
    }

    public Main(String[] stringArray) {
        this.cmdLine = stringArray;
        Thread thread2 = new Thread((Runnable)new MainWorker(this), "MainGuiWorker");
        thread2.start();
    }

    private static void usage() {
        System.err.println("usage: Main <ejb-jar-file> <ejb-source-dir>, -or-");
        System.err.println("       Main <ejb2jsp-project-file>");
    }

    EJBTaglibDescriptor loadRootBean() throws Exception {
        if (this.cmdLine == null || this.cmdLine.length == 0) {
            return null;
        }
        if (this.cmdLine.length == 1) {
            if (this.cmdLine[0].endsWith(".ejb2jsp")) {
                return this.loadBeanFromFile(new File(this.cmdLine[0]));
            }
            if (this.cmdLine[0].endsWith(".jar")) {
                File file = new File(this.cmdLine[0]);
                file = new File(file.getAbsolutePath());
                return this.loadFromPaths(file.getAbsolutePath(), file.getParent());
            }
            Main.usage();
        }
        if (this.cmdLine.length != 2) {
            Main.usage();
            return null;
        }
        try {
            return this.loadFromPaths(this.cmdLine[0], this.cmdLine[1]);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return null;
        }
    }

    EJBTaglibDescriptor loadBeanFromFile(File file) throws Exception {
        EJBTaglibDescriptor eJBTaglibDescriptor = EJBTaglibDescriptor.load(file);
        this.currentProject = file;
        return eJBTaglibDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushTask(Runnable runnable) {
        Stack stack = this.tasks;
        synchronized (stack) {
            this.tasks.push(runnable);
            this.tasks.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getTask() throws InterruptedException {
        Stack stack = this.tasks;
        synchronized (stack) {
            while (this.tasks.isEmpty()) {
                this.tasks.wait();
            }
            Runnable runnable = (Runnable)this.tasks.firstElement();
            this.tasks.removeElementAt(0);
            return runnable;
        }
    }

    private boolean askToSave() {
        this.fields2bean();
        if (!this.dirty) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this.frame, "Changes to the current project have not been saved.  Do you want to save now?", "Confirm Exit", 1, 1);
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (this.saveMenu.isEnabled()) {
            this.doSave();
        } else {
            this.doSaveAs();
        }
        return true;
    }

    public void doSave() {
        this.saveCurrentBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentBean() {
        this.fields2bean();
        XMLWriter xMLWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.currentProject);
            xMLWriter = new XMLWriter((OutputStream)fileOutputStream);
            this.currentBean.toXML(xMLWriter);
            xMLWriter.flush();
            xMLWriter.close();
            fileOutputStream.close();
            this.dirty = false;
            xMLWriter = null;
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
        finally {
            if (xMLWriter != null) {
                try {
                    xMLWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void doCompile() {
        int n = 0;
        Main.p("docompile " + n++);
        this.fields2bean();
        Main.p("docompile " + n++);
        GUIPrintStream gUIPrintStream = this.getGUIPrintStream();
        Main.p("docompile " + n++);
        try {
            Main.p("docompile " + n++);
            this.right.getViewport().setView(this.compileTA);
            Main.p("docompile " + n++);
            PrintStream printStream = new PrintStream(gUIPrintStream);
            Main.p("docompile " + n++);
            Utils.compile(this.currentBean, printStream);
            Main.p("docompile " + n++);
            printStream.flush();
            Main.p("docompile " + n++);
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    public void doSaveAs() {
        try {
            JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
            jFileChooser.setFileFilter(new EJB2JSPFileChooser());
            boolean bl = false;
            do {
                int n = jFileChooser.showDialog(this.frame, "Save ejb2jsp project");
                if (n == 1) {
                    return;
                }
                this.currentDirectory = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                String string = file.getName();
                if (string == null) continue;
                if (!string.endsWith(".ejb2jsp")) {
                    string = string + ".ejb2jsp";
                    file = new File(new File(file.getParent()), string);
                }
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this.frame, "A file called \"" + string + "\" already exists.  Do " + "you want to overwrite it?", "Confirm file overwrite", 0, 3)) == 1) continue;
                this.currentProject = file;
                this.saveCurrentBean();
                this.saveMenu.setEnabled(true);
                bl = true;
            } while (!bl);
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit() {
        try {
            this.prefs.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public void doQuit() {
        if (this.askToSave()) {
            this.doExit();
        }
    }

    public void doOpen() {
        Main.p("doOpen");
        try {
            JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
            jFileChooser.setFileFilter(new EJB2JSPFileChooser());
            int n = jFileChooser.showDialog(this.frame, "Open ejb2jsp project");
            if (n == 0) {
                this.currentDirectory = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                EJBTaglibDescriptor eJBTaglibDescriptor = this.loadBeanFromFile(file);
                this.setRootBean(eJBTaglibDescriptor);
                this.currentProject = file;
                this.saveMenu.setEnabled(true);
                this.saveAsMenu.setEnabled(true);
                this.compileMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    public void doResolve() {
        try {
            Utils.resolveSources(this.currentBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doHelp() {
        try {
            this.initHelp();
            if (this.docFrame != null) {
                this.docFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doPrefs() {
        try {
            PreferencesDialog preferencesDialog = new PreferencesDialog((Frame)this.frame, "Preferences", true, this.prefs);
            preferencesDialog.pack();
            AWTUtils.centerOnWindow(preferencesDialog, this.frame);
            preferencesDialog.show();
            this.prefs = preferencesDialog.getPrefs();
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    public void doNew() {
        try {
            JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
            jFileChooser.setFileFilter(new JarFileChooser());
            int n = jFileChooser.showDialog(this.frame, "Open EJB Jar File");
            if (n == 1) {
                return;
            }
            File file = this.currentDirectory = jFileChooser.getCurrentDirectory();
            File file2 = jFileChooser.getSelectedFile();
            this.currentBean = this.loadFromPaths(file2.getAbsolutePath(), file.getAbsolutePath());
            this.currentBean.getFileInfo().setJavacPath(this.prefs.compiler);
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    private EJBTaglibDescriptor loadFromPaths(String string, String string2) throws Exception {
        try {
            if (this.prefs.sourceDir != null && (this.prefs.sourceDir = this.prefs.sourceDir.trim()).length() > 0) {
                string2 = this.prefs.sourceDir + File.pathSeparator + string2;
            }
            EJBTaglibDescriptor eJBTaglibDescriptor = Utils.createDefaultDescriptor(string, string2, this.prefs.webapp);
            this.setRootBean(eJBTaglibDescriptor);
            this.currentProject = null;
            this.saveMenu.setEnabled(false);
            this.saveAsMenu.setEnabled(true);
            this.compileMenu.setEnabled(true);
            return eJBTaglibDescriptor;
        }
        catch (Exception exception) {
            this.displayException(exception);
            return null;
        }
    }

    private File fixJChooserDirBug(File file) {
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        String string = file.getAbsolutePath().replace('/', File.separatorChar);
        int n = string.lastIndexOf(File.separatorChar);
        if (n <= 0) {
            return file;
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        if ((n = string3.lastIndexOf(File.separatorChar)) <= 0) {
            return file;
        }
        String string4 = string3.substring(n + 1);
        return string2.equals(string4) ? new File(string3) : file;
    }

    public void setRootBean(EJBTaglibDescriptor eJBTaglibDescriptor) {
        this.tree = null;
        this.left.setViewportView(null);
        this.currentBean = eJBTaglibDescriptor;
        int n = this.split.getWidth();
        this.split.setDividerLocation(n / 4);
        if (eJBTaglibDescriptor == null) {
            this.saveAsMenu.setEnabled(false);
            this.saveMenu.setEnabled(false);
            this.compileMenu.setEnabled(false);
            this.resolveMenu.setEnabled(false);
            return;
        }
        this.resolveMenu.setEnabled(true);
        try {
            this.tree = new EJBTaglibDescriptorTree(eJBTaglibDescriptor);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return;
        }
        this.tree.addTreeSelectionListener(this);
        this.left.setViewportView(this.tree);
    }

    private Image getFrameIcon() {
        if (this.frameIcon == null) {
            this.frameIcon = AWTUtils.loadImage(this.getClass().getClassLoader(), "/weblogic/graphics/W.gif");
        }
        return this.frameIcon;
    }

    private void initSplash() {
        this.splash = new JPanel();
        Image image = AWTUtils.loadImage(this.getClass().getClassLoader(), "/weblogic/graphics/logo-trans.gif");
        if (image != null) {
            ImageIcon imageIcon = new ImageIcon(image);
            this.splash.add(new JLabel(imageIcon));
            Main.p("initSplash: added Image=" + image);
        } else {
            Main.p("initSplash: cannot find image");
        }
    }

    private void initHelp() {
        try {
            int n;
            if (this.docFrame != null) {
                return;
            }
            URL uRL = this.getClass().getResource("documentation.html");
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[512];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read(byArray)) > 0) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            inputStream.close();
            JEditorPane jEditorPane = new JEditorPane("text/html", stringBuffer.toString());
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            this.docFrame = new JFrame("documentation");
            Image image = this.getFrameIcon();
            if (image != null) {
                this.docFrame.setIconImage(image);
            }
            this.docFrame.getContentPane().add(jScrollPane);
            this.docFrame.setSize(500, 400);
            this.docFrame.setLocation(200, 200);
            this.helpMenu.setEnabled(true);
            uRL = this.getClass().getResource("help.html");
            this.contextHelp = new HelpFrame("EJB to JSP Help", this.frame, uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Main getInstance() {
        return theMain;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string;
        Object object2 = actionEvent.getSource();
        if (object2 instanceof JComponent && (string = (String)((JComponent)(object = (JComponent)object2)).getClientProperty("help-anchor")) != null) {
            Main.p("help anchor: '" + string + "'");
            this.contextHelp.scroll2anchor(string);
            return;
        }
        object = null;
        if (object2 == this.saveMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doSave();
                }
            };
        } else if (object2 == this.saveAsMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doSaveAs();
                }
            };
        } else if (object2 == this.quitMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doQuit();
                }
            };
        } else if (object2 == this.openMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doOpen();
                }
            };
        } else if (object2 == this.newMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doNew();
                }
            };
        } else if (object2 == this.compileMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doCompile();
                }
            };
        } else if (object2 == this.resolveMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doResolve();
                }
            };
        } else if (object2 == this.helpMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doHelp();
                }
            };
        } else if (object2 == this.prefsMenu) {
            object = new Runnable(){

                public void run() {
                    Main.this.doPrefs();
                }
            };
        }
        if (object != null) {
            this.pushTask((Runnable)object);
        }
    }

    public void start() throws Exception {
        this.prefs = new Prefs();
        this.prefs.load();
        this.initSplash();
        this.left = new JScrollPane(null);
        this.right = new JScrollPane(this.splash);
        this.split = new JSplitPane(1, true, this.left, this.right);
        this.frame = new JFrame("EJB To JSP Tool");
        Image image = this.getFrameIcon();
        if (image != null) {
            this.frame.setIconImage(image);
        }
        this.frame.addWindowListener(this);
        this.frame.getContentPane().add(this.split);
        this.mb = new JMenuBar();
        this.menu = new JMenu("File");
        this.newMenu = new JMenuItem("New...");
        this.menu.add(this.newMenu);
        this.openMenu = new JMenuItem("Open...");
        this.menu.add(this.openMenu);
        this.compileMenu = new JMenuItem("Build Project");
        this.menu.add(this.compileMenu);
        this.saveMenu = new JMenuItem("Save");
        this.menu.add(this.saveMenu);
        this.saveAsMenu = new JMenuItem("Save As...");
        this.menu.add(this.saveAsMenu);
        this.quitMenu = new JMenuItem("Quit");
        this.menu.add(this.quitMenu);
        this.resolveMenu = new JMenuItem("Resolve Attributes...");
        this.menu.add(this.resolveMenu);
        this.prefsMenu = new JMenuItem("Preferences...");
        this.menu.add(this.prefsMenu);
        this.resolveMenu.setEnabled(false);
        this.resolveMenu.setToolTipText("resolves tag attribute names against EJB interface sources");
        this.openMenu.setToolTipText("opens an existing ejb2jsp project file");
        this.newMenu.setToolTipText("creates a new ejb2jsp project from an EJB jar file");
        this.compileMenu.setToolTipText("builds the current project into the JSP tag library");
        this.openMenu.addActionListener(this);
        this.newMenu.addActionListener(this);
        this.compileMenu.addActionListener(this);
        this.saveMenu.addActionListener(this);
        this.saveAsMenu.addActionListener(this);
        this.quitMenu.addActionListener(this);
        this.resolveMenu.addActionListener(this);
        this.prefsMenu.addActionListener(this);
        this.mb.add(this.menu);
        this.helpMenu = new JMenuItem("Help");
        this.menu.add(this.helpMenu);
        this.helpMenu.addActionListener(this);
        this.helpMenu.setEnabled(false);
        Runnable runnable = new Runnable(){

            public void run() {
                Main.this.initHelp();
            }
        };
        this.pushTask(runnable);
        this.frame.setJMenuBar(this.mb);
        this.frame.setSize(800, 500);
        this.frame.setLocation(200, 200);
        this.setRootBean(this.loadRootBean());
        this.split.setDividerLocation(200);
        this.frame.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        Main main;
        System.setProperty("line.separator", "\n");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "weblogic.apache.xerces.jaxp.SAXParserFactoryImpl");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "weblogic.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        AWTUtils.initLookAndFeel();
        theMain = main = new Main(stringArray);
        main.start();
    }

    private GUIPrintStream getGUIPrintStream() {
        if (this.guiPS == null) {
            this.compileTA = new JTextArea("", 20, 30);
            this.guiPS = new GUIPrintStream(this.compileTA);
        }
        this.compileTA.setText("");
        return this.guiPS;
    }

    public void displayException(Throwable throwable) {
        System.err.println("error occurred: " + throwable);
        throwable.printStackTrace();
        String string = throwable.toString();
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        int n3 = Math.min(n, n2);
        if (n3 > 0) {
            string = string.substring(0, n3);
        }
        JOptionPane.showMessageDialog(this.frame, string, "Error occurred", 0);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.askToSave()) {
            this.doExit();
        } else {
            this.frame.setVisible(true);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

