/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.httppubsub;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.httppubsub.PubSubHelper;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionData;

public class WlsPubSubHelper
implements PubSubHelper {
    public Object getAuthSubject(HttpSession httpSession) {
        SessionData sessionData = (SessionData)httpSession;
        if (sessionData == null) {
            return null;
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)sessionData.getInternalAttribute("weblogic.authuser");
        return authenticatedSubject;
    }

    public Object getWeblogicWebAppBean(ServletContext servletContext) {
        WebAppServletContext webAppServletContext = (WebAppServletContext)servletContext;
        return webAppServletContext.getWebAppModule().getWlWebAppBean();
    }

    public String getApplicationName(ServletContext servletContext) {
        WebAppServletContext webAppServletContext = (WebAppServletContext)servletContext;
        return webAppServletContext.getApplicationId();
    }

    public String getContextPath(ServletContext servletContext) {
        WebAppServletContext webAppServletContext = (WebAppServletContext)servletContext;
        return webAppServletContext.getContextPath();
    }

    public String getSecurityModel(ServletContext servletContext) {
        AppDeploymentMBean appDeploymentMBean;
        WebAppServletContext webAppServletContext = (WebAppServletContext)servletContext;
        if (webAppServletContext.getApplicationContext() != null && (appDeploymentMBean = webAppServletContext.getApplicationContext().getAppDeploymentMBean()) != null) {
            return appDeploymentMBean.getSecurityDDModel();
        }
        return "DDOnly";
    }
}

