/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import weblogic.application.library.CachableLibMetadataEntry;
import weblogic.application.library.CachableLibMetadataType;
import weblogic.application.library.LibraryProcessingException;
import weblogic.servlet.internal.WarLibraryDefinition;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.classloaders.Source;

class AnnotatedClassesCacheEntry
implements CachableLibMetadataEntry {
    protected WarLibraryDefinition library;

    public AnnotatedClassesCacheEntry(WarLibraryDefinition warLibraryDefinition) {
        this.library = warLibraryDefinition;
    }

    public CachableLibMetadataType getType() {
        return CachableLibMetadataType.ANNOTATED_CLASSES;
    }

    public File getLocation() {
        return this.library.getLibTempDir();
    }

    public Object getCachableObject() throws LibraryProcessingException {
        return this.library.getAnnotatedClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStale(long l) {
        boolean bl;
        JarClassFinder jarClassFinder;
        block8: {
            boolean bl2;
            block7: {
                if (this.library.isArchived()) {
                    return false;
                }
                jarClassFinder = null;
                try {
                    try {
                        jarClassFinder = new JarClassFinder(this.library.getLocation());
                        Enumeration enumeration = jarClassFinder.entries();
                        while (enumeration.hasMoreElements()) {
                            Source source = (Source)enumeration.nextElement();
                            if (!source.getURL().getPath().endsWith(".class") || !this.isStale(source, l)) continue;
                            bl2 = true;
                            Object var8_8 = null;
                            if (jarClassFinder == null) return bl2;
                            break block7;
                        }
                        bl = false;
                        break block8;
                    }
                    catch (IOException iOException) {
                        Object var8_10 = null;
                        if (jarClassFinder == null) return true;
                        jarClassFinder.close();
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (jarClassFinder == null) throw throwable;
                    jarClassFinder.close();
                    throw throwable;
                }
            }
            jarClassFinder.close();
            return bl2;
        }
        Object var8_9 = null;
        if (jarClassFinder == null) return bl;
        jarClassFinder.close();
        return bl;
    }

    private boolean isStale(Source source, long l) {
        return source.lastModified() > l;
    }
}

