/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import weblogic.application.io.ClasspathInfo;
import weblogic.application.io.DescriptorFinder;
import weblogic.application.io.ExplodedJar;
import weblogic.application.io.JarCopyFilter;
import weblogic.servlet.internal.CaseAwareClasspathClassFinder;
import weblogic.utils.FileUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.classloaders.ZipClassFinder;
import weblogic.utils.classloaders.ZipSource;
import weblogic.utils.collections.FilteringIterator;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class ArchivedWar
extends ExplodedJar {
    public static final String TMP_CLASSES_JAR = "_wl_cls_gen.jar";
    private static final String WEB_INF_LIB = "WEB-INF" + File.separator + "lib";
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    private final boolean foundClasses;
    private final File classesJar;
    private final FileFilter jarFileFilter;

    public ArchivedWar(String string, File file, File file2, ClasspathInfo classpathInfo) throws IOException {
        super(string, ArchivedWar.extractWarFile(file, file2), new File[0], classpathInfo, JarCopyFilter.NOCOPY_FILTER);
        this.classesJar = new File(file, WEB_INF_LIB + File.separator + TMP_CLASSES_JAR);
        this.foundClasses = this.classesJar.exists();
        this.jarFileFilter = new ExplodedJar.JarFileFilter(this.classesJar);
    }

    public ClassFinder getClassFinder() throws IOException {
        ClassFinder classFinder = super.getClassFinder();
        if (this.foundClasses) {
            MultiClassFinder multiClassFinder = new MultiClassFinder((ClassFinder)new ClasspathClassFinder2(this.classesJar.getAbsolutePath()));
            multiClassFinder.addFinder(classFinder);
            multiClassFinder.addFinder((ClassFinder)new DescriptorFinder(this.getURI(), (ClassFinder)new WebInfClassesFinder(this.classesJar)));
            return multiClassFinder;
        }
        return classFinder;
    }

    protected ClassFinder buildDescriptorFinder() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dirs.length; ++i) {
            this.addClasspath(stringBuffer, this.dirs[i]);
        }
        return new DescriptorFinder(this.uri, (ClassFinder)new CaseAwareClasspathClassFinder(stringBuffer.toString()));
    }

    protected FileFilter getJarFileFilter() {
        return this.jarFileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File extractWarFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block7: {
            if (file.exists()) {
                if (ArchivedWar.extractionUpToDate(file, file2)) {
                    return file;
                }
                FileUtils.remove((File)file);
            }
            file.mkdirs();
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file2);
                ArchivedWar.expandWarFileIntoDirectory(jarFile, file);
                fileOutputStream = null;
                if (jarFile == null) break block7;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (jarFile != null) {
                    jarFile.close();
                }
                throw throwable;
            }
            jarFile.close();
        }
        File file3 = new File(file, ".beamarker.dat");
        fileOutputStream = new FileOutputStream(file3);
        try {
            fileOutputStream.write(0);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        file3.setLastModified(file2.lastModified());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void expandWarFileIntoDirectory(JarFile jarFile, File file) throws IOException {
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
            boolean bl = ArchivedWar.extractClasses(virtualJarFile, file);
            if (bl) {
                virtualJarFile = new NoClassVirtualJarFile(virtualJarFile);
            }
            JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)file);
            Object var5_4 = null;
            if (virtualJarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (virtualJarFile == null) throw throwable;
            try {
                virtualJarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            virtualJarFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean extractClasses(VirtualJarFile virtualJarFile, File file) throws IOException {
        boolean bl = false;
        Iterator iterator = virtualJarFile.getEntries("WEB-INF/classes/");
        int n = "WEB-INF/classes/".length();
        ZipOutputStream zipOutputStream = null;
        HashSet hashSet = new HashSet();
        try {
            while (iterator.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)iterator.next();
                String string = zipEntry.getName();
                String string2 = string.substring(n);
                if (string2 == null || string2.trim().equals("")) continue;
                if (zipOutputStream == null) {
                    zipOutputStream = ArchivedWar.initZipOutputStream(file);
                }
                InputStream inputStream = virtualJarFile.getInputStream(zipEntry);
                bl = true;
                ArchivedWar.writeZipEntry(string2, inputStream, zipOutputStream, hashSet);
            }
            if (zipOutputStream != null && !hashSet.contains(MANIFEST_MF)) {
                ArchivedWar.writeZipEntry(MANIFEST_MF, ArchivedWar.createManifestStream(), zipOutputStream, hashSet);
            }
            Object var12_11 = null;
            if (zipOutputStream == null) return bl;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (zipOutputStream == null) throw throwable;
            try {
                zipOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipOutputStream.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
    }

    private static ZipOutputStream initZipOutputStream(File file) throws IOException {
        File file2 = new File(file, "WEB-INF" + File.separator + "lib");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File file3 = new File(file2, TMP_CLASSES_JAR);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        return new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
    }

    private static void writeZipEntry(String string, InputStream inputStream, ZipOutputStream zipOutputStream, Set set) throws IOException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!(set.contains(string) || string.toLowerCase().endsWith(".jsp") || string.toLowerCase().endsWith(".jspx"))) {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            set.add(string);
            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
        inputStream.close();
        ArchivedWar.createSubEntries(string, zipOutputStream, set);
    }

    private static void createSubEntries(String string, ZipOutputStream zipOutputStream, Set set) throws IOException {
        int n;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 2);
        }
        while ((n = string.lastIndexOf("/")) != -1) {
            if (!set.contains(string = string.substring(0, n + 1))) {
                zipOutputStream.putNextEntry(new ZipEntry(string));
                zipOutputStream.closeEntry();
                set.add(string);
            }
            string = string.substring(0, string.length() - 2);
        }
    }

    private static InputStream createManifestStream() throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        manifest.write(byteArrayOutputStream);
        byteArrayOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static class WebInfClassesFinder
    extends ZipClassFinder {
        private static final String PREFIX = "WEB-INF/classes";

        private WebInfClassesFinder(File file) throws IOException {
            super(file.getName().endsWith(".jar") ? new JarFile(file) : new ZipFile(file));
        }

        public Source getSource(String string) {
            if (string == null) {
                return null;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (!string.startsWith(PREFIX)) {
                return null;
            }
            if ((string = string.substring(PREFIX.length())).startsWith("/")) {
                string = string.substring(1);
            }
            if (string.equals("")) {
                return new ZipSource(this.getZipFile(), new ZipEntry(""));
            }
            return super.getSource(string);
        }

        public Enumeration getSources(String string) {
            if (string == null) {
                return new EmptyEnumerator();
            }
            return super.getSources(string);
        }

        public Source getClassSource(String string) {
            if (string == null) {
                return null;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (!string.startsWith(PREFIX)) {
                return null;
            }
            if ((string = string.substring(PREFIX.length())).startsWith("/")) {
                string = string.substring(1);
            }
            return super.getClassSource(string);
        }
    }

    private static class NoClassVirtualJarFile
    implements VirtualJarFile {
        private static final String PREFIX = "WEB-INF/classes";
        private static final String JSP_SURFIX = ".jsp";
        private static final String JSPX_SURFIX = ".jspx";
        private VirtualJarFile vjf;

        NoClassVirtualJarFile(VirtualJarFile virtualJarFile) {
            this.vjf = virtualJarFile;
        }

        public String getName() {
            return this.vjf.getName();
        }

        public void close() throws IOException {
            this.vjf.close();
        }

        public Iterator entries() {
            return new FilteringIterator(this.vjf.entries()){

                public boolean accept(Object object) {
                    ZipEntry zipEntry = (ZipEntry)object;
                    String string = zipEntry.getName();
                    if (string.endsWith("WEB-INF/classes/") && zipEntry.isDirectory()) {
                        return true;
                    }
                    return !string.startsWith(NoClassVirtualJarFile.PREFIX) || string.toLowerCase().endsWith(NoClassVirtualJarFile.JSP_SURFIX) || string.toLowerCase().endsWith(NoClassVirtualJarFile.JSPX_SURFIX);
                }
            };
        }

        public URL getResource(String string) {
            return this.vjf.getResource(string);
        }

        public ZipEntry getEntry(String string) {
            return this.vjf.getEntry(string);
        }

        public Iterator getEntries(String string) throws IOException {
            return this.vjf.getEntries(string);
        }

        public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
            return this.vjf.getInputStream(zipEntry);
        }

        public Manifest getManifest() throws IOException {
            return this.vjf.getManifest();
        }

        public File[] getRootFiles() {
            return this.vjf.getRootFiles();
        }

        public boolean isDirectory() {
            return this.vjf.isDirectory();
        }

        public JarFile getJarFile() {
            return this.vjf.getJarFile();
        }

        public File getDirectory() {
            return this.vjf.getDirectory();
        }
    }
}

