/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import weblogic.common.internal.PassivationUtils;
import weblogic.servlet.ReferencedAttribute;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.classloaders.ClassLoaderUtils;
import weblogic.utils.classloaders.GenericClassLoader;

public class AttributeWrapper
implements Serializable {
    static final long serialVersionUID = 309266816418685703L;
    protected Object object;
    protected transient byte[] serializedObject;
    private final String intialContextPath;
    private transient int lastClassloaderHash = 0;
    private transient boolean isLoadedByBootStrap = false;
    private transient boolean isWebLogicClassLoader = false;
    private transient int objectClassLoaderHash = 0;
    private transient boolean forceToConvert;
    private transient long currentChecksum = -1L;
    private transient long previousChecksum = -1L;

    public AttributeWrapper(Object object) {
        this(object, null);
    }

    AttributeWrapper(Object object, WebAppServletContext webAppServletContext) {
        this.object = object;
        this.intialContextPath = webAppServletContext == null ? null : webAppServletContext.getContextPath();
        this.saveObjectClassLoaderInfo(object);
    }

    public final Object getObject() throws ClassNotFoundException, IOException {
        return this.getObject(true, null);
    }

    public Object getObject(boolean bl) throws ClassNotFoundException, IOException {
        return this.getObject(bl, null);
    }

    Object getObject(WebAppServletContext webAppServletContext) throws ClassNotFoundException, IOException {
        return this.getObject(true, webAppServletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(boolean bl, WebAppServletContext webAppServletContext) throws ClassNotFoundException, IOException {
        AttributeWrapper attributeWrapper = this;
        synchronized (attributeWrapper) {
            if (!bl) {
                return this.object;
            }
            if (this.serializedObject != null) {
                return this.convertBytesToObject(this.serializedObject);
            }
            if (!AttributeWrapper.needToWrap(this.object) || this.isOptimisticSerialization(webAppServletContext)) {
                return this.object;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (this.needToConvert(classLoader, webAppServletContext)) {
                this.object = PassivationUtils.copy(this.object);
                this.saveObjectClassLoaderInfo(this.object);
                this.forceToConvert = false;
            }
            return this.object;
        }
    }

    protected boolean isOptimisticSerialization(WebAppServletContext webAppServletContext) {
        return this.intialContextPath != null && webAppServletContext != null && webAppServletContext.getConfigManager().isOptimisticSerialization() && !this.intialContextPath.equals(webAppServletContext.getContextPath());
    }

    protected Object convertBytesToObject(byte[] byArray) throws ClassNotFoundException, IOException {
        this.object = PassivationUtils.toObject(byArray);
        this.saveObjectClassLoaderInfo(this.object);
        this.serializedObject = null;
        return this.object;
    }

    static boolean needToWrap(Object object) {
        return !(object instanceof String) && !(object instanceof Number) && !(object instanceof ReferencedAttribute);
    }

    public void setForceToConvert(boolean bl) {
        this.forceToConvert = bl;
    }

    public synchronized void convertToBytes() throws IOException {
        this.serializedObject = PassivationUtils.toByteArray(this.object);
    }

    protected boolean needToConvert(ClassLoader classLoader, WebAppServletContext webAppServletContext) {
        this.reInitClassLoaderInfo();
        if (this.isLoadedByBootStrap && (this.object instanceof Iterable || this.object instanceof Map) && webAppServletContext != null && !this.intialContextPath.equals(webAppServletContext.getContextPath())) {
            return true;
        }
        if (this.isLoadedByBootStrap) {
            return false;
        }
        if (this.forceToConvert) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Attribute value is forced to be converted at lookup time with the appropriate ClassLoader");
            }
            return true;
        }
        int n = classLoader.hashCode();
        if (this.isSameThreadClassLoader(n)) {
            return false;
        }
        if (this.objectClassLoaderHash == n) {
            return false;
        }
        if (!this.isWebLogicClassLoader) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("WLS ignores to convert attribute value.Because, attribute value is impossible to be converted at lookup time with the appropriate ClassLoader because initial ClassLoader isn't Weblogic classloaders. To convert attribute value, initial ClassLoader should be WebLogic ClassLoader. \nCurrent classloader: " + classLoader + "\nInitial context path: " + this.intialContextPath + ", current context path: " + (webAppServletContext == null ? "null" : webAppServletContext.getContextPath()) + "\nObject class: " + this.object.getClass());
            }
            return false;
        }
        if (!ClassLoaderUtils.isChild((int)this.objectClassLoaderHash, (ClassLoader)classLoader)) {
            if (HTTPDebugLogger.isEnabled()) {
                HTTPDebugLogger.debug("Attribute value is needed to be converted at lookup time with the appropriate ClassLoader because current ClassLoader is different with initial ClassLoader and is not child of initial ClassLoader.\nCurrent classloader: " + classLoader + "\nInitial context path: " + this.intialContextPath + ", current context path: " + (webAppServletContext == null ? "null" : webAppServletContext.getContextPath()) + "\nObject class: " + this.object.getClass());
            }
            return true;
        }
        return false;
    }

    protected void reInitClassLoaderInfo() {
        if (this.objectClassLoaderHash == 0) {
            this.saveObjectClassLoaderInfo(this.object);
        }
    }

    protected boolean isSameThreadClassLoader(int n) {
        if (this.lastClassloaderHash == n) {
            return true;
        }
        this.lastClassloaderHash = n;
        return false;
    }

    private void saveObjectClassLoaderInfo(Object object) {
        ClassLoader classLoader = object.getClass().getClassLoader();
        if (classLoader == null) {
            this.isLoadedByBootStrap = true;
            this.isWebLogicClassLoader = false;
            return;
        }
        this.objectClassLoaderHash = classLoader.hashCode();
        this.isWebLogicClassLoader = classLoader instanceof GenericClassLoader;
    }

    public void setCheckSum(long l) {
        this.currentChecksum = l;
    }

    public long getCheckSum() {
        return this.currentChecksum;
    }

    public void setPreviousChecksum(long l) {
        this.previousChecksum = l;
    }

    public long getPreviousChecksum() {
        return this.previousChecksum;
    }
}

