/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.AttributeWrapper;
import weblogic.servlet.internal.ContextAttributeWrapper;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.classloaders.ClassLoaderUtils;

class AttributesMap {
    static final String REQUEST = "request";
    static final String CONTEXT = "servlet-context";
    private final Map attributes;
    private final String scope;
    private final boolean isConcurrent;
    private Object lastAttribute;
    private String lastAttributeKey;

    AttributesMap(String string) {
        this.scope = string;
        if (this.scope == CONTEXT) {
            this.attributes = new ConcurrentHashMap();
            this.isConcurrent = true;
        } else {
            this.attributes = new HashMap();
            this.isConcurrent = false;
        }
    }

    Object put(String string, Object object, WebAppServletContext webAppServletContext) {
        this.checkNullName(string);
        if (object instanceof Serializable && AttributeWrapper.needToWrap(object)) {
            object = this.scope == CONTEXT ? new ContextAttributeWrapper(object, webAppServletContext) : new AttributeWrapper(object, webAppServletContext);
        }
        if (!this.isConcurrent) {
            this.lastAttributeKey = string;
            this.lastAttribute = object;
        }
        return this.attributes.put(string, object);
    }

    public void put(String string, Object object) {
        this.checkNullName(string);
        if (!this.isConcurrent) {
            this.lastAttributeKey = string;
            this.lastAttribute = object;
        }
        this.attributes.put(string, object);
    }

    Object get(String string, WebAppServletContext webAppServletContext) {
        this.checkNullName(string);
        Object object = !this.isConcurrent && this.lastAttributeKey == string ? this.lastAttribute : this.attributes.get(string);
        if (!(object instanceof AttributeWrapper)) {
            return object;
        }
        AttributeWrapper attributeWrapper = (AttributeWrapper)object;
        try {
            return attributeWrapper.getObject(webAppServletContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            HTTPLogger.logFailedToDeserializeAttribute((String)webAppServletContext.getLogContext(), (String)this.scope, (String)string, (Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            HTTPLogger.logFailedToDeserializeAttribute((String)webAppServletContext.getLogContext(), (String)this.scope, (String)string, (Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            HTTPLogger.logFailedToDeserializeAttribute((String)webAppServletContext.getLogContext(), (String)this.scope, (String)string, (Throwable)runtimeException);
        }
        return null;
    }

    Object remove(String string) {
        this.checkNullName(string);
        if (!this.isConcurrent && this.lastAttributeKey == string) {
            this.lastAttributeKey = null;
            this.lastAttribute = null;
        }
        return this.attributes.remove(string);
    }

    Iterator keys() {
        return this.attributes.keySet().iterator();
    }

    void clear() {
        this.lastAttributeKey = null;
        this.lastAttribute = null;
        this.attributes.clear();
    }

    boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    synchronized void removeTransientAttributes(ClassLoader classLoader, WebAppServletContext webAppServletContext) {
        if (this.isEmpty()) {
            return;
        }
        int n = classLoader.hashCode();
        Iterator iterator = this.attributes.keySet().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.attributes.get(string);
            if (!(object instanceof AttributeWrapper)) {
                ClassLoader classLoader2 = object.getClass().getClassLoader();
                if (classLoader2 == null || classLoader2 != classLoader && !ClassLoaderUtils.isChild((int)n, (ClassLoader)classLoader2)) continue;
                arrayList.add(string);
                continue;
            }
            try {
                ((AttributeWrapper)object).convertToBytes();
            }
            catch (IOException iOException) {}
        }
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                webAppServletContext.removeAttribute(string);
            }
        }
    }

    private void checkNullName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name can NOT be null.");
        }
    }
}

