/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.Chunk;

public abstract class ByteRangeHandler {
    protected static final boolean debug = false;
    protected static final String RANGE = "Range";
    protected Source source;
    protected String contentType;

    public ByteRangeHandler(Source source, String string) {
        this.source = source;
        this.contentType = string;
    }

    public abstract void sendRangeData(HttpServletResponse var1) throws IOException;

    public static ByteRangeHandler makeInstance(Source source, HttpServletRequest httpServletRequest, String string) {
        long l = source.length();
        String string2 = string == null ? "text/plain" : string;
        Enumeration enumeration = httpServletRequest.getHeaders(RANGE);
        if (enumeration == null) {
            return null;
        }
        List list = ByteRangeHandler.parseByteRanges(enumeration, l);
        if (list == null || list.size() == 0) {
            return new UnsatisfiableRangeHandler(source, string2);
        }
        if (list.size() == 1) {
            ByteRangeInfo byteRangeInfo = (ByteRangeInfo)list.get(0);
            SingleByteRangeHandler singleByteRangeHandler = new SingleByteRangeHandler(source, string2, byteRangeInfo);
            return singleByteRangeHandler;
        }
        if (list.size() > 1) {
            String string3 = httpServletRequest.getHeader("Request-Range");
            MultipleByteRangeHandler multipleByteRangeHandler = new MultipleByteRangeHandler(source, string2, list);
            if (string3 != null) {
                multipleByteRangeHandler.setRequestRange(true);
            }
            return multipleByteRangeHandler;
        }
        return null;
    }

    public void write(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        try {
            ((ServletOutputStreamImpl)((Object)outputStream)).writeStream(inputStream, (int)l);
        }
        catch (ClassCastException classCastException) {
            this.writeDirectly(inputStream, outputStream, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirectly(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        Chunk chunk = Chunk.getChunk();
        int n = 0;
        try {
            int n2;
            for (n2 = (int)l; n2 > 0; n2 -= n) {
                int n3;
                if (chunk.end == Chunk.CHUNK_SIZE) {
                    outputStream.write(chunk.buf, 0, chunk.end);
                    chunk.end = 0;
                }
                if ((n = inputStream.read(chunk.buf, chunk.end, n3 = Math.min(n2, Chunk.CHUNK_SIZE - chunk.end))) == -1) break;
                chunk.end += n;
            }
            if (chunk.end > 0) {
                outputStream.write(chunk.buf, 0, chunk.end);
                n2 -= chunk.end;
            }
            if (n2 > 0) {
                throw new IOException("Failed to read '" + n2 + "' bytes from InputStream");
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Chunk.releaseChunk((Chunk)chunk);
            throw throwable;
        }
        Chunk.releaseChunk((Chunk)chunk);
    }

    public static List parseByteRanges(Enumeration enumeration, long l) {
        ArrayList<ByteRangeInfo> arrayList = new ArrayList<ByteRangeInfo>();
        block2: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = StringUtils.splitCompletely((String)string, (String)"=,");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    ByteRangeInfo byteRangeInfo;
                    long l2 = -1L;
                    long l3 = -1L;
                    String string2 = stringArray[i].trim();
                    int n = string2.indexOf(45);
                    if (n < 0) {
                        if (!"bytes".equals(string2)) continue block2;
                        continue;
                    }
                    if (n == 0) {
                        if (n + 1 == string2.length() || (byteRangeInfo = ByteRangeHandler.makeRangeInfo(-1L, l2 = Long.parseLong(string2.substring(n + 1)), l)) == null) continue;
                        arrayList.add(byteRangeInfo);
                        continue;
                    }
                    if (n + 1 < string2.length()) {
                        l3 = Long.parseLong(string2.substring(0, n));
                        byteRangeInfo = ByteRangeHandler.makeRangeInfo(l3, l2 = Long.parseLong(string2.substring(n + 1)), l);
                        if (byteRangeInfo == null) continue;
                        arrayList.add(byteRangeInfo);
                        continue;
                    }
                    l3 = Long.parseLong(string2.substring(0, n));
                    byteRangeInfo = ByteRangeHandler.makeRangeInfo(l3, l2 = l - 1L, l);
                    if (byteRangeInfo == null) continue;
                    arrayList.add(byteRangeInfo);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    private static ByteRangeInfo makeRangeInfo(long l, long l2, long l3) {
        if (l == -1L && l2 == -1L) {
            return null;
        }
        if (l >= 0L && l2 >= 0L && l > l2) {
            return null;
        }
        if (l2 > l3) {
            l2 = l3 - 1L;
        }
        if (l < l3) {
            return new ByteRangeInfo(l, l2, l3);
        }
        return null;
    }

    static void p(String string) {
        System.out.println("[ByteRangeHandler]" + string);
    }

    protected void pp(String string) {
        System.out.println("[" + this.getClass().getName() + "]" + string);
    }

    static class ByteRangeInfo {
        long fromIndex;
        long toIndex;
        long total;

        public ByteRangeInfo(long l, long l2, long l3) {
            this.fromIndex = l;
            this.toIndex = l2;
            this.total = l3;
        }

        public String toString() {
            return "[ByteRangeInfo] fromIndex: " + this.fromIndex + " toIndex : " + this.toIndex;
        }

        public long getFromIndex() {
            if (this.fromIndex < 0L) {
                long l = this.total - this.toIndex;
                if (l < 0L) {
                    l = 0L;
                }
                return l;
            }
            return this.fromIndex;
        }

        public long getToIndex() {
            if (this.fromIndex < 0L) {
                return this.total - 1L;
            }
            if (this.toIndex < 0L || this.toIndex >= this.total) {
                return this.total - 1L;
            }
            return this.toIndex;
        }

        public String toHeader() {
            return "bytes " + this.getFromIndex() + '-' + this.getToIndex() + '/' + this.total;
        }
    }

    static class UnsatisfiableRangeHandler
    extends ByteRangeHandler {
        UnsatisfiableRangeHandler(Source source, String string) {
            super(source, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sendRangeData(HttpServletResponse httpServletResponse) throws IOException {
            InputStream inputStream = null;
            try {
                long l = this.source.length();
                httpServletResponse.setStatus(416);
                if (httpServletResponse instanceof ServletResponseImpl) {
                    ((ServletResponseImpl)httpServletResponse).setHeaderInternal("Content-Range", "bytes */" + l);
                } else {
                    httpServletResponse.setHeader("Content-Range", "bytes */" + l);
                }
                if (l != -1L) {
                    httpServletResponse.setContentLength((int)l);
                }
                if (this.contentType != null) {
                    httpServletResponse.setContentType(this.contentType);
                }
                inputStream = this.source.getInputStream();
                this.write(inputStream, (OutputStream)httpServletResponse.getOutputStream(), (int)l);
                Object var6_4 = null;
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
    }

    static class SingleByteRangeHandler
    extends ByteRangeHandler {
        ByteRangeInfo info;

        SingleByteRangeHandler(Source source, String string, ByteRangeInfo byteRangeInfo) {
            super(source, string);
            this.info = byteRangeInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sendRangeData(HttpServletResponse httpServletResponse) throws IOException {
            InputStream inputStream = null;
            try {
                long l = this.info.getToIndex() - this.info.getFromIndex() + 1L;
                httpServletResponse.setStatus(206);
                if (httpServletResponse instanceof ServletResponseImpl) {
                    ((ServletResponseImpl)httpServletResponse).setHeaderInternal("Content-Range", this.info.toHeader());
                } else {
                    httpServletResponse.setHeader("Content-Range", this.info.toHeader());
                }
                httpServletResponse.setContentType(this.contentType);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                inputStream = this.source.getInputStream();
                long l2 = this.info.getFromIndex();
                if (l2 > 0L) {
                    inputStream.skip(l2);
                }
                this.write(inputStream, (OutputStream)servletOutputStream, l);
                Object var9_6 = null;
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
    }

    static class MultipleByteRangeHandler
    extends ByteRangeHandler {
        static final String SEPERATOR = "--";
        static final String CRLF = "\r\n";
        private String boundary;
        List rangeList;
        boolean requestRange;

        MultipleByteRangeHandler(Source source, String string, List list) {
            super(source, string);
            this.rangeList = list;
            this.boundary = System.currentTimeMillis() + "WLS";
        }

        public void setRequestRange(boolean bl) {
            this.requestRange = bl;
        }

        public boolean hasRequestRange() {
            return this.requestRange;
        }

        public void sendRangeData(HttpServletResponse httpServletResponse) throws IOException {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setStatus(206);
            String string = null;
            string = this.hasRequestRange() ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            httpServletResponse.addHeader("Content-Type", string + this.boundary);
            InputStream inputStream = this.source.getInputStream();
            if (inputStream == null) {
                httpServletResponse.sendError(404);
                return;
            }
            Iterator iterator = this.rangeList.iterator();
            long l = 0L;
            while (iterator.hasNext()) {
                ByteRangeInfo byteRangeInfo = (ByteRangeInfo)iterator.next();
                long l2 = byteRangeInfo.getFromIndex();
                long l3 = byteRangeInfo.getToIndex() - byteRangeInfo.getFromIndex() + 1L;
                String string2 = this.getStartRange(byteRangeInfo);
                servletOutputStream.write(string2.getBytes());
                if (l < l2) {
                    inputStream.skip(l2 - l);
                } else if (l > l2) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    inputStream = this.source.getInputStream();
                    inputStream.skip(l2);
                }
                l = l2 + l3;
                this.write(inputStream, (OutputStream)servletOutputStream, l3);
                servletOutputStream.write(this.getEndRangeHeader().getBytes());
            }
            if (inputStream != null) {
                inputStream.close();
            }
            servletOutputStream.write(this.getFinalRangeHeader().getBytes());
        }

        private String getStartRange(ByteRangeInfo byteRangeInfo) {
            return SEPERATOR + this.boundary + CRLF + "Content-Type: " + this.contentType + CRLF + "Content-Range: " + byteRangeInfo.toHeader() + CRLF + CRLF;
        }

        private String getEndRangeHeader() {
            return CRLF;
        }

        private String getFinalRangeHeader() {
            return SEPERATOR + this.boundary + SEPERATOR + CRLF;
        }
    }
}

