/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.JarClassFinder;

public class CaseAwareClasspathClassFinder
extends ClasspathClassFinder2 {
    private static final boolean WIN_32 = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    private static final boolean ENFORCE_CASE = !SecurityServiceManager.areWebAppFilesCaseInsensitive() && WIN_32;

    public CaseAwareClasspathClassFinder(String string) {
        super(string, new HashSet());
    }

    protected ClassFinder getClassFinder(File file, Set set) throws IOException {
        return new JarClassFinder(file, set, ENFORCE_CASE);
    }
}

