/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import weblogic.utils.collections.PartitionedStackPool;
import weblogic.utils.collections.Pool;

public class CharChunk {
    private static final int CHUNK_SIZE = CharChunk.getIntegerProperty("weblogic.servlet.internal.CharChunk.ChunkSize", 8192);
    private static final int TOTAL_CHUNKS = CharChunk.getIntegerProperty("weblogic.servlet.internal.CharChunk.TotalChunks", 256);
    private static final int CHUNK_PARTITIONS = CharChunk.getIntegerProperty("weblogic.servlet.internal.CharChunk.ChunkPartitions", 4);
    private static final Pool chunkPool = new PartitionedStackPool(TOTAL_CHUNKS, CHUNK_PARTITIONS);
    public final char[] buf = new char[CHUNK_SIZE];
    public int end = 0;
    public CharChunk next = null;

    public static CharChunk getChunk() {
        CharChunk charChunk = null;
        charChunk = (CharChunk)chunkPool.remove();
        if (charChunk == null) {
            return new CharChunk();
        }
        return charChunk;
    }

    public static void releaseChunk(CharChunk charChunk) {
        charChunk.end = 0;
        charChunk.next = null;
        chunkPool.add((Object)charChunk);
    }

    public static void releaseChunks(CharChunk charChunk) {
        while (charChunk != null) {
            CharChunk charChunk2 = charChunk.next;
            CharChunk.releaseChunk(charChunk);
            charChunk = charChunk2;
        }
    }

    public static CharChunk tail(CharChunk charChunk) {
        CharChunk charChunk2 = charChunk;
        while (charChunk2.next != null) {
            charChunk2 = charChunk2.next;
        }
        return charChunk2;
    }

    public static CharChunk ensureCapacity(CharChunk charChunk) {
        if (CHUNK_SIZE == charChunk.end) {
            charChunk.next = CharChunk.getChunk();
            return charChunk.next;
        }
        return charChunk;
    }

    public static int chunkFully(CharChunk charChunk, Reader reader) throws IOException {
        CharChunk charChunk2 = CharChunk.tail(charChunk);
        int n = 0;
        while (true) {
            charChunk2 = CharChunk.ensureCapacity(charChunk2);
            int n2 = reader.read(charChunk2.buf, charChunk2.end, CHUNK_SIZE - charChunk2.end);
            if (n2 == -1) break;
            charChunk2.end += n2;
            n += n2;
        }
        return n;
    }

    public static int chunk(CharChunk charChunk, Reader reader, int n) throws IOException {
        CharChunk charChunk2 = CharChunk.tail(charChunk);
        int n2 = n;
        while (n > 0) {
            charChunk2 = CharChunk.ensureCapacity(charChunk2);
            int n3 = Math.min(n, CHUNK_SIZE - charChunk2.end);
            int n4 = reader.read(charChunk2.buf, charChunk2.end, n3);
            if (n4 == -1) {
                return n2 - n;
            }
            charChunk2.end += n4;
            n -= n4;
        }
        return n2;
    }

    private static int getIntegerProperty(final String string, int n) {
        Integer n2 = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(string);
            }
        });
        return n2 == null ? n : n2;
    }

    private CharChunk() {
    }
}

