/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import javax.servlet.ServletResponse;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.utils.io.Chunk;

public class CharChunkOutput
extends ChunkOutput {
    private int count;
    private char[] buf;
    private CharsetDecoder decoder;
    private static final int BUF_SIZE = 64;
    private String encoding;

    public CharChunkOutput(ServletResponse servletResponse) {
        this.autoflush = false;
        this.buflimit = -1;
        this.encoding = servletResponse.getCharacterEncoding();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void reset() {
        this.count = 0;
    }

    public void release() {
        this.count = 0;
        this.buf = null;
        this.decoder = null;
    }

    public Chunk getHead() {
        return null;
    }

    public int getTotal() {
        return 0;
    }

    public int getCount() {
        return this.count;
    }

    public int getBufferSize() {
        return -1;
    }

    public void setBufferSize(int n) {
    }

    public boolean isAutoFlush() {
        return this.autoflush;
    }

    public void setAutoFlush(boolean bl) {
    }

    public boolean isChunking() {
        return false;
    }

    public void setChunking(boolean bl) {
    }

    public void write(int n) throws IOException {
        this.initBuf();
        int n2 = this.adjustBuf(1);
        this.buf[this.count] = (char)n;
        this.count = n2;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Comparable<Charset> comparable;
        this.initBuf();
        if (this.decoder == null) {
            comparable = Charset.forName(this.getEncoding());
            this.decoder = ((Charset)comparable).newDecoder();
        }
        comparable = ByteBuffer.wrap(byArray, n, n2);
        int n3 = (int)(this.decoder.averageCharsPerByte() * (float)n2);
        this.adjustBuf(n3);
        int n4 = 0;
        while (((Buffer)((Object)comparable)).hasRemaining()) {
            CharBuffer charBuffer = CharBuffer.wrap(this.buf, this.count, this.buf.length - this.count);
            n4 = charBuffer.position();
            CoderResult coderResult = this.decoder.decode((ByteBuffer)comparable, charBuffer, true);
            this.count += charBuffer.position() - n4;
            if (coderResult == CoderResult.UNDERFLOW) break;
            if (coderResult == CoderResult.OVERFLOW) {
                n3 = (int)((float)((Buffer)((Object)comparable)).remaining() * this.decoder.averageCharsPerByte());
                this.adjustBuf(n3 == 0 ? 1 : n3);
                continue;
            }
            coderResult.throwException();
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.initBuf();
        int n3 = this.adjustBuf(n2);
        System.arraycopy(cArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public void print(String string) throws IOException {
        this.initBuf();
        int n = this.adjustBuf(string.length());
        string.getChars(0, string.length(), this.buf, this.count);
        this.count = n;
    }

    public void commit() throws IOException {
    }

    public void clearBuffer() {
        this.count = 0;
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStream(InputStream inputStream, int n, int n2) throws IOException {
        Chunk chunk = Chunk.getChunk();
        byte[] byArray = chunk.buf;
        try {
            int n3;
            boolean bl = n == -1;
            int n4 = 0;
            while ((n3 = inputStream.read()) != -1) {
                if (n4 == Chunk.CHUNK_SIZE) {
                    this.write(byArray, 0, n4);
                    n4 = 0;
                }
                byArray[n4] = (byte)n3;
                ++n4;
                if (bl || --n != 0) continue;
            }
            if (n4 > 0) {
                this.write(byArray, 0, n4);
                n4 = 0;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Chunk.releaseChunk((Chunk)chunk);
            throw throwable;
        }
        Chunk.releaseChunk((Chunk)chunk);
    }

    private int adjustBuf(int n) {
        int n2 = this.count + n;
        if (n2 > this.buf.length) {
            char[] cArray = new char[Math.max(this.buf.length << 1, n2)];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            this.buf = cArray;
        }
        return n2;
    }

    private void initBuf() {
        if (this.buf == null) {
            this.buf = new char[64];
        }
    }

    public char[] getCharBuffer() {
        return this.buf;
    }

    private void p(String string) {
        System.err.println("[CharChunkOutput]" + string);
    }
}

