/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import weblogic.servlet.internal.CharChunk;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.utils.io.Chunk;

class CharsetChunkOutput
extends ChunkOutput {
    private static final boolean debug = false;
    private CharsetEncoder encoder;
    private String encoding;
    private ByteBuffer headBuf;
    private ByteBuffer buf;
    private int charcount;
    private CharChunk charChunk;
    private CharBuffer charBuffer;

    protected CharsetChunkOutput(int n, boolean bl, OutputStream outputStream, ServletOutputStreamImpl servletOutputStreamImpl, Charset charset) {
        super(n, bl, outputStream, servletOutputStreamImpl);
        this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.encoding = charset.name();
        this.buf = this.headBuf = CharsetChunkOutput.makeByteBuffer(this.head);
        this.charChunk = CharChunk.getChunk();
        this.charBuffer = CharBuffer.wrap(this.charChunk.buf);
    }

    CharsetChunkOutput(ChunkOutput chunkOutput, Charset charset) {
        this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        if (chunkOutput instanceof CharsetChunkOutput) {
            CharsetChunkOutput charsetChunkOutput = (CharsetChunkOutput)chunkOutput;
            this.charChunk = charsetChunkOutput.charChunk;
            this.charBuffer = charsetChunkOutput.charBuffer;
        } else {
            this.charChunk = CharChunk.getChunk();
            this.charBuffer = CharBuffer.wrap(this.charChunk.buf);
        }
        this.encoding = charset.name();
        this.head = chunkOutput.head;
        this.tail = chunkOutput.tail;
        this.total = chunkOutput.total;
        this.count = chunkOutput.count;
        this.buflimit = chunkOutput.buflimit;
        this.os = chunkOutput.os;
        this.sos = chunkOutput.sos;
        this.autoflush = chunkOutput.autoflush;
        this.stickyBufferSize = chunkOutput.stickyBufferSize;
        this.chunking = chunkOutput.chunking;
        this.alwaysFlush = chunkOutput.alwaysFlush;
        this.setBufferFlushStrategy();
        this.headBuf = CharsetChunkOutput.makeByteBuffer(this.head);
        this.buf = this.head == this.tail ? this.headBuf : CharsetChunkOutput.makeByteBuffer(this.tail);
        this.encoder.reset();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void reset() {
        if (this.encoder != null) {
            this.encoder.reset();
        }
        super.reset();
        this.headBuf = null;
        this.buf = null;
        this.charBuffer.clear();
    }

    public void release() {
        this.buf = null;
        this.headBuf = null;
        this.encoder = null;
        super.release();
        this.charBuffer = null;
        CharChunk.releaseChunks(this.charChunk);
    }

    public void write(int n) throws IOException {
        if (this.released) {
            return;
        }
        this.flushStrategy.checkOverflow(1);
        ++this.charcount;
        this.ensureCharBufferNotFull();
        this.charBuffer.put((char)n);
        this.flushStrategy.checkForFlush();
    }

    void writeByte(int n) throws IOException {
        if (this.released) {
            return;
        }
        this.ensureCharBufferEmpty();
        this.flushStrategy.checkOverflow(1);
        ++this.charcount;
        this.tail = Chunk.tail((Chunk)this.tail);
        int n2 = this.buf.remaining();
        if (n2 == 0) {
            this.tail = CharsetChunkOutput.ensureCapacity(this.tail);
            this.buf = CharsetChunkOutput.makeByteBuffer(this.tail);
            n2 = this.buf.remaining();
        }
        this.buf.put((byte)n);
        ++this.tail.end;
        ++this.count;
        this.flushStrategy.checkForFlush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.released) {
            return;
        }
        this.ensureCharBufferEmpty();
        this.flushStrategy.checkOverflow(n2);
        this.charcount += n2;
        this.tail = Chunk.tail((Chunk)this.tail);
        this.implWrite(byArray, n, n2);
        this.flushStrategy.checkForFlush();
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        if (this.released) {
            return;
        }
        this.ensureCharBufferEmpty();
        super.write(byteBuffer);
    }

    public void writeStream(InputStream inputStream, int n, int n2) throws IOException {
        if (this.released) {
            return;
        }
        this.ensureCharBufferEmpty();
        if (n > 0) {
            this.flushStrategy.checkOverflow(n);
            this.charcount += n;
        }
        this.tail = Chunk.tail((Chunk)this.tail);
        super.writeStream(inputStream, n, n2);
        this.tail = Chunk.tail((Chunk)this.tail);
        this.buf = CharsetChunkOutput.makeByteBuffer(this.tail);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.released) {
            return;
        }
        this.flushStrategy.checkOverflow(n2);
        this.charcount += n2;
        if (this.charBuffer.position() + n2 < this.charBuffer.limit()) {
            this.charBuffer.put(cArray, n, n2);
        } else if (n2 > this.charBuffer.limit()) {
            this.flushCharBuffer();
            this.write(CharBuffer.wrap(cArray, n, n2));
        } else {
            while (n2 > 0) {
                this.ensureCharBufferNotFull();
                int n3 = this.charBuffer.remaining();
                int n4 = Math.min(n3, n2);
                this.charBuffer.put(cArray, n, n4);
                n += n4;
                n2 -= n4;
            }
        }
        this.flushStrategy.checkForFlush();
    }

    public void print(String string) throws IOException {
        int n;
        if (this.released) {
            return;
        }
        if (string == null) {
            string = "null";
        }
        this.flushStrategy.checkOverflow(n);
        this.charcount += n;
        if (this.charBuffer.position() + n < this.charBuffer.limit()) {
            this.charBuffer.put(string);
        } else if (n > this.charBuffer.limit()) {
            this.flushCharBuffer();
            this.write(CharBuffer.wrap(string));
        } else {
            int n2;
            int n3 = 0;
            for (n = string.length(); n > 0; n -= n2) {
                this.ensureCharBufferNotFull();
                int n4 = this.charBuffer.remaining();
                n2 = Math.min(n4, n);
                this.charBuffer.put(string, n3, n3 + n2);
                n3 += n2;
            }
        }
        this.flushStrategy.checkForFlush();
    }

    public void clearBuffer() {
        if (this.released) {
            return;
        }
        super.clearBuffer();
        this.charcount = 0;
        this.buf = this.headBuf;
        this.buf.position(this.head.end).limit(END_OFFSET - this.head.end);
        this.charBuffer.clear();
    }

    public void flush() throws IOException {
        if (this.released) {
            return;
        }
        this.ensureCharBufferEmpty();
        super.flush();
        this.postFlush();
    }

    void postFlush() {
        this.tail = CharsetChunkOutput.ensureCapacity(this.tail);
        this.buf = CharsetChunkOutput.makeByteBuffer(this.tail);
    }

    public int getCount() {
        try {
            this.ensureCharBufferEmpty();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.count;
    }

    protected int getCountForCheckOverflow() {
        return this.charcount;
    }

    protected void flushBufferedDataToChunk() {
        if (this.charBuffer == null) {
            return;
        }
        try {
            this.ensureCharBufferEmpty();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureCharBufferNotFull() throws IOException {
        if (!this.charBuffer.hasRemaining()) {
            this.flushCharBuffer();
        }
    }

    private void ensureCharBufferEmpty() throws IOException {
        if (this.charBuffer.position() > 0) {
            this.flushCharBuffer();
        }
    }

    private void flushCharBuffer() throws IOException {
        this.charBuffer.flip();
        this.write(this.charBuffer);
        this.charBuffer.clear();
    }

    private void write(CharBuffer charBuffer) throws IOException {
        Object object;
        if (!charBuffer.hasRemaining()) {
            return;
        }
        this.tail = Chunk.tail((Chunk)this.tail);
        while (charBuffer.hasRemaining()) {
            int n;
            int n2 = this.buf.position();
            CoderResult coderResult = this.encoder.encode(charBuffer, this.buf, true);
            this.tail.end = n = this.buf.position();
            this.count += n - n2;
            if (coderResult == CoderResult.UNDERFLOW) break;
            if (coderResult == CoderResult.OVERFLOW) {
                if (this.buf.hasRemaining()) {
                    object = new byte[(int)this.encoder.maxBytesPerChar()];
                    ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
                    this.encoder.encode(charBuffer, byteBuffer, true);
                    byteBuffer.flip();
                    this.implWrite((byte[])object, 0, byteBuffer.remaining());
                    continue;
                }
                this.tail = CharsetChunkOutput.ensureCapacity(this.tail);
                this.buf = CharsetChunkOutput.makeByteBuffer(this.tail);
                continue;
            }
            coderResult.throwException();
        }
        int n = this.buf.position();
        CoderResult coderResult = this.encoder.flush(this.buf);
        if (coderResult.isUnderflow()) {
            int n3;
            this.tail.end = n3 = this.buf.position();
            this.count += n3 - n;
        } else if (coderResult.isOverflow()) {
            object = ByteBuffer.allocate((int)this.encoder.maxBytesPerChar());
            this.encoder.flush((ByteBuffer)object);
            ((ByteBuffer)object).flip();
            this.implWrite(((ByteBuffer)object).array(), 0, ((Buffer)object).remaining());
        }
        this.encoder.reset();
    }

    private void implWrite(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.buf.remaining();
            if (n3 == 0) {
                this.tail = CharsetChunkOutput.ensureCapacity(this.tail);
                this.buf = CharsetChunkOutput.makeByteBuffer(this.tail);
                n3 = this.buf.remaining();
            }
            int n4 = Math.min(n3, n2);
            this.buf.put(byArray, n, n4);
            n += n4;
            n2 -= n4;
            this.tail.end += n4;
            this.count += n4;
        }
    }

    private static ByteBuffer makeByteBuffer(Chunk chunk) {
        return ByteBuffer.wrap(chunk.buf, chunk.end, END_OFFSET - chunk.end);
    }

    private static void showProps(Buffer buffer) {
        CharsetChunkOutput.p(" capacity : " + buffer.capacity() + " limit : " + buffer.limit() + " position: " + buffer.position());
    }

    private static void p(String string) {
        System.out.println("[CharsetChunkOutput]" + string);
    }
}

