/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import weblogic.j2ee.descriptor.wl.CharsetMappingBean;
import weblogic.utils.StringUtils;

public final class CharsetMap {
    private Map userMap = null;

    public CharsetMap(Map map) {
        this.userMap = map;
    }

    public String getJavaCharset(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (this.userMap != null) {
            string2 = (String)this.userMap.get(string);
        }
        if (string2 == null) {
            string2 = weblogic.utils.CharsetMap.getJavaFromIANA((String)string);
        }
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public void addMapping(CharsetMappingBean charsetMappingBean) {
        String string = charsetMappingBean.getIanaCharsetName();
        String string2 = charsetMappingBean.getJavaCharsetName();
        if (this.userMap == null) {
            this.userMap = new Hashtable();
        }
        this.userMap.put(string, string2);
    }

    public InputStreamReader makeI18NReader(String string, InputStream inputStream) throws UnsupportedEncodingException {
        if (string == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(inputStream, this.getJavaCharset(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(this.getEncodingErr(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedEncodingException(this.getEncodingErr(string));
        }
    }

    private String getEncodingErr(String string) {
        String string2 = string.equals(this.getJavaCharset(string)) ? "Charset: '" + string + "' not recognized, and there is no alias for it in the " + "WebServerMBean" : "Neither charset: '" + string + "' nor the WebServerMBean alias for it: '" + this.getJavaCharset(string) + "' identifies a supported Java charset.";
        return string2;
    }

    static boolean isCharsetAllowedForType(String string) {
        if (string == null) {
            return false;
        }
        return StringUtils.indexOfIgnoreCase((String)"application/octet-stream", (String)string) <= -1;
    }
}

