/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import weblogic.servlet.proxy.WriteClientIOException;
import weblogic.utils.Hex;

public final class ChunkInput {
    private static void enforceEOL(InputStream inputStream) throws IOException {
        if (inputStream.read() != 13) {
            throw new IOException("chunk data not ended with CR");
        }
        if (inputStream.read() != 10) {
            throw new IOException("chunk data not ended with LF");
        }
    }

    public static int readCTE(byte[] byArray, InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n = ChunkInput.readChunkSize(inputStream)) > 0) {
            int n4;
            do {
                if ((n2 += (n4 = inputStream.read(byArray, n2, n))) <= byArray.length) continue;
                throw new IOException("Max buffer exceeded");
            } while ((n -= n4) > 0);
            n3 += n4;
            ChunkInput.enforceEOL(inputStream);
        }
        return n3;
    }

    public static int readCTE(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        boolean bl = true;
        while ((n = ChunkInput.readChunkSize(inputStream)) > 0) {
            if (ChunkInput.readAndWriteChunk(n, outputStream, inputStream, bl) == -1) {
                bl = false;
            }
            n2 += n + 2;
        }
        return n2;
    }

    public static int readChunkSize(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = inputStream.read()) != -1 && (n != 13 || (n = inputStream.read()) != 10)) {
            char c = (char)n;
            if (!Hex.isHexChar((int)c)) continue;
            stringBuilder.append(c);
        }
        n2 = Integer.parseInt(stringBuilder.toString(), 16);
        if (n2 == 0) {
            ChunkInput.enforceEOL(inputStream);
        }
        return n2;
    }

    public static int readAndWriteChunk(int n, OutputStream outputStream, InputStream inputStream) throws IOException {
        return ChunkInput.readAndWriteChunk(n, outputStream, inputStream, true);
    }

    public static int readAndWriteChunk(int n, OutputStream outputStream, InputStream inputStream, boolean bl) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[Math.min(n, 8192)];
        for (int i = n; i > 0; i -= n2) {
            n2 = inputStream.read(byArray, 0, Math.min(byArray.length, i));
            if (n2 == -1) {
                throw new IOException("unexpected EOF, expected to read: " + n + " actually read: " + n2);
            }
            if (!bl) continue;
            try {
                outputStream.write(byArray, 0, n2);
                continue;
            }
            catch (IOException iOException) {
                bl = false;
                throw new WriteClientIOException("Error in writing to client");
            }
        }
        ChunkInput.enforceEOL(inputStream);
        if (!bl) {
            return -1;
        }
        return n;
    }
}

