/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import weblogic.servlet.internal.CharsetChunkOutput;
import weblogic.servlet.internal.CharsetMap;
import weblogic.servlet.internal.CompleteMessageTimeoutTrigger;
import weblogic.servlet.internal.GatheringChunkOutput;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;
import weblogic.utils.http.BytesToString;
import weblogic.utils.io.Chunk;

public class ChunkOutput {
    private static final boolean ASSERT = true;
    protected static final int CHUNK_HEADER_SIZE = 6;
    protected static final int CHUNK_TRAILER_SIZE = 2;
    protected static final int CHUNK_SIZE = Chunk.CHUNK_SIZE - 6 - 2;
    protected static final int END_OFFSET = Chunk.CHUNK_SIZE - 2;
    protected static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected static final int UNLIMITED_BUFFER = -1;
    protected Chunk head;
    protected Chunk tail;
    protected int total;
    protected int count;
    protected int buflimit;
    protected OutputStream os;
    protected ServletOutputStreamImpl sos;
    protected boolean autoflush;
    protected boolean stickyBufferSize = false;
    protected boolean chunking;
    protected boolean alwaysFlush;
    protected boolean released;
    protected BufferFlushStrategy flushStrategy;
    private static CompleteMessageTimeoutTrigger trigger = null;

    private void p(String string) {
        System.err.println("[" + super.toString() + "]: " + string);
    }

    protected ChunkOutput(int n, boolean bl, OutputStream outputStream, ServletOutputStreamImpl servletOutputStreamImpl) {
        this.setBufferSize(n);
        this.autoflush = bl;
        this.os = outputStream;
        this.total = 0;
        this.count = 0;
        this.head = this.tail = Chunk.getChunk();
        this.head.end = 6;
        this.sos = servletOutputStreamImpl;
        if (outputStream != null && servletOutputStreamImpl == null) {
            this.alwaysFlush = true;
        }
        this.setBufferFlushStrategy();
    }

    protected ChunkOutput() {
    }

    protected ChunkOutput(ChunkOutput chunkOutput) {
        this.head = chunkOutput.head;
        this.tail = chunkOutput.tail;
        this.total = chunkOutput.total;
        this.count = chunkOutput.count;
        this.buflimit = chunkOutput.buflimit;
        this.os = chunkOutput.os;
        this.sos = chunkOutput.sos;
        this.autoflush = chunkOutput.autoflush;
        this.stickyBufferSize = chunkOutput.stickyBufferSize;
        this.chunking = chunkOutput.chunking;
        this.alwaysFlush = chunkOutput.alwaysFlush;
        chunkOutput.tail = null;
        chunkOutput.head = null;
        this.setBufferFlushStrategy();
    }

    public static ChunkOutput create(int n, boolean bl, OutputStream outputStream, ServletOutputStreamImpl servletOutputStreamImpl) {
        if (outputStream == null && n != -1) {
            throw new IllegalArgumentException("cannot have no outputstream and a limited buffer size");
        }
        return ServletOutputStreamImpl.supportsGatheredWrites(outputStream) ? new GatheringChunkOutput(new ChunkOutput(n, bl, outputStream, servletOutputStreamImpl)) : new ChunkOutput(n, bl, outputStream, servletOutputStreamImpl);
    }

    public static ChunkOutput create(ChunkOutput chunkOutput, String string, CharsetMap charsetMap) throws UnsupportedEncodingException {
        String string2;
        chunkOutput.flushBufferedDataToChunk();
        if (BytesToString.is8BitUnicodeSubset((String)string)) {
            if (chunkOutput instanceof GatheringChunkOutput) {
                GatheringChunkOutput gatheringChunkOutput = (GatheringChunkOutput)chunkOutput;
                return new GatheringChunkOutput(gatheringChunkOutput, new ChunkOutput(gatheringChunkOutput.getDelegate()));
            }
            return new ChunkOutput(chunkOutput);
        }
        String string3 = string2 = charsetMap != null ? charsetMap.getJavaCharset(string) : string;
        if (!Charset.isSupported(string2)) {
            throw new UnsupportedEncodingException(string2);
        }
        Charset charset = Charset.forName(string2);
        ChunkOutput chunkOutput2 = null;
        if (chunkOutput instanceof GatheringChunkOutput) {
            GatheringChunkOutput gatheringChunkOutput = (GatheringChunkOutput)chunkOutput;
            chunkOutput2 = new GatheringChunkOutput(gatheringChunkOutput, new CharsetChunkOutput(gatheringChunkOutput.getDelegate(), charset));
            gatheringChunkOutput.getDelegate().tail = null;
            gatheringChunkOutput.getDelegate().head = null;
        } else {
            chunkOutput2 = new CharsetChunkOutput(chunkOutput, charset);
            chunkOutput.tail = null;
            chunkOutput.head = null;
        }
        return chunkOutput2;
    }

    public static ChunkOutput create(int n, boolean bl, OutputStream outputStream, ServletOutputStreamImpl servletOutputStreamImpl, String string, CharsetMap charsetMap) throws UnsupportedEncodingException {
        String string2;
        if (BytesToString.is8BitUnicodeSubset((String)string)) {
            return ChunkOutput.create(n, bl, outputStream, servletOutputStreamImpl);
        }
        String string3 = string2 = charsetMap != null ? charsetMap.getJavaCharset(string) : string;
        if (!Charset.isSupported(string2)) {
            throw new UnsupportedEncodingException(string2);
        }
        Charset charset = Charset.forName(string2);
        return ServletOutputStreamImpl.supportsGatheredWrites(outputStream) ? new GatheringChunkOutput(new CharsetChunkOutput(n, bl, outputStream, servletOutputStreamImpl, charset)) : new CharsetChunkOutput(n, bl, outputStream, servletOutputStreamImpl, charset);
    }

    public String getEncoding() {
        return null;
    }

    public void reset() {
        this.clearBuffer();
        this.total = 0;
        this.count = 0;
    }

    public void release() {
        Chunk.releaseChunks((Chunk)this.head);
        this.tail = null;
        this.head = null;
        this.released = true;
    }

    public Chunk getHead() {
        return this.head;
    }

    public int getTotal() {
        return this.total;
    }

    public int getCount() {
        return this.count;
    }

    public int getBufferSize() {
        return this.buflimit;
    }

    public void setBufferSize(int n) {
        if (this.stickyBufferSize) {
            return;
        }
        if (n == -1) {
            this.buflimit = -1;
            this.setBufferFlushStrategy();
            return;
        }
        int n2 = n / CHUNK_SIZE;
        if (n % CHUNK_SIZE != 0) {
            ++n2;
        }
        this.buflimit = n2 * CHUNK_SIZE;
        this.setBufferFlushStrategy();
    }

    public void setStickyBufferSize(boolean bl) {
        this.stickyBufferSize = bl;
    }

    public boolean isAutoFlush() {
        return this.autoflush;
    }

    public void setAutoFlush(boolean bl) {
        this.autoflush = this.os != null ? bl : false;
        this.setBufferFlushStrategy();
    }

    public boolean isChunking() {
        return this.chunking;
    }

    public void setChunking(boolean bl) {
        this.chunking = bl;
    }

    void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void write(int n) throws IOException {
        if (this.released) {
            return;
        }
        this.flushStrategy.checkOverflow(1);
        ++this.count;
        this.tail = ChunkOutput.ensureCapacity(this.tail);
        this.tail.buf[this.tail.end++] = (byte)n;
        this.flushStrategy.checkForFlush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.released) {
            return;
        }
        while (n2 > 0) {
            this.tail = ChunkOutput.ensureCapacity(this.tail);
            int n3 = Math.min(END_OFFSET - this.tail.end, n2);
            this.flushStrategy.checkOverflow(n3);
            System.arraycopy(byArray, n, this.tail.buf, this.tail.end, n3);
            this.count += n3;
            this.tail.end += n3;
            n += n3;
            n2 -= n3;
            this.flushStrategy.checkForFlush();
        }
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasArray()) {
            this.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        } else {
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(byArray, 0, byArray.length);
            this.write(byArray, 0, byArray.length);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.released) {
            return;
        }
        while (n2 > 0) {
            this.tail = ChunkOutput.ensureCapacity(this.tail);
            int n3 = Math.min(END_OFFSET - this.tail.end, n2);
            this.flushStrategy.checkOverflow(n3);
            for (int i = 0; i < n3; ++i) {
                this.tail.buf[this.tail.end++] = (byte)cArray[n++];
            }
            this.count += n3;
            n2 -= n3;
            this.flushStrategy.checkForFlush();
        }
    }

    public void print(String string) throws IOException {
        int n;
        int n2;
        if (this.released) {
            return;
        }
        if (string == null) {
            return;
        }
        int n3 = 0;
        this.flushStrategy.checkOverflow(n2);
        for (n2 = string.length(); n2 > 0; n2 -= n) {
            this.tail = ChunkOutput.ensureCapacity(this.tail);
            n = Math.min(n2, END_OFFSET - this.tail.end);
            StringUtils.getBytes((String)string, (int)n3, (int)(n3 + n), (byte[])this.tail.buf, (int)this.tail.end);
            n3 += n;
            this.tail.end += n;
            this.count += n;
            this.flushStrategy.checkForFlush();
        }
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void commit() throws IOException {
        if (this.sos != null) {
            this.sos.commit();
        }
    }

    public void clearBuffer() {
        if (this.head == null) {
            return;
        }
        Chunk.releaseChunks((Chunk)this.head.next);
        this.tail = this.head;
        this.head.next = null;
        this.head.end = 6;
        this.count = 0;
    }

    public void flush() throws IOException {
        if (this.released) {
            return;
        }
        if (this.sos != null && !this.sos.headersSent()) {
            this.sos.sendHeaders();
        }
        if (this.os != null) {
            int n = ChunkOutput.writeChunks(this.head, this.os, this.chunking);
            this.total += this.count;
            if (this.chunking) {
                this.total += 8 * n;
            }
            this.clearBuffer();
        }
    }

    void postFlush() {
    }

    public void writeStream(InputStream inputStream, int n, int n2) throws IOException {
        if (this.released) {
            return;
        }
        if (n2 == -1 && n == -1) {
            this.writeStream(inputStream);
            return;
        }
        if (n == -1) {
            n = n2;
        }
        while (n > 0) {
            this.tail = ChunkOutput.ensureCapacity(this.tail);
            int n3 = Math.min(n, END_OFFSET - this.tail.end);
            if (n2 != -1 && this.total + this.count + n3 > n2) {
                throw new ProtocolException("Exceeded stated content length of " + n2);
            }
            this.flushStrategy.checkOverflow(n3);
            int n4 = inputStream.read(this.tail.buf, this.tail.end, n3);
            if (n4 == -1) {
                throw new IOException("failed to read '" + n3 + "' bytes from InputStream; clen: " + n2 + " remaining: " + n + " count: " + this.count);
            }
            this.count += n4;
            this.tail.end += n4;
            this.flushStrategy.checkForFlush();
            n -= n4;
        }
    }

    protected void flushBufferedDataToChunk() {
    }

    protected void setHttpHeaders(Chunk chunk) {
    }

    private void writeStream(InputStream inputStream) throws IOException {
        while (true) {
            this.tail = ChunkOutput.ensureCapacity(this.tail);
            int n = END_OFFSET - this.tail.end;
            this.flushStrategy.checkOverflow(n);
            int n2 = inputStream.read(this.tail.buf, this.tail.end, n);
            if (n2 == -1) break;
            this.tail.end += n2;
            this.count += n2;
            this.flushStrategy.checkForFlush();
        }
    }

    private static void writeChunkHeader(byte[] byArray, int n) {
        Debug.assertion((n <= CHUNK_SIZE ? 1 : 0) != 0);
        int n2 = 4;
        do {
            byArray[--n2] = DIGITS[n & 0xF];
        } while ((n >>>= 4) != 0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = 48;
        }
        byArray[4] = 13;
        byArray[5] = 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int writeChunks(Chunk chunk, OutputStream outputStream, boolean bl) throws IOException {
        block3: {
            int n;
            try {
                ChunkOutput.registerToTrigger(outputStream);
                if (!bl) break block3;
                n = ChunkOutput.writeChunkTransfer(chunk, outputStream);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ChunkOutput.unregisterFromTrigger(outputStream);
                throw throwable;
            }
            ChunkOutput.unregisterFromTrigger(outputStream);
            return n;
        }
        int n = ChunkOutput.writeChunkNoTransfer(chunk, outputStream);
        Object var5_6 = null;
        ChunkOutput.unregisterFromTrigger(outputStream);
        return n;
    }

    protected static void registerToTrigger(OutputStream outputStream) {
        trigger.register(outputStream);
    }

    protected static void unregisterFromTrigger(OutputStream outputStream) {
        trigger.unregister(outputStream);
    }

    private static int writeChunkTransfer(Chunk chunk, OutputStream outputStream) throws IOException {
        int n = 0;
        while (chunk != null) {
            int n2 = chunk.end - 6;
            if (n2 <= 0) {
                chunk = chunk.next;
                continue;
            }
            ChunkOutput.writeChunkHeader(chunk.buf, n2);
            chunk.buf[chunk.end] = 13;
            chunk.buf[chunk.end + 1] = 10;
            outputStream.write(chunk.buf, 0, chunk.end + 2);
            Debug.assertion((chunk != chunk.next ? 1 : 0) != 0);
            chunk = chunk.next;
            ++n;
        }
        return n;
    }

    private static int writeChunkNoTransfer(Chunk chunk, OutputStream outputStream) throws IOException {
        int n = 0;
        while (chunk != null) {
            int n2;
            for (int i = 6; i < chunk.end; i += n2) {
                n2 = Math.min(Chunk.CHUNK_SIZE, chunk.end - i);
                Debug.assertion((n2 >= 0 ? 1 : 0) != 0);
                outputStream.write(chunk.buf, i, n2);
            }
            chunk = chunk.next;
            ++n;
        }
        return n;
    }

    protected static Chunk ensureCapacity(Chunk chunk) {
        if (chunk.end == END_OFFSET) {
            chunk.next = Chunk.getChunk();
            chunk.next.end = 6;
            return chunk.next;
        }
        return chunk;
    }

    protected void setBufferFlushStrategy() {
        if (this.buflimit == -1) {
            this.flushStrategy = new BufferFlushStrategy(this){

                public final void checkOverflow(int n) throws IOException {
                }

                public final void checkForFlush() throws IOException {
                }
            };
            return;
        }
        if (this.autoflush) {
            this.flushStrategy = new BufferFlushStrategy(this){

                public final void checkOverflow(int n) throws IOException {
                }

                public final void checkForFlush() throws IOException {
                    if (ChunkOutput.this.getCountForCheckOverflow() >= ChunkOutput.this.buflimit) {
                        this.out.flush();
                    }
                }
            };
            return;
        }
        if (this.alwaysFlush) {
            this.flushStrategy = new BufferFlushStrategy(this){

                public final void checkOverflow(int n) throws IOException {
                }

                public final void checkForFlush() throws IOException {
                    this.out.flush();
                }
            };
            return;
        }
        this.flushStrategy = new BufferFlushStrategy(this){

            public final void checkOverflow(int n) throws IOException {
                if (ChunkOutput.this.getCountForCheckOverflow() + n > ChunkOutput.this.buflimit) {
                    throw new IOException("Exceeded buffer size of: '" + ChunkOutput.this.buflimit + "', and autoflush is: 'false'");
                }
            }

            public final void checkForFlush() throws IOException {
            }
        };
    }

    protected int getCountForCheckOverflow() {
        return this.count;
    }

    static {
        trigger = new CompleteMessageTimeoutTrigger();
    }

    protected abstract class BufferFlushStrategy {
        ChunkOutput out;

        public BufferFlushStrategy(ChunkOutput chunkOutput2) {
            this.out = chunkOutput2;
        }

        void setChunkOutput(ChunkOutput chunkOutput) {
            this.out = chunkOutput;
        }

        abstract void checkOverflow(int var1) throws IOException;

        abstract void checkForFlush() throws IOException;
    }
}

