/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import weblogic.servlet.internal.CharsetMap;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.servlet.internal.IllegalStateChunkOutput;
import weblogic.servlet.internal.NullChunkOutput;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.utils.http.BytesToString;
import weblogic.utils.io.Chunk;

public class ChunkOutputWrapper {
    public static final String OUTPUT_ATT_NAME = "weblogic.servlet.BodyTagOutput";
    private ChunkOutput currChunkoutput;
    private ChunkOutput realChunkOutput;
    private boolean writeEnabled = true;
    private boolean nativeControlsPipe = false;
    private boolean enforceCL = false;
    private int clen = -1;
    private static final ChunkOutput readonlyChunkoutput = new NullChunkOutput();
    private static final ChunkOutput nativePipeChunkoutput = new IllegalStateChunkOutput(new IllegalStateException("Can not send data via ServletOutputStream or Writer when native control pipe is used."));

    public static ChunkOutputWrapper getCurrentOutput(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        ChunkOutputWrapper chunkOutputWrapper = null;
        chunkOutputWrapper = (ChunkOutputWrapper)servletRequest.getAttribute(OUTPUT_ATT_NAME);
        if (chunkOutputWrapper != null) {
            return chunkOutputWrapper;
        }
        ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
        if (servletOutputStream instanceof ServletOutputStreamImpl) {
            ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletOutputStream;
            chunkOutputWrapper = servletOutputStreamImpl.getOutput();
        }
        return chunkOutputWrapper;
    }

    public ChunkOutputWrapper(ChunkOutput chunkOutput) {
        this.currChunkoutput = chunkOutput;
        this.realChunkOutput = chunkOutput;
    }

    public void changeToCharset(String string, CharsetMap charsetMap) throws UnsupportedEncodingException {
        this.realChunkOutput = BytesToString.is8BitUnicodeSubset((String)string) ? ChunkOutput.create(this.realChunkOutput, null, charsetMap) : ChunkOutput.create(this.realChunkOutput, string, charsetMap);
        if (this.writeEnabled) {
            this.currChunkoutput = this.realChunkOutput;
        }
    }

    public ChunkOutput getOutput() {
        return this.currChunkoutput;
    }

    public void setOutput(ChunkOutput chunkOutput) {
        this.currChunkoutput = chunkOutput;
        this.realChunkOutput = chunkOutput;
    }

    public void reset() {
        this.realChunkOutput.reset();
        this.enforceCL = false;
        this.clen = -1;
    }

    public void release() {
        this.realChunkOutput.release();
        this.enforceCL = false;
        this.clen = -1;
    }

    public int getTotal() {
        return this.realChunkOutput.getTotal();
    }

    public int getCount() {
        return this.realChunkOutput.getCount();
    }

    public int getBufferSize() {
        return this.realChunkOutput.getBufferSize();
    }

    public void setBufferSize(int n) {
        this.realChunkOutput.setBufferSize(n);
    }

    public boolean isAutoFlush() {
        return this.realChunkOutput.isAutoFlush();
    }

    public void setAutoFlush(boolean bl) {
        this.realChunkOutput.setAutoFlush(bl);
    }

    public boolean isChunking() {
        return this.realChunkOutput.isChunking();
    }

    public void setChunking(boolean bl) {
        this.realChunkOutput.setChunking(bl);
    }

    void writeByte(int n) throws IOException {
        if (!this.enforceCL) {
            this.currChunkoutput.writeByte(n);
        } else {
            if (this.remainingContent() > 0) {
                this.currChunkoutput.writeByte(n);
            }
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void write(int n) throws IOException {
        if (!this.enforceCL) {
            this.currChunkoutput.write(n);
        } else {
            if (this.remainingContent() > 0) {
                this.currChunkoutput.write(n);
            }
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.checkBoundary(cArray.length, n, n2);
        if (!this.enforceCL) {
            this.currChunkoutput.write(cArray, n, n2);
        } else {
            int n3 = this.remainingContent();
            if (n2 > n3) {
                n2 = n3;
            }
            this.currChunkoutput.write(cArray, n, n2);
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void write(char[] cArray) throws IOException {
        if (!this.enforceCL) {
            this.currChunkoutput.write(cArray, 0, cArray.length);
        } else {
            int n = cArray.length;
            int n2 = this.remainingContent();
            if (n > n2) {
                n = n2;
            }
            this.currChunkoutput.write(cArray, 0, n);
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkBoundary(byArray.length, n, n2);
        if (!this.enforceCL) {
            this.currChunkoutput.write(byArray, n, n2);
        } else {
            int n3 = this.remainingContent();
            if (n2 > n3) {
                n2 = n3;
            }
            this.currChunkoutput.write(byArray, n, n2);
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        if (!this.enforceCL) {
            this.currChunkoutput.write(byteBuffer);
        } else {
            int n;
            int n2 = byteBuffer.limit();
            if (n2 > (n = this.remainingContent())) {
                n2 = n;
            }
            this.currChunkoutput.write(byteBuffer);
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void print(String string) throws IOException {
        if (!this.enforceCL) {
            this.currChunkoutput.print(string);
        } else {
            int n;
            int n2 = this.remainingContent();
            if (string == null) {
                string = "null";
            }
            if ((n = string.length()) > n2) {
                string = string.substring(0, n2);
            }
            this.currChunkoutput.print(string);
            if (this.remainingContent() == 0) {
                this.currChunkoutput.commit();
            }
        }
    }

    public void clearBuffer() {
        this.realChunkOutput.clearBuffer();
    }

    public void flush() throws IOException {
        this.realChunkOutput.flush();
    }

    public void writeStream(InputStream inputStream, int n) throws IOException {
        this.currChunkoutput.writeStream(inputStream, n, this.clen);
    }

    public String getEncoding() {
        return this.realChunkOutput.getEncoding();
    }

    boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    void setWriteEnabled(boolean bl) {
        this.writeEnabled = bl;
        this.currChunkoutput = !this.writeEnabled ? readonlyChunkoutput : this.realChunkOutput;
    }

    void setNativeControlsPipe(boolean bl) {
        this.nativeControlsPipe = bl;
        this.currChunkoutput = this.nativeControlsPipe ? nativePipeChunkoutput : this.realChunkOutput;
    }

    void setHttpHeaders(Chunk chunk) {
        this.realChunkOutput.setHttpHeaders(chunk);
    }

    public void commit() throws IOException {
        this.realChunkOutput.commit();
    }

    public void setCL(int n) {
        this.clen = n;
        if (this.clen != -1) {
            this.enforceCL = true;
        }
    }

    private int remainingContent() {
        return this.clen - (this.getTotal() + this.getCount());
    }

    private void checkBoundary(int n, int n2, int n3) {
        if (n2 < 0 || n2 > n || n3 < 0 || n2 + n3 > n || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

