/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.Writer;
import weblogic.servlet.internal.ChunkOutputWrapper;

public final class ChunkWriter
extends Writer {
    private boolean error = false;
    private ChunkOutputWrapper co;

    public ChunkWriter(ChunkOutputWrapper chunkOutputWrapper) {
        this.co = chunkOutputWrapper;
    }

    public String getEncoding() {
        String string = this.co.getEncoding();
        if (string == null) {
            string = "ISO-8859-1";
        }
        return string;
    }

    public void write(int n) throws IOException {
        if (this.error) {
            return;
        }
        try {
            this.co.write(n);
        }
        catch (IOException iOException) {
            this.error = true;
            throw iOException;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.error) {
            return;
        }
        try {
            this.co.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
            throw iOException;
        }
    }

    public void write(String string) throws IOException {
        if (this.error) {
            return;
        }
        try {
            this.co.print(string);
        }
        catch (IOException iOException) {
            this.error = true;
            throw iOException;
        }
    }

    public void flush() throws IOException {
        if (this.error) {
            return;
        }
        try {
            this.co.flush();
        }
        catch (IOException iOException) {
            this.error = true;
            throw iOException;
        }
    }

    public void close() throws IOException {
    }
}

