/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.deployment.EnvironmentBuilder;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.descriptors.BaseDescriptor;
import weblogic.deployment.descriptors.EJBReference;
import weblogic.deployment.descriptors.ResourceReference;
import weblogic.deployment.descriptors.xml.EnvironmentEntry;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.EjbReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.MessageDestinationDescriptorBean;
import weblogic.j2ee.descriptor.wl.ResourceDescriptionBean;
import weblogic.j2ee.descriptor.wl.ResourceEnvDescriptionBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.jndi.internal.ApplicationNamingNode;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.Debug;
import weblogic.utils.NestedException;
import weblogic.utils.collections.ArrayMap;

public class CompEnv {
    private static final boolean DEBUG = false;
    private static final String INJECTION_BINDING = "WebComponentCreator";
    private final EnvironmentBuilder eBuilder;
    private final WebAppServletContext servletContext;
    private final String subcontextName;
    private final Context webctx;
    private final Context msgDstnCtx;
    private final List envEntriesList = new ArrayList();
    private final List ejbRefsList = new ArrayList();
    private final List resRefsList = new ArrayList();
    private final ArrayMap resEnvRefsMap = new ArrayMap();
    private final List serviceRefsList = new ArrayList();
    private final List wlServiceRefsList = new ArrayList();
    private final Map msgDstnDescriptors = new HashMap();
    private final String linkRefPrefix;

    public CompEnv(WebAppServletContext webAppServletContext) throws DeploymentException {
        this.servletContext = webAppServletContext;
        this.subcontextName = this.servletContext.getName() + "/" + this.hashCode();
        Context context = this.servletContext.getApplicationContext().getEnvContext();
        this.linkRefPrefix = this.initLinkRefPrefix();
        if (context == null) {
            context = this.createApplicationContext();
        }
        try {
            this.webctx = (Context)context.lookup("webapp");
            Context context2 = this.webctx.createSubcontext(J2EEUtils.normalizeJarName(this.subcontextName));
            context2.bind("app", (Object)context);
            this.eBuilder = new EnvironmentBuilder(context2, this.servletContext.getApplicationId(), this.servletContext.getId());
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)namingException);
        }
        this.msgDstnCtx = this.setupMessageDestinationSubContext(context);
    }

    private String initLinkRefPrefix() {
        if (this.servletContext.getWebAppModule() == null) {
            return null;
        }
        return J2EEUtils.normalizeJarName(this.servletContext.getWebAppModule().getId() + "#");
    }

    void prepare() throws DeploymentException {
        WebAppModule webAppModule = this.servletContext.getWebAppModule();
        if (webAppModule == null) {
            return;
        }
        WebAppBean webAppBean = webAppModule.getWebAppBean();
        if (webAppBean == null) {
            return;
        }
        WeblogicWebAppBean weblogicWebAppBean = webAppModule.getWlWebAppBean();
        this.registerEnvironmentEntries(webAppBean);
        this.registerEjbReferenceDescriptions(webAppBean, weblogicWebAppBean);
        this.registerEjbLocalReferenceDescriptions(webAppBean, weblogicWebAppBean);
        this.registerServiceRefs(webAppBean, weblogicWebAppBean);
        this.registerResourceReferenceDescriptions(webAppBean, weblogicWebAppBean);
        this.registerResourceEnvDescriptions(weblogicWebAppBean);
        this.registerResourceEnvWebServices(webAppBean);
        this.registerMessageDestinations(webAppBean, weblogicWebAppBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() throws DeploymentException {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        ClassLoader classLoader2 = this.servletContext.getServletClassLoader();
        thread2.setContextClassLoader(classLoader2);
        WebAppBean webAppBean = this.servletContext.getWebAppModule().getWebAppBean();
        try {
            this.addWebComponentCreator();
            this.eBuilder.addEnvironmentEntries(this.envEntriesList);
            this.eBuilder.addResourceReferences(this.resRefsList);
            this.eBuilder.addServiceReferences(this.serviceRefsList, this.wlServiceRefsList, this.servletContext, this.servletContext.getURI());
            this.initializeMessageDestinationLinks();
            this.initializeMessageDestinationRefs();
            this.eBuilder.addResourceEnvReferences((Map)this.resEnvRefsMap);
            this.eBuilder.addPersistenceContextRefs(webAppBean.getPersistenceContextRefs(), classLoader2, this.servletContext.getWebAppModule());
            this.eBuilder.addPersistenceUnitRefs(webAppBean.getPersistenceUnitRefs(), classLoader2, this.servletContext.getWebAppModule());
            try {
                javaURLContextFactory.pushContext(this.eBuilder.getContext());
                this.eBuilder.addEJBReferences(this.ejbRefsList, this.servletContext.getURI());
            }
            finally {
                javaURLContextFactory.popContext();
            }
        }
        catch (NamingException namingException) {
            this.cleanup();
            throw new DeploymentException("Could not setup environment", namingException);
        }
        catch (EnvironmentException environmentException) {
            this.cleanup();
            throw new DeploymentException("Could not setup environment", (Throwable)((Object)environmentException));
        }
        catch (NestedException nestedException) {
            this.cleanup();
            throw new DeploymentException(nestedException);
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    private Context createApplicationContext() throws DeploymentException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
        hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
        hashtable.put("weblogic.jndi.replicateBindings", "false");
        Context context = new ApplicationNamingNode("/").getContext(hashtable);
        try {
            context.createSubcontext("webapp");
        }
        catch (NamingException namingException) {
            throw new DeploymentException("Can't create context", namingException);
        }
        return context;
    }

    private void registerEnvironmentEntries(WebAppBean webAppBean) {
        EnvEntryBean[] envEntryBeanArray = webAppBean.getEnvEntries();
        if (envEntryBeanArray == null) {
            return;
        }
        for (int i = 0; i < envEntryBeanArray.length; ++i) {
            EnvEntryBean envEntryBean = envEntryBeanArray[i];
            EnvironmentEntry environmentEntry = new EnvironmentEntry();
            String[] stringArray = envEntryBean.getDescriptions();
            if (stringArray != null && stringArray.length > 0) {
                environmentEntry.setDescription(stringArray[0]);
            }
            environmentEntry.setName(envEntryBean.getEnvEntryName());
            environmentEntry.setValue(envEntryBean.getEnvEntryValue());
            environmentEntry.setType(envEntryBean.getEnvEntryType());
            this.envEntriesList.add(environmentEntry);
        }
    }

    private void initializeMessageDestinationRefs() throws NamingException, EnvironmentException {
        if (this.servletContext.getWebAppModule() == null || this.servletContext.getWebAppModule().getWebAppBean() == null) {
            return;
        }
        MessageDestinationRefBean[] messageDestinationRefBeanArray = this.servletContext.getWebAppModule().getWebAppBean().getMessageDestinationRefs();
        if (messageDestinationRefBeanArray == null || messageDestinationRefBeanArray.length < 1) {
            return;
        }
        this.eBuilder.addMessageDestinationReferences(Arrays.asList(messageDestinationRefBeanArray), this.servletContext.getLogContext());
    }

    private void removeMessageDestinationRefs() {
        if (this.servletContext.getWebAppModule() == null || this.servletContext.getWebAppModule().getWebAppBean() == null) {
            return;
        }
        MessageDestinationRefBean[] messageDestinationRefBeanArray = this.servletContext.getWebAppModule().getWebAppBean().getMessageDestinationRefs();
        if (messageDestinationRefBeanArray == null || messageDestinationRefBeanArray.length < 1) {
            return;
        }
        this.eBuilder.removeMessageDestinationReferences(Arrays.asList(messageDestinationRefBeanArray));
    }

    private void initializeMessageDestinationLinks() throws DeploymentException {
        if (this.msgDstnDescriptors.isEmpty()) {
            return;
        }
        try {
            for (MessageDestinationDescriptorBean messageDestinationDescriptorBean : this.msgDstnDescriptors.values()) {
                String string = J2EEUtils.normalizeJNDIName(messageDestinationDescriptorBean.getMessageDestinationName());
                this.msgDstnCtx.bind(this.linkRefPrefix + string, (Object)messageDestinationDescriptorBean);
            }
        }
        catch (NamingException namingException) {
            throw new DeploymentException(this.servletContext.getLogContext(), namingException);
        }
    }

    private void removeMessageDestinationLinks() {
        if (!this.msgDstnDescriptors.isEmpty()) {
            for (MessageDestinationDescriptorBean messageDestinationDescriptorBean : this.msgDstnDescriptors.values()) {
                String string = J2EEUtils.normalizeJNDIName(messageDestinationDescriptorBean.getMessageDestinationName());
                try {
                    this.msgDstnCtx.unbind(this.linkRefPrefix + string);
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private Context setupMessageDestinationSubContext(Context context) {
        try {
            return (Context)context.lookup("messageDestination");
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                return context.createSubcontext("messageDestination");
            }
            catch (NamingException namingException) {
                throw new AssertionError((Object)namingException);
            }
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)namingException);
        }
    }

    private void registerMessageDestinations(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) throws DeploymentException {
        int n;
        MessageDestinationDescriptorBean[] messageDestinationDescriptorBeanArray;
        if (weblogicWebAppBean != null && (messageDestinationDescriptorBeanArray = weblogicWebAppBean.getMessageDestinationDescriptors()) != null) {
            for (n = 0; n < messageDestinationDescriptorBeanArray.length; ++n) {
                this.msgDstnDescriptors.put(messageDestinationDescriptorBeanArray[n].getMessageDestinationName(), messageDestinationDescriptorBeanArray[n]);
            }
        }
        if ((messageDestinationDescriptorBeanArray = webAppBean.getMessageDestinations()) == null || messageDestinationDescriptorBeanArray.length < 1) {
            return;
        }
        for (n = 0; n < messageDestinationDescriptorBeanArray.length; ++n) {
            if (this.msgDstnDescriptors.containsKey(messageDestinationDescriptorBeanArray[n].getMessageDestinationName())) continue;
            Loggable loggable = HTTPLogger.logMissingMessageDestinationDescriptorLoggable((String)messageDestinationDescriptorBeanArray[n].getMessageDestinationName(), (String)this.servletContext.getLogContext());
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private void registerEjbReferenceDescriptions(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) {
        EjbRefBean[] ejbRefBeanArray = webAppBean.getEjbRefs();
        if (ejbRefBeanArray == null || ejbRefBeanArray.length == 0) {
            return;
        }
        EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray = null;
        if (weblogicWebAppBean != null) {
            ejbReferenceDescriptionBeanArray = weblogicWebAppBean.getEjbReferenceDescriptions();
        }
        for (int i = 0; i < ejbRefBeanArray.length; ++i) {
            EjbRefBean ejbRefBean = ejbRefBeanArray[i];
            weblogic.deployment.descriptors.xml.EJBReference eJBReference = new weblogic.deployment.descriptors.xml.EJBReference();
            String[] stringArray = ejbRefBean.getDescriptions();
            if (stringArray != null && stringArray.length > 0) {
                eJBReference.setDescription(stringArray[0]);
            }
            eJBReference.setName(ejbRefBean.getEjbRefName());
            eJBReference.setRefType(ejbRefBean.getEjbRefType());
            eJBReference.setHomeInterfaceName(ejbRefBean.getHome());
            eJBReference.setRemoteInterfaceName(ejbRefBean.getRemote());
            eJBReference.setLinkedEjbName(ejbRefBean.getEjbLink());
            eJBReference.setMappedName(ejbRefBean.getMappedName());
            if (ejbReferenceDescriptionBeanArray != null) {
                for (int j = 0; j < ejbReferenceDescriptionBeanArray.length; ++j) {
                    if (!ejbRefBean.getEjbRefName().equals(ejbReferenceDescriptionBeanArray[j].getEjbRefName())) continue;
                    eJBReference.setJNDIName(this.transformJNDIName(ejbReferenceDescriptionBeanArray[j].getJNDIName()));
                    break;
                }
            }
            eJBReference.setLocalLink(false);
            this.ejbRefsList.add(eJBReference);
        }
    }

    private void registerEjbLocalReferenceDescriptions(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) {
        EjbLocalRefBean[] ejbLocalRefBeanArray = webAppBean.getEjbLocalRefs();
        if (ejbLocalRefBeanArray == null || ejbLocalRefBeanArray.length == 0) {
            return;
        }
        EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray = null;
        if (weblogicWebAppBean != null) {
            ejbReferenceDescriptionBeanArray = weblogicWebAppBean.getEjbReferenceDescriptions();
        }
        for (int i = 0; i < ejbLocalRefBeanArray.length; ++i) {
            EjbLocalRefBean ejbLocalRefBean = ejbLocalRefBeanArray[i];
            weblogic.deployment.descriptors.xml.EJBReference eJBReference = new weblogic.deployment.descriptors.xml.EJBReference();
            String[] stringArray = ejbLocalRefBean.getDescriptions();
            if (stringArray != null && stringArray.length > 0) {
                eJBReference.setDescription(stringArray[0]);
            }
            eJBReference.setName(ejbLocalRefBean.getEjbRefName());
            eJBReference.setRefType(ejbLocalRefBean.getEjbRefType());
            eJBReference.setHomeInterfaceName(ejbLocalRefBean.getLocalHome());
            eJBReference.setRemoteInterfaceName(ejbLocalRefBean.getLocal());
            eJBReference.setLinkedEjbName(ejbLocalRefBean.getEjbLink());
            eJBReference.setMappedName(ejbLocalRefBean.getMappedName());
            if (ejbReferenceDescriptionBeanArray != null) {
                for (int j = 0; j < ejbReferenceDescriptionBeanArray.length; ++j) {
                    if (!ejbLocalRefBean.getEjbRefName().equals(ejbReferenceDescriptionBeanArray[j].getEjbRefName())) continue;
                    eJBReference.setJNDIName(this.transformJNDIName(ejbReferenceDescriptionBeanArray[j].getJNDIName()));
                    break;
                }
            }
            eJBReference.setLocalLink(true);
            this.ejbRefsList.add(eJBReference);
        }
    }

    private void registerResourceReferenceDescriptions(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) {
        ResourceRefBean[] resourceRefBeanArray = webAppBean.getResourceRefs();
        if (resourceRefBeanArray == null) {
            return;
        }
        ResourceDescriptionBean[] resourceDescriptionBeanArray = null;
        if (weblogicWebAppBean != null) {
            resourceDescriptionBeanArray = weblogicWebAppBean.getResourceDescriptions();
        }
        for (int i = 0; i < resourceRefBeanArray.length; ++i) {
            ResourceRefBean resourceRefBean = resourceRefBeanArray[i];
            weblogic.deployment.descriptors.xml.ResourceReference resourceReference = new weblogic.deployment.descriptors.xml.ResourceReference();
            resourceReference.setName(resourceRefBean.getResRefName());
            resourceReference.setResourceType(resourceRefBean.getResType());
            resourceReference.setResourceAuthMode(resourceRefBean.getResAuth());
            String[] stringArray = resourceRefBean.getDescriptions();
            if (stringArray != null && stringArray.length > 0) {
                resourceReference.setDescription(stringArray[0]);
            }
            resourceReference.setResourceSharingScope(resourceRefBean.getResSharingScope());
            resourceReference.setMappedName(resourceRefBean.getMappedName());
            if (resourceDescriptionBeanArray != null) {
                for (int j = 0; j < resourceDescriptionBeanArray.length; ++j) {
                    String string;
                    if (!resourceRefBean.getResRefName().equals(resourceDescriptionBeanArray[j].getResRefName())) continue;
                    String string2 = resourceDescriptionBeanArray[j].getJNDIName();
                    if (string2 == null || string2.length() < 1) {
                        string = this.servletContext.getApplicationContext().getApplicationId();
                        String string3 = resourceDescriptionBeanArray[i].getResourceLink();
                        if (string3 != null && string3.length() > 0) {
                            string2 = CompEnv.constructJNDIName(string, string3);
                        }
                    }
                    resourceReference.setJNDIName(this.transformJNDIName(string2));
                    if (!HTTPDebugLogger.isEnabled()) break;
                    string = HTTPLogger.logBindingResourceReferenceLoggable((String)this.servletContext.getAppDisplayName(), (String)this.servletContext.getId(), (String)resourceRefBean.getResRefName(), (String)string2);
                    HTTPDebugLogger.debug(string.getMessage());
                    break;
                }
            }
            this.resRefsList.add(resourceReference);
        }
    }

    private void registerResourceEnvWebServices(WebAppBean webAppBean) {
        ResourceEnvRefBean[] resourceEnvRefBeanArray = webAppBean.getResourceEnvRefs();
        for (int i = 0; i < resourceEnvRefBeanArray.length; ++i) {
            ResourceEnvRefBean resourceEnvRefBean = resourceEnvRefBeanArray[i];
            if (!WebServiceContext.class.getName().equals(resourceEnvRefBean.getResourceEnvRefType())) continue;
            this.resEnvRefsMap.put((Object)resourceEnvRefBean.getResourceEnvRefName(), (Object)"java:comp/WebServiceContext");
        }
    }

    private void registerResourceEnvDescriptions(WeblogicWebAppBean weblogicWebAppBean) {
        if (weblogicWebAppBean == null) {
            return;
        }
        ResourceEnvDescriptionBean[] resourceEnvDescriptionBeanArray = weblogicWebAppBean.getResourceEnvDescriptions();
        if (resourceEnvDescriptionBeanArray == null) {
            return;
        }
        for (int i = 0; i < resourceEnvDescriptionBeanArray.length; ++i) {
            String string;
            String string2 = this.servletContext.getApplicationContext().getApplicationId();
            String string3 = resourceEnvDescriptionBeanArray[i].getJNDIName();
            if ((string3 == null || string3.length() < 1) && (string = resourceEnvDescriptionBeanArray[i].getResourceLink()) != null && string.length() > 0) {
                string3 = CompEnv.constructJNDIName(string2, string);
            }
            this.resEnvRefsMap.put((Object)resourceEnvDescriptionBeanArray[i].getResourceEnvRefName(), (Object)this.transformJNDIName(string3));
        }
    }

    private void registerServiceRefs(WebAppBean webAppBean, WeblogicWebAppBean weblogicWebAppBean) {
        int n;
        ServiceRefBean[] serviceRefBeanArray;
        ServiceReferenceDescriptionBean[] serviceReferenceDescriptionBeanArray = null;
        if (weblogicWebAppBean != null) {
            serviceReferenceDescriptionBeanArray = weblogicWebAppBean.getServiceReferenceDescriptions();
        }
        if ((serviceRefBeanArray = webAppBean.getServiceRefs()) != null) {
            for (n = 0; n < serviceRefBeanArray.length; ++n) {
                this.serviceRefsList.add(serviceRefBeanArray[n]);
            }
        }
        if (serviceReferenceDescriptionBeanArray != null) {
            for (n = 0; n < serviceReferenceDescriptionBeanArray.length; ++n) {
                this.wlServiceRefsList.add(serviceReferenceDescriptionBeanArray[n]);
            }
        }
    }

    private String transformJNDIName(String string) {
        return BaseEnvironmentBuilder.transformJNDIName(string, this.servletContext.getApplicationName());
    }

    private static String constructJNDIName(String string, String string2) {
        return "weblogic." + string + "." + string2;
    }

    private void destroyContext() {
        try {
            Context context = (Context)this.webctx.lookup(this.subcontextName);
            context.unbind("app");
            this.webctx.destroySubcontext(this.subcontextName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    void cleanup() {
        if (!this.resRefsList.isEmpty()) {
            this.eBuilder.removeResourceReferences(this.resRefsList);
        }
        this.eBuilder.removePersistenceContextRefs(null);
        if (!this.resEnvRefsMap.isEmpty()) {
            this.eBuilder.removeResourceEnvReferences((Map)this.resEnvRefsMap);
        }
        if (!this.ejbRefsList.isEmpty()) {
            this.eBuilder.removeEJBReferences(this.ejbRefsList);
        }
        this.removeMessageDestinationRefs();
        this.removeMessageDestinationLinks();
        if (!this.serviceRefsList.isEmpty()) {
            this.eBuilder.removeServiceReferences(this.serviceRefsList);
        }
    }

    void destroy() {
        this.removeWebComponentCreator();
        if (!this.envEntriesList.isEmpty()) {
            this.eBuilder.removeEnvironmentEntries(this.envEntriesList);
        }
        WebAppBean webAppBean = this.servletContext.getWebAppModule().getWebAppBean();
        this.eBuilder.removePersistenceContextRefs(webAppBean.getPersistenceContextRefs());
        this.eBuilder.removePersistenceUnitRefs(webAppBean.getPersistenceUnitRefs());
        this.eBuilder.removeStandardEntries();
        this.envEntriesList.clear();
        this.resRefsList.clear();
        this.resEnvRefsMap.clear();
        this.ejbRefsList.clear();
        this.msgDstnDescriptors.clear();
        this.serviceRefsList.clear();
        this.destroyContext();
    }

    Context getEnvironmentContext() {
        return this.eBuilder.getContext();
    }

    private void say(String string) {
        Debug.say((String)(this.subcontextName + ": " + string));
    }

    public void dump() {
        Debug.say((String)("DUMPING COMP ENV FOR WEBAPP: " + this.subcontextName));
        this.dumpContext(this.eBuilder.getContext(), "  ", this.servletContext.getApplicationContext().getEnvContext());
    }

    private void dumpContext(Context context, String string, Context context2) {
        if (context == null) {
            return;
        }
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMoreElements()) {
                Object object = namingEnumeration.next();
                Binding binding = object;
                String string2 = binding.getName();
                object = binding.getObject();
                this.say(string + string2 + "=" + object);
                if (!(object instanceof Context) || object == context2) continue;
                this.dumpContext((Context)object, "  " + string, context2);
            }
        }
        catch (NamingException namingException) {
            HTTPLogger.logErrorWithThrowable((String)this.servletContext.getLogContext(), (String)"Naming exception while dumping context", (Throwable)namingException);
        }
    }

    void bindResourceRef(String string, String string2, String string3, String string4, boolean bl, String string5) throws DeploymentException {
        weblogic.deployment.descriptors.xml.ResourceReference resourceReference = new weblogic.deployment.descriptors.xml.ResourceReference();
        resourceReference.setName(string);
        resourceReference.setResourceType(string2);
        if (!weblogic.deployment.descriptors.xml.ResourceReference.VALID_AUTH_MODES.contains(string3)) {
            throw new DeploymentException("invalid value for res-auth: " + string3 + ", valid values are: \"Application\" and \"Container\"");
        }
        resourceReference.setResourceAuthMode(string3);
        resourceReference.setJNDIName(string4);
        if (bl) {
            resourceReference.setResourceSharingScope("Shareable");
        } else {
            resourceReference.setResourceSharingScope("Unshareable");
        }
        resourceReference.setDescription(string5);
        try {
            this.eBuilder.addResourceReference(resourceReference);
        }
        catch (NamingException namingException) {
            throw new DeploymentException(namingException.getMessage(), namingException);
        }
        catch (EnvironmentException environmentException) {
            throw new DeploymentException(environmentException.getMessage(), (Throwable)((Object)environmentException));
        }
        this.resRefsList.add(resourceReference);
    }

    void bindEjbRef(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws DeploymentException {
        weblogic.deployment.descriptors.xml.EJBReference eJBReference = new weblogic.deployment.descriptors.xml.EJBReference();
        eJBReference.setName(string);
        if (!weblogic.deployment.descriptors.xml.EJBReference.VALID_EJB_REF_TYPES.contains(string2)) {
            throw new DeploymentException("invalid value for ejb-ref-type: " + string2 + ", valid values are: \"Entity\" and \"Session\"");
        }
        eJBReference.setRefType(string2);
        eJBReference.setHomeInterfaceName(string3);
        eJBReference.setRemoteInterfaceName(string4);
        eJBReference.setLinkedEjbName(string5);
        eJBReference.setJNDIName(this.transformJNDIName(string6));
        eJBReference.setLocalLink(bl);
        eJBReference.setDescription(string7);
        this.ejbRefsList.add(eJBReference);
    }

    boolean isResourceBound(String string) {
        boolean bl;
        do {
            try {
                if (!this.resRefsList.isEmpty()) {
                    for (BaseDescriptor baseDescriptor : this.resRefsList) {
                        if (!((ResourceReference)baseDescriptor).getName().equals(string)) continue;
                        return true;
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                concurrentModificationException.printStackTrace();
                bl = true;
            }
        } while (bl);
        do {
            try {
                if (!this.ejbRefsList.isEmpty()) {
                    for (BaseDescriptor baseDescriptor : this.ejbRefsList) {
                        if (!((EJBReference)baseDescriptor).getName().equals(string)) continue;
                        return true;
                    }
                }
                bl = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                concurrentModificationException.printStackTrace();
                bl = true;
            }
        } while (bl);
        return this.resEnvRefsMap.keySet().contains(string);
    }

    private void addWebComponentCreator() throws NamingException {
        if (!this.servletContext.isJsfApplication()) {
            return;
        }
        Context context = this.eBuilder.getContext();
        Context context2 = (Context)context.lookup("bea");
        if (context2 == null) {
            throw new NamingException("Can't bind WebComponentCreator because of context bea not found. ");
        }
        context2.bind(INJECTION_BINDING, (Object)this.servletContext.getComponentCreator());
    }

    private void removeWebComponentCreator() {
        if (!this.servletContext.isJsfApplication()) {
            return;
        }
        Context context = this.eBuilder.getContext();
        try {
            Context context2 = (Context)context.lookup("bea");
            if (context2 != null) {
                context2.unbind(INJECTION_BINDING);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    EnvironmentBuilder getEnvironmentBuilder() {
        return this.eBuilder;
    }
}

