/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.KernelMBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public class CompleteMessageTimeoutTrigger
implements TimerListener {
    private static final int CLEANUP_TRIGGER_TIMEPERIOD_LOW = 2000;
    private static final int CLEANUP_TRIGGER_TIMEPERIOD_HIGH = 30000;
    private ConcurrentHashMap sockets = new ConcurrentHashMap(1024);
    private long writeTimeoutInterval;
    private long triggerInterval;

    public CompleteMessageTimeoutTrigger() {
        KernelMBean kernelMBean = Kernel.getConfig();
        this.writeTimeoutInterval = 1000 * (kernelMBean.getCompleteHTTPMessageTimeout() == -1 ? kernelMBean.getCompleteMessageTimeout() : kernelMBean.getCompleteHTTPMessageTimeout());
        this.triggerInterval = this.writeTimeoutInterval / 10L;
        if (this.triggerInterval < 2000L) {
            this.triggerInterval = 2000L;
        } else if (this.triggerInterval > 30000L) {
            this.triggerInterval = 30000L;
        }
        if (HTTPDebugLogger.isEnabled()) {
            HTTPLogger.logDebug((String)("Setting the writetimeout interval to " + this.writeTimeoutInterval));
        }
        TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager(CompleteMessageTimeoutTrigger.class.getName(), WorkManagerFactory.getInstance().getSystem());
        timerManager.schedule((TimerListener)this, 0L, this.triggerInterval);
    }

    void register(OutputStream outputStream) {
        this.sockets.put(outputStream, new Long(System.currentTimeMillis()));
    }

    void unregister(OutputStream outputStream) {
        this.sockets.remove(outputStream);
    }

    public void timerExpired(Timer timer) {
        long l = System.currentTimeMillis();
        for (OutputStream outputStream : this.sockets.keySet()) {
            Long l2 = (Long)this.sockets.get(outputStream);
            if (l2 == null || l - l2 <= this.writeTimeoutInterval || !this.sockets.remove(outputStream, l2)) continue;
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HTTPLogger.logClosingTimeoutSocket();
        }
    }
}

