/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.Home;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleExtensionManager {
    private static final ConsoleExtensionManager INSTANCE = new ConsoleExtensionManager();
    private static final XMLInputFactory XMLINFACTORY = XMLInputFactory.newInstance();
    private static final String extConfigFileName = "ConsoleExtensions.xml";
    static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static ConsoleExtensionManager getInstance() {
        return INSTANCE;
    }

    protected ConsoleExtensionManager() {
    }

    public ExtensionDef[] findExtensions() {
        HashMap<String, ExtensionDef> hashMap = new HashMap<String, ExtensionDef>();
        this.includeDirectoryContents(this.getHomeExtensionDir(), hashMap, false);
        this.includeDirectoryContents(this.getHomeAutodeployExtensionDir(), hashMap, true);
        this.includeDirectoryContents(this.getDomainExtensionDir(), hashMap, true);
        File file = this.getHomeExtensionConfigFile();
        if (file.exists()) {
            this.applyExtensionConfigFile(file, hashMap);
        }
        if ((file = this.getDomainExtensionConfigFile()).exists()) {
            this.applyExtensionConfigFile(file, hashMap);
        }
        ExtensionDef[] extensionDefArray = new ExtensionDef[hashMap.size()];
        hashMap.values().toArray(extensionDefArray);
        return extensionDefArray;
    }

    public boolean shouldIncludeExtension(String string, ExtensionDef extensionDef) {
        if (extensionDef != null) {
            File file;
            if (string.endsWith(".war") || string.endsWith(".war")) {
                string = string.substring(0, string.length() - 4);
            }
            if (!string.equals(extensionDef.getModuleName())) {
                return false;
            }
            if (!extensionDef.isEnabled()) {
                return false;
            }
            String[] stringArray = extensionDef.getRequiredServices();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.isServiceEnabled(stringArray[i])) continue;
                    return false;
                }
            }
            return (file = new File(extensionDef.getPath())).exists();
        }
        return false;
    }

    public void release() {
    }

    protected boolean isServiceEnabled(String string) {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServerRuntime();
        return serverRuntimeMBean.isServiceAvailable(string);
    }

    private void applyExtensionConfigFile(File file, Map<String, ExtensionDef> map) {
        XMLStreamReader xMLStreamReader = null;
        try {
            xMLStreamReader = XMLINFACTORY.createXMLStreamReader(new FileReader(file.getPath()));
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        if (!"extensions".equals(xMLStreamReader.getLocalName())) break;
                        this.parseExtensions(xMLStreamReader, map);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            xMLStreamReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void parseExtensions(XMLStreamReader xMLStreamReader, Map<String, ExtensionDef> map) throws XMLStreamException {
        block4: while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 1: {
                    if (!"extension-def".equals(xMLStreamReader.getLocalName())) break;
                    String string = xMLStreamReader.getAttributeValue(null, "module");
                    String string2 = xMLStreamReader.getAttributeValue(null, "path");
                    String string3 = xMLStreamReader.getAttributeValue(null, "enabled");
                    String string4 = xMLStreamReader.getAttributeValue(null, "requiredServices");
                    String string5 = xMLStreamReader.getAttributeValue(null, "prerequisites");
                    if (ConsoleExtensionManager.isEmptyString(string)) {
                        string = "console";
                    }
                    boolean bl = true;
                    if (!ConsoleExtensionManager.isEmptyString(string3)) {
                        bl = "true".equals(string3);
                    }
                    if (ConsoleExtensionManager.isEmptyString(string2)) continue block4;
                    String string6 = this.computeExtensionDefName(string, string2);
                    ExtensionDef extensionDef = map.get(string6);
                    if (extensionDef != null) {
                        extensionDef.setEnabled(bl);
                        extensionDef.setPrerequisites(string5);
                        extensionDef.setRequiredServices(string4);
                    } else {
                        extensionDef = new ExtensionDef(string, string2, bl, string4, string5);
                    }
                    map.put(extensionDef.getName(), extensionDef);
                    break;
                }
                case 2: {
                    if (!"extensions".equals(xMLStreamReader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    protected File getDomainExtensionDir() {
        File file;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        String string = domainMBean.getConsoleExtensionDirectory();
        if (string != null && (file = new File(domainMBean.getRootDirectory(), string)).isDirectory()) {
            return file;
        }
        return null;
    }

    protected File getHomeExtensionDir() {
        File file = new File(Home.getPath());
        if (file.getParentFile() != null) {
            return new File(file.getParentFile(), "server" + File.separator + "lib" + File.separator + "console-ext");
        }
        return null;
    }

    protected File getHomeAutodeployExtensionDir() {
        File file = new File(Home.getPath());
        if (file.getParentFile() != null) {
            return new File(file.getParentFile(), "server" + File.separator + "lib" + File.separator + "console-ext" + File.separator + "autodeploy");
        }
        return null;
    }

    protected File getDomainExtensionConfigFile() {
        return new File(DomainDir.getDataDirForServer((String)ManagementService.getPropertyService(KERNEL_ID).getServerName()) + File.separatorChar + "console" + File.separatorChar + extConfigFileName);
    }

    protected File getHomeExtensionConfigFile() {
        File file = new File(Home.getPath());
        if (file.getParentFile() != null) {
            return new File(file.getParentFile(), "server" + File.separator + "lib" + File.separator + "console-ext" + File.separator + extConfigFileName);
        }
        return null;
    }

    private void includeDirectoryContents(File file, Map<String, ExtensionDef> map, boolean bl) {
        FileFilter fileFilter = FileUtils.makeExtensionFilter((String[])new String[]{".jar", ".war"});
        if (file != null && file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles(fileFilter);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                String string = this.computeExtensionName(fileArray[i].getAbsolutePath());
                String string2 = "console";
                if (string.toLowerCase().indexOf("help") > 0) {
                    string2 = "consolehelp";
                }
                ExtensionDef extensionDef = new ExtensionDef(string2, fileArray[i].getAbsolutePath(), bl, null, null);
                extensionDef.setDiscovered(true);
                map.put(extensionDef.getName(), extensionDef);
            }
        }
    }

    protected String computeExtensionDefName(String string, String string2) {
        return string + "." + this.computeExtensionName(string2);
    }

    protected String computeExtensionName(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(".")) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.length() == 0 || ConsoleExtensionManager.isWhitespace(string);
    }

    private static boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public class ExtensionDef {
        private String name = null;
        private String extensionName = null;
        private String moduleName;
        private String path;
        private boolean enabled;
        private boolean discovered;
        private String[] prerequisites;
        private String[] requiredServices;

        ExtensionDef(String string, String string2, boolean bl, String string3, String string4) {
            this.extensionName = ConsoleExtensionManager.this.computeExtensionName(string2);
            this.moduleName = string;
            this.name = this.moduleName + "." + this.extensionName;
            this.path = string2;
            this.setEnabled(bl);
            this.setRequiredServices(string3);
            this.setPrerequisites(string4);
            this.setDiscovered(false);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDiscovered() {
            return this.discovered;
        }

        public String getName() {
            return this.name;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getPath() {
            return this.path;
        }

        public File getFile() {
            return new File(this.getPath());
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setDiscovered(boolean bl) {
            this.discovered = bl;
        }

        public void setRequiredServices(String string) {
            this.requiredServices = string != null ? string.split(",") : null;
        }

        public String[] getRequiredServices() {
            if (this.requiredServices == null) {
                return new String[0];
            }
            return this.requiredServices;
        }

        public String getRequiredServiceList() {
            if (this.requiredServices != null) {
                return this.getStringArrayString(this.requiredServices);
            }
            return null;
        }

        public void setPrerequisites(String string) {
            this.prerequisites = string != null ? string.split(",") : null;
        }

        public String[] getPrerequisites() {
            if (this.prerequisites == null) {
                return new String[0];
            }
            return this.prerequisites;
        }

        public String getPrerequisiteList() {
            if (this.prerequisites != null) {
                return this.getStringArrayString(this.prerequisites);
            }
            return null;
        }

        private String getStringArrayString(String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    if (i + 1 == stringArray.length) continue;
                    stringBuffer.append(", ");
                }
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return super.toString() + ",\n        name=" + this.name + ",\n        extensionName=" + this.extensionName + ",\n        moduleName=" + this.moduleName + ",\n        path=" + this.path + ",\n        enabled=" + this.enabled + ",\n        discovered=" + this.discovered + ",\n        prerequisites=" + this.getStringArrayString(this.prerequisites) + ",\n        requiredServices=" + this.getStringArrayString(this.requiredServices);
        }
    }
}

