/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class ContextVersionManager {
    private static final String DEFAULT_VERSION_ID = "weblogic.default_version";
    private final String appName;
    private String contextPath;
    private WebAppServletContext activeServletContext;
    private WebAppServletContext activeAdminModeServletContext;
    private Map versionIdWASCMap;
    private final Map sessionIdWASCMap;
    private boolean isOld = false;
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");

    ContextVersionManager(ContextVersionManager contextVersionManager, String string, String string2) {
        this.contextPath = string2;
        if (contextVersionManager == null) {
            this.versionIdWASCMap = new HashMap();
            this.sessionIdWASCMap = new Hashtable();
            this.appName = string;
        } else {
            this.versionIdWASCMap = new HashMap(contextVersionManager.versionIdWASCMap);
            this.sessionIdWASCMap = contextVersionManager.sessionIdWASCMap;
            this.activeServletContext = contextVersionManager.activeServletContext;
            this.activeAdminModeServletContext = contextVersionManager.activeAdminModeServletContext;
            this.appName = contextVersionManager.appName;
            contextVersionManager.isOld = true;
        }
    }

    public String toString() {
        return "CVM[appName=" + this.appName + ", contextPath=" + this.contextPath + ", activeServletContext={" + this.activeServletContext + "}, activeAdminServletContext={" + this.activeAdminModeServletContext + "}, versionIdWASCMap.size=" + this.versionIdWASCMap.size() + ", sessionIdWASCMap.size=" + this.sessionIdWASCMap.size() + "]";
    }

    public boolean isVersioned() {
        if (this.activeServletContext != null) {
            return this.activeServletContext.getVersionId() != null;
        }
        if (this.activeAdminModeServletContext != null) {
            return this.activeAdminModeServletContext.getVersionId() != null;
        }
        if (!this.versionIdWASCMap.isEmpty()) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)this.versionIdWASCMap.values().iterator().next();
            return webAppServletContext.getVersionId() != null;
        }
        return false;
    }

    String getAppName() {
        return this.appName;
    }

    String getContextPath() {
        return this.contextPath;
    }

    void setDefaultContext() {
        this.contextPath = "";
    }

    public void putContext(String string, WebAppServletContext webAppServletContext) {
        if (string == null) {
            this.versionIdWASCMap.put(DEFAULT_VERSION_ID, webAppServletContext);
        } else {
            this.versionIdWASCMap.put(string, webAppServletContext);
        }
        this.delaySetActive(webAppServletContext);
    }

    public void removeContext(String string) {
        WebAppServletContext webAppServletContext = null;
        HashMap hashMap = new HashMap(this.versionIdWASCMap);
        webAppServletContext = string == null ? (WebAppServletContext)hashMap.remove(DEFAULT_VERSION_ID) : (WebAppServletContext)hashMap.remove(string);
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("CVM.removeContext: version=" + string + ", CVM=" + this));
        }
        this.versionIdWASCMap = hashMap;
        this.unsetActive(webAppServletContext);
    }

    public WebAppServletContext getContext(String string) {
        if (string == null) {
            if (this.activeServletContext != null) {
                return this.activeServletContext;
            }
            return (WebAppServletContext)this.versionIdWASCMap.get(DEFAULT_VERSION_ID);
        }
        return (WebAppServletContext)this.versionIdWASCMap.get(string);
    }

    public WebAppServletContext getActiveContext(boolean bl) {
        if (bl) {
            return this.activeAdminModeServletContext;
        }
        return this.activeServletContext;
    }

    public WebAppServletContext getCurrentOrActiveContext(boolean bl) {
        return this.getContext(ApplicationVersionUtils.getCurrentVersionId(this.appName));
    }

    public WebAppServletContext getContext() {
        Iterator iterator = this.getServletContexts().iterator();
        if (iterator.hasNext()) {
            return (WebAppServletContext)iterator.next();
        }
        return null;
    }

    public WebAppServletContext getContext(boolean bl) {
        Iterator iterator = this.getServletContexts(bl);
        if (iterator.hasNext()) {
            return (WebAppServletContext)iterator.next();
        }
        WebAppServletContext webAppServletContext = this.getContext();
        if (webAppServletContext != null && (webAppServletContext.isInternalApp() || webAppServletContext.getConfigManager().isRequireAdminTraffic())) {
            return webAppServletContext;
        }
        return null;
    }

    public Collection getServletContexts() {
        return this.versionIdWASCMap.values();
    }

    public Iterator getServletContexts(boolean bl) {
        return new AdminModeAwareIterator(bl);
    }

    public void putContextForSession(String string, WebAppServletContext webAppServletContext) {
        this.sessionIdWASCMap.put(string, webAppServletContext);
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("CVM.putServletContextForSession(sessionID=" + string + ", WASC=" + webAppServletContext + ")"));
        }
    }

    public void removeContextForSession(String string) {
        this.sessionIdWASCMap.remove(string);
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("CVM.removeServletContextForSession(sessionID=" + string + ")"));
        }
    }

    public WebAppServletContext getContextForSession(String string) {
        return (WebAppServletContext)this.sessionIdWASCMap.get(string);
    }

    public WorkManager getWorkManager(boolean bl) {
        WebAppServletContext webAppServletContext = this.getActiveContext(bl);
        if (webAppServletContext != null) {
            return webAppServletContext.getConfigManager().getWorkManager();
        }
        return WorkManagerFactory.getInstance().getDefault();
    }

    private void setActive(String string, boolean bl) {
        this.setActive(this.getContext(string), bl);
    }

    private void setActive(WebAppServletContext webAppServletContext, boolean bl) {
        if (webAppServletContext == null) {
            return;
        }
        if (bl) {
            this.activeAdminModeServletContext = webAppServletContext;
        } else {
            this.activeServletContext = webAppServletContext;
        }
        webAppServletContext.setAdminMode(bl);
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("CVM.setActive: version=" + (webAppServletContext == null ? null : webAppServletContext.getVersionId()) + ", admin=" + bl + ", CVM=" + this));
        }
    }

    private void delaySetActive(WebAppServletContext webAppServletContext) {
        ApplicationRuntimeMBean applicationRuntimeMBean = ApplicationVersionUtils.getCurrentApplicationRuntime();
        if (applicationRuntimeMBean == null) {
            this.setActive(webAppServletContext, false);
        } else {
            applicationRuntimeMBean.addPropertyChangeListener(new StateChangeListener(webAppServletContext));
            if (DEBUG_APP_VERSION.isEnabled()) {
                HTTPLogger.logDebug((String)("CVM.delaySetActive: version=" + webAppServletContext.getVersionId() + ", CVM=" + this));
            }
        }
    }

    private void unsetActive(WebAppServletContext webAppServletContext) {
        if (webAppServletContext == null) {
            return;
        }
        if (webAppServletContext == this.activeServletContext) {
            this.activeServletContext = null;
        } else if (webAppServletContext == this.activeAdminModeServletContext) {
            this.activeAdminModeServletContext = null;
            webAppServletContext.setAdminMode(false);
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("CVM.unsetActive: app=" + this.appName + ", version=" + (webAppServletContext == null ? null : webAppServletContext.getVersionId()) + ", CVM=" + this));
        }
    }

    private void adminTransition(WebAppServletContext webAppServletContext, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            if (webAppServletContext == this.activeAdminModeServletContext) {
                this.activeAdminModeServletContext = null;
                this.activeServletContext = webAppServletContext;
            }
        } else if (!bl && bl2 && webAppServletContext == this.activeServletContext) {
            this.activeServletContext = null;
            this.activeAdminModeServletContext = webAppServletContext;
        }
        webAppServletContext.setAdminMode(bl2);
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("CVM.adminTransition: app=" + this.appName + ", version=" + webAppServletContext.getVersionId() + ", admin=" + bl2));
        }
    }

    boolean isOld() {
        return this.isOld;
    }

    private final class AdminModeAwareIterator
    implements Iterator {
        Iterator iter;
        boolean isAdminMode;
        WebAppServletContext nextContext;

        private AdminModeAwareIterator(boolean bl) {
            this.isAdminMode = bl;
            this.iter = ContextVersionManager.this.versionIdWASCMap.values().iterator();
        }

        public void remove() {
            this.iter.remove();
        }

        public boolean hasNext() {
            while (this.iter.hasNext()) {
                this.nextContext = (WebAppServletContext)this.iter.next();
                if (this.nextContext.isAdminMode() != this.isAdminMode) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            return this.nextContext;
        }
    }

    private final class StateChangeListener
    implements PropertyChangeListener {
        private WebAppServletContext ctx;

        private StateChangeListener(WebAppServletContext webAppServletContext) {
            this.ctx = webAppServletContext;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block16: {
                if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("ActiveVersionState")) {
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object instanceof Integer && object2 instanceof Integer) {
                        int n = (Integer)object;
                        int n2 = (Integer)object2;
                        if (DEBUG_APP_VERSION.isEnabled()) {
                            HTTPLogger.logDebug((String)("+++ StateChange oldState=" + n + ", newState=" + n2));
                        }
                        ApplicationRuntimeMBean applicationRuntimeMBean = (ApplicationRuntimeMBean)propertyChangeEvent.getSource();
                        String string = applicationRuntimeMBean.getApplicationVersion();
                        if (n2 == 2 && applicationRuntimeMBean.getApplicationName().equals(ContextVersionManager.this.appName) && string != null && !string.equals(this.ctx.getVersionId())) {
                            block15: {
                                ContextVersionManager.this.setActive(applicationRuntimeMBean.getApplicationVersion(), n2 == 1);
                                try {
                                    ((RuntimeMBeanDelegate)applicationRuntimeMBean).removePropertyChangeListener((PropertyChangeListener)this);
                                }
                                catch (Throwable throwable) {
                                    if (!DEBUG_APP_VERSION.isEnabled()) break block15;
                                    HTTPLogger.logDebug((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                                }
                            }
                            return;
                        }
                        if (n == n2) {
                            return;
                        }
                        if (this.isActiveState(n2)) {
                            if (n == 0) {
                                ContextVersionManager.this.setActive(this.ctx, n2 == 1);
                            } else if (this.isActiveState(n)) {
                                ContextVersionManager.this.adminTransition(this.ctx, n == 1, n2 == 1);
                            }
                        } else if (this.isActiveState(n)) {
                            ContextVersionManager.this.unsetActive(this.ctx);
                            try {
                                ((RuntimeMBeanDelegate)applicationRuntimeMBean).removePropertyChangeListener((PropertyChangeListener)this);
                            }
                            catch (Throwable throwable) {
                                if (!DEBUG_APP_VERSION.isEnabled()) break block16;
                                HTTPLogger.logDebug((String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                            }
                        }
                    }
                }
            }
        }

        private boolean isActiveState(int n) {
            return n == 2 || n == 1;
        }
    }
}

