/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import weblogic.servlet.internal.MalformedCookieHeaderException;
import weblogic.utils.http.HttpParsing;

public final class CookieParser {
    private String path;
    private String comment;
    private String domain;
    private boolean secure;
    private int version = 0;
    private int maxAge = -1;
    private final char[] buf;
    private final int len;
    private final String bufAsString;
    private final List cookies = new ArrayList();
    private static boolean allowCommasInNetscapeCookie;
    private static boolean stripQuotedValues;
    private static final SimpleDateFormat[] expiresFormats;

    public static Iterator parseCookies(String string) throws MalformedCookieHeaderException {
        CookieParser cookieParser = new CookieParser(string);
        cookieParser.parse();
        return cookieParser.cookies.iterator();
    }

    private CookieParser(String string) {
        String string2 = string.trim();
        this.bufAsString = string2.toLowerCase();
        this.buf = string2.toCharArray();
        this.len = this.buf.length;
    }

    private void parse() throws MalformedCookieHeaderException {
        this.getVersion();
        if (this.version == 0) {
            this.parseNetscapeCookie();
        } else {
            this.parseRFC2109Cookie();
        }
    }

    private void parseNetscapeCookie() throws MalformedCookieHeaderException {
        this.path = this.getAttribute("path");
        this.domain = this.getAttribute("domain");
        if (this.indexAttributeName("secure") != -1) {
            this.secure = true;
        }
        this.getExpires();
        String string = null;
        String string2 = null;
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n2 = this.nextNonWS(n2)) != -1) {
            String string3;
            int n4;
            int n5 = this.nextIndex(';', n2);
            n3 = this.nextIndex('=', n2);
            if (n3 == -1) {
                n4 = n5 > 0 ? n5 : this.len;
                string3 = new String(this.buf, n2, n4 - n2);
                n2 += string3.length() + 1;
                string3 = string3.trim();
                this.addCookie(string3, "");
                continue;
            }
            if (n5 != -1 && n3 > n5) {
                String string4 = new String(this.buf, n2, n5 - n2);
                n2 += string4.length() + 1;
                string4 = string4.trim();
                this.addCookie(string4, "");
                continue;
            }
            n4 = allowCommasInNetscapeCookie ? this.nextIndex(';', ',', n3) : this.nextIndex(';', n3);
            if (n4 == -1) {
                n4 = this.len;
            }
            string3 = new String(this.buf, n2, n3 - n2);
            for (int i = n2; i < n3; ++i) {
                if (!HttpParsing.isNetscapeSpecial((char)this.buf[i])) continue;
                string = new String(this.buf);
                string2 = string3;
                c = this.buf[i];
                n = i;
            }
            boolean bl = false;
            String string5 = new String(this.buf, ++n3, n4 - n3);
            if (n3 < this.len && this.buf[n3] == '\"' && n4 - 1 > n3 && this.buf[n4 - 1] == '\"') {
                bl = true;
            }
            if (!string3.equalsIgnoreCase("expires") && !bl) {
                for (int i = n3; i < n4; ++i) {
                    if (!HttpParsing.isNetscapeSpecial((char)this.buf[i])) continue;
                    string = new String(this.buf);
                    string2 = string3;
                    c = this.buf[i];
                    n = i;
                }
            }
            if (string3 != string2) {
                this.addCookie(string3, this.unquote(string5));
            }
            for (n2 = n4 + 1; n2 < this.len && HttpParsing.isSpace((char)this.buf[n2]); ++n2) {
            }
        }
        if (string != null) {
            throw new MalformedCookieHeaderException("In cookie '" + string + "' character '" + c + "' at position " + n + " is illegal");
        }
    }

    private void getExpires() throws MalformedCookieHeaderException {
        String string = this.getAttribute("Expires", true);
        if (string == null) {
            return;
        }
        try {
            Date date = null;
            block7: for (int i = 0; i < expiresFormats.length; ++i) {
                try {
                    for (int j = 0; j < 3; ++j) {
                        try {
                            date = expiresFormats[i].parse(string);
                            break block7;
                        }
                        catch (ParseException parseException) {
                            throw parseException;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    break;
                }
                catch (ParseException parseException) {
                    if (i != expiresFormats.length - 1) continue;
                    throw parseException;
                }
            }
            if (date == null) {
                throw new ParseException("Null date returned from parser", 0);
            }
            long l = date.getTime();
            long l2 = new Date().getTime();
            this.maxAge = l2 < l ? (int)((l - l2) / 1000L) : -1;
        }
        catch (ParseException parseException) {
            throw new MalformedCookieHeaderException("Expires header '" + string + "' in cookie '" + new String(this.buf) + "' is invalid, nested " + parseException.toString());
        }
    }

    private void parseRFC2109Cookie() throws MalformedCookieHeaderException {
        this.comment = this.getAttribute("$Comment");
        this.path = this.getAttribute("$Path");
        this.domain = this.getAttribute("$Domain");
        if (this.indexAttributeName("$Secure") != -1 || this.indexAttributeName("Secure") != -1) {
            this.secure = true;
        }
        this.getMaxAge();
        int n = 0;
        MalformedCookieHeaderException malformedCookieHeaderException = null;
        boolean bl = true;
        while ((n = this.nextNonWS(n)) != -1) {
            String string = null;
            String string2 = null;
            int n2 = this.nextIndex('=', n);
            int n3 = this.nextIndex(';', ',', n);
            if (n2 < 0 || n3 != -1 && n3 < n2) {
                int n4 = n3 != -1 && n3 < n2 ? n3 : (n2 >= 0 ? n2 : this.len);
                string = new String(this.buf, n, n4 - n).trim();
                n = n4 + 1;
            } else {
                string = new String(this.buf, n, n2 - n);
                try {
                    string2 = this.getValueString(string, ++n2, true);
                }
                catch (MalformedCookieHeaderException malformedCookieHeaderException2) {
                    malformedCookieHeaderException = malformedCookieHeaderException2;
                    bl = false;
                }
                n += string.length();
                n += 2;
                if (string2 != null) {
                    n += string2.length();
                }
                if (n2 < this.len && this.buf[n2] == '\"') {
                    n += 2;
                }
                string = string.trim();
            }
            if (string.equalsIgnoreCase("$Version") || string.equalsIgnoreCase("$Path") || string.equalsIgnoreCase("$Domain")) continue;
            if (bl) {
                this.addCookie(string, string2);
            }
            bl = true;
        }
        if (malformedCookieHeaderException != null) {
            throw malformedCookieHeaderException;
        }
    }

    private void getMaxAge() throws MalformedCookieHeaderException {
        String string = this.getAttribute("Max-Age");
        if (string != null) {
            try {
                this.maxAge = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedCookieHeaderException("Max-Age header '" + string + "' in cookie '" + new String(this.buf) + "' is invalid, nested " + numberFormatException);
            }
        }
    }

    private String getAttribute(String string) throws MalformedCookieHeaderException {
        return this.getAttribute(string, false);
    }

    private String getAttribute(String string, boolean bl) throws MalformedCookieHeaderException {
        int n = this.indexAttributeName(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.nextIndex('=', n += string.length());
        int n3 = this.version > 0 ? this.nextIndex(';', ',', n) : this.nextIndex(';', n);
        if (n2 < 0 || n3 != -1 && n3 < n2) {
            return null;
        }
        return this.getValueString(string, ++n2, bl);
    }

    private String getValueString(String string, int n, boolean bl) throws MalformedCookieHeaderException {
        if (n >= this.len) {
            return "";
        }
        if (this.version > 0 && this.buf[n] == '\"') {
            int n2;
            if ((n2 = this.nextIndex('\"', ++n)) == -1) {
                throw new MalformedCookieHeaderException("In cookie '" + new String(this.buf) + "' quote at position " + (n - 1) + " is unbalanced");
            }
            return new String(this.buf, n, n2 - n);
        }
        int n3 = allowCommasInNetscapeCookie ? this.nextIndex(';', ',', n) : this.nextIndex(';', n);
        if (n3 == -1) {
            n3 = this.len;
        }
        if (this.version == 0 && !bl) {
            for (int i = n; i < n3; ++i) {
                if ("expires".equalsIgnoreCase(string) || !HttpParsing.isWS((char)this.buf[i])) continue;
                throw new MalformedCookieHeaderException("In cookie '" + new String(this.buf) + "' the value of '" + string + "' may not contain white-space");
            }
        }
        return new String(this.buf, n, n3 - n);
    }

    private int nextNonWS(int n) {
        while (n < this.len) {
            if (!HttpParsing.isWS((char)this.buf[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int nextIndex(char c, int n) {
        for (int i = n; i < this.len; ++i) {
            if (c != this.buf[i]) continue;
            return i;
        }
        return -1;
    }

    private int nextIndex(char c, char c2, int n) {
        for (int i = n; i < this.len; ++i) {
            if (c != this.buf[i] && c2 != this.buf[i]) continue;
            return i;
        }
        return -1;
    }

    private int indexString(int n, String string) {
        return this.bufAsString.indexOf(string.toLowerCase(), n);
    }

    /*
     * Unable to fully structure code
     */
    private int indexAttributeName(String var1_1) {
        var2_2 = -1;
        block0: while (true) {
            ++var2_2;
            if ((var2_2 = this.indexString(var2_2, var1_1)) == -1) break;
            if (var2_2 > 0 && !HttpParsing.isWS((char)this.buf[var2_2 - 1])) continue;
            if (var2_2 + var1_1.length() == this.len) {
                return var2_2;
            }
            var3_3 = var2_2 + var1_1.length();
            while (true) {
                if (var3_3 >= this.len) continue block0;
                if (this.version > 0 ? this.buf[var3_3] == '=' || this.buf[var3_3] == ';' || this.buf[var3_3] == ',' : this.buf[var3_3] == '=' || this.buf[var3_3] == ';') {
                    return var2_2;
                }
                if (HttpParsing.isWS((char)this.buf[var3_3])) ** break;
                continue block0;
                ++var3_3;
            }
            break;
        }
        return -1;
    }

    private void addCookie(String string, String string2) {
        try {
            Cookie cookie = new Cookie(string, string2);
            cookie.setVersion(this.version);
            cookie.setSecure(this.secure);
            if (this.path != null) {
                cookie.setPath(this.path);
            }
            if (this.comment != null) {
                cookie.setComment(this.comment);
            }
            if (this.domain != null) {
                cookie.setDomain(this.domain);
            }
            cookie.setMaxAge(this.maxAge);
            this.cookies.add(cookie);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static String formatCookie(Cookie cookie, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(85);
        stringBuilder.append(cookie.getName());
        switch (cookie.getVersion()) {
            case 0: {
                CookieParser.formatNetscapeCookie(stringBuilder, cookie);
                break;
            }
            default: {
                CookieParser.formatRFC2109Cookie(cookie, stringBuilder);
            }
        }
        if (bl) {
            stringBuilder.append("; HttpOnly");
        }
        return stringBuilder.toString();
    }

    private static void formatNetscapeCookie(StringBuilder stringBuilder, Cookie cookie) {
        Object object;
        int n;
        stringBuilder.append('=');
        stringBuilder.append(cookie.getValue());
        String string = cookie.getDomain();
        if (string != null) {
            stringBuilder.append("; domain=").append(string);
        }
        if ((n = cookie.getMaxAge()) >= 0) {
            if (n == 0) {
                object = new Date(3600000L);
            } else {
                long l = (long)n * 1000L;
                object = new Date(System.currentTimeMillis() + l);
            }
            for (int i = 0; i < 3; ++i) {
                try {
                    String string2 = expiresFormats[0].format((Date)object);
                    stringBuilder.append("; expires=").append(string2);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        if ((object = cookie.getPath()) != null) {
            stringBuilder.append("; path=").append((String)object);
        }
        if (cookie.getSecure()) {
            stringBuilder.append("; secure");
        }
    }

    private static void formatRFC2109Cookie(Cookie cookie, StringBuilder stringBuilder) {
        int n;
        String string;
        String string2;
        String string3 = cookie.getValue();
        if (string3 != null) {
            stringBuilder.append('=');
            CookieParser.appendValue(stringBuilder, string3);
        }
        if ((string2 = cookie.getComment()) != null) {
            CookieParser.appendValue(stringBuilder.append("; Comment="), string2);
        }
        stringBuilder.append("; Version=1");
        String string4 = cookie.getDomain();
        if (string4 != null) {
            CookieParser.appendValue(stringBuilder.append("; Domain="), string4);
        }
        if ((string = cookie.getPath()) != null) {
            CookieParser.appendValue(stringBuilder.append("; Path="), string);
        }
        if ((n = cookie.getMaxAge()) >= 0) {
            stringBuilder.append("; Max-Age=").append(n);
        }
        if (cookie.getSecure()) {
            stringBuilder.append("; Secure");
        }
    }

    private void getVersion() {
        this.version = 0;
        int n = this.indexAttributeName("$Version");
        if (n == -1) {
            return;
        }
        int n2 = this.nextIndex('=', n);
        if (n2 == -1 || n2 == this.len - 1) {
            return;
        }
        ++n2;
        try {
            while (HttpParsing.isWS((char)this.buf[n2])) {
                if (++n2 != this.len) continue;
                return;
            }
            if (this.buf[n2] == '\"' && ++n2 == this.len) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        int n3 = n2;
        while (n2 < this.len && HttpParsing.isDigit((char)this.buf[n2])) {
            ++n2;
        }
        if (n2 == n3) {
            return;
        }
        if (n2 - n3 == 1) {
            this.version = this.buf[n3] - 48;
            return;
        }
        try {
            this.version = Integer.parseInt(new String(this.buf, n3, n2 - n3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void appendValue(StringBuilder stringBuilder, String string) {
        if (HttpParsing.isTokenClean((String)string) || HttpParsing.isQuoted((String)string)) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append("\"").append(string).append("\"");
        }
    }

    private String unquote(String string) {
        if (!HttpParsing.isQuoted((String)string) || !stripQuotedValues) {
            return string;
        }
        return string.trim().substring(1, string.length() - 1);
    }

    static {
        String string = System.getProperty("weblogic.allowCommasInNetscapeCookie");
        if (string != null && "true".equalsIgnoreCase(string)) {
            allowCommasInNetscapeCookie = true;
        }
        stripQuotedValues = Boolean.getBoolean("weblogic.cookies.stripQuotedValues");
        expiresFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zz", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zz", Locale.US), new SimpleDateFormat("EEEE, dd-MMM-yyyy HH:mm:ss zz", Locale.US), new SimpleDateFormat("EEEE, dd MMM yyyy HH:mm:ss zz", Locale.US)};
        for (int i = 0; i < expiresFormats.length; ++i) {
            expiresFormats[i].setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }
}

