/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import weblogic.servlet.internal.ChunkOutput;
import weblogic.servlet.internal.WLOutputStreamWriter;

public class DelegateChunkWriter
extends ChunkOutput {
    private static final boolean DEBUG = false;
    protected Writer writer;
    private ServletResponse response;
    private boolean autoFlush;
    private String enc;

    public DelegateChunkWriter(ServletResponse servletResponse, boolean bl, int n) throws IOException {
        this.response = servletResponse;
        this.autoFlush = bl;
    }

    protected DelegateChunkWriter(Writer writer) {
        this.writer = writer;
    }

    public String getEncoding() {
        return this.response != null ? this.response.getCharacterEncoding() : null;
    }

    public void reset() {
    }

    public void release() {
    }

    public int getTotal() {
        return 0;
    }

    public int getCount() {
        return 0;
    }

    public int getBufferSize() {
        return this.response != null ? this.response.getBufferSize() : 0;
    }

    public void setBufferSize(int n) {
    }

    public void setStickyBufferSize(boolean bl) {
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean bl) {
        this.autoFlush = bl;
    }

    public boolean isChunking() {
        return false;
    }

    public void setChunking(boolean bl) {
    }

    public void write(int n) throws IOException {
        this.getWriter().write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.response != null) {
            this.response.getOutputStream().write(byArray, n, n2);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.getWriter().write(cArray, n, n2);
    }

    public void print(String string) throws IOException {
        if (string != null) {
            this.getWriter().write(string, 0, string.length());
        }
    }

    public void commit() throws IOException {
    }

    public void clearBuffer() {
        if (this.response != null) {
            this.response.resetBuffer();
        }
    }

    public void flush() throws IOException {
        this.getWriter().flush();
        if (this.response != null) {
            this.response.flushBuffer();
        }
    }

    public void writeStream(InputStream inputStream, int n, int n2) throws IOException {
    }

    protected Writer getWriter() throws IOException {
        String string = this.response.getCharacterEncoding();
        if (this.writer == null || string != null && !this.enc.equalsIgnoreCase(string)) {
            ServletOutputStream servletOutputStream = this.response.getOutputStream();
            this.enc = string;
            if (this.enc == null) {
                this.enc = "ISO-8859-1";
            }
            this.writer = new WLOutputStreamWriter((OutputStream)servletOutputStream, this.enc);
        }
        if (this.writer == null) {
            throw new IOException("Writer already closed ");
        }
        return this.writer;
    }

    static void p(String string) {
        System.out.println("[DelegateChunkWriter]" + string);
    }

    public static class DelegateJspChunkWriter
    extends DelegateChunkWriter {
        public DelegateJspChunkWriter(Writer writer) {
            super(writer);
        }

        protected Writer getWriter() throws IOException {
            return this.writer;
        }

        public void clearBuffer() {
        }

        public int getBufferSize() {
            return 0;
        }

        public int getRemaining() {
            return 0;
        }

        public String getEncoding() {
            return null;
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void writeStream(InputStream inputStream, int n, int n2) throws IOException {
            throw new AssertionError((Object)"writeStream called ");
        }
    }
}

