/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import weblogic.application.library.CachableLibMetadataEntry;
import weblogic.application.library.LibraryMetadataCache;
import weblogic.application.library.LibraryProcessingException;
import weblogic.servlet.internal.WarLibraryDefinition;

public abstract class DescriptorCacheEntry
implements CachableLibMetadataEntry {
    protected WarLibraryDefinition library;

    public DescriptorCacheEntry(WarLibraryDefinition warLibraryDefinition) {
        this.library = warLibraryDefinition;
    }

    public File getLocation() {
        return this.library.getLibTempDir();
    }

    public Object getCachableObject() throws LibraryProcessingException {
        File file = LibraryMetadataCache.getCacheDir(this);
        List list = this.getResourceLocations();
        return new DescriptorCachableObject(file, list);
    }

    protected abstract List getResourceLocations() throws LibraryProcessingException;

    public boolean isStale(long l) {
        return !this.library.isArchived();
    }

    static class DescriptorCachableObject
    implements Serializable {
        private List resLocations;
        private File cacheBaseDir;

        public DescriptorCachableObject(File file, List list) {
            this.cacheBaseDir = file;
            this.resLocations = list;
        }

        public File getCacheBaseDir() {
            return this.cacheBaseDir;
        }

        public List getResourceLocation() {
            return this.resLocations;
        }
    }
}

