/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.security.PrivilegedAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import weblogic.j2ee.descriptor.ErrorPageBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.ErrorMessages;
import weblogic.servlet.internal.ForwardAction;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.security.Utils;
import weblogic.servlet.security.internal.SecurityModule;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class ErrorManager {
    public static final String ERROR_PAGE = "weblogic.servlet.errorPage";
    private final WebAppServletContext context;
    private final String[] statusErrors = new String[110];
    private final ConcurrentHashMap exceptionMap = new ConcurrentHashMap();

    ErrorManager(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
    }

    String[] getStatusErrors() {
        return this.statusErrors;
    }

    private void registerError(int n, String string) {
        try {
            int n2 = n - 400;
            if (!WebAppServletContext.isAbsoluteURL(string)) {
                string = HttpParsing.ensureStartingSlash((String)string);
            }
            this.statusErrors[n2] = string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HTTPLogger.logUnsupportedErrorCode((String)this.context.getLogContext(), (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    private void registerException(String string, String string2) {
        try {
            Class<?> clazz = this.context.getServletClassLoader().loadClass(string);
            if (!WebAppServletContext.isAbsoluteURL(string2)) {
                string2 = HttpParsing.ensureStartingSlash((String)string2);
            }
            this.exceptionMap.put(clazz, (Object)string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            HTTPLogger.logInvalidExceptionType((String)string, (Throwable)classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerErrorPages(WebAppBean webAppBean) {
        if (webAppBean == null) {
            return;
        }
        ErrorPageBean[] errorPageBeanArray = webAppBean.getErrorPages();
        if (errorPageBeanArray != null) {
            for (int i = 0; i < errorPageBeanArray.length; ++i) {
                ErrorPageBean errorPageBean = errorPageBeanArray[i];
                int n = errorPageBean.getErrorCode();
                String string = errorPageBean.getExceptionType();
                if (n > 0) {
                    this.registerError(n, errorPageBean.getLocation());
                    continue;
                }
                if (string == null) continue;
                ErrorManager errorManager = this;
                synchronized (errorManager) {
                    this.registerException(string, errorPageBean.getLocation());
                    continue;
                }
            }
        }
    }

    public String getErrorLocation(String string) {
        try {
            int n = Integer.parseInt(string) - 400;
            return this.statusErrors[n];
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public String getExceptionLocation(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (this.exceptionMap.isEmpty()) {
            return null;
        }
        String string = this.findExceptionLocation(throwable);
        if (string != null) {
            return string;
        }
        if (throwable instanceof ServletException) {
            throwable = ((ServletException)throwable).getRootCause();
            return this.findExceptionLocation(throwable);
        }
        return null;
    }

    void handleException(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, Throwable throwable) throws IOException {
        Object object;
        int n;
        String string;
        if (throwable instanceof NestedRuntimeException) {
            throwable = ((NestedRuntimeException)throwable).getNestedException();
        }
        if ((string = this.getExceptionLocation(throwable)) != null) {
            if (WebAppServletContext.isAbsoluteURL(string)) {
                servletResponseImpl.sendRedirect(string);
                return;
            }
            servletResponseImpl.reset();
            RequestDispatcher requestDispatcher = this.context.getRequestDispatcher(string, 3);
            if (requestDispatcher != null) {
                ForwardAction forwardAction;
                Throwable throwable2;
                servletResponseImpl.setStatus(500);
                this.setErrorAttributes(servletRequestImpl, servletRequestImpl.getInputHelper().getNormalizedURI(), throwable);
                AuthenticatedSubject authenticatedSubject = SecurityModule.getCurrentUser(this.context.getServer(), servletRequestImpl);
                if (authenticatedSubject == null) {
                    authenticatedSubject = SubjectUtils.getAnonymousSubject();
                }
                if ((throwable2 = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)(forwardAction = new ForwardAction(requestDispatcher, (ServletRequest)servletRequestImpl, (ServletResponse)servletResponseImpl)))) != null) {
                    if (throwable2 instanceof IOException) {
                        throw (IOException)throwable2;
                    }
                    servletResponseImpl.sendError(500);
                    HTTPLogger.logSendError((String)this.context.getLogContext(), (Throwable)throwable2);
                }
                return;
            }
        }
        try {
            throw throwable;
        }
        catch (UnavailableException unavailableException) {
            n = 503;
        }
        catch (ServletException servletException) {
            n = 500;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            n = 408;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable3) {
            n = !"Internal Servlet Session Process Error Found!".equals(throwable3.getMessage()) ? 500 : -900;
        }
        if ((!HttpServer.isProductionModeEnabled() || HTTPDebugLogger.isEnabled()) && n != -900) {
            object = (Throwable)servletRequestImpl.getAttribute("javax.servlet.error.exception");
            if (object == null) {
                object = throwable;
            }
            String string2 = this.throwable2StackTraceWithXSSEncodedMessage((Throwable)object);
            string2 = "<pre>" + string2 + "</pre>";
            string2 = ErrorMessages.getErrorPage(n, string2);
            servletResponseImpl.sendError(n, string2);
        } else if (n != -900) {
            servletResponseImpl.sendError(n);
        } else {
            object = "<H3>This server only licensed to concurrently serve " + SessionData.getCurrProcessedSessionsCount() + " sessions. Please try again later!</H3>";
            object = ErrorMessages.getErrorPage(n, (String)object);
            servletResponseImpl.sendError(500, (String)object);
        }
    }

    public void setErrorAttributes(HttpServletRequest httpServletRequest, String string, Throwable throwable) {
        Throwable throwable2;
        ServletStubImpl servletStubImpl = null;
        String string2 = this.context.getContextPath();
        String string3 = string2 != null && !this.context.isDefaultContext() && string.startsWith(string2) ? string.substring(string2.length()) : string;
        if (string3 != null) {
            servletStubImpl = this.context.getServletStub(string3);
        }
        if (servletStubImpl != null) {
            httpServletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)servletStubImpl.getServletName());
        }
        if ((throwable2 = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception")) != null) {
            throwable = throwable2;
        }
        httpServletRequest.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
        httpServletRequest.setAttribute("javax.servlet.error.exception", (Object)throwable);
        httpServletRequest.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
        if (httpServletRequest.getAttribute("javax.servlet.error.request_uri") == null) {
            httpServletRequest.setAttribute("javax.servlet.error.request_uri", (Object)string);
        }
        if (httpServletRequest.getAttribute("javax.servlet.jsp.jspException") == null) {
            httpServletRequest.setAttribute("javax.servlet.jsp.jspException", (Object)throwable);
        }
        httpServletRequest.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
    }

    private String throwable2StackTraceWithXSSEncodedMessage(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)unsyncByteArrayOutputStream);
        printStream.println(Utils.encodeXSS(throwable.toString()));
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            printStream.println("\tat " + stackTraceElementArray[i]);
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            this.printStackTraceAsCause(throwable2, printStream, stackTraceElementArray);
        }
        return unsyncByteArrayOutputStream.toString();
    }

    private void printStackTraceAsCause(Throwable throwable, PrintStream printStream, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable2;
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + Utils.encodeXSS(throwable.toString()));
        for (int i = 0; i <= n; ++i) {
            printStream.println("\tat " + stackTraceElementArray2[i]);
        }
        if (n2 != 0) {
            printStream.println("\t... " + n2 + " more");
        }
        if ((throwable2 = throwable.getCause()) != null) {
            this.printStackTraceAsCause(throwable2, printStream, stackTraceElementArray2);
        }
    }

    private String findExceptionLocation(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        String string = null;
        for (Class<?> clazz = throwable.getClass(); clazz != null && (string = (String)this.exceptionMap.get(clazz)) == null; clazz = clazz.getSuperclass()) {
        }
        return string;
    }
}

