/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import weblogic.j2ee.descriptor.ListenerBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.WebLogicServletContextListener;
import weblogic.servlet.internal.AttributeWrapper;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SharedSessionData;

public final class EventsManager {
    private final List wlCtxListeners = new ArrayList();
    private final List ctxListeners = new ArrayList();
    private final List ctxAttrListeners = new ArrayList();
    private final List sessListeners = new ArrayList();
    private final List sessAttrListeners = new ArrayList();
    private final List requestListeners = new ArrayList();
    private final List requestAttrListeners = new ArrayList();
    private final WebAppServletContext context;
    private boolean hasRequestListeners = false;
    private RegistrationListener regListener;
    private static final String[] internalListeners = new String[]{"weblogic.wsee.deploy.ServletDeployListener", "weblogic.security.internal.SAMLServletContextListener"};
    private static final String internalSessAttrListener = "weblogic.servlet.internal.session.WLSessionAttributeChangedListener";

    public EventsManager(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
    }

    boolean hasRequestListeners() {
        return this.hasRequestListeners;
    }

    void registerPreparePhaseListeners() throws DeploymentException {
        this.registerEventListeners(true);
    }

    void registerEventListeners() throws DeploymentException {
        this.registerEventListeners(false);
    }

    private void registerEventListeners(boolean bl) throws DeploymentException {
        String string = null;
        try {
            WebAppBean webAppBean;
            Set set;
            Object object;
            for (int i = 0; i < internalListeners.length; ++i) {
                string = internalListeners[i];
                object = Class.forName(string);
                if (WebLogicServletContextListener.class.isAssignableFrom((Class<?>)object) != bl) continue;
                this.registerEventListener(internalListeners[i], bl);
            }
            if (!bl) {
                this.context.getServer();
                if (!HttpServer.isProductionModeEnabled()) {
                    this.registerEventListener(internalSessAttrListener, bl);
                }
            }
            if (this.context.getHelper() != null && (set = this.context.getHelper().getTagListeners(false)) != null && !set.isEmpty()) {
                object = set.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    Class<?> clazz = this.context.getServletClassLoader().loadClass(string);
                    if (WebLogicServletContextListener.class.isAssignableFrom(clazz) != bl) continue;
                    this.registerEventListener(string, bl);
                }
            }
            if (this.context.getWebAppModule() != null && (webAppBean = this.context.getWebAppModule().getWebAppBean()) != null && (object = webAppBean.getListeners()) != null) {
                for (int i = 0; i < ((ListenerBean[])object).length; ++i) {
                    string = object[i].getListenerClass();
                    Class<?> clazz = this.context.getServletClassLoader().loadClass(string);
                    if (WebLogicServletContextListener.class.isAssignableFrom(clazz) != bl) continue;
                    this.registerEventListener(object[i].getListenerClass(), bl);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Loggable loggable = HTTPLogger.logCouldNotLoadListenerLoggable(string, (Throwable)classNotFoundException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), classNotFoundException);
        }
    }

    void registerEventsListeners(List list) throws DeploymentException {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (String string : list) {
            this.registerEventListener(string);
        }
    }

    synchronized void registerEventListener(String string) throws DeploymentException {
        this.registerEventListener(string, false);
    }

    void notifyContextPreparedEvent() throws DeploymentException {
        for (WebLogicServletContextListener webLogicServletContextListener : this.wlCtxListeners) {
            Throwable throwable;
            ServletContextEvent servletContextEvent = new ServletContextEvent((ServletContext)this.context);
            FireContextPreparedAction fireContextPreparedAction = new FireContextPreparedAction(webLogicServletContextListener, servletContextEvent);
            AuthenticatedSubject authenticatedSubject = this.context.getApplicationContext().getDeploymentInitiator();
            if (authenticatedSubject == null) {
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
            }
            if ((throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)fireContextPreparedAction)) == null) continue;
            HTTPLogger.logListenerFailed((String)webLogicServletContextListener.getClass().getName(), (Throwable)throwable);
            throw new DeploymentException(throwable);
        }
    }

    void notifyContextCreatedEvent() throws DeploymentException {
        for (ServletContextListener servletContextListener : this.ctxListeners) {
            Throwable throwable;
            ServletContextEvent servletContextEvent = new ServletContextEvent((ServletContext)this.context);
            FireContextListenerAction fireContextListenerAction = new FireContextListenerAction(true, servletContextListener, servletContextEvent);
            AuthenticatedSubject authenticatedSubject = this.context.getApplicationContext().getDeploymentInitiator();
            if (authenticatedSubject == null) {
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
            }
            if ((throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)fireContextListenerAction)) == null) continue;
            HTTPLogger.logListenerFailed((String)servletContextListener.getClass().getName(), (Throwable)throwable);
            throw new DeploymentException(throwable);
        }
    }

    void notifyContextDestroyedEvent() {
        for (int i = this.ctxListeners.size() - 1; i >= 0; --i) {
            Throwable throwable;
            ServletContextListener servletContextListener = (ServletContextListener)this.ctxListeners.get(i);
            ServletContextEvent servletContextEvent = new ServletContextEvent((ServletContext)this.context);
            FireContextListenerAction fireContextListenerAction = new FireContextListenerAction(false, servletContextListener, servletContextEvent);
            AuthenticatedSubject authenticatedSubject = this.context.getApplicationContext().getDeploymentInitiator();
            if (authenticatedSubject == null) {
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
            }
            if ((throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)fireContextListenerAction)) == null) continue;
            HTTPLogger.logListenerFailed((String)servletContextListener.getClass().getName(), (Throwable)throwable);
        }
        this.destroyListeners(this.wlCtxListeners);
        this.destroyListeners(this.ctxListeners);
        this.destroyListeners(this.ctxAttrListeners);
        this.destroyListeners(this.sessListeners);
        this.destroyListeners(this.sessAttrListeners);
        this.destroyListeners(this.requestListeners);
        this.destroyListeners(this.requestAttrListeners);
    }

    private void destroyListeners(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.context.getComponentCreator().notifyPreDestroy(iterator.next());
        }
        this.notifyEventListenersRemoved(list);
        list.clear();
    }

    void notifyContextAttributeChange(String string, Object object, Object object2) {
        object2 = this.unwrapAttribute(object2);
        for (ServletContextAttributeListener servletContextAttributeListener : this.ctxAttrListeners) {
            if (object2 == null) {
                if (object == null) continue;
                servletContextAttributeListener.attributeAdded(new ServletContextAttributeEvent((ServletContext)this.context, string, object));
                continue;
            }
            if (object == null) {
                servletContextAttributeListener.attributeRemoved(new ServletContextAttributeEvent((ServletContext)this.context, string, object2));
                continue;
            }
            if (object2.equals(object)) {
                return;
            }
            servletContextAttributeListener.attributeReplaced(new ServletContextAttributeEvent((ServletContext)this.context, string, object2));
        }
    }

    private Object unwrapAttribute(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            object2 = object instanceof AttributeWrapper ? ((AttributeWrapper)object).getObject(this.context) : object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            HTTPLogger.logUnableToDeserializeAttribute((String)this.context.getLogContext(), (Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            HTTPLogger.logUnableToDeserializeAttribute((String)this.context.getLogContext(), (Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            HTTPLogger.logUnableToDeserializeAttribute((String)this.context.getLogContext(), (Throwable)runtimeException);
        }
        return object2;
    }

    public void notifySessionLifetimeEvent(HttpSession httpSession, boolean bl) {
        for (WebAppServletContext[] webAppServletContextArray : this.sessListeners) {
            try {
                if (bl) {
                    webAppServletContextArray.sessionCreated(new HttpSessionEvent(httpSession));
                    continue;
                }
                webAppServletContextArray.sessionDestroyed(new HttpSessionEvent(httpSession));
            }
            catch (Throwable throwable) {
                HTTPLogger.logListenerFailed((String)webAppServletContextArray.getClass().getName(), (Throwable)throwable);
            }
        }
        if (this.context.getSessionContext().getConfigMgr().isSessionSharingEnabled() && !(httpSession instanceof SharedSessionData)) {
            WebAppServletContext[] webAppServletContextArray;
            webAppServletContextArray = this.context.getServer().getServletContextManager().getAllContexts();
            if (webAppServletContextArray == null || webAppServletContextArray.length < 2) {
                return;
            }
            for (int i = 0; i < webAppServletContextArray.length; ++i) {
                if (webAppServletContextArray[i] == this.context) continue;
                webAppServletContextArray[i].getEventsManager().notifySessionLifetimeEvent(new SharedSessionData(httpSession, webAppServletContextArray[i]), bl);
            }
        }
    }

    public void notifySessionAttributeChange(HttpSession httpSession, String string, Object object, Object object2) {
        for (WebAppServletContext[] webAppServletContextArray : this.sessAttrListeners) {
            if (object == null) {
                if (object2 == null) continue;
                webAppServletContextArray.attributeAdded(new HttpSessionBindingEvent(httpSession, string, object2));
                continue;
            }
            if (object2 == null) {
                webAppServletContextArray.attributeRemoved(new HttpSessionBindingEvent(httpSession, string, object));
                continue;
            }
            webAppServletContextArray.attributeReplaced(new HttpSessionBindingEvent(httpSession, string, object));
        }
        if (this.context.getSessionContext().getConfigMgr().isSessionSharingEnabled() && !(httpSession instanceof SharedSessionData)) {
            WebAppServletContext[] webAppServletContextArray;
            webAppServletContextArray = this.context.getServer().getServletContextManager().getAllContexts();
            if (webAppServletContextArray == null || webAppServletContextArray.length < 2) {
                return;
            }
            for (int i = 0; i < webAppServletContextArray.length; ++i) {
                if (webAppServletContextArray[i] == this.context) continue;
                webAppServletContextArray[i].getEventsManager().notifySessionAttributeChange(new SharedSessionData(httpSession, webAppServletContextArray[i]), string, object, object2);
            }
        }
    }

    void notifyRequestLifetimeEvent(ServletRequest servletRequest, boolean bl) {
        for (ServletRequestListener servletRequestListener : this.requestListeners) {
            if (bl) {
                servletRequestListener.requestInitialized(new ServletRequestEvent((ServletContext)this.context, servletRequest));
                continue;
            }
            servletRequestListener.requestDestroyed(new ServletRequestEvent((ServletContext)this.context, servletRequest));
        }
    }

    void notifyRequestAttributeEvent(ServletRequest servletRequest, String string, Object object, Object object2) {
        object = this.unwrapAttribute(object);
        for (ServletRequestAttributeListener servletRequestAttributeListener : this.requestAttrListeners) {
            if (object == null) {
                if (object2 == null) continue;
                servletRequestAttributeListener.attributeAdded(new ServletRequestAttributeEvent((ServletContext)this.context, servletRequest, string, object2));
                continue;
            }
            if (object2 == null) {
                servletRequestAttributeListener.attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.context, servletRequest, string, object));
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(new ServletRequestAttributeEvent((ServletContext)this.context, servletRequest, string, object));
        }
    }

    private synchronized void registerEventListener(String string, boolean bl) throws DeploymentException {
        if (string == null) {
            throw new DeploymentException("listener-class is null");
        }
        try {
            EventListener eventListener;
            if (!bl) {
                eventListener = this.context.getComponentCreator().createListenerInstance(string);
            } else {
                Class<?> clazz = this.context.getServletClassLoader().loadClass(string);
                eventListener = clazz.newInstance();
            }
            boolean bl2 = false;
            if (eventListener instanceof WebLogicServletContextListener) {
                this.wlCtxListeners.add(eventListener);
                bl2 = true;
            }
            if (eventListener instanceof ServletContextListener) {
                this.ctxListeners.add(eventListener);
                bl2 = true;
            }
            if (eventListener instanceof ServletContextAttributeListener) {
                this.ctxAttrListeners.add(eventListener);
                bl2 = true;
            }
            if (eventListener instanceof HttpSessionListener) {
                this.sessListeners.add(eventListener);
                bl2 = true;
            }
            if (eventListener instanceof HttpSessionAttributeListener) {
                this.sessAttrListeners.add(eventListener);
                bl2 = true;
            }
            if (eventListener instanceof ServletRequestListener) {
                this.requestListeners.add(eventListener);
                this.hasRequestListeners = true;
                bl2 = true;
            }
            if (eventListener instanceof ServletRequestAttributeListener) {
                this.requestAttrListeners.add(eventListener);
                this.hasRequestListeners = true;
                bl2 = true;
            }
            if (bl2) {
                this.notifyEventListenerAdded(eventListener);
            } else {
                HTTPLogger.logNotAListener((String)eventListener.getClass().getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Loggable loggable = HTTPLogger.logCouldNotLoadListenerLoggable((String)string, (Throwable)classNotFoundException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Loggable loggable = HTTPLogger.logCouldNotLoadListenerLoggable((String)string, (Throwable)noClassDefFoundError);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), noClassDefFoundError);
        }
        catch (InstantiationException instantiationException) {
            Loggable loggable = HTTPLogger.logCouldNotLoadListenerLoggable((String)string, (Throwable)instantiationException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Loggable loggable = HTTPLogger.logCouldNotLoadListenerLoggable((String)string, (Throwable)illegalAccessException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            Loggable loggable = HTTPLogger.logCouldNotLoadListenerLoggable((String)string, (Throwable)classCastException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), classCastException);
        }
    }

    public boolean isListenerRegistered(String string) {
        Iterator iterator = this.ctxListeners.iterator();
        if (this.contains(iterator, string)) {
            return true;
        }
        iterator = this.wlCtxListeners.iterator();
        if (this.contains(iterator, string)) {
            return true;
        }
        iterator = this.ctxAttrListeners.iterator();
        if (this.contains(iterator, string)) {
            return true;
        }
        iterator = this.sessListeners.iterator();
        if (this.contains(iterator, string)) {
            return true;
        }
        iterator = this.sessAttrListeners.iterator();
        if (this.contains(iterator, string)) {
            return true;
        }
        iterator = this.requestListeners.iterator();
        if (this.contains(iterator, string)) {
            return true;
        }
        iterator = this.requestAttrListeners.iterator();
        return this.contains(iterator, string);
    }

    private boolean contains(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next().getClass().getName())) continue;
            return true;
        }
        return false;
    }

    public synchronized void setRegistrationListener(RegistrationListener registrationListener) {
        this.regListener = registrationListener;
        this.notifyEventListenersAdded(this.wlCtxListeners);
        this.notifyEventListenersAdded(this.ctxListeners);
        this.notifyEventListenersAdded(this.ctxAttrListeners);
        this.notifyEventListenersAdded(this.sessListeners);
        this.notifyEventListenersAdded(this.sessAttrListeners);
        this.notifyEventListenersAdded(this.requestListeners);
        this.notifyEventListenersAdded(this.requestAttrListeners);
    }

    private void notifyEventListenersAdded(List list) {
        if (this.regListener != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.notifyEventListenerAdded(iterator.next());
            }
        }
    }

    private void notifyEventListenerAdded(Object object) {
        RegistrationListener registrationListener = this.regListener;
        if (registrationListener != null) {
            registrationListener.eventListenerAdded(object);
        }
    }

    private void notifyEventListenersRemoved(List list) {
        if (this.regListener != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.notifyEventListenerRemoved(iterator.next());
            }
        }
    }

    private void notifyEventListenerRemoved(Object object) {
        RegistrationListener registrationListener = this.regListener;
        if (registrationListener != null) {
            registrationListener.eventListenerRemoved(object);
        }
    }

    public static interface RegistrationListener {
        public void eventListenerAdded(Object var1);

        public void eventListenerRemoved(Object var1);
    }

    private static final class FireContextPreparedAction
    implements PrivilegedAction {
        private final WebLogicServletContextListener listener;
        private final ServletContextEvent event;

        FireContextPreparedAction(WebLogicServletContextListener webLogicServletContextListener, ServletContextEvent servletContextEvent) {
            this.listener = webLogicServletContextListener;
            this.event = servletContextEvent;
        }

        public Object run() {
            try {
                this.listener.contextPrepared(this.event);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private static final class FireContextListenerAction
    implements PrivilegedAction {
        private final ServletContextListener listener;
        private final ServletContextEvent event;
        private final boolean init;

        FireContextListenerAction(boolean bl, ServletContextListener servletContextListener, ServletContextEvent servletContextEvent) {
            this.listener = servletContextListener;
            this.event = servletContextEvent;
            this.init = bl;
        }

        public Object run() {
            try {
                if (this.init) {
                    this.listener.contextInitialized(this.event);
                } else {
                    this.listener.contextDestroyed(this.event);
                }
            }
            catch (Throwable throwable) {
                if (this.init) {
                    return throwable;
                }
                HTTPLogger.logListenerFailed((String)this.listener.getClass().getName(), (Throwable)throwable);
            }
            return null;
        }
    }
}

