/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.descriptor.DescriptorCache;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppIOHelper;
import weblogic.utils.collections.ArraySet;

public class FaceConfigCacheHelper {
    private static final String FACES_CACHE_DIR = ".faces_cache";

    public static Set parseFacesConfigs(Collection collection, String string, String string2) {
        return FaceConfigCacheHelper.parseFacesConfigs(collection, new File(string), string2);
    }

    public static Set parseFacesConfigs(Collection collection, File file, String string) {
        if (collection == null || collection.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet();
        long l = System.currentTimeMillis();
        File file2 = new File(file, FACES_CACHE_DIR);
        file2.mkdirs();
        for (War.ResourceLocation resourceLocation : collection) {
            FacesConfigsIOHelper facesConfigsIOHelper = new FacesConfigsIOHelper(resourceLocation);
            try {
                File file3 = new File(file2, resourceLocation.getURI().replace('\\', '/'));
                hashSet.addAll((Set)DescriptorCache.getInstance().parseXML(file3, (DescriptorCache.IOHelper)facesConfigsIOHelper));
                if (!HTTPDebugLogger.isEnabled()) continue;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    HTTPDebugLogger.debug("[FaceConfigCacheHelper] Found managed bean class '" + iterator.next() + "' in faces config at " + resourceLocation.getLocation());
                }
            }
            catch (XMLStreamException xMLStreamException) {
                if (string == null) continue;
                HTTPLogger.logFacesConfigParseException((String)string, (String)resourceLocation.getLocation(), (Throwable)xMLStreamException);
            }
            catch (IOException iOException) {
                if (string == null) continue;
                HTTPLogger.logFacesConfigParseException((String)string, (String)resourceLocation.getLocation(), (Throwable)iOException);
            }
        }
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug("[FaceConfigCacheHelper] parseFacesConfigs() took : " + (System.currentTimeMillis() - l));
        }
        return hashSet;
    }

    private static class FacesConfigsIOHelper
    extends WebAppIOHelper {
        FacesConfigsIOHelper(War.ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        protected Object parseXMLInternal(XMLStreamReader xMLStreamReader) throws IOException, XMLStreamException {
            ArraySet arraySet = new ArraySet();
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            int n = xMLStreamReader.next();
            while (n != 8) {
                switch (n) {
                    case 1: {
                        if ("managed-bean".equals(xMLStreamReader.getLocalName())) {
                            string = null;
                            string2 = null;
                            break;
                        }
                        if ("managed-bean-class".equals(xMLStreamReader.getLocalName())) {
                            bl = true;
                            break;
                        }
                        if (!"managed-bean-scope".equals(xMLStreamReader.getLocalName())) break;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if ("managed-bean".equals(xMLStreamReader.getLocalName())) {
                            if (string == null || string2 == null || "none".equals(string2)) break;
                            arraySet.add(string);
                            break;
                        }
                        if ("managed-bean-class".equals(xMLStreamReader.getLocalName())) {
                            bl = false;
                            break;
                        }
                        if (!"managed-bean-scope".equals(xMLStreamReader.getLocalName())) break;
                        bl2 = false;
                        break;
                    }
                    case 4: 
                    case 12: {
                        String string3;
                        if (bl2 && (string3 = xMLStreamReader.getText().trim()).length() != 0) {
                            string2 = string3;
                        }
                        if (!bl || (string3 = xMLStreamReader.getText().trim()).length() == 0) break;
                        string = string3;
                    }
                }
                n = xMLStreamReader.next();
            }
            return arraySet;
        }
    }
}

