/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import weblogic.servlet.FileSender;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.VirtualConnection;
import weblogic.socket.WeblogicSocket;
import weblogic.utils.io.Chunk;

public abstract class FileSenderImpl
implements FileSender {
    protected final long maxMessageSize;
    protected long bytesWritten;
    protected ServletRequestImpl request;
    protected ServletResponseImpl response;

    private FileSenderImpl(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        this.response = servletResponseImpl;
        this.request = servletRequestImpl;
        VirtualConnection virtualConnection = servletRequestImpl.getConnection();
        this.maxMessageSize = virtualConnection.getChannel().getMaxMessageSize();
        servletResponseImpl.setFileSender(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        if (!file.isFile()) {
            throw new IOException(file.getName() + " is not a file");
        }
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            long l = this.sendFile(fileChannel, 0L, file.length());
            return l;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
    }

    public long getBytesSent() {
        return this.bytesWritten;
    }

    public abstract long sendFile(FileChannel var1, long var2, long var4) throws IOException;

    public abstract boolean usesServletOutputStream();

    public static FileSender getZeroCopyFileSender(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            return null;
        }
        ServletResponseImpl servletResponseImpl = (ServletResponseImpl)httpServletResponse;
        ServletRequestImpl servletRequestImpl = servletResponseImpl.getRequest();
        VirtualConnection virtualConnection = servletRequestImpl.getConnection();
        Socket socket = virtualConnection.getSocket();
        if (socket instanceof WeblogicSocket) {
            socket = ((WeblogicSocket)socket).getSocket();
        }
        if (socket.getChannel() == null) {
            return null;
        }
        if (servletRequestImpl.getAttribute("javax.servlet.include.request_uri") != null) {
            return null;
        }
        if (servletResponseImpl.getContext().getFilterManager().hasFilters()) {
            return null;
        }
        ZeroCopyFileSender zeroCopyFileSender = (ZeroCopyFileSender)servletResponseImpl.getFileSender();
        if (zeroCopyFileSender != null) {
            return zeroCopyFileSender;
        }
        return new ZeroCopyFileSender(servletRequestImpl, servletResponseImpl);
    }

    public static FileSender getFileSender(HttpServletResponse httpServletResponse) {
        FileSender fileSender = FileSenderImpl.getZeroCopyFileSender(httpServletResponse);
        if (fileSender != null) {
            return fileSender;
        }
        ServletResponseImpl servletResponseImpl = (ServletResponseImpl)httpServletResponse;
        ServletRequestImpl servletRequestImpl = servletResponseImpl.getRequest();
        DefaultFileSender defaultFileSender = (DefaultFileSender)servletResponseImpl.getFileSender();
        if (defaultFileSender != null) {
            return defaultFileSender;
        }
        return new DefaultFileSender(servletRequestImpl, servletResponseImpl);
    }

    private static final class ChunkHeaderMaker {
        private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        private static final int ARR_LEN = 18;

        private ChunkHeaderMaker() {
        }

        public static byte[] getChunkHeader(long l) {
            byte[] byArray = new byte[18];
            long l2 = -1152921504606846976L;
            long l3 = 60L;
            for (int i = 0; i < 18; ++i) {
                byArray[i] = DIGITS[(int)((l & l2) >> (int)l3)];
                l2 = l2 >> 4 & 0xFFFFFFFFFFFFFFFL;
                l3 -= 4L;
            }
            byArray[16] = 13;
            byArray[17] = 10;
            return byArray;
        }
    }

    private static class DefaultFileSender
    extends FileSenderImpl {
        public DefaultFileSender(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
            super(servletRequestImpl, servletResponseImpl);
        }

        public boolean usesServletOutputStream() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long sendFile(FileChannel fileChannel, long l, long l2) throws IOException {
            fileChannel.position(l);
            int n = this.response.getBufferSize();
            n = n == -1 || n == 0 ? Chunk.CHUNK_SIZE : n;
            byte[] byArray = null;
            Chunk chunk = null;
            try {
                if (n == Chunk.CHUNK_SIZE) {
                    chunk = Chunk.getChunk();
                    byArray = chunk.buf;
                } else {
                    byArray = new byte[n];
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                assert (byteBuffer.array() != null);
                long l3 = 0L;
                while (l3 != l2) {
                    int n2 = fileChannel.read(byteBuffer);
                    long l4 = n2 + this.response.getServletOutputStream().getTotal() + this.response.getServletOutputStream().getCount();
                    if (l4 > this.maxMessageSize) {
                        throw new IOException("Outgoing message size will exceed the configured maximum message size of " + this.maxMessageSize + " bytes");
                    }
                    if (n2 == 0 || n2 == -1) break;
                    this.response.getOutputStream().write(byteBuffer.array(), 0, n2);
                    this.response.incrementBytesSentCount(n2);
                    l3 += (long)n2;
                    this.bytesWritten += (long)n2;
                    byteBuffer.clear();
                }
                long l5 = l3;
                return l5;
            }
            finally {
                if (chunk != null) {
                    Chunk.releaseChunk((Chunk)chunk);
                }
            }
        }
    }

    private static class ZeroCopyFileSender
    extends FileSenderImpl {
        public ZeroCopyFileSender(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
            super(servletRequestImpl, servletResponseImpl);
        }

        public boolean usesServletOutputStream() {
            return false;
        }

        public long sendFile(FileChannel fileChannel, long l, long l2) throws IOException {
            this.response.flushBuffer();
            VirtualConnection virtualConnection = this.request.getConnection();
            long l3 = this.response.getServletOutputStream().getTotal();
            Socket socket = virtualConnection.getSocket();
            if (socket instanceof WeblogicSocket) {
                socket = ((WeblogicSocket)socket).getSocket();
            }
            byte[] byArray = new byte[]{};
            if ("HTTP/1.1".equals(this.request.getProtocol()) && this.response.getContentLength() == 0) {
                byArray = ChunkHeaderMaker.getChunkHeader(l2);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(byArray);
                outputStream.flush();
            }
            assert (socket.getChannel() != null);
            long l4 = 0L;
            while (l2 > l4) {
                long l5 = l2 - l4;
                long l6 = l5 > Integer.MAX_VALUE ? Integer.MAX_VALUE : l5;
                long l7 = l6 + this.bytesWritten + l3 + (long)byArray.length;
                if (l7 > this.maxMessageSize) {
                    throw new IOException("Outgoing message size will exceed the configured maximum message size of " + this.maxMessageSize + " bytes");
                }
                l5 = fileChannel.transferTo(l, l6, socket.getChannel());
                if (l5 == 0L) break;
                this.response.incrementBytesSentCount(l5);
                this.bytesWritten += l5;
                l4 += l5;
                l += l5;
            }
            if ("HTTP/1.1".equals(this.request.getProtocol()) && this.response.getContentLength() == 0 && l4 != l2) {
                throw new IOException("Expected to send " + l2 + " bytes, but " + l4 + " bytes sent");
            }
            return l4;
        }
    }
}

