/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import weblogic.servlet.internal.FilterWrapper;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;

public final class FilterChainImpl
implements FilterChain {
    private List<Filter> filters = new LinkedList<Filter>();
    private int index = 0;
    private int headFilterInsertPos = 0;
    private ServletRequestImpl req;
    private ServletResponseImpl res;

    public void add(Filter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void add(FilterWrapper filterWrapper) throws ServletException {
        if (filterWrapper == null) {
            return;
        }
        Filter filter = filterWrapper.getFilter(true);
        if (filter == null) {
            return;
        }
        if (filterWrapper.isHeadFilter()) {
            this.filters.add(this.headFilterInsertPos, filter);
            ++this.headFilterInsertPos;
        } else {
            this.filters.add(filter);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        Filter filter = this.filters.get(this.index++);
        filter.doFilter(servletRequest, servletResponse, (FilterChain)this);
    }

    public ServletRequestImpl getOrigRequest() {
        return this.req;
    }

    public void setOrigRequest(ServletRequestImpl servletRequestImpl) {
        this.req = servletRequestImpl;
    }

    public ServletResponseImpl getOrigResponse() {
        return this.res;
    }

    public void setOrigResponse(ServletResponseImpl servletResponseImpl) {
        this.res = servletResponseImpl;
    }
}

