/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import weblogic.j2ee.descriptor.FilterBean;
import weblogic.j2ee.descriptor.FilterMappingBean;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.FilterUnavailableException;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.FilterChainImpl;
import weblogic.servlet.internal.FilterConfigImpl;
import weblogic.servlet.internal.FilterWrapper;
import weblogic.servlet.internal.RequestEventsFilter;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.TailFilter;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.servlet.utils.StandardURLMapping;
import weblogic.servlet.utils.URLMapping;
import weblogic.servlet.utils.URLMappingFactory;

public final class FilterManager {
    public static final int REQUEST = 0;
    public static final int FORWARD = 1;
    public static final int INCLUDE = 2;
    public static final int ERROR = 3;
    public static final int UNKNOWN = -1;
    private final WebAppServletContext context;
    private HashMap filters = new HashMap();
    private FilterBean[] filterList;
    private final ArrayList filterPatternList = new ArrayList();
    private final ArrayList filterServletList = new ArrayList();
    private FilterWrapper reqEventsFilterWrapper;

    FilterManager(WebAppServletContext webAppServletContext) {
        this.context = webAppServletContext;
    }

    boolean hasFilters() {
        return !this.filterPatternList.isEmpty() || !this.filterServletList.isEmpty();
    }

    void preloadFilters() throws DeploymentException {
        this.preloadReqEventFilter();
        if (this.filterList == null || this.filterList.length < 1) {
            return;
        }
        for (int i = 0; i < this.filterList.length; ++i) {
            HashMap hashMap = this.getParamsMap(this.filterList[i].getInitParams());
            Filter filter = this.loadFilter(this.filterList[i].getFilterName(), this.filterList[i].getFilterClass(), hashMap);
            if (filter == null) continue;
            this.filters.put(this.filterList[i].getFilterName(), new FilterWrapper(filter, this.filterList[i].getFilterName(), this.filterList[i].getFilterClass(), hashMap, this.context));
        }
    }

    private void preloadReqEventFilter() throws DeploymentException {
        String string = RequestEventsFilter.class.getName();
        this.reqEventsFilterWrapper = new FilterWrapper(this.loadFilter(string, string, null), string, string, null, this.context);
        this.reqEventsFilterWrapper.setHeadFilter(true);
    }

    private HashMap getParamsMap(ParamValueBean[] paramValueBeanArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (paramValueBeanArray != null) {
            for (int i = 0; i < paramValueBeanArray.length; ++i) {
                hashMap.put(paramValueBeanArray[i].getParamName(), paramValueBeanArray[i].getParamValue());
            }
        }
        return hashMap;
    }

    synchronized Filter loadFilter(String string, String string2, Map map) throws DeploymentException {
        try {
            Filter filter = this.context.getComponentCreator().createFilterInstance(string2);
            FilterConfigImpl filterConfigImpl = new FilterConfigImpl(string, this.context, map);
            FilterInitAction filterInitAction = new FilterInitAction(filter, filterConfigImpl);
            Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)filterInitAction);
            if (throwable != null) {
                if (!(throwable instanceof FilterUnavailableException)) {
                    HTTPLogger.logCouldNotLoadFilter((String)string2, (Throwable)throwable);
                }
                this.filters.remove(string);
                return null;
            }
            return filter;
        }
        catch (ClassNotFoundException classNotFoundException) {
            HTTPLogger.logCouldNotLoadFilter((String)(this.context.getLogContext() + " " + string2), (Throwable)classNotFoundException);
            throw new DeploymentException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            HTTPLogger.logCouldNotLoadFilter((String)(this.context.getLogContext() + " " + string2), (Throwable)instantiationException);
            throw new DeploymentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            HTTPLogger.logCouldNotLoadFilter((String)(this.context.getLogContext() + " " + string2), (Throwable)illegalAccessException);
            throw new DeploymentException(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            HTTPLogger.logCouldNotLoadFilter((String)(this.context.getLogContext() + " " + string2), (Throwable)classCastException);
            throw new DeploymentException(classCastException);
        }
    }

    void registerFilter(String string, String string2, String[] stringArray, String[] stringArray2, Map map, String[] stringArray3) throws DeploymentException {
        int n;
        Filter filter = this.loadFilter(string, string2, map);
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.registerFilterMapping(string, null, stringArray[n], stringArray3);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.registerFilterMapping(string, stringArray2[n], null, stringArray3);
            }
        }
        this.filters.put(string, new FilterWrapper(filter, string, string2, map, this.context));
    }

    void registerFilter(String string, String string2, String[] stringArray, String[] stringArray2, Map map) throws DeploymentException {
        this.registerFilter(string, string2, stringArray, stringArray2, map, null);
    }

    private synchronized void registerFilterMapping(String string, String string2, String string3, String[] stringArray) throws DeploymentException {
        if (string3 != null) {
            StandardURLMapping standardURLMapping = URLMappingFactory.createCompatibleURLMapping(this.context.getUrlMatchMap(), this.context.getServletClassLoader(), WebAppConfigManager.isCaseInsensitive(), WebAppSecurity.getEnforceStrictURLPattern());
            if (URLMappingFactory.isInvalidUrlPattern(this.context.getUrlMatchMap(), string3)) {
                throw new DeploymentException("The url-pattern, '" + string3 + "' is not valid");
            }
            standardURLMapping.put(string3, string);
            this.filterPatternList.add(new FilterInfo(string, standardURLMapping, this.context, stringArray));
        }
        if (string2 != null) {
            this.filterServletList.add(new FilterInfo(string, string2, this.context, stringArray));
        }
    }

    private synchronized void registerFilterMapping(FilterMappingBean filterMappingBean) throws DeploymentException {
        int n;
        Object object;
        String string = filterMappingBean.getFilterName();
        String[] stringArray = filterMappingBean.getServletNames();
        String[] stringArray2 = filterMappingBean.getUrlPatterns();
        String string2 = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            object = URLMappingFactory.createCompatibleURLMapping(this.context.getUrlMatchMap(), this.context.getServletClassLoader(), WebAppConfigManager.isCaseInsensitive(), WebAppSecurity.getEnforceStrictURLPattern());
            for (n = 0; n < stringArray2.length; ++n) {
                if (URLMappingFactory.isInvalidUrlPattern(this.context.getUrlMatchMap(), stringArray2[n])) {
                    throw new DeploymentException("The url-pattern, '" + stringArray2[n] + "' is not valid");
                }
                string2 = WebAppSecurity.fixupURLPattern(stringArray2[n]);
                object.put(string2, string);
            }
            this.filterPatternList.add(new FilterInfo((URLMapping)object, filterMappingBean, this.context));
        }
        object = new HashSet();
        if (stringArray != null && stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null || ((HashSet)object).contains(stringArray[n])) continue;
                this.filterServletList.add(new FilterInfo(string, stringArray[n], filterMappingBean, this.context));
                ((HashSet)object).add(stringArray[n]);
            }
        }
    }

    void registerServletFilters(WebAppBean webAppBean) throws DeploymentException {
        this.filterList = webAppBean.getFilters();
        FilterMappingBean[] filterMappingBeanArray = webAppBean.getFilterMappings();
        if (filterMappingBeanArray != null) {
            for (int i = 0; i < filterMappingBeanArray.length; ++i) {
                this.registerFilterMapping(filterMappingBeanArray[i]);
            }
        }
    }

    FilterChainImpl getFilterChain(ServletStubImpl servletStubImpl, ServletRequest servletRequest, ServletResponse servletResponse, boolean bl, int n) throws ServletException {
        String string;
        ServletRequestImpl servletRequestImpl = ServletRequestImpl.getOriginalRequest(servletRequest);
        FilterChainImpl filterChainImpl = null;
        if (bl) {
            filterChainImpl = new FilterChainImpl();
            filterChainImpl.add(this.reqEventsFilterWrapper);
        }
        String string2 = (string = (String)servletRequest.getAttribute("javax.servlet.include.request_uri")) != null ? string.substring(((String)servletRequest.getAttribute("javax.servlet.include.context_path")).length()) : (servletRequest.getAttribute("weblogic.servlet.errorPage") != null ? (String)servletRequest.getAttribute("weblogic.servlet.errorPage") : servletRequestImpl.getRelativeUri());
        if (this.filters.size() > 0) {
            Object object;
            String string3;
            for (Object object2 : this.filterPatternList) {
                Object object3;
                if (!this.isApplicable(n, (FilterInfo)object2) || (string3 = (String)(object3 = ((FilterInfo)object2).getMap()).get(string2)) == null || (object = (FilterWrapper)this.filters.get(string3)) == null) continue;
                if (filterChainImpl == null) {
                    filterChainImpl = new FilterChainImpl();
                }
                filterChainImpl.add((FilterWrapper)object);
            }
            String string4 = servletStubImpl.getServletName();
            for (Object object3 : this.filterServletList) {
                FilterWrapper filterWrapper;
                if (!this.isApplicable(n, (FilterInfo)object3)) continue;
                string3 = ((FilterInfo)object3).getFilterName();
                object = ((FilterInfo)object3).getServletName();
                if (!((String)object).equals(string4) && !"*".equals(object) || (filterWrapper = (FilterWrapper)this.filters.get(string3)) == null) continue;
                if (filterChainImpl == null) {
                    filterChainImpl = new FilterChainImpl();
                }
                filterChainImpl.add(filterWrapper);
            }
        }
        if (filterChainImpl == null) {
            return null;
        }
        filterChainImpl.add(new TailFilter(servletStubImpl));
        filterChainImpl.setOrigRequest(servletRequestImpl);
        filterChainImpl.setOrigResponse(servletRequestImpl.getResponse());
        return filterChainImpl;
    }

    private boolean isApplicable(int n, FilterInfo filterInfo) {
        if (n == 0 && filterInfo.applyOnRequest()) {
            return true;
        }
        if (n == 1 && filterInfo.applyOnForward()) {
            return true;
        }
        if (n == 2 && filterInfo.applyOnInclude()) {
            return true;
        }
        return n == 3 && filterInfo.applyOnError();
    }

    synchronized void destroyFilters() {
        if (this.filters.size() < 1) {
            return;
        }
        if (this.filterList != null) {
            for (int i = this.filterList.length - 1; i >= 0; --i) {
                String string = this.filterList[i].getFilterName();
                this.destroyFilter(string);
                this.filters.remove(string);
            }
        }
        for (String string : this.filters.keySet()) {
            this.destroyFilter(string);
        }
        this.filters.clear();
        this.filterPatternList.clear();
        this.filterServletList.clear();
    }

    private void destroyFilter(String string) {
        FilterWrapper filterWrapper = (FilterWrapper)this.filters.get(string);
        if (filterWrapper == null) {
            return;
        }
        Filter filter = filterWrapper.getFilter();
        if (filter == null) {
            return;
        }
        this.destroyFilter(filter, string);
        this.context.getComponentCreator().notifyPreDestroy(filter);
    }

    synchronized void destroyFilter(Filter filter, String string) {
        FilterDestroyAction filterDestroyAction = new FilterDestroyAction(filter);
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)WebAppConfigManager.KERNEL_ID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)filterDestroyAction);
        if (throwable != null) {
            HTTPLogger.logFailedWhileDestroyingFilter((String)string, (Throwable)throwable);
        }
    }

    public boolean isFilterRegistered(String string) {
        return this.filters.containsKey(string);
    }

    private static class FilterInfo {
        private String filterName;
        private String servletName;
        private URLMapping map;
        private boolean applyOnRequest;
        private boolean applyOnForward;
        private boolean applyOnInclude;
        private boolean applyOnError;

        private FilterInfo(String string, String string2) {
            this.filterName = string;
            this.servletName = string2;
        }

        private FilterInfo(URLMapping uRLMapping) {
            this.map = uRLMapping;
        }

        private FilterInfo(String string, String string2, FilterMappingBean filterMappingBean, WebAppServletContext webAppServletContext) throws DeploymentException {
            this(string, string2);
            this.initDispatcher(filterMappingBean, webAppServletContext);
        }

        private FilterInfo(URLMapping uRLMapping, FilterMappingBean filterMappingBean, WebAppServletContext webAppServletContext) throws DeploymentException {
            this(uRLMapping);
            this.initDispatcher(filterMappingBean, webAppServletContext);
        }

        private FilterInfo(String string, String string2, WebAppServletContext webAppServletContext, String[] stringArray) throws DeploymentException {
            this(string, string2);
            this.initDispatcher(webAppServletContext, stringArray, string);
        }

        private FilterInfo(String string, URLMapping uRLMapping, WebAppServletContext webAppServletContext, String[] stringArray) throws DeploymentException {
            this(uRLMapping);
            this.initDispatcher(webAppServletContext, stringArray, string);
        }

        private String getFilterName() {
            return this.filterName;
        }

        private String getServletName() {
            return this.servletName;
        }

        private URLMapping getMap() {
            return this.map;
        }

        private boolean applyOnRequest() {
            return this.applyOnRequest;
        }

        private boolean applyOnForward() {
            return this.applyOnForward;
        }

        private boolean applyOnInclude() {
            return this.applyOnInclude;
        }

        private boolean applyOnError() {
            return this.applyOnError;
        }

        private void initDispatcher(FilterMappingBean filterMappingBean, WebAppServletContext webAppServletContext) throws DeploymentException {
            String[] stringArray = filterMappingBean.getDispatchers();
            this.initDispatcher(webAppServletContext, stringArray, filterMappingBean.getFilterName());
        }

        private void initDispatcher(WebAppServletContext webAppServletContext, String[] stringArray, String string) throws DeploymentException {
            if (stringArray == null || stringArray.length < 1) {
                this.applyOnRequest = true;
                if (webAppServletContext.getConfigManager().isFilterDispatchedRequestsEnabled()) {
                    this.applyOnInclude = true;
                    this.applyOnForward = true;
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("REQUEST")) {
                        this.applyOnRequest = true;
                        continue;
                    }
                    if (stringArray[i].equals("FORWARD")) {
                        this.applyOnForward = true;
                        continue;
                    }
                    if (stringArray[i].equals("INCLUDE")) {
                        this.applyOnInclude = true;
                        continue;
                    }
                    if (stringArray[i].equals("ERROR")) {
                        this.applyOnError = true;
                        continue;
                    }
                    Loggable loggable = HTTPLogger.logInvalidFilterDispatcherLoggable((String)webAppServletContext.getLogContext(), (String)string, (String)stringArray[i]);
                    throw new DeploymentException(loggable.getMessage());
                }
            }
        }
    }

    private final class FilterDestroyAction
    implements PrivilegedAction {
        private final Filter filter;

        FilterDestroyAction(Filter filter) {
            this.filter = filter;
        }

        public Object run() {
            try {
                this.filter.destroy();
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private final class FilterInitAction
    implements PrivilegedAction {
        private final Filter filter;
        private final FilterConfig cfg;

        FilterInitAction(Filter filter, FilterConfig filterConfig) {
            this.filter = filter;
            this.cfg = filterConfig;
        }

        public Object run() {
            try {
                this.filter.init(this.cfg);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }
}

