/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal;

import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import weblogic.management.DeploymentException;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.classloaders.ChangeAwareClassLoader;

public class FilterWrapper {
    private static final String HEAD_FILTER = "weblogic.servlet.Filter.Head";
    private final WebAppServletContext context;
    private final String filtername;
    private final String filterclass;
    private final Map filterparams;
    private Filter filter;
    private ClassLoader contextLoader;
    private boolean reloadable = false;
    private boolean headFilter = false;

    public FilterWrapper(Filter filter, String string, String string2, Map map, WebAppServletContext webAppServletContext) {
        this.filter = filter;
        this.filtername = string;
        this.filterclass = string2;
        this.filterparams = map;
        this.context = webAppServletContext;
        this.contextLoader = webAppServletContext.getServletClassLoader();
        this.reloadable = this.contextLoader instanceof ChangeAwareClassLoader;
        this.headFilter = map != null && "true".equalsIgnoreCase((String)map.get(HEAD_FILTER));
    }

    Filter getFilter() {
        return this.filter;
    }

    Filter getFilter(boolean bl) throws ServletException {
        try {
            if (bl && this.reloadable) {
                this.checkForReload();
            }
        }
        catch (DeploymentException deploymentException) {
            throw new ServletException((Throwable)((Object)deploymentException));
        }
        return this.filter;
    }

    boolean isHeadFilter() {
        return this.headFilter;
    }

    void setHeadFilter(boolean bl) {
        this.headFilter = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadFilter(boolean bl) throws DeploymentException {
        Thread thread2 = Thread.currentThread();
        try {
            thread2.setContextClassLoader(this.contextLoader);
            this.context.getFilterManager().destroyFilter(this.filter, this.filtername);
            if (bl) {
                this.context.reloadServletClassLoader();
            }
            Object var4_3 = null;
            this.contextLoader = this.context.getServletClassLoader();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.contextLoader = this.context.getServletClassLoader();
            this.reloadable = this.contextLoader instanceof ChangeAwareClassLoader;
            thread2.setContextClassLoader(this.contextLoader);
            throw throwable;
        }
        this.reloadable = this.contextLoader instanceof ChangeAwareClassLoader;
        thread2.setContextClassLoader(this.contextLoader);
        this.filter = this.context.getFilterManager().loadFilter(this.filtername, this.filterclass, this.filterparams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForReload() throws DeploymentException {
        long l;
        if (this.context.getServletClassLoader() != this.contextLoader) {
            FilterWrapper filterWrapper = this;
            synchronized (filterWrapper) {
                if (this.context.getServletClassLoader() != this.contextLoader) {
                    this.reloadFilter(false);
                    return;
                }
            }
        }
        if ((l = (long)this.context.getConfigManager().getServletReloadCheckSecs()) >= 0L && this.checkReloadTimeout(l)) {
            FilterWrapper filterWrapper = this;
            synchronized (filterWrapper) {
                if (this.context.getServletClassLoader() != this.contextLoader) {
                    this.reloadFilter(false);
                    return;
                }
                if (this.checkReloadTimeout(l) && this.needToReload()) {
                    this.reloadFilter(true);
                }
            }
        }
    }

    private final boolean checkReloadTimeout(long l) {
        ChangeAwareClassLoader changeAwareClassLoader = (ChangeAwareClassLoader)this.context.getServletClassLoader();
        long l2 = System.currentTimeMillis();
        return l2 - l * 1000L > changeAwareClassLoader.getLastChecked();
    }

    private boolean needToReload() {
        ChangeAwareClassLoader changeAwareClassLoader = (ChangeAwareClassLoader)this.context.getServletClassLoader();
        return !changeAwareClassLoader.upToDate();
    }
}

